/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.FDBError;
import com.apple.foundationdb.FDBException;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.TestRecordsTextProto;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.lucene.LuceneIndexMaintainer;
import com.apple.foundationdb.record.lucene.LuceneIndexTest;
import com.apple.foundationdb.record.lucene.LuceneIndexTestUtils;
import com.apple.foundationdb.record.lucene.LuceneIndexTestValidator;
import com.apple.foundationdb.record.lucene.LucenePartitionInfoProto;
import com.apple.foundationdb.record.lucene.LucenePartitioner;
import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneQuerySearchClause;
import com.apple.foundationdb.record.lucene.LuceneQueryType;
import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.lucene.LuceneScanQuery;
import com.apple.foundationdb.record.lucene.LuceneScanQueryParameters;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexValidator;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.IndexDeferredMaintenanceControl;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactory;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexer;
import com.apple.foundationdb.record.provider.foundationdb.indexes.TextIndexTestUtils;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyStorage;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.test.RandomSeedSource;
import com.apple.test.RandomizedTestUtils;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LuceneOnlineIndexingTest
extends FDBRecordStoreTestBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneOnlineIndexingTest.class);

    LuceneOnlineIndexingTest() {
    }

    private void rebuildIndexMetaData(FDBRecordContext context, String document, Index index) {
        Pair<FDBRecordStore, QueryPlanner> pair = LuceneIndexTestUtils.rebuildIndexMetaData(context, this.path, document, index, this.isUseCascadesPlanner());
        this.recordStore = (FDBRecordStore)pair.getLeft();
        this.planner = (QueryPlanner)pair.getRight();
    }

    private void disableIndex(Index index, String document) {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, document, index);
            this.recordStore.markIndexDisabled(index).join();
            context.commit();
        }
    }

    @Test
    void luceneOnlineIndexingTestSimple() throws IOException {
        Index index = LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES;
        this.disableIndex(index, "SimpleDocument");
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 1));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(2222L, "There's always one more way to do things and that's your way, and you have a right to try it at least once. who?", 1));
            context.commit();
        }
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 1));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(2222L, "There's always one more way to do things and that's your way, and you have a right to try it at least once. who?", 1));
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).build();){
                Assertions.assertTrue((boolean)this.recordStore.isIndexDisabled(index));
                indexBuilder.buildIndex(true);
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            Assertions.assertTrue((boolean)this.recordStore.isIndexReadable(index));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        String[] allFiles = this.listFiles(index);
        Assertions.assertTrue((allFiles.length < 12 ? 1 : 0) != 0);
    }

    @Test
    void luceneOnlineIndexingTestWithRecordUpdates() throws IOException {
        Map<String, String> options = Map.of("partitionFieldName", "timestamp", "primaryKeySegmentIndexV2Enabled", "true", "partitionHighWatermark", String.valueOf(2));
        Index index = LuceneIndexTest.complexPartitionedIndex(options);
        this.disableIndex(index, "ComplexDocument");
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)2).build();
        long startTime = System.currentTimeMillis();
        long docId_1 = 1623L;
        long docId_2 = 1547L;
        long docId_3 = 2222L;
        long docId_4 = 899L;
        Tuple primaryKey_1 = Tuple.from((Object[])new Object[]{1, docId_1});
        Tuple primaryKey_2 = Tuple.from((Object[])new Object[]{1, docId_2});
        Tuple primaryKey_3 = Tuple.from((Object[])new Object[]{1, docId_3});
        Tuple primaryKey_4 = Tuple.from((Object[])new Object[]{1, docId_4});
        try (FDBRecordContext context2 = this.openContext(contextProps);){
            this.rebuildIndexMetaData(context2, "ComplexDocument", index);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(docId_1, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 1L, startTime));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(docId_2, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 1L, startTime + 1000L));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(docId_3, "There's always one more way to do things and that's your way, and you have a right to try it at least once. who?", 1L, startTime + 2000L));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(docId_4, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1L, startTime + 3000L));
            context2.commit();
        }
        context2 = this.openContext(contextProps);
        try {
            this.rebuildIndexMetaData(context2, "ComplexDocument", index);
            RuntimeException stopBuildException = new RuntimeException("stop build");
            try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)((OnlineIndexer.Builder)((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).setInitialLimit(1)).setConfigLoader(config -> {
                throw stopBuildException;
            })).build();){
                Assertions.assertTrue((boolean)this.recordStore.isIndexDisabled(index));
                RuntimeException thrown = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> indexBuilder.buildIndex(true));
                Assertions.assertSame((Object)stopBuildException, (Object)thrown);
            }
        }
        finally {
            if (context2 != null) {
                context2.close();
            }
        }
        LuceneIndexTestValidator luceneIndexTestValidator = new LuceneIndexTestValidator(() -> this.openContext(contextProps), context -> {
            this.rebuildIndexMetaData((FDBRecordContext)context, "ComplexDocument", index);
            return this.recordStore;
        });
        List<LucenePartitionInfoProto.LucenePartitionInfo> partitionMeta = luceneIndexTestValidator.getPartitionMeta(index, Tuple.from((Object[])new Object[]{1L}));
        Assertions.assertTrue((boolean)partitionMeta.isEmpty());
        try (FDBRecordContext context3 = this.openContext(contextProps);){
            this.rebuildIndexMetaData(context3, "ComplexDocument", index);
            Assertions.assertTrue((boolean)this.recordStore.isIndexWriteOnly(index));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(docId_1, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1L, startTime));
            context3.commit();
        }
        List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfos = luceneIndexTestValidator.getPartitionMeta(index, Tuple.from((Object[])new Object[]{1}));
        Assertions.assertEquals((int)1, (int)partitionInfos.size());
        Assertions.assertEquals((int)1, (int)partitionInfos.get(0).getCount());
        Assertions.assertEquals((Object)Tuple.from((Object[])new Object[]{startTime}).addAll(primaryKey_1), (Object)LucenePartitioner.getPartitionKey((LucenePartitionInfoProto.LucenePartitionInfo)partitionInfos.get(0)));
        Assertions.assertEquals((Object)Tuple.from((Object[])new Object[]{startTime}).addAll(primaryKey_1), (Object)LucenePartitioner.getToTuple((LucenePartitionInfoProto.LucenePartitionInfo)partitionInfos.get(0)));
        try (FDBRecordContext context4 = this.openContext(contextProps);){
            this.rebuildIndexMetaData(context4, "ComplexDocument", index);
            Assertions.assertTrue((boolean)this.recordStore.isIndexWriteOnly(index));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(docId_2, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1L, startTime + 1000L));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(docId_1, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.' XANADU", 1L, startTime));
            context4.commit();
        }
        partitionInfos = luceneIndexTestValidator.getPartitionMeta(index, Tuple.from((Object[])new Object[]{1}));
        Assertions.assertEquals((int)1, (int)partitionInfos.size());
        Assertions.assertEquals((int)2, (int)partitionInfos.get(0).getCount());
        Assertions.assertEquals((Object)Tuple.from((Object[])new Object[]{startTime}).addAll(primaryKey_1), (Object)LucenePartitioner.getPartitionKey((LucenePartitionInfoProto.LucenePartitionInfo)partitionInfos.get(0)));
        Assertions.assertEquals((Object)Tuple.from((Object[])new Object[]{startTime + 1000L}).addAll(primaryKey_2), (Object)LucenePartitioner.getToTuple((LucenePartitionInfoProto.LucenePartitionInfo)partitionInfos.get(0)));
        context4 = this.openContext(contextProps);
        try {
            this.rebuildIndexMetaData(context4, "ComplexDocument", index);
            try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).build();){
                Assertions.assertTrue((boolean)this.recordStore.isIndexWriteOnly(index));
                indexBuilder.buildIndex(true);
            }
        }
        finally {
            if (context4 != null) {
                context4.close();
            }
        }
        luceneIndexTestValidator.validate(index, Map.of(Tuple.from((Object[])new Object[]{1}), Map.of(primaryKey_4, Tuple.from((Object[])new Object[]{startTime + 3000L}), primaryKey_3, Tuple.from((Object[])new Object[]{startTime + 2000L}), primaryKey_2, Tuple.from((Object[])new Object[]{startTime + 1000L}), primaryKey_1, Tuple.from((Object[])new Object[]{startTime}))), "*:*");
        context4 = this.openContext(contextProps);
        try {
            List entries;
            this.rebuildIndexMetaData(context4, "ComplexDocument", index);
            LuceneScanQuery query = (LuceneScanQuery)LuceneIndexTestValidator.groupedSortedTextSearch(this.recordStore, index, "text:software", null, (Object)1);
            try (RecordCursor indexEntryCursor = this.recordStore.scanIndex(index, (IndexScanBounds)query, null, ExecuteProperties.newBuilder().build().asScanProperties(false));){
                entries = (List)indexEntryCursor.asList().join();
                Assertions.assertEquals((int)3, (int)entries.size());
                Assertions.assertEquals(Set.of(primaryKey_4, primaryKey_2, primaryKey_1), entries.stream().map(IndexEntry::getPrimaryKey).collect(Collectors.toSet()));
            }
            query = (LuceneScanQuery)LuceneIndexTestValidator.groupedSortedTextSearch(this.recordStore, index, "text:XANADU", null, (Object)1);
            indexEntryCursor = this.recordStore.scanIndex(index, (IndexScanBounds)query, null, ExecuteProperties.newBuilder().build().asScanProperties(false));
            try {
                entries = (List)indexEntryCursor.asList().join();
                Assertions.assertEquals((int)1, (int)entries.size());
                Assertions.assertEquals(Set.of(primaryKey_1), entries.stream().map(IndexEntry::getPrimaryKey).collect(Collectors.toSet()));
            }
            finally {
                if (indexEntryCursor != null) {
                    indexEntryCursor.close();
                }
            }
        }
        finally {
            if (context4 != null) {
                context4.close();
            }
        }
    }

    @ParameterizedTest
    @RandomSeedSource(value={6997773450764782661L, 3416978384487730594L, 6096618498708109618L})
    void luceneOnlineIndexingTestWithAllRecordUpdates(long seed) {
        Map<String, String> options = Map.of("partitionFieldName", "timestamp", "primaryKeySegmentIndexV2Enabled", "true", "partitionHighWatermark", String.valueOf(2));
        Index index = new Index("Complex$partitioned", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), (KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp")), (KeyExpression[])new KeyExpression[]{Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"time"))}).groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]), "lucene", options);
        this.disableIndex(index, "ComplexDocument");
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)2).build();
        Random random = new Random(seed);
        int docCount = 5;
        HashMap<Long, Long> primaryKeyToTimestamp = new HashMap<Long, Long>();
        try (FDBRecordContext context = this.openContext(contextProps);){
            this.rebuildIndexMetaData(context, "ComplexDocument", index);
            for (int i = 0; i < 5; ++i) {
                Long docId = (Long)RandomizedTestUtils.randomNotIn(primaryKeyToTimestamp.keySet(), () -> random.nextInt(1000) + 1000);
                Long timestamp = (Long)RandomizedTestUtils.randomNotIn(primaryKeyToTimestamp.values(), () -> random.nextInt(100) + 1);
                primaryKeyToTimestamp.put(docId, timestamp);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument((long)docId, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1L, timestamp));
            }
            context.commit();
        }
        AtomicInteger counter = new AtomicInteger(0);
        try (FDBRecordContext context = this.openContext(contextProps);){
            this.rebuildIndexMetaData(context, "ComplexDocument", index);
            try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)((OnlineIndexer.Builder)((OnlineIndexer.Builder)((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).setInitialLimit(1)).setLimit(1)).setConfigLoader(old -> {
                try (FDBRecordContext context2 = this.fdb.openContext(context.getConfig());){
                    this.rebuildIndexMetaData(context2, "ComplexDocument", index);
                    for (Map.Entry entry : primaryKeyToTimestamp.entrySet()) {
                        long newTime = counter.getAndIncrement();
                        TestRecordsTextProto.ComplexDocument doc = TestRecordsTextProto.ComplexDocument.newBuilder().setDocId(((Long)entry.getKey()).longValue()).setTimestamp(((Long)entry.getValue()).longValue()).setGroup(1L).setTime((double)newTime).build();
                        this.recordStore.saveRecord((Message)doc);
                    }
                    if (counter.get() == 10) {
                        TestRecordsTextProto.ComplexDocument doc = TestRecordsTextProto.ComplexDocument.newBuilder().setDocId(100L).setGroup(1L).setText("extra record").setTimestamp(200L).setTime(Math.pow(5.0, 2.0) - 1.0).build();
                        this.recordStore.saveRecord((Message)doc);
                    }
                    context2.commit();
                }
                return old.toBuilder().setMaxLimit(1).setMaxRetries(Integer.MAX_VALUE).build();
            })).build();){
                indexBuilder.buildIndex();
            }
        }
        context = this.openContext(contextProps);
        try {
            this.rebuildIndexMetaData(context, "ComplexDocument", index);
            Assertions.assertTrue((boolean)this.recordStore.isIndexReadable(index));
            String search = "time:[" + (Math.pow(5.0, 2.0) - 5.0) + " TO " + Math.pow(5.0, 2.0) + "]";
            LuceneScanQuery query = new LuceneScanQueryParameters((ScanComparisons)Verify.verifyNotNull((Object)ScanComparisons.from((Comparisons.Comparison)new Comparisons.SimpleComparison(Comparisons.Type.EQUALS, (Object)1))), (LuceneQueryClause)new LuceneQuerySearchClause(LuceneQueryType.QUERY, search, false), new Sort(new SortField("timestamp", SortField.Type.LONG, false)), List.of("time"), List.of(LuceneIndexExpressions.DocumentFieldType.DOUBLE), null).bind((FDBRecordStoreBase)this.recordStore, index, EvaluationContext.EMPTY);
            try (RecordCursor indexEntryCursor = this.recordStore.scanIndex(index, (IndexScanBounds)query, null, ExecuteProperties.newBuilder().build().asScanProperties(false));){
                List entries = (List)indexEntryCursor.asList().join();
                Assertions.assertEquals((int)6, (int)entries.size());
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @Test
    void luceneOnlineIndexingTest1() throws IOException {
        this.luceneOnlineIndexingTestAny(LuceneIndexTestUtils.QUERY_ONLY_SYNONYM_LUCENE_INDEX, "ComplexDocument", 17, 7, 0, 20);
    }

    @Test
    void luceneOnlineIndexingTest2() throws IOException {
        this.luceneOnlineIndexingTestAny(LuceneIndexTestUtils.QUERY_ONLY_SYNONYM_LUCENE_INDEX, "SimpleDocument", 15, 100, 300, 4);
    }

    @Test
    void luceneOnlineIndexingTest3() throws IOException {
        this.luceneOnlineIndexingTestAny(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, "SimpleDocument", 44, 7, 2, 34);
    }

    @Test
    void luceneOnlineIndexingTest4() throws IOException {
        this.luceneOnlineIndexingTestAny(LuceneIndexTestUtils.TEXT_AND_STORED, "ComplexDocument", 8, 100, 1, 4);
    }

    @Test
    void luceneOnlineIndexingTest5() throws IOException {
        this.luceneOnlineIndexingTestAny(LuceneIndexTestUtils.COMPLEX_MULTIPLE_GROUPED, "ComplexDocument", 77, 20, 2, 20);
    }

    @Test
    void luceneOnlineIndexingTest6() throws IOException {
        this.luceneOnlineIndexingTestAny(LuceneIndexTestUtils.COMPLEX_MULTIPLE_GROUPED, "ComplexDocument", 77, 20, 0, 20);
    }

    private String randomText(Random rn) {
        switch (rn.nextInt() % 4) {
            case 0: {
                return "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'";
            }
            case 1: {
                return "There's always one more way to do things and that's your way, and you have a right to try it at least once.";
            }
            case 2: {
                return "There's always one more way to do things and that's your way, and you have a right to try it at least once. says who?";
            }
            case 3: {
                return "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.' is it really funny?";
            }
        }
        return "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'There's always one more way to do things and that's your way, and you have a right to try it at least once.";
    }

    private int randomGroup(Random rn) {
        return rn.nextInt() % 2;
    }

    void luceneOnlineIndexingTestAny(Index index, String document, int numRecords, int transactionLimit, int mergesLimit, int expectedFileCount) throws IOException {
        long docId;
        int i;
        Assertions.assertTrue((numRecords > 3 ? 1 : 0) != 0);
        Random rn = new Random();
        rn.nextInt();
        this.disableIndex(index, document);
        long[] docIds = new long[numRecords * 2];
        for (int i2 = 0; i2 < numRecords * 2; ++i2) {
            docIds[i2] = rn.nextLong();
        }
        int middle = 1 + rn.nextInt(numRecords - 2);
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, document, index);
            for (i = 0; i < numRecords; ++i) {
                docId = docIds[i];
                if (document.equals("SimpleDocument")) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(docId, this.randomText(rn), this.randomGroup(rn)));
                    continue;
                }
                if (document.equals("ComplexDocument")) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(docId, this.randomText(rn), this.randomText(rn), this.randomGroup(rn)));
                    continue;
                }
                Assertions.fail((String)("Unexpected document type: " + document));
                return;
            }
            context.commit();
        }
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, document, index);
            for (i = 0; i < middle; ++i) {
                docId = docIds[i];
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(docId, this.randomText(rn), this.randomGroup(rn)));
            }
            for (i = middle; i < numRecords; ++i) {
                docId = docIds[numRecords + i];
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(docId, this.randomText(rn), this.randomGroup(rn)));
            }
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, document, index);
            try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).setLimit(transactionLimit)).setIndexingPolicy(OnlineIndexer.IndexingPolicy.newBuilder().setInitialMergesCountLimit((long)mergesLimit).build()).build();){
                Assertions.assertTrue((boolean)this.recordStore.isIndexDisabled(index));
                indexBuilder.buildIndex(true);
            }
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, document, index);
            Assertions.assertTrue((boolean)this.recordStore.isIndexReadable(index));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        CharSequence[] files = this.listFiles(index);
        MatcherAssert.assertThat((String)String.join((CharSequence)", ", files), (Object)files, (Matcher)Matchers.arrayWithSize((Matcher)Matchers.allOf((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1)), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(expectedFileCount)))));
    }

    @Test
    void luceneOnlineIndexingTestMulti() throws IOException {
        int i;
        int numRecords = 47;
        int transactionLimit = 10;
        int groupingCount = 1;
        Random rn = new Random();
        int numIndexes = 4;
        rn.nextInt();
        ArrayList<Index> indexes = new ArrayList<Index>();
        for (int i2 = 0; i2 < numIndexes; ++i2) {
            indexes.add(new Index("Map_with_auto_complete$entry-value-" + i2 + "-" + groupingCount, (KeyExpression)new GroupingKeyExpression((KeyExpression)Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.concat(LuceneIndexTestUtils.keys)), groupingCount + 1), "lucene", (Map)ImmutableMap.of()));
        }
        long[] docIds = new long[numRecords * 2];
        for (int i3 = 0; i3 < numRecords * 2; ++i3) {
            docIds[i3] = rn.nextLong();
        }
        int middle = 1 + rn.nextInt(numRecords - 2);
        FDBRecordStoreTestBase.RecordMetaDataHook hook = metaDataBuilder -> {
            for (Index index : indexes) {
                metaDataBuilder.addIndex("MapDocument", index);
            }
            metaDataBuilder.removeIndex("SimpleDocument$text");
            TextIndexTestUtils.addRecordTypePrefix((RecordMetaDataBuilder)metaDataBuilder);
        };
        try (FDBRecordContext context = this.openContext();){
            this.recordStore = LuceneIndexTestUtils.openRecordStore(context, this.path, hook);
            for (Index index : indexes) {
                this.recordStore.markIndexDisabled(index).join();
            }
            context.commit();
        }
        context = this.openContext();
        try {
            this.recordStore = LuceneIndexTestUtils.openRecordStore(context, this.path, hook);
            for (i = 0; i < numRecords; ++i) {
                long docId = docIds[i];
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(docId, this.randomText(rn), this.randomGroup(rn)));
            }
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.recordStore = LuceneIndexTestUtils.openRecordStore(context, this.path, hook);
            for (i = 0; i < middle; ++i) {
                long docId = docIds[i];
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(docId, this.randomText(rn), this.randomGroup(rn)));
            }
            for (i = middle; i < numRecords; ++i) {
                long docId = docIds[numRecords + i];
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(docId, this.randomText(rn), this.randomGroup(rn)));
            }
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.recordStore = LuceneIndexTestUtils.openRecordStore(context, this.path, hook);
            try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setTargetIndexes(indexes).setLimit(transactionLimit)).build();){
                for (Index index : indexes) {
                    Assertions.assertTrue((boolean)this.recordStore.isIndexDisabled(index));
                }
                indexBuilder.buildIndex(true);
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.recordStore = LuceneIndexTestUtils.openRecordStore(context, this.path, hook);
            for (Index index : indexes) {
                Assertions.assertTrue((boolean)this.recordStore.isIndexReadable(index));
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        for (Index index : indexes) {
            String[] allFiles = this.listFiles(index);
            Assertions.assertTrue((allFiles.length < 12 ? 1 : 0) != 0);
        }
    }

    protected void openRecordStore(FDBRecordContext context, FDBRecordStoreTestBase.RecordMetaDataHook hook) {
        RecordMetaDataBuilder metaDataBuilder = RecordMetaData.newBuilder().setRecords(TestRecordsTextProto.getDescriptor());
        metaDataBuilder.getRecordType("ComplexDocument").setPrimaryKey((KeyExpression)Key.Expressions.concatenateFields((String)"group", (String)"doc_id", (String[])new String[0]));
        hook.apply(metaDataBuilder);
        this.recordStore = (FDBRecordStore)this.getStoreBuilder(context, metaDataBuilder.getRecordMetaData()).setSerializer((RecordSerializer)TextIndexTestUtils.COMPRESSING_SERIALIZER).createOrOpen();
        this.setupPlanner(null);
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2, 3})
    void luceneOnlineIndexingTestGroupingKeys(int groupingCount) {
        long i;
        Index index = new Index("Map_with_auto_complete$entry-value", (KeyExpression)new GroupingKeyExpression((KeyExpression)Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.concat(LuceneIndexTestUtils.keys)), groupingCount), "lucene", (Map)ImmutableMap.of());
        FDBRecordStoreTestBase.RecordMetaDataHook hook = metaDataBuilder -> {
            metaDataBuilder.removeIndex("SimpleDocument$text");
            TextIndexTestUtils.addRecordTypePrefix((RecordMetaDataBuilder)metaDataBuilder);
            metaDataBuilder.addIndex("MapDocument", index);
        };
        int group = 3;
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, hook);
            this.recordStore.markIndexDisabled(index).join();
            context.commit();
        }
        context = this.openContext();
        try {
            this.openRecordStore(context, hook);
            for (i = 1L; i < 42L; ++i) {
                this.recordStore.saveRecord((Message)this.multiEntryMapDoc(77L * i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", group));
            }
            this.commit(context);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.openRecordStore(context, hook);
            for (i = 1L; i < 37L; i += 2L) {
                this.recordStore.saveRecord((Message)this.multiEntryMapDoc(77L * i, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", group));
            }
            this.commit(context);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.openRecordStore(context, hook);
            try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).build();){
                Assertions.assertTrue((boolean)this.recordStore.isIndexDisabled(index));
                indexBuilder.buildIndex(true);
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.openRecordStore(context, hook);
            Assertions.assertTrue((boolean)this.recordStore.isIndexReadable(index));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @ParameterizedTest
    @ValueSource(ints={1, 2, 3})
    void luceneOnlineIndexingTestGroupingKeysBackgroundMerge(int groupingCount) throws IOException {
        int groupedCount = 4 - groupingCount;
        Index index = new Index("Map_with_auto_complete$entry-value", (KeyExpression)new GroupingKeyExpression((KeyExpression)Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.concat(LuceneIndexTestUtils.keys)), groupedCount), "lucene", (Map)ImmutableMap.of());
        FDBRecordStoreTestBase.RecordMetaDataHook hook = metaDataBuilder -> {
            metaDataBuilder.removeIndex("SimpleDocument$text");
            TextIndexTestUtils.addRecordTypePrefix((RecordMetaDataBuilder)metaDataBuilder);
            metaDataBuilder.addIndex("MapDocument", index);
        };
        int group = 3;
        boolean needMerge = false;
        for (int iLast = 60; iLast > 40; --iLast) {
            try (FDBRecordContext context = this.openContext();){
                this.openRecordStore(context, hook);
                for (int i = 0; i < iLast; ++i) {
                    this.recordStore.saveRecord((Message)this.multiEntryMapDoc(77L * (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'" + iLast, group));
                }
                Set indexSet = this.recordStore.getIndexDeferredMaintenanceControl().getMergeRequiredIndexes();
                if (indexSet != null && !indexSet.isEmpty()) {
                    Assertions.assertEquals((int)1, (int)indexSet.size());
                    Assertions.assertEquals((Object)((Index)indexSet.stream().findFirst().get()).getName(), (Object)index.getName());
                    needMerge = true;
                }
                this.commit(context);
                continue;
            }
        }
        Assertions.assertTrue((boolean)needMerge);
        Tuple tuple = Tuple.from((Object[])new Object[]{"Text 2, and 1", "Text 3, plus 1", "I am text 4, with 1"});
        String[] allFiles = this.listFiles(index, tuple, groupingCount);
        int oldLength = allFiles.length;
        try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).build();){
            indexBuilder.mergeIndex();
        }
        allFiles = this.listFiles(index, tuple, groupingCount);
        int newLength = allFiles.length;
        LOGGER.debug("Merge test: number of files: old=" + oldLength + " new=" + newLength);
        Assertions.assertTrue((newLength > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((newLength < oldLength ? 1 : 0) != 0);
    }

    private TestRecordsTextProto.MapDocument multiEntryMapDoc(long id, String text, int group) {
        Assertions.assertTrue((group < 4 ? 1 : 0) != 0);
        String text2 = "Text 2, and " + id % 2L;
        String text3 = "Text 3, plus " + id % 3L;
        String text4 = "I am text 4, with " + id % 5L;
        return TestRecordsTextProto.MapDocument.newBuilder().setDocId(id).setGroup((long)group).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey(text2).setValue(text3).setSecondValue(text4).setThirdValue(text)).build();
    }

    private String[] listFiles(Index index) throws IOException {
        try (FDBRecordContext context = this.openContext();){
            if (index.getRootExpression() instanceof GroupingKeyExpression) {
                ArrayList<String> files = new ArrayList<String>();
                for (int i = 0; i < 2; ++i) {
                    FDBDirectory directory = new FDBDirectory(this.recordStore.indexSubspace(index).subspace(Tuple.from((Object[])new Object[]{i})), context, index.getOptions());
                    files.addAll(Arrays.asList(directory.listAll()));
                }
                String[] stringArray = files.toArray(new String[0]);
                return stringArray;
            }
            FDBDirectory directory = new FDBDirectory(this.recordStore.indexSubspace(index), context, index.getOptions());
            String[] stringArray = directory.listAll();
            return stringArray;
        }
    }

    private String[] listFiles(Index index, Tuple tuple, int groupingCount) throws IOException {
        try (FDBRecordContext context = this.openContext();){
            Subspace subspace = this.recordStore.indexSubspace(index);
            FDBDirectory directory = new FDBDirectory(subspace.subspace(Tuple.fromItems(tuple.getItems().subList(0, groupingCount))), context, index.getOptions());
            String[] stringArray = directory.listAll();
            return stringArray;
        }
    }

    @Test
    void testRecordUpdateBackgroundMerge() throws IOException {
        boolean needMerge = false;
        Index index = LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES;
        int[] iLimits = new int[]{0, 20, 10, 50, 40, 100, 0, 10, 0, 9, 0, 8, 0, 7, 0, 6, 0, 5, 0, 4, 0, 3, 0, 2};
        int iIndex = 0;
        while (iIndex < iLimits.length) {
            int iFIrst = iLimits[iIndex++];
            int iLast = iLimits[iIndex++];
            FDBRecordContext context = this.openContext();
            try {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                for (int i = iFIrst; i < iLast; ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'" + iIndex, 2));
                }
                Set indexSet = this.recordStore.getIndexDeferredMaintenanceControl().getMergeRequiredIndexes();
                if (indexSet != null && !indexSet.isEmpty()) {
                    needMerge = true;
                }
                this.commit(context);
            }
            finally {
                if (context == null) continue;
                context.close();
            }
        }
        Assertions.assertTrue((boolean)needMerge);
        String[] allFiles = this.listFiles(index);
        int oldLength = allFiles.length;
        try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).build();){
            indexBuilder.mergeIndex();
        }
        allFiles = this.listFiles(index);
        int newLength = allFiles.length;
        LOGGER.debug("Merge test: number of files: old=" + oldLength + " new=" + newLength);
        Assertions.assertTrue((newLength < oldLength ? 1 : 0) != 0);
    }

    private boolean populateDataSplitSegments(Index index, int high, int low) {
        boolean needMerge = false;
        for (int iLast = high; iLast > low; --iLast) {
            try (FDBRecordContext context = this.openContext();){
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                for (int i = 0; i < iLast; ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'" + iLast, 2));
                }
                Set indexSet = this.recordStore.getIndexDeferredMaintenanceControl().getMergeRequiredIndexes();
                if (indexSet != null && !indexSet.isEmpty()) {
                    Optional first = indexSet.stream().findFirst();
                    Assertions.assertEquals((int)1, (int)indexSet.size());
                    Assertions.assertEquals((Object)((Index)first.get()).getName(), (Object)index.getName());
                    needMerge = true;
                }
                this.commit(context);
                continue;
            }
        }
        return needMerge;
    }

    @Test
    void testRecordUpdateBackgroundMerge2() throws IOException {
        Index index = LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES;
        boolean needMerge = this.populateDataSplitSegments(index, 20, 5);
        Assertions.assertTrue((boolean)needMerge);
        String[] allFiles = this.listFiles(index);
        int oldLength = allFiles.length;
        try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).build();){
            indexBuilder.mergeIndex();
        }
        allFiles = this.listFiles(index);
        int newLength = allFiles.length;
        LOGGER.debug("Merge test: number of files: old=" + oldLength + " new=" + newLength);
        Assertions.assertTrue((newLength < oldLength ? 1 : 0) != 0);
    }

    @Test
    void testRecordUpdateMergeByAnotherRecordUpdate() throws IOException {
        Index index = LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES;
        boolean needMerge = this.populateDataSplitSegments(index, 20, 5);
        Assertions.assertTrue((boolean)needMerge);
        String[] allFiles = this.listFiles(index);
        int oldLength = allFiles.length;
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            this.recordStore.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(true);
            for (int i = 17; i < 22; ++i) {
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.' Sababa", 2));
            }
            this.commit(context);
        }
        allFiles = this.listFiles(index);
        int newLength = allFiles.length;
        LOGGER.debug("Merge test: number of files: old=" + oldLength + " new=" + newLength);
        Assertions.assertTrue((newLength < oldLength ? 1 : 0) != 0);
    }

    @Test
    void testRecordUpdateReducedMerge() throws IOException {
        Index index = LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES;
        boolean needMerge = this.populateDataSplitSegments(index, 40, 7);
        Assertions.assertTrue((boolean)needMerge);
        int loopCounter = 0;
        boolean allDone = false;
        while (!allDone) {
            int oldLength = this.listFiles(index).length;
            try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).build();){
                indexBuilder.mergeIndex();
            }
            int newLength = this.listFiles(index).length;
            LOGGER.debug("Merge test: number of files: old=" + oldLength + " new=" + newLength + " needMerge=" + String.valueOf(this.recordStore.getIndexDeferredMaintenanceControl().getMergeRequiredIndexes()));
            allDone = oldLength <= newLength;
            ++loopCounter;
        }
        Assertions.assertTrue((loopCounter > 1 ? 1 : 0) != 0);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 400})
    void luceneOnlineIndexingTestMergesLimit(int mergesLimit) throws IOException {
        Index index = LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES;
        boolean needMerge = this.populateDataSplitSegments(index, 40, 7);
        Assertions.assertTrue((boolean)needMerge);
        int loopCounter = 0;
        boolean allDone = false;
        while (!allDone) {
            int oldLength = this.listFiles(index).length;
            try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).setIndexingPolicy(OnlineIndexer.IndexingPolicy.newBuilder().setInitialMergesCountLimit((long)mergesLimit).build()).build();){
                indexBuilder.mergeIndex();
            }
            int newLength = this.listFiles(index).length;
            LOGGER.debug("Merge test with limits: merges_limit: " + mergesLimit + " number of files: old=" + oldLength + " new=" + newLength + " needMerge=" + String.valueOf(this.recordStore.getIndexDeferredMaintenanceControl().getMergeRequiredIndexes()));
            allDone = oldLength <= newLength;
            ++loopCounter;
        }
        Assertions.assertTrue((loopCounter > 1 ? 1 : 0) != 0);
    }

    @Test
    void luceneOnlineIndexingTestMerger() {
        Index index = new Index("Simple$text_suffixes", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), "terribleMerger", (Map)ImmutableMap.of((Object)"textTokenizerName", (Object)"all_suffixes"));
        boolean needMerge = this.populateDataSplitSegments(index, 4, 1);
        Assertions.assertTrue((boolean)needMerge);
        try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).setMaxAttempts(1)).build();){
            indexBuilder.mergeIndex();
        }
    }

    @Test
    void luceneOnlineIndexingTestTerrible2Merger() {
        Index index = new Index("Simple$text_suffixes", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), "terrible2Merger", (Map)ImmutableMap.of((Object)"textTokenizerName", (Object)"all_suffixes"));
        boolean needMerge = this.populateDataSplitSegments(index, 4, 1);
        Assertions.assertTrue((boolean)needMerge);
        try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).setMaxAttempts(1)).build();){
            indexBuilder.mergeIndex();
            Assertions.assertTrue((this.recordStore.getIndexDeferredMaintenanceControl().getTimeQuotaMillis() <= 10L ? 1 : 0) != 0);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void testRecordUpdateReducedMergeForcingAgileSizeQuota(boolean disableAgilityContext) throws IOException {
        RecordLayerPropertyStorage.Builder insertProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_AGILE_COMMIT_SIZE_QUOTA, (Object)100).addProp(LuceneRecordContextProperties.LUCENE_AGILE_DISABLE_AGILITY_CONTEXT, (Object)disableAgilityContext);
        Index index = LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES;
        FDBRecordStoreTestBase.RecordMetaDataHook hook = metaDataBuilder -> {
            metaDataBuilder.removeIndex("SimpleDocument$text");
            metaDataBuilder.addIndex("SimpleDocument", index);
        };
        this.populateDataSplitSegments(index, 42, 10);
        int oldLength = this.listFiles(index).length;
        FDBStoreTimer timer = new FDBStoreTimer();
        try (FDBRecordContext context = this.openContext(insertProps);){
            this.openRecordStore(context, hook);
            try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).setTimer(timer)).build();){
                indexBuilder.mergeIndex();
            }
            this.commit(context);
        }
        int newLength = this.listFiles(index).length;
        Assertions.assertTrue((newLength < oldLength ? 1 : 0) != 0);
        StoreTimer.Counter counter = timer.getCounter((StoreTimer.Event)LuceneEvents.Counts.LUCENE_AGILE_COMMITS_SIZE_QUOTA);
        if (disableAgilityContext) {
            Assertions.assertNull((Object)counter);
            return;
        }
        Assertions.assertNotNull((Object)counter);
        int sizeCommitCount = counter.getCount();
        LOGGER.debug("Merge test: number of files: old=" + oldLength + " new=" + newLength + " needMerge=" + String.valueOf(this.recordStore.getIndexDeferredMaintenanceControl().getMergeRequiredIndexes()) + " sizeCommitCount: " + sizeCommitCount);
        Assertions.assertTrue((sizeCommitCount > 10 ? 1 : 0) != 0);
    }

    @Test
    void testRecordUpdateReducedMergeForcingAgileTimeQuota() throws IOException {
        RecordLayerPropertyStorage.Builder insertProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_AGILE_COMMIT_TIME_QUOTA, (Object)1);
        Index index = LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES;
        FDBRecordStoreTestBase.RecordMetaDataHook hook = metaDataBuilder -> {
            metaDataBuilder.removeIndex("SimpleDocument$text");
            metaDataBuilder.addIndex("SimpleDocument", index);
        };
        this.populateDataSplitSegments(index, 42, 10);
        int oldLength = this.listFiles(index).length;
        FDBStoreTimer timer = new FDBStoreTimer();
        try (FDBRecordContext context = this.openContext(insertProps);){
            this.openRecordStore(context, hook);
            try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).setTimer(timer)).build();){
                indexBuilder.mergeIndex();
            }
            this.commit(context);
        }
        int newLength = this.listFiles(index).length;
        int timeCommitCount = timer.getCounter((StoreTimer.Event)LuceneEvents.Counts.LUCENE_AGILE_COMMITS_TIME_QUOTA).getCount();
        LOGGER.debug("Merge test: number of files: old=" + oldLength + " new=" + newLength + " needMerge=" + String.valueOf(this.recordStore.getIndexDeferredMaintenanceControl().getMergeRequiredIndexes()) + " timeCommitCount: " + timeCommitCount);
        Assertions.assertTrue((newLength < oldLength ? 1 : 0) != 0);
        Assertions.assertTrue((timeCommitCount > 0 ? 1 : 0) != 0);
    }

    @Test
    void luceneOnlineIndexingTestTerribleRebalance() {
        Index index = new Index("Simple$text_suffixes", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), "terribleRebalance", (Map)ImmutableMap.of((Object)"textTokenizerName", (Object)"all_suffixes"));
        boolean needMerge = this.populateDataSplitSegments(index, 4, 1);
        Assertions.assertTrue((boolean)needMerge);
        try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).setMaxAttempts(1)).build();){
            indexBuilder.mergeIndex();
            Assertions.assertTrue((this.recordStore.getIndexDeferredMaintenanceControl().getRepartitionDocumentCount() <= 2 ? 1 : 0) != 0);
        }
    }

    @Test
    void luceneOnlineIndexingTestTerribleRebalance2ndChance() {
        Terriblerebalnce2ndChanceIndexMaintainer.isSecondPass = false;
        Terriblerebalnce2ndChanceIndexMaintainer.gotSecondChance = false;
        Index index = new Index("Simple$text_suffixes", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), "terribleRebalance2ndChance", (Map)ImmutableMap.of((Object)"textTokenizerName", (Object)"all_suffixes"));
        boolean needMerge = this.populateDataSplitSegments(index, 4, 1);
        Assertions.assertTrue((boolean)needMerge);
        try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).setMaxAttempts(1)).build();){
            indexBuilder.mergeIndex();
            Assertions.assertTrue((boolean)Terriblerebalnce2ndChanceIndexMaintainer.gotSecondChance);
            Assertions.assertTrue((boolean)Terriblerebalnce2ndChanceIndexMaintainer.isSecondPass);
        }
    }

    private static class Terriblerebalnce2ndChanceIndexMaintainer
    extends LuceneIndexMaintainer {
        private final IndexMaintainerState state;
        static boolean isSecondPass = false;
        static boolean gotSecondChance = false;

        protected Terriblerebalnce2ndChanceIndexMaintainer(IndexMaintainerState state) {
            super(state, state.context.getExecutor());
            this.state = state;
        }

        public CompletableFuture<Void> mergeIndex() {
            IndexDeferredMaintenanceControl mergeControl = this.state.store.getIndexDeferredMaintenanceControl();
            int documentCount = mergeControl.getRepartitionDocumentCount();
            if (isSecondPass) {
                mergeControl.setLastStep(IndexDeferredMaintenanceControl.LastStep.REPARTITION);
                Assertions.assertEquals((int)0, (int)documentCount);
                gotSecondChance = true;
                return AsyncUtil.DONE;
            }
            if (documentCount == -1) {
                isSecondPass = true;
                mergeControl.setLastStep(IndexDeferredMaintenanceControl.LastStep.MERGE);
                return AsyncUtil.DONE;
            }
            mergeControl.setLastStep(IndexDeferredMaintenanceControl.LastStep.REPARTITION);
            if (documentCount <= 0) {
                mergeControl.setRepartitionDocumentCount(16);
                throw new FDBException("transaction_too_old", FDBError.TRANSACTION_TOO_OLD.code());
            }
            throw new FDBException("transaction_too_old", FDBError.TRANSACTION_TOO_OLD.code());
        }
    }

    public static class Terriblerebalnce2ndChanceIndexMaintainerFactory
    implements IndexMaintainerFactory {
        @Nonnull
        public Iterable<String> getIndexTypes() {
            return Collections.singletonList("terribleRebalance2ndChance");
        }

        @Nonnull
        public IndexValidator getIndexValidator(Index index) {
            return new IndexValidator(index);
        }

        @Nonnull
        public IndexMaintainer getIndexMaintainer(@Nonnull IndexMaintainerState state) {
            return new Terriblerebalnce2ndChanceIndexMaintainer(state);
        }
    }

    public static class TerribleRebalanceIndexMaintainerFactory
    implements IndexMaintainerFactory {
        @Nonnull
        public Iterable<String> getIndexTypes() {
            return Collections.singletonList("terribleRebalance");
        }

        @Nonnull
        public IndexValidator getIndexValidator(Index index) {
            return new IndexValidator(index);
        }

        @Nonnull
        public IndexMaintainer getIndexMaintainer(@Nonnull IndexMaintainerState state) {
            return new TerribleRebalanceIndexMaintainer(state);
        }
    }

    private static class TerribleRebalanceIndexMaintainer
    extends LuceneIndexMaintainer {
        private final IndexMaintainerState state;
        private static int pseodoFound = 0;

        protected TerribleRebalanceIndexMaintainer(IndexMaintainerState state) {
            super(state, state.context.getExecutor());
            this.state = state;
        }

        public CompletableFuture<Void> mergeIndex() {
            IndexDeferredMaintenanceControl mergeControl = this.state.store.getIndexDeferredMaintenanceControl();
            mergeControl.setLastStep(IndexDeferredMaintenanceControl.LastStep.REPARTITION);
            int documentCount = mergeControl.getRepartitionDocumentCount();
            if (documentCount <= 0) {
                mergeControl.setRepartitionDocumentCount(16);
                throw new FDBException("transaction_too_old", FDBError.TRANSACTION_TOO_OLD.code());
            }
            if (documentCount > 2) {
                throw new FDBException("transaction_too_old", FDBError.TRANSACTION_TOO_OLD.code());
            }
            return AsyncUtil.DONE;
        }
    }

    public static class Terrible2MergingIndexMaintainerFactory
    implements IndexMaintainerFactory {
        @Nonnull
        public Iterable<String> getIndexTypes() {
            return Collections.singletonList("terrible2Merger");
        }

        @Nonnull
        public IndexValidator getIndexValidator(Index index) {
            return new IndexValidator(index);
        }

        @Nonnull
        public IndexMaintainer getIndexMaintainer(@Nonnull IndexMaintainerState state) {
            return new Terrible2MergingIndexMaintainer(state);
        }
    }

    private static class Terrible2MergingIndexMaintainer
    extends LuceneIndexMaintainer {
        private final IndexMaintainerState state;
        private static int pseodoFound = 0;

        protected Terrible2MergingIndexMaintainer(IndexMaintainerState state) {
            super(state, state.context.getExecutor());
            this.state = state;
        }

        public CompletableFuture<Void> mergeIndex() {
            IndexDeferredMaintenanceControl mergeControl = this.state.store.getIndexDeferredMaintenanceControl();
            mergeControl.setLastStep(IndexDeferredMaintenanceControl.LastStep.MERGE);
            mergeControl.setMergesFound(1L);
            mergeControl.setMergesTried(1L);
            long timeQuota = mergeControl.getTimeQuotaMillis();
            if (timeQuota <= 0L) {
                mergeControl.setTimeQuotaMillis(1000L);
                throw new FDBException("transaction_too_old", FDBError.TRANSACTION_TOO_OLD.code());
            }
            if (timeQuota > 10L) {
                throw new FDBException("transaction_too_old", FDBError.TRANSACTION_TOO_OLD.code());
            }
            return AsyncUtil.DONE;
        }
    }

    public static class TerribleMergingIndexMaintainerFactory
    implements IndexMaintainerFactory {
        @Nonnull
        public Iterable<String> getIndexTypes() {
            return Collections.singletonList("terribleMerger");
        }

        @Nonnull
        public IndexValidator getIndexValidator(Index index) {
            return new IndexValidator(index);
        }

        @Nonnull
        public IndexMaintainer getIndexMaintainer(@Nonnull IndexMaintainerState state) {
            return new TerribleMergingIndexMaintainer(state);
        }
    }

    private static class TerribleMergingIndexMaintainer
    extends LuceneIndexMaintainer {
        private final IndexMaintainerState state;
        private static int pseodoFound = 0;

        protected TerribleMergingIndexMaintainer(IndexMaintainerState state) {
            super(state, state.context.getExecutor());
            this.state = state;
        }

        public CompletableFuture<Void> mergeIndex() {
            IndexDeferredMaintenanceControl mergeControl = this.state.store.getIndexDeferredMaintenanceControl();
            mergeControl.setLastStep(IndexDeferredMaintenanceControl.LastStep.MERGE);
            long limit = mergeControl.getMergesLimit();
            if (limit == 0L) {
                mergeControl.setMergesFound(10L);
                mergeControl.setMergesTried(10L);
                throw new FDBException("transaction_too_old", FDBError.TRANSACTION_TOO_OLD.code());
            }
            if (limit > 3L) {
                Assertions.assertEquals((long)5L, (long)limit);
                mergeControl.setMergesFound(10L);
                mergeControl.setMergesTried(limit);
                throw new FDBException("transaction_too_old", FDBError.TRANSACTION_TOO_OLD.code());
            }
            if (pseodoFound <= 0) {
                pseodoFound = 10;
            } else {
                Assertions.assertEquals((long)2L, (long)limit);
            }
            mergeControl.setMergesFound((long)pseodoFound);
            int pseudoTried = Math.min((int)limit, pseodoFound);
            mergeControl.setMergesTried((long)pseudoTried);
            pseodoFound -= pseudoTried;
            return AsyncUtil.DONE;
        }
    }
}

