/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.TestRecordsGroupedParentChildProto;
import com.apple.foundationdb.record.lucene.LuceneIndexTestValidator;
import com.apple.foundationdb.record.lucene.LucenePartitionInfoProto;
import com.apple.foundationdb.record.lucene.RandomTextGenerator;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.JoinedRecordTypeBuilder;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.metadata.expressions.ThenKeyExpression;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexer;
import com.apple.foundationdb.record.provider.foundationdb.keyspace.KeySpacePath;
import com.apple.foundationdb.record.test.TestKeySpacePathManagerExtension;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.junit.jupiter.api.Assertions;

public class LuceneIndexTestDataModel {
    public static final String PARENT_SEARCH_TERM = "text_value:about";
    public static final String CHILD_SEARCH_TERM = "child_str_value:forth";
    final boolean isGrouped;
    final boolean isSynthetic;
    final boolean primaryKeySegmentIndexEnabled;
    final int partitionHighWatermark;
    final Random random;
    final RandomTextGenerator textGenerator;
    final Index index;
    final Function<FDBRecordContext, FDBRecordStore> schemaSetup;
    final ConcurrentMap<Tuple, ConcurrentMap<Tuple, Tuple>> groupingKeyToPrimaryKeyToPartitionKey;
    private final ConcurrentMap<Tuple, RecordUnderTest> recordsUnderTest;
    final ConcurrentMap<Tuple, AtomicInteger> nextRecNoInGroup;
    private LuceneIndexTestValidator validator;
    private long start;
    private boolean reverseSaveOrder = false;

    private LuceneIndexTestDataModel(@Nonnull Builder builder, @Nonnull Function<FDBRecordContext, FDBRecordStore> schemaSetup) {
        this.random = builder.random;
        this.textGenerator = builder.textGenerator;
        this.isGrouped = builder.isGrouped;
        this.isSynthetic = builder.isSynthetic;
        this.primaryKeySegmentIndexEnabled = builder.primaryKeySegmentIndexEnabled;
        this.partitionHighWatermark = builder.partitionHighWatermark;
        this.index = builder.index;
        this.schemaSetup = schemaSetup;
        this.groupingKeyToPrimaryKeyToPartitionKey = new ConcurrentHashMap<Tuple, ConcurrentMap<Tuple, Tuple>>();
        this.recordsUnderTest = new ConcurrentHashMap<Tuple, RecordUnderTest>();
        this.nextRecNoInGroup = new ConcurrentHashMap<Tuple, AtomicInteger>();
        this.start = Instant.now().toEpochMilli();
    }

    public String toString() {
        return "LuceneIndexDataModel{isGrouped=" + this.isGrouped + ", isSynthetic=" + this.isSynthetic + ", primaryKeySegmentIndexEnabled=" + this.primaryKeySegmentIndexEnabled + ", partitionHighWatermark=" + this.partitionHighWatermark + "}";
    }

    public Set<Tuple> groupingKeys() {
        return this.groupingKeyToPrimaryKeyToPartitionKey.keySet();
    }

    public Set<Tuple> primaryKeys(Tuple groupingKey) {
        return ((ConcurrentMap)this.groupingKeyToPrimaryKeyToPartitionKey.get(groupingKey)).keySet();
    }

    public List<RecordUnderTest> recordsUnderTest() {
        return List.copyOf(this.recordsUnderTest.values());
    }

    public List<RecordUnderTest> sampleRecordsUnderTest() {
        Map<Tuple, List> recordsByGroup = this.recordsUnderTest.values().stream().collect(Collectors.groupingBy(RecordUnderTest::getGroupingKey, Collectors.toCollection(ArrayList::new)));
        ArrayList<RecordUnderTest> returnValue = new ArrayList<RecordUnderTest>();
        recordsByGroup.forEach((groupingKey, records) -> {
            records.sort(Comparator.comparing(RecordUnderTest::getPartitioningKey));
            for (int i = 0; i < records.size(); i += 2) {
                RecordUnderTest record = (RecordUnderTest)records.get(i);
                returnValue.add(record);
            }
        });
        return returnValue;
    }

    @Nonnull
    public FDBRecordStore createOrOpenRecordStore(FDBRecordContext context) {
        return Objects.requireNonNull(this.schemaSetup.apply(context));
    }

    public void deleteRecord(FDBRecordContext context, Tuple primaryKey) {
        FDBRecordStore recordStore = this.createOrOpenRecordStore(context);
        recordStore.deleteRecord(primaryKey);
    }

    void saveManyRecords(int minDocumentCount, @Nonnull Supplier<FDBRecordContext> openContext, int transactionCount) {
        long start = Instant.now().toEpochMilli();
        for (int i = 0; i < transactionCount || this.groupingKeyToPrimaryKeyToPartitionKey.values().stream().map(Map::size).sorted(Comparator.reverseOrder()).limit(2L).skip(this.isGrouped ? 1L : 0L).findFirst().orElse(0) < minDocumentCount; ++i) {
            int docCount = this.random.nextInt(10) + 1;
            try (FDBRecordContext context = openContext.get();){
                this.saveRecords(docCount, context);
                context.commit();
                continue;
            }
        }
    }

    void saveRecords(int count, FDBRecordContext context) {
        FDBRecordStore recordStore = this.createOrOpenRecordStore(context);
        for (int j = 0; j < count; ++j) {
            int group = this.isGrouped ? this.random.nextInt(this.random.nextInt(10) + 1) : 0;
            this.saveRecord(recordStore, group);
        }
    }

    void saveRecordsToAllGroups(int count, FDBRecordContext context) {
        FDBRecordStore recordStore = this.createOrOpenRecordStore(context);
        for (int i = 0; i < count; ++i) {
            if (this.isGrouped) {
                for (int j = 0; j < 10; ++j) {
                    this.saveRecord(recordStore, j);
                }
                continue;
            }
            this.saveRecord(recordStore, 0);
        }
    }

    void saveRecords(int count, FDBRecordContext context, int group) {
        FDBRecordStore recordStore = this.createOrOpenRecordStore(context);
        for (int j = 0; j < count; ++j) {
            this.saveRecordToSync(true, recordStore, group);
        }
    }

    public Tuple saveEmptyRecord(FDBRecordStore recordStore, int group) {
        return this.saveRecordToSync(false, recordStore, group);
    }

    public Tuple saveRecord(FDBRecordStore recordStore, int group) {
        return this.saveRecordToSync(true, recordStore, group);
    }

    private Tuple saveRecordToSync(boolean withContent, FDBRecordStore recordStore, int group) {
        return (Tuple)recordStore.getContext().asyncToSync((StoreTimer.Wait)FDBStoreTimer.Waits.WAIT_SAVE_RECORD, this.saveRecordAsync(withContent, recordStore, group));
    }

    public CompletableFuture<Tuple> saveRecordAsync(boolean withContent, FDBRecordStore recordStore, int group) {
        Tuple groupTuple = LuceneIndexTestDataModel.calculateGroupTuple(this.isGrouped, group);
        int uniqueCounter = this.nextRecNoInGroup.computeIfAbsent(groupTuple, key -> new AtomicInteger(0)).incrementAndGet();
        long timestamp = this.reverseSaveOrder ? this.start - (long)uniqueCounter - (long)this.random.nextInt(20) - 5L - 20L : this.start + (long)uniqueCounter + (long)this.random.nextInt(20) - 5L;
        return ((CompletableFuture)this.saveParentRecord(withContent, recordStore, group, uniqueCounter, timestamp).thenCompose(parentPrimaryKey -> {
            if (this.isSynthetic) {
                return this.saveChildRecord(withContent, recordStore, group, uniqueCounter).thenApply(childPrimaryKey -> {
                    Tuple syntheticPrimaryKey = LuceneIndexTestDataModel.createSyntheticPrimaryKey(recordStore, parentPrimaryKey, childPrimaryKey);
                    this.recordsUnderTest.put((Tuple)parentPrimaryKey, new SyntheticRecord(groupTuple, (Tuple)parentPrimaryKey, (Tuple)childPrimaryKey, syntheticPrimaryKey, timestamp));
                    return syntheticPrimaryKey;
                });
            }
            this.recordsUnderTest.put((Tuple)parentPrimaryKey, new ParentRecord(groupTuple, (Tuple)parentPrimaryKey, timestamp));
            return CompletableFuture.completedFuture(parentPrimaryKey);
        })).thenApply(primaryKey -> {
            this.groupingKeyToPrimaryKeyToPartitionKey.computeIfAbsent(groupTuple, key -> new ConcurrentHashMap()).put(primaryKey, Tuple.from((Object[])new Object[]{timestamp}).addAll(primaryKey));
            return primaryKey;
        });
    }

    @Nonnull
    private static Tuple createSyntheticPrimaryKey(FDBRecordStore recordStore, Tuple parentPrimaryKey, Tuple childPrimaryKey) {
        Tuple syntheticRecordTypeKey = recordStore.getRecordMetaData().getSyntheticRecordType("JoinChildren").getRecordTypeKeyTuple();
        return Tuple.from((Object[])new Object[]{syntheticRecordTypeKey.getItems().get(0), parentPrimaryKey.getItems(), childPrimaryKey.getItems()});
    }

    @Nonnull
    private CompletableFuture<Tuple> saveParentRecord(boolean withContent, FDBRecordStore recordStore, int group, int uniqueCounter, long timestamp) {
        TestRecordsGroupedParentChildProto.MyParentRecord.Builder parentBuilder = TestRecordsGroupedParentChildProto.MyParentRecord.newBuilder().setGroup((long)group).setRecNo(1001L + (long)uniqueCounter).setTimestamp(timestamp).setChildRecNo(1000L - (long)uniqueCounter);
        if (withContent) {
            parentBuilder.setTextValue(this.isSynthetic ? "This is not the text that goes in lucene" : this.textGenerator.generateRandomText("about")).setIntValue((long)this.random.nextInt());
        }
        TestRecordsGroupedParentChildProto.MyParentRecord parent = parentBuilder.build();
        return recordStore.saveRecordAsync((Message)parent).thenApply(FDBStoredRecord::getPrimaryKey);
    }

    @Nonnull
    private CompletableFuture<Tuple> saveChildRecord(boolean withContent, FDBRecordStore recordStore, int group, int countInGroup) {
        TestRecordsGroupedParentChildProto.MyChildRecord.Builder childBuilder = TestRecordsGroupedParentChildProto.MyChildRecord.newBuilder().setGroup((long)group).setRecNo(1000L - (long)countInGroup);
        if (withContent) {
            childBuilder.setStrValue(this.textGenerator.generateRandomText("forth")).setOtherValue((long)this.random.nextInt());
        }
        TestRecordsGroupedParentChildProto.MyChildRecord child = childBuilder.build();
        return recordStore.saveRecordAsync((Message)child).thenApply(FDBStoredRecord::getPrimaryKey);
    }

    public void validate(Supplier<FDBRecordContext> openContext) throws IOException {
        this.getValidator(openContext);
        this.validator.validate(this.index, this.groupingKeyToPrimaryKeyToPartitionKey, this.isSynthetic ? CHILD_SEARCH_TERM : PARENT_SEARCH_TERM);
    }

    public Map<Tuple, List<Integer>> getPartitionCounts(Supplier<FDBRecordContext> openContext) {
        return this.groupingKeys().stream().collect(Collectors.toMap(Function.identity(), groupingKey -> this.getValidator(openContext).getPartitionMeta(this.index, (Tuple)groupingKey).stream().sorted(Comparator.comparing(info -> Tuple.fromBytes((byte[])info.getFrom().toByteArray()))).map(LucenePartitionInfoProto.LucenePartitionInfo::getCount).collect(Collectors.toList())));
    }

    private LuceneIndexTestValidator getValidator(Supplier<FDBRecordContext> openContext) {
        if (this.validator == null) {
            this.validator = new LuceneIndexTestValidator(openContext, this::createOrOpenRecordStore);
        }
        return this.validator;
    }

    @Nonnull
    static Index addIndex(boolean isSynthetic, KeyExpression rootExpression, Map<String, String> options, RecordMetaDataBuilder metaDataBuilder) {
        Index index = new Index("joinNestedConcat", rootExpression, "lucene", options);
        if (isSynthetic) {
            JoinedRecordTypeBuilder joinBuilder = metaDataBuilder.addJoinedRecordType("JoinChildren");
            joinBuilder.addConstituent("parent", "MyParentRecord");
            joinBuilder.addConstituent("child", "MyChildRecord");
            joinBuilder.addJoin("parent", (KeyExpression)Key.Expressions.field((String)"group"), "child", (KeyExpression)Key.Expressions.field((String)"group"));
            joinBuilder.addJoin("parent", (KeyExpression)Key.Expressions.field((String)"child_rec_no"), "child", (KeyExpression)Key.Expressions.field((String)"rec_no"));
            metaDataBuilder.addIndex("JoinChildren", index);
        } else {
            metaDataBuilder.addIndex("MyParentRecord", index);
        }
        return index;
    }

    @Nonnull
    static KeyExpression createRootExpression(boolean isGrouped, boolean isSynthetic) {
        FieldKeyExpression groupingExpression;
        ThenKeyExpression baseExpression;
        if (isSynthetic) {
            baseExpression = Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"parent").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"int_value"))), (KeyExpression)Key.Expressions.field((String)"child").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"str_value"))), (KeyExpression[])new KeyExpression[]{Key.Expressions.field((String)"parent").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp")))});
            groupingExpression = Key.Expressions.field((String)"parent").nest("group");
        } else {
            baseExpression = Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"int_value")), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text_value")), (KeyExpression[])new KeyExpression[]{Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp"))});
            groupingExpression = Key.Expressions.field((String)"group");
        }
        Object rootExpression = isGrouped ? baseExpression.groupBy((KeyExpression)groupingExpression, new KeyExpression[0]) : baseExpression;
        return rootExpression;
    }

    @Nonnull
    static Tuple calculateGroupTuple(boolean isGrouped, int group) {
        return isGrouped ? Tuple.from((Object[])new Object[]{group}) : Tuple.from((Object[])new Object[0]);
    }

    @Nonnull
    static RecordMetaDataBuilder createBaseMetaDataBuilder() {
        RecordMetaDataBuilder metaDataBuilder = RecordMetaData.newBuilder().setRecords(TestRecordsGroupedParentChildProto.getDescriptor());
        metaDataBuilder.getRecordType("MyParentRecord").setPrimaryKey((KeyExpression)Key.Expressions.concatenateFields((String)"group", (String)"rec_no", (String[])new String[0]));
        metaDataBuilder.getRecordType("MyChildRecord").setPrimaryKey((KeyExpression)Key.Expressions.concatenateFields((String)"group", (String)"rec_no", (String[])new String[0]));
        return metaDataBuilder;
    }

    public void explicitMergeIndex(FDBRecordContext context, @Nullable FDBStoreTimer timer) {
        FDBRecordStore recordStore = Objects.requireNonNull(this.schemaSetup.apply(context));
        try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(recordStore)).setIndex(this.index).setTimer(timer)).build();){
            indexBuilder.mergeIndex();
        }
    }

    public Integer nextInt(int bound) {
        return this.random.nextInt(bound);
    }

    public void setReverseSaveOrder(boolean reverseSaveOrder) {
        this.reverseSaveOrder = reverseSaveOrder;
    }

    private CompletableFuture<Void> updateRecord(FDBRecordStore recordStore, Tuple primaryKey, Function<Message, Message> updateMessage) {
        return recordStore.loadRecordAsync(primaryKey).thenAccept(existingRecord -> recordStore.saveRecord((Message)updateMessage.apply(existingRecord.getRecord())));
    }

    static class Builder {
        private final Random random;
        private final StoreBuilderSupplier storeBuilderSupplier;
        private final TestKeySpacePathManagerExtension pathManager;
        private RandomTextGenerator textGenerator;
        boolean isGrouped;
        boolean isSynthetic;
        boolean primaryKeySegmentIndexEnabled = true;
        int partitionHighWatermark;
        @Nullable
        private Index index;
        @Nullable
        private RecordMetaData metadata;

        public Builder(long seed, StoreBuilderSupplier storeBuilderSupplier, TestKeySpacePathManagerExtension pathManager) {
            this.random = new Random(seed);
            this.storeBuilderSupplier = storeBuilderSupplier;
            this.pathManager = pathManager;
        }

        public Builder setIsGrouped(boolean isGrouped) {
            this.isGrouped = isGrouped;
            this.metadata = null;
            return this;
        }

        public Builder setIsSynthetic(boolean isSynthetic) {
            this.isSynthetic = isSynthetic;
            this.metadata = null;
            return this;
        }

        public Builder setPrimaryKeySegmentIndexEnabled(boolean primaryKeySegmentIndexEnabled) {
            this.primaryKeySegmentIndexEnabled = primaryKeySegmentIndexEnabled;
            this.metadata = null;
            return this;
        }

        public Builder setPartitionHighWatermark(int partitionHighWatermark) {
            this.partitionHighWatermark = partitionHighWatermark;
            this.metadata = null;
            return this;
        }

        public Builder setTextGeneratorWithNewRandom(RandomTextGenerator textGenerator) {
            this.textGenerator = textGenerator.withNewRandom(this.random);
            return this;
        }

        public LuceneIndexTestDataModel build() {
            if (this.textGenerator == null) {
                this.textGenerator = new RandomTextGenerator(this.random);
            }
            KeySpacePath path = this.pathManager.createPath(new String[]{"recordStore"});
            if (this.metadata == null) {
                Map<String, String> options = this.getOptions();
                RecordMetaDataBuilder metaDataBuilder = LuceneIndexTestDataModel.createBaseMetaDataBuilder();
                KeyExpression rootExpression = LuceneIndexTestDataModel.createRootExpression(this.isGrouped, this.isSynthetic);
                this.index = LuceneIndexTestDataModel.addIndex(this.isSynthetic, rootExpression, options, metaDataBuilder);
                this.metadata = metaDataBuilder.build();
            }
            Function<FDBRecordContext, FDBRecordStore> schemaSetup = context -> {
                FDBRecordStore store = (FDBRecordStore)this.storeBuilderSupplier.get((FDBRecordContext)context, this.metadata, path).createOrOpen();
                store.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(false);
                return store;
            };
            return new LuceneIndexTestDataModel(this, schemaSetup);
        }

        @Nonnull
        private Map<String, String> getOptions() {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("primaryKeySegmentIndexV2Enabled", String.valueOf(this.primaryKeySegmentIndexEnabled));
            if (this.partitionHighWatermark > 0) {
                options.put("partitionFieldName", this.isSynthetic ? "parent.timestamp" : "timestamp");
                options.put("partitionHighWatermark", String.valueOf(this.partitionHighWatermark));
            }
            return options;
        }
    }

    private class ParentRecord
    implements RecordUnderTest {
        @Nonnull
        final Tuple groupingKey;
        @Nonnull
        final Tuple primaryKey;
        @Nonnull
        private final Tuple partitioningKey;

        private ParentRecord(@Nonnull Tuple groupingKey, Tuple primaryKey, long timestamp) {
            this.groupingKey = groupingKey;
            this.primaryKey = primaryKey;
            this.partitioningKey = Tuple.from((Object[])new Object[]{timestamp}).addAll(primaryKey);
        }

        @Override
        public Tuple getGroupingKey() {
            return this.groupingKey;
        }

        @Override
        public Tuple getPartitioningKey() {
            return this.partitioningKey;
        }

        @Override
        public CompletableFuture<Void> updateOtherValue(FDBRecordStore recordStore) {
            return LuceneIndexTestDataModel.this.updateRecord(recordStore, this.primaryKey, existingRecord -> {
                TestRecordsGroupedParentChildProto.MyParentRecord.Builder builder = TestRecordsGroupedParentChildProto.MyParentRecord.newBuilder();
                builder.mergeFrom(existingRecord);
                builder.setIntValue((long)LuceneIndexTestDataModel.this.random.nextInt());
                return builder.build();
            });
        }

        @Override
        public CompletableFuture<Void> deleteRecord(FDBRecordStore recordStore) {
            ((ConcurrentMap)LuceneIndexTestDataModel.this.groupingKeyToPrimaryKeyToPartitionKey.get(this.groupingKey)).remove(this.primaryKey);
            LuceneIndexTestDataModel.this.recordsUnderTest.remove(this.primaryKey);
            return recordStore.deleteRecordAsync(this.primaryKey).thenAccept(wasDeleted -> Assertions.assertTrue((boolean)wasDeleted, () -> String.valueOf(this.primaryKey) + " should have been deletable"));
        }
    }

    private class SyntheticRecord
    implements RecordUnderTest {
        @Nonnull
        final Tuple groupingKey;
        @Nonnull
        final Tuple parentPrimaryKey;
        @Nonnull
        private final Tuple childPrimaryKey;
        @Nonnull
        private final Tuple syntheticPrimaryKey;
        @Nonnull
        private final Tuple partitioningKey;

        private SyntheticRecord(@Nonnull Tuple groupingKey, @Nonnull Tuple primaryKey, @Nonnull Tuple childPrimaryKey, Tuple syntheticPrimaryKey, long timestamp) {
            this.groupingKey = groupingKey;
            this.parentPrimaryKey = primaryKey;
            this.childPrimaryKey = childPrimaryKey;
            this.syntheticPrimaryKey = syntheticPrimaryKey;
            this.partitioningKey = Tuple.from((Object[])new Object[]{timestamp}).addAll(primaryKey);
        }

        @Override
        public Tuple getGroupingKey() {
            return this.groupingKey;
        }

        @Override
        public Tuple getPartitioningKey() {
            return this.partitioningKey;
        }

        @Override
        public CompletableFuture<Void> updateOtherValue(FDBRecordStore recordStore) {
            return LuceneIndexTestDataModel.this.updateRecord(recordStore, this.parentPrimaryKey, existingRecord -> {
                TestRecordsGroupedParentChildProto.MyParentRecord.Builder builder = TestRecordsGroupedParentChildProto.MyParentRecord.newBuilder();
                builder.mergeFrom(existingRecord);
                builder.setIntValue((long)LuceneIndexTestDataModel.this.random.nextInt());
                return builder.build();
            });
        }

        @Override
        public CompletableFuture<Void> deleteRecord(FDBRecordStore recordStore) {
            ((ConcurrentMap)LuceneIndexTestDataModel.this.groupingKeyToPrimaryKeyToPartitionKey.get(this.groupingKey)).remove(this.syntheticPrimaryKey);
            LuceneIndexTestDataModel.this.recordsUnderTest.remove(this.parentPrimaryKey);
            return ((CompletableFuture)((CompletableFuture)recordStore.deleteRecordAsync(this.parentPrimaryKey).thenAccept(wasDeleted -> Assertions.assertTrue((boolean)wasDeleted, () -> String.valueOf(this.parentPrimaryKey) + " should have been deletable"))).thenCompose(vignore -> recordStore.deleteRecordAsync(this.childPrimaryKey))).thenAccept(wasDeleted -> Assertions.assertTrue((boolean)wasDeleted, () -> String.valueOf(this.childPrimaryKey) + " should have been deletable"));
        }
    }

    public static interface RecordUnderTest {
        public Tuple getGroupingKey();

        public CompletableFuture<Void> updateOtherValue(FDBRecordStore var1);

        public CompletableFuture<Void> deleteRecord(FDBRecordStore var1);

        public Tuple getPartitioningKey();
    }

    @FunctionalInterface
    public static interface StoreBuilderSupplier {
        public FDBRecordStore.Builder get(@Nonnull FDBRecordContext var1, @Nonnull RecordMetaData var2, @Nonnull KeySpacePath var3);
    }
}

