/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.IndexEntry;
import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.IsolationLevel;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordCursorResult;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TestHelpers;
import com.apple.foundationdb.record.TestRecordsTextProto;
import com.apple.foundationdb.record.lucene.FDBLuceneTestBase;
import com.apple.foundationdb.record.lucene.LuceneAutoCompleteQueryClause;
import com.apple.foundationdb.record.lucene.LuceneComparisonQuery;
import com.apple.foundationdb.record.lucene.LuceneContinuationProto;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneFieldInfosProto;
import com.apple.foundationdb.record.lucene.LuceneIndexKeyValueToPartialRecordUtils;
import com.apple.foundationdb.record.lucene.LuceneIndexMaintainer;
import com.apple.foundationdb.record.lucene.LuceneIndexQueryPlan;
import com.apple.foundationdb.record.lucene.LuceneIndexTestUtils;
import com.apple.foundationdb.record.lucene.LuceneIndexTestValidator;
import com.apple.foundationdb.record.lucene.LucenePartitionInfoProto;
import com.apple.foundationdb.record.lucene.LucenePartitioner;
import com.apple.foundationdb.record.lucene.LucenePlanMatchers;
import com.apple.foundationdb.record.lucene.LucenePlanner;
import com.apple.foundationdb.record.lucene.LucenePrimaryKeySegmentIndex;
import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneQueryComponent;
import com.apple.foundationdb.record.lucene.LuceneQueryMultiFieldSearchClause;
import com.apple.foundationdb.record.lucene.LuceneQuerySearchClause;
import com.apple.foundationdb.record.lucene.LuceneQueryType;
import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.lucene.LuceneRecordCursor;
import com.apple.foundationdb.record.lucene.LuceneScanBounds;
import com.apple.foundationdb.record.lucene.LuceneScanParameters;
import com.apple.foundationdb.record.lucene.LuceneScanQuery;
import com.apple.foundationdb.record.lucene.LuceneScanQueryParameters;
import com.apple.foundationdb.record.lucene.LuceneScanSpellCheckParameters;
import com.apple.foundationdb.record.lucene.LuceneScanTypes;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedPostingsFormat;
import com.apple.foundationdb.record.lucene.directory.AgilityContext;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FDBLuceneFileReference;
import com.apple.foundationdb.record.lucene.synonym.EnglishSynonymMapConfig;
import com.apple.foundationdb.record.lucene.synonym.SynonymMapConfig;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.JoinedRecordTypeBuilder;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.RecordType;
import com.apple.foundationdb.record.metadata.RecordTypeIndexesBuilder;
import com.apple.foundationdb.record.metadata.expressions.GroupingKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoredRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBSyntheticRecord;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanParameters;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexer;
import com.apple.foundationdb.record.provider.foundationdb.indexes.TextIndexTestUtils;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyStorage;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.Field;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.IndexKeyValueToPartialRecord;
import com.apple.foundationdb.record.query.plan.PlannableIndexTypes;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.query.plan.ScanComparisons;
import com.apple.foundationdb.record.query.plan.match.PlanMatchers;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryFetchFromPartialRecordPlan;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.test.RandomizedTestUtils;
import com.google.common.base.Verify;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.io.Serializable;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.store.Lock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.opentest4j.AssertionFailedError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="RequiresFDB")
public class LuceneIndexTest
extends FDBLuceneTestBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneIndexTest.class);
    private static final String LUCENE_INDEX_MAP_PARAMS = "com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams";
    private static final Index JOINED_INDEX_NOGROUP = LuceneIndexTest.getJoinedIndexNoGroup(Map.of("partitionFieldName", "complex.timestamp", "partitionHighWatermark", "10"));
    private long timestamp60DaysAgo;
    private long timestamp30DaysAgo;
    private long timestamp29DaysAgo;
    private long yesterday;
    protected static final Index MAP_ON_VALUE_INDEX_WITH_AUTO_COMPLETE_2 = new Index("Map_with_auto_complete$entry-value", (KeyExpression)new GroupingKeyExpression((KeyExpression)Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.concat(LuceneIndexTestUtils.keys)), 1), "lucene", (Map)ImmutableMap.of());
    protected static final List<String> autoCompleteCJKPhrases = List.of("\u4e16\u4e0a\u65e0\u96be\u4e8b", "\u4e16\u4e0a\u65e0English word", "\u4e16\u306e\u4e2d\u306b\u96e3\u3057\u3044\u3053\u3068\u306a\u3093\u3066\u306a\u3044", "\u30b7\u30de\u30b9\u98a8\u30c8\u96f7\u30f2", "\u30b7\u30de\u30b9\u98a8\u30c8 \uc2dc\ud5d8@\uae40\uce58\uc624\ub79c", "\ud3c9\uac00\ud588\ub2e4", "\uc138\uc0c1\uc5d0 \uc5b4\ub824\uc6b4 \uc77c\uc740 \uc5c6\ub2e4", "\u7528\u6237@\u4f8b\u5b50.\u5e7f\u544a", "\u304a\u3044\u3057\u3044@\u3059\u3057.\u3042\u3069 \u306a\u3093\u3066\u306a\u3044", "\u30aa\u30a4\u30b7\u30a4@\u30b9\u30b7.\u30a2\u30c9 \u306a\u3093\u3066\u306a\u3044", "\uc2dc\ud5d8@\uae40\uce58\uc624\ub79c.\uad11\uace0", "asb@icloud.com \uae40\uce58\uc624\ub79c");
    private static final List<String> spellcheckWords = List.of("hello", "monitor", "keyboard", "mouse", "trackpad", "cable", "help", "elmo", "elbow", "helps", "helm", "helms", "gulps");
    protected static final List<String> autoCompletes = List.of("Good morning", "Good afternoon", "good evening", "Good night", "That's really good!", "I'm good", "Hello Record Layer", "Hello FoundationDB!", "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'");
    protected static final List<String> autoCompletePhrases = List.of("united states of america", "welcome to the united states of america", "united kingdom, france, the states", "The countries are united kingdom, france, the states", "states united as a country", "all the states united as a country", "states have been united as a country", "all the states have been united as a country", "united states is a country in the continent of america");
    protected static final List<String> capitalizedAutoCaseCompletePhrases = List.of("United States of America", "welcome to the United States of America", "United Kingdom, France, the States", "The countries are United Kingdom, France, the States", "States United as a country", "all the States United as a country", "States have been United as a country", "all the States have been united as a country", "United States is a country in the continent of America", "There is a country called Armenia");

    private Tuple createComplexRecordJoinedToSimple(int group, long docIdSimple, long docIdComplex, String text, String text2, boolean isSeen, long timestamp, Integer score) {
        return this.createComplexRecordJoinedToSimple(group, docIdSimple, docIdComplex, text, text2, isSeen, timestamp, score, null);
    }

    private Tuple createComplexRecordJoinedToSimple(int group, long docIdSimple, long docIdComplex, String text, String text2, boolean isSeen, long timestamp, Integer score, FDBRecordStoreBase.RecordExistenceCheck existenceCheck) {
        TestRecordsTextProto.SimpleDocument simpleDocument = text != null ? LuceneIndexTestUtils.createSimpleDocument(docIdSimple, text, group) : LuceneIndexTestUtils.createSimpleDocument(docIdSimple, group);
        TestRecordsTextProto.ComplexDocument complexDocument = LuceneIndexTestUtils.createComplexDocument(docIdComplex, "", text2, group, score, isSeen, timestamp);
        Tuple syntheticRecordTypeKey = this.recordStore.getRecordMetaData().getSyntheticRecordType("luceneSyntheticComplexJoinedToSimple").getRecordTypeKeyTuple();
        if (existenceCheck != null) {
            Tuple tp = this.recordStore.saveRecord((Message)simpleDocument, existenceCheck).getPrimaryKey();
            return Tuple.from((Object[])new Object[]{syntheticRecordTypeKey.getItems().get(0), this.recordStore.saveRecord((Message)complexDocument).getPrimaryKey().getItems(), tp.getItems()});
        }
        return Tuple.from((Object[])new Object[]{syntheticRecordTypeKey.getItems().get(0), this.recordStore.saveRecord((Message)complexDocument).getPrimaryKey().getItems(), this.recordStore.saveRecord((Message)simpleDocument).getPrimaryKey().getItems()});
    }

    private Tuple createComplexRecordJoinedToManyFields(int group, long docIdMany, long docIdComplex, String text, String text2, boolean isSeen, long timestamp, int score) {
        TestRecordsTextProto.ManyFieldsDocument manyFieldsDocument = TestRecordsTextProto.ManyFieldsDocument.newBuilder().setDocId(docIdMany).setText0(text).setText3(text).setText1(text2).setText4(text2).setBool0(isSeen).setLong0((long)group).build();
        TestRecordsTextProto.ComplexDocument complexDocument = LuceneIndexTestUtils.createComplexDocument(docIdComplex, "", "", group, score, isSeen, timestamp);
        Tuple syntheticRecordTypeKey = this.recordStore.getRecordMetaData().getSyntheticRecordType("luceneSyntheticComplexJoinedToManyFields").getRecordTypeKeyTuple();
        return Tuple.from((Object[])new Object[]{syntheticRecordTypeKey.getItems().get(0), this.recordStore.saveRecord((Message)complexDocument).getPrimaryKey().getItems(), this.recordStore.saveRecord((Message)manyFieldsDocument).getPrimaryKey().getItems()});
    }

    private Tuple createComplexRecordJoinedToMap(int group, long docIdMap, long docIdComplex, String text, String text2, String text3, String text4, boolean isSeen, long timestamp, int score) {
        TestRecordsTextProto.MapDocument mapDocument = LuceneIndexTestUtils.createComplexMapDocument(docIdMap, text, text2, group);
        TestRecordsTextProto.ComplexDocument complexDocument = LuceneIndexTestUtils.createComplexDocument(docIdComplex, "", "", group, score, isSeen, timestamp);
        Tuple syntheticRecordTypeKey = this.recordStore.getRecordMetaData().getSyntheticRecordType("luceneSyntheticComplexJoinedToMap").getRecordTypeKeyTuple();
        return Tuple.from((Object[])new Object[]{syntheticRecordTypeKey.getItems().get(0), this.recordStore.saveRecord((Message)complexDocument).getPrimaryKey().getItems(), this.recordStore.saveRecord((Message)mapDocument).getPrimaryKey().getItems()});
    }

    private void metaDataHookSyntheticRecordComplexJoinedToSimple(RecordMetaDataBuilder metaDataBuilder, Index ... indexes) {
        JoinedRecordTypeBuilder joined = metaDataBuilder.addJoinedRecordType("luceneSyntheticComplexJoinedToSimple");
        joined.addConstituent("complex", "ComplexDocument");
        joined.addConstituent("simple", "SimpleDocument");
        joined.addJoin("simple", (KeyExpression)Key.Expressions.field((String)"group"), "complex", (KeyExpression)Key.Expressions.field((String)"group"));
        for (Index index : indexes) {
            metaDataBuilder.addIndex((RecordTypeIndexesBuilder)joined, index);
        }
    }

    private void metaDataHookSyntheticRecordComplexJoinedToManyFields(RecordMetaDataBuilder metaDataBuilder, Index index) {
        JoinedRecordTypeBuilder joined = metaDataBuilder.addJoinedRecordType("luceneSyntheticComplexJoinedToManyFields");
        joined.addConstituent("complex", "ComplexDocument");
        joined.addConstituent("many", "ManyFieldsDocument");
        joined.addJoin("many", (KeyExpression)Key.Expressions.field((String)"long0"), "complex", (KeyExpression)Key.Expressions.field((String)"group"));
        metaDataBuilder.addIndex((RecordTypeIndexesBuilder)joined, index);
    }

    private void metaDataHookSyntheticRecordComplexJoinedToMap(RecordMetaDataBuilder metaDataBuilder, Index index) {
        JoinedRecordTypeBuilder joined = metaDataBuilder.addJoinedRecordType("luceneSyntheticComplexJoinedToMap");
        joined.addConstituent("complex", "ComplexDocument");
        joined.addConstituent("map", "MapDocument");
        joined.addJoin("map", (KeyExpression)Key.Expressions.field((String)"group"), "complex", (KeyExpression)Key.Expressions.field((String)"group"));
        metaDataBuilder.addIndex((RecordTypeIndexesBuilder)joined, index);
    }

    @Nonnull
    private static Index getJoinedIndexNoGroup(Map<String, String> options) {
        return new Index("joinNestedConcat", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"is_seen"))), (KeyExpression)Key.Expressions.field((String)"simple").nest((KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text"))), (KeyExpression[])new KeyExpression[]{Key.Expressions.field((String)"complex").nest((KeyExpression)Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"timestamp")))}), "lucene", options);
    }

    private static Index getMapOnValueIndexWithOption(@Nonnull String name, @Nonnull ImmutableMap<String, String> options) {
        return new Index(name, (KeyExpression)new GroupingKeyExpression((KeyExpression)Key.Expressions.field((String)"entry", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.concat(LuceneIndexTestUtils.keys)), 3), "lucene", options);
    }

    protected void openRecordStore(FDBRecordContext context, FDBRecordStoreTestBase.RecordMetaDataHook hook) {
        this.openRecordStore(context, hook, "group");
    }

    protected void openRecordStore(FDBRecordContext context, FDBRecordStoreTestBase.RecordMetaDataHook hook, String groupField) {
        RecordMetaDataBuilder metaDataBuilder = RecordMetaData.newBuilder().setRecords(TestRecordsTextProto.getDescriptor());
        metaDataBuilder.getRecordType("ComplexDocument").setPrimaryKey((KeyExpression)Key.Expressions.concatenateFields((String)groupField, (String)"doc_id", (String[])new String[0]));
        hook.apply(metaDataBuilder);
        this.recordStore = (FDBRecordStore)this.getStoreBuilder(context, metaDataBuilder.getRecordMetaData()).createOrOpen();
        PlannableIndexTypes indexTypes = new PlannableIndexTypes((Set)Sets.newHashSet((Object[])new String[]{"value", "version"}), (Set)Sets.newHashSet((Object[])new String[]{"rank", "time_window_leaderboard"}), (Set)Sets.newHashSet((Object[])new String[]{"text"}), (Set)Sets.newHashSet((Object[])new String[]{"lucene"}));
        this.planner = new LucenePlanner(this.recordStore.getRecordMetaData(), this.recordStore.getRecordStoreState(), indexTypes, this.recordStore.getTimer());
        this.planner.setConfiguration(this.planner.getConfiguration().asBuilder().setPlanOtherAttemptWholeFilter(false).build());
        this.recordStore.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(true);
    }

    protected RecordLayerPropertyStorage.Builder addDefaultProps(RecordLayerPropertyStorage.Builder props) {
        return super.addDefaultProps(props).addProp(LuceneRecordContextProperties.LUCENE_INDEX_COMPRESSION_ENABLED, (Object)true);
    }

    private LuceneScanBounds specificFieldSearch(Index index, String search, String field) {
        LuceneScanQueryParameters scan = new LuceneScanQueryParameters(ScanComparisons.EMPTY, (LuceneQueryClause)new LuceneQuerySearchClause(LuceneQueryType.QUERY, field, search, false));
        return scan.bind((FDBRecordStoreBase)this.recordStore, index, EvaluationContext.EMPTY);
    }

    @Nonnull
    private LuceneScanBounds groupedAutoCompleteBounds(@Nonnull Index index, @Nonnull String search, @Nonnull Object group, @Nonnull Iterable<String> fields) {
        LuceneScanParameters scan = LuceneIndexTest.groupedAutoCompleteScanParams(search, group, fields);
        return scan.bind((FDBRecordStoreBase)this.recordStore, index, EvaluationContext.EMPTY);
    }

    @Nonnull
    protected static LuceneScanParameters groupedAutoCompleteScanParams(@Nonnull String search, @Nonnull Object group, @Nonnull Iterable<String> fields) {
        return new LuceneScanQueryParameters((ScanComparisons)Verify.verifyNotNull((Object)ScanComparisons.from((Comparisons.Comparison)new Comparisons.SimpleComparison(Comparisons.Type.EQUALS, group))), (LuceneQueryClause)new LuceneAutoCompleteQueryClause(search, false, fields));
    }

    @Nonnull
    private LuceneScanBounds autoCompleteBounds(@Nonnull Index index, @Nonnull String search, @Nonnull Iterable<String> fields) {
        LuceneScanParameters scan = this.autoCompleteScanParams(search, fields);
        return scan.bind((FDBRecordStoreBase)this.recordStore, index, EvaluationContext.EMPTY);
    }

    @Nonnull
    private LuceneScanParameters autoCompleteScanParams(@Nonnull String search, @Nonnull Iterable<String> fields) {
        return new LuceneScanQueryParameters((ScanComparisons)Verify.verifyNotNull((Object)ScanComparisons.EMPTY), (LuceneQueryClause)new LuceneAutoCompleteQueryClause(search, false, fields));
    }

    private LuceneScanBounds spellCheck(Index index, String search) {
        LuceneScanSpellCheckParameters scan = new LuceneScanSpellCheckParameters(ScanComparisons.EMPTY, search, false);
        return scan.bind((FDBRecordStoreBase)this.recordStore, index, EvaluationContext.EMPTY);
    }

    private LuceneScanBounds groupedSpellCheck(Index index, String search, Object group) {
        LuceneScanSpellCheckParameters scan = new LuceneScanSpellCheckParameters((ScanComparisons)Verify.verifyNotNull((Object)ScanComparisons.from((Comparisons.Comparison)new Comparisons.SimpleComparison(Comparisons.Type.EQUALS, group))), search, false);
        return scan.bind((FDBRecordStoreBase)this.recordStore, index, EvaluationContext.EMPTY);
    }

    @Test
    void basicGroupedPartitionedTest() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "ComplexDocument", COMPLEX_PARTITIONED);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(6666L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1L, Instant.now().toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(7777L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2L, Instant.now().toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(8888L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 2L, Instant.now().plus(1L, ChronoUnit.DAYS).toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(9999L, "hello world!", 1L, Instant.now().plus(2L, ChronoUnit.DAYS).toEpochMilli()));
            this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{2, 7777L})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(COMPLEX_PARTITIONED, (IndexScanBounds)this.groupedTextSearch(COMPLEX_PARTITIONED, "text:propose", 2), null, ScanProperties.FORWARD_SCAN));
            Assertions.assertEquals((int)1, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            this.assertIndexEntryPrimaryKeyTuples(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(COMPLEX_PARTITIONED, (IndexScanBounds)this.groupedTextSearch(COMPLEX_PARTITIONED, "text:things", 1), null, ScanProperties.FORWARD_SCAN));
            Assertions.assertEquals((int)1, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{1, 6666L}));
            this.assertIndexEntryPrimaryKeyTuples(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(COMPLEX_PARTITIONED, (IndexScanBounds)this.groupedTextSearch(COMPLEX_PARTITIONED, "text:propose", 1), null, ScanProperties.FORWARD_SCAN));
            Subspace partition1Subspace = this.recordStore.indexSubspace(COMPLEX_PARTITIONED).subspace(Tuple.from((Object[])new Object[]{1, 1}).add(0L));
            Subspace partition2Subspace = this.recordStore.indexSubspace(COMPLEX_PARTITIONED).subspace(Tuple.from((Object[])new Object[]{2, 1}).add(0L));
            LuceneIndexTest.validateSegmentAndIndexIntegrity(COMPLEX_PARTITIONED, partition1Subspace, context, "_0.cfs");
            LuceneIndexTest.validateSegmentAndIndexIntegrity(COMPLEX_PARTITIONED, partition2Subspace, context, "_0.cfs");
        }
    }

    @Test
    void basicNonGroupedPartitionedTest() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "ComplexDocument", COMPLEX_PARTITIONED_NOGROUP);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(6666L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1L, Instant.now().toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(7777L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2L, Instant.now().toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(8888L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 2L, Instant.now().plus(1L, ChronoUnit.DAYS).toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(9999L, "hello world!", 1L, Instant.now().plus(2L, ChronoUnit.DAYS).toEpochMilli()));
            this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{2, 7777L}), Tuple.from((Object[])new Object[]{1, 6666L})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(COMPLEX_PARTITIONED_NOGROUP, (IndexScanBounds)this.fullTextSearch(COMPLEX_PARTITIONED_NOGROUP, "text:propose"), null, ScanProperties.FORWARD_SCAN));
            Assertions.assertEquals((int)2, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{1, 6666L}));
            this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{2, 7777L})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(COMPLEX_PARTITIONED_NOGROUP, (IndexScanBounds)this.fullTextSearch(COMPLEX_PARTITIONED_NOGROUP, "text:propose"), null, ScanProperties.FORWARD_SCAN));
            Subspace partition1Subspace = this.recordStore.indexSubspace(COMPLEX_PARTITIONED_NOGROUP).subspace(Tuple.from((Object[])new Object[]{1}).add(0L));
            LuceneIndexTest.validateSegmentAndIndexIntegrity(COMPLEX_PARTITIONED_NOGROUP, partition1Subspace, context, "_0.cfs");
        }
    }

    @Test
    void testBlockCacheRemove() {
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_BLOCK_CACHE_MAXIMUM_SIZE, (Object)2).build();
        try (FDBRecordContext context = this.openContext(contextProps);){
            this.rebuildIndexMetaData(context, "ComplexDocument", COMPLEX_PARTITIONED_NOGROUP);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(6666L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1L, Instant.now().toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(7777L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2L, Instant.now().toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(8888L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 2L, Instant.now().plus(1L, ChronoUnit.DAYS).toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(9999L, "hello world!", 1L, Instant.now().plus(2L, ChronoUnit.DAYS).toEpochMilli()));
            context.commit();
            FDBStoreTimer timer = context.getTimer();
            Assertions.assertTrue((timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_BLOCK_CACHE_REMOVE) > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    void testBlockCacheNotRemove() {
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_BLOCK_CACHE_MAXIMUM_SIZE, (Object)1000).build();
        try (FDBRecordContext context = this.openContext(contextProps);){
            this.rebuildIndexMetaData(context, "ComplexDocument", COMPLEX_PARTITIONED_NOGROUP);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(6666L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1L, Instant.now().toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(7777L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2L, Instant.now().toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(8888L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 2L, Instant.now().plus(1L, ChronoUnit.DAYS).toEpochMilli()));
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(9999L, "hello world!", 1L, Instant.now().plus(2L, ChronoUnit.DAYS).toEpochMilli()));
            context.commit();
            FDBStoreTimer timer = context.getTimer();
            Assertions.assertEquals((int)timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_BLOCK_CACHE_REMOVE), (int)0);
            Assertions.assertTrue((timer.getCount((StoreTimer.Event)LuceneEvents.Waits.WAIT_LUCENE_GET_DATA_BLOCK) > 0 ? 1 : 0) != 0);
        }
    }

    static Stream<Pair<Index, Tuple>> dualGroupModeIndexProvider() {
        return Stream.of(Pair.of((Object)COMPLEX_PARTITIONED, (Object)Tuple.from((Object[])new Object[]{1L})), Pair.of((Object)COMPLEX_PARTITIONED_NOGROUP, (Object)Tuple.from((Object[])new Object[0])));
    }

    @ParameterizedTest
    @MethodSource(value={"dualGroupModeIndexProvider"})
    void repartitionGroupedTest(Pair<Index, Tuple> indexAndGroupingKey) throws IOException {
        Index index = (Index)indexAndGroupingKey.getLeft();
        Tuple groupingKey = (Tuple)indexAndGroupingKey.getRight();
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)6).build();
        int totalDocCount = 20;
        Consumer<FDBRecordContext> schemaSetup = context -> this.rebuildIndexMetaData((FDBRecordContext)context, "ComplexDocument", index);
        long docGroupFieldValue = groupingKey.isEmpty() ? 0L : groupingKey.getLong(0);
        try (FDBRecordContext context2 = this.openContext(contextProps);){
            schemaSetup.accept(context2);
            long start = Instant.now().toEpochMilli();
            for (int i = 0; i < 20; ++i) {
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1000L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, start + (long)(i * 100)));
            }
            this.commit(context2);
        }
        List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfos = this.getPartitionMeta(index, groupingKey, contextProps, schemaSetup);
        Assertions.assertEquals((int)1, (int)partitionInfos.size());
        Assertions.assertEquals((int)20, (int)partitionInfos.get(0).getCount());
        this.explicitMergeIndex(index, contextProps, schemaSetup);
        try (FDBRecordContext context3 = this.openContext(contextProps);){
            schemaSetup.accept(context3);
            Assertions.assertEquals((int)1, (int)this.getCounter(context3, (StoreTimer.Event)LuceneEvents.Counts.LUCENE_REPARTITION_CALLS).getCount());
        }
        partitionInfos = this.getPartitionMeta(index, groupingKey, contextProps, schemaSetup);
        Assertions.assertEquals(List.of(Integer.valueOf(6), Integer.valueOf(6), Integer.valueOf(8)), partitionInfos.stream().sorted(Comparator.comparing(partitionInfo -> Tuple.fromBytes((byte[])partitionInfo.getFrom().toByteArray()))).map(LucenePartitionInfoProto.LucenePartitionInfo::getCount).collect(Collectors.toList()));
        Assertions.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(0)), partitionInfos.stream().sorted(Comparator.comparing(partitionInfo -> Tuple.fromBytes((byte[])partitionInfo.getFrom().toByteArray()))).map(LucenePartitionInfoProto.LucenePartitionInfo::getId).collect(Collectors.toList()));
        this.explicitMergeIndex(index, contextProps, schemaSetup);
        Assertions.assertEquals(partitionInfos, this.getPartitionMeta(index, groupingKey, contextProps, schemaSetup));
        context3 = this.openContext(contextProps);
        try {
            schemaSetup.accept(context3);
            Assertions.assertEquals((int)2, (int)this.getCounter(context3, (StoreTimer.Event)LuceneEvents.Counts.LUCENE_REPARTITION_CALLS).getCount());
            this.validateDocsInPartition(index, 0, groupingKey, this.makeKeyTuples(docGroupFieldValue, 1012, 1019), "text:propose");
            this.validateDocsInPartition(index, 2, groupingKey, this.makeKeyTuples(docGroupFieldValue, 1006, 1011), "text:propose");
            this.validateDocsInPartition(index, 1, groupingKey, this.makeKeyTuples(docGroupFieldValue, 1000, 1005), "text:propose");
        }
        finally {
            if (context3 != null) {
                context3.close();
            }
        }
    }

    public static Stream<Arguments> repartitionAndMerge() {
        return Stream.of(2, 3).flatMap(repartitionCount -> Stream.of(Integer.valueOf(2)).flatMap(mergeSegmentsPerTier -> Stream.of(Arguments.of((Object[])new Object[]{COMPLEX_PARTITIONED, Tuple.from((Object[])new Object[]{1}), repartitionCount, mergeSegmentsPerTier}), Arguments.of((Object[])new Object[]{COMPLEX_PARTITIONED_NOGROUP, Tuple.from((Object[])new Object[0]), repartitionCount, mergeSegmentsPerTier}))));
    }

    @Tag(value="Slow")
    @ParameterizedTest
    @MethodSource
    void repartitionAndMerge(Index index, Tuple groupingKey, int repartitionCount, int mergeSegmentsPerTier) throws IOException {
        int partitionCount;
        int partitionSize;
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)repartitionCount).addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)mergeSegmentsPerTier).build();
        Consumer<FDBRecordContext> schemaSetup = context -> this.rebuildIndexMetaData((FDBRecordContext)context, "ComplexDocument", index);
        long docGroupFieldValue = groupingKey.isEmpty() ? 0L : groupingKey.getLong(0);
        int transactionCount = 100;
        int docsPerTransaction = 2;
        long id = 0L;
        ArrayList<Long> allIds = new ArrayList<Long>();
        for (int i = 0; i < transactionCount; ++i) {
            try (FDBRecordContext context2 = this.openContext(contextProps);){
                schemaSetup.accept(context2);
                this.recordStore.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(false);
                long start = Instant.now().toEpochMilli();
                for (int j = 0; j < docsPerTransaction; ++j) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(++id, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, start + id));
                    allIds.add(id);
                }
                this.commit(context2);
                continue;
            }
        }
        Assertions.assertEquals(Map.of(0, transactionCount), this.getSegmentCounts(index, groupingKey, contextProps, schemaSetup));
        this.timer.reset();
        this.explicitMergeIndex(index, contextProps, schemaSetup);
        Map<Integer, Integer> segmentCounts = this.getSegmentCounts(index, groupingKey, contextProps, schemaSetup);
        int n = partitionSize = repartitionCount == 3 ? 9 : 10;
        if (repartitionCount == 3) {
            partitionCount = allIds.size() / partitionSize + 1;
            MatcherAssert.assertThat(segmentCounts, (Matcher)Matchers.aMapWithSize((int)partitionCount));
            Assertions.assertEquals(IntStream.range(0, partitionCount).boxed().collect(Collectors.toMap(Function.identity(), partitionId -> partitionId == partitionCount - 1 ? 1 : 2)), segmentCounts);
        } else {
            partitionCount = allIds.size() / partitionSize;
            MatcherAssert.assertThat(segmentCounts, (Matcher)Matchers.aMapWithSize((int)partitionCount));
            Assertions.assertEquals(IntStream.range(0, partitionCount).boxed().collect(Collectors.toMap(Function.identity(), partitionId -> 2)), segmentCounts);
        }
        try (FDBRecordContext context3 = this.openContext(contextProps);){
            schemaSetup.accept(context3);
            this.validateDocsInPartition(index, 0, groupingKey, allIds.stream().skip(repartitionCount == 3 ? 192L : 190L).map(idLong -> Tuple.from((Object[])new Object[]{docGroupFieldValue, idLong})).collect(Collectors.toSet()), "text:propose");
            for (int i = 1; i < 20; ++i) {
                this.validateDocsInPartition(index, i, groupingKey, allIds.stream().skip((i - 1) * partitionSize).limit(partitionSize).map(idLong -> Tuple.from((Object[])new Object[]{docGroupFieldValue, idLong})).collect(Collectors.toSet()), "text:propose");
            }
            List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfos = this.getPartitionMeta(index, groupingKey, contextProps, schemaSetup);
            Assertions.assertEquals((int)partitionCount, (int)partitionInfos.size());
        }
    }

    @Test
    void repartitionSyntheticGroupedTest() throws IOException {
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)6).build();
        int totalDocCount = 20;
        Consumer<FDBRecordContext> schemaSetup = context -> this.openRecordStore((FDBRecordContext)context, LuceneIndexTest::joinedPartitionedLuceneIndexMetadataHook);
        ArrayList<Tuple> ids = new ArrayList<Tuple>();
        try (FDBRecordContext context2 = this.openContext(contextProps);){
            schemaSetup.accept(context2);
            long start = Instant.now().toEpochMilli();
            for (int i = 0; i < 20; ++i) {
                TestRecordsTextProto.ComplexDocument complexDocument = TestRecordsTextProto.ComplexDocument.newBuilder().setGroup(42L).setDocId(1000L + (long)i).setIsSeen(true).setHeader(TestRecordsTextProto.ComplexDocument.Header.newBuilder().setHeaderId(1000L - (long)i)).setTimestamp(start + (long)(i * 100)).build();
                TestRecordsTextProto.SimpleDocument simpleDocument = TestRecordsTextProto.SimpleDocument.newBuilder().setGroup(42L).setDocId(1000L - (long)i).setText("Four score and seven years ago our fathers brought forth propose").build();
                Tuple syntheticRecordTypeKey = this.recordStore.getRecordMetaData().getSyntheticRecordType("luceneJoinedPartitionedIdx").getRecordTypeKeyTuple();
                ids.add(Tuple.from((Object[])new Object[]{syntheticRecordTypeKey.getItems().get(0), this.recordStore.saveRecord((Message)complexDocument).getPrimaryKey().getItems(), this.recordStore.saveRecord((Message)simpleDocument).getPrimaryKey().getItems()}));
            }
            this.commit(context2);
        }
        Tuple groupingKey = Tuple.from((Object[])new Object[]{42});
        List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfos = this.getPartitionMeta(JOINED_INDEX, groupingKey, contextProps, schemaSetup);
        Assertions.assertEquals((int)1, (int)partitionInfos.size());
        Assertions.assertEquals((int)20, (int)partitionInfos.get(0).getCount());
        this.explicitMergeIndex(JOINED_INDEX, contextProps, schemaSetup);
        partitionInfos = this.getPartitionMeta(JOINED_INDEX, groupingKey, contextProps, schemaSetup);
        Assertions.assertEquals(List.of(Integer.valueOf(6), Integer.valueOf(6), Integer.valueOf(8)), partitionInfos.stream().sorted(Comparator.comparing(partitionInfo -> Tuple.fromBytes((byte[])partitionInfo.getFrom().toByteArray()))).map(LucenePartitionInfoProto.LucenePartitionInfo::getCount).collect(Collectors.toList()));
        Assertions.assertEquals(List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(0)), partitionInfos.stream().sorted(Comparator.comparing(partitionInfo -> Tuple.fromBytes((byte[])partitionInfo.getFrom().toByteArray()))).map(LucenePartitionInfoProto.LucenePartitionInfo::getId).collect(Collectors.toList()));
        this.explicitMergeIndex(JOINED_INDEX, contextProps, schemaSetup);
        Assertions.assertEquals(partitionInfos, this.getPartitionMeta(JOINED_INDEX, groupingKey, contextProps, schemaSetup));
        try (FDBRecordContext context3 = this.openContext(contextProps);){
            schemaSetup.accept(context3);
            this.validateDocsInPartition(JOINED_INDEX, 0, groupingKey, Set.copyOf(ids.subList(12, 20)), "simple_text:propose");
            this.validateDocsInPartition(JOINED_INDEX, 2, groupingKey, Set.copyOf(ids.subList(6, 12)), "simple_text:propose");
            this.validateDocsInPartition(JOINED_INDEX, 1, groupingKey, Set.copyOf(ids.subList(0, 6)), "simple_text:propose");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"dualGroupModeIndexProvider"})
    void optimizedPartitionInsertionTest(Pair<Index, Tuple> indexAndGroupingKey) throws IOException {
        int i;
        Index index = (Index)indexAndGroupingKey.getLeft();
        Tuple groupingKey = (Tuple)indexAndGroupingKey.getRight();
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)6).build();
        int totalDocCount = 10;
        Consumer<FDBRecordContext> schemaSetup = context -> this.rebuildIndexMetaData((FDBRecordContext)context, "ComplexDocument", index);
        long docGroupFieldValue = groupingKey.isEmpty() ? 0L : groupingKey.getLong(0);
        long start = Instant.now().toEpochMilli();
        try (FDBRecordContext context2 = this.openContext(contextProps);){
            schemaSetup.accept(context2);
            for (i = 0; i < 10; ++i) {
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1000L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, start + (long)(i * 100)));
            }
            this.commit(context2);
        }
        context2 = this.openContext(contextProps);
        try {
            schemaSetup.accept(context2);
            this.validateDocsInPartition(index, 0, groupingKey, this.makeKeyTuples(docGroupFieldValue, 1000, 1009), "text:propose");
        }
        finally {
            if (context2 != null) {
                context2.close();
            }
        }
        context2 = this.openContext(contextProps);
        try {
            schemaSetup.accept(context2);
            for (i = 0; i < 20; ++i) {
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1010L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", docGroupFieldValue, start - (long)i - 1L));
            }
            this.validateDocsInPartition(index, 1, groupingKey, this.makeKeyTuples(docGroupFieldValue, 1010, 1019), "text:propose");
            this.validateDocsInPartition(index, 2, groupingKey, this.makeKeyTuples(docGroupFieldValue, 1020, 1029), "text:propose");
        }
        finally {
            if (context2 != null) {
                context2.close();
            }
        }
    }

    private void explicitMergeIndex(Index index, RecordLayerPropertyStorage contextProps, Consumer<FDBRecordContext> schemaSetup) {
        try (FDBRecordContext context = this.openContext(contextProps);){
            schemaSetup.accept(context);
            try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).setTimer(this.timer)).build();){
                indexBuilder.mergeIndex();
            }
        }
    }

    private static void joinedPartitionedLuceneIndexMetadataHook(@Nonnull RecordMetaDataBuilder metaDataBuilder) {
        metaDataBuilder.addIndex((RecordTypeIndexesBuilder)LuceneIndexTest.joinedMetadataHook(metaDataBuilder), JOINED_INDEX);
    }

    private static void joinedPartitionedUngroupedLuceneIndexMetadataHook(@Nonnull RecordMetaDataBuilder metaDataBuilder) {
        metaDataBuilder.addIndex((RecordTypeIndexesBuilder)LuceneIndexTest.joinedMetadataHook(metaDataBuilder), JOINED_INDEX_NOGROUP);
    }

    private static JoinedRecordTypeBuilder joinedMetadataHook(@Nonnull RecordMetaDataBuilder metaDataBuilder) {
        JoinedRecordTypeBuilder joined = metaDataBuilder.addJoinedRecordType("luceneJoinedPartitionedIdx");
        joined.addConstituent("complex", "ComplexDocument");
        joined.addConstituent("simple", "SimpleDocument");
        joined.addJoin("simple", (KeyExpression)Key.Expressions.field((String)"doc_id"), "complex", (KeyExpression)Key.Expressions.field((String)"header").nest("header_id"));
        return joined;
    }

    @Test
    void partitionedJoinedIndexTest() {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, LuceneIndexTest::joinedPartitionedUngroupedLuceneIndexMetadataHook);
            TestRecordsTextProto.ComplexDocument complexDocument = TestRecordsTextProto.ComplexDocument.newBuilder().setGroup(42L).setDocId(5L).setIsSeen(true).setHeader(TestRecordsTextProto.ComplexDocument.Header.newBuilder().setHeaderId(143L)).setTimestamp(System.currentTimeMillis()).build();
            TestRecordsTextProto.SimpleDocument simpleDocument = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(143L).setGroup(42L).setText("Four score and seven years ago our fathers brought forth").build();
            this.recordStore.saveRecord((Message)complexDocument);
            this.recordStore.saveRecord((Message)simpleDocument);
            String luceneSearch = "simple_text: \"fathers\"";
            LuceneQueryComponent filter = new LuceneQueryComponent(luceneSearch, List.of("simple", "complex"));
            RecordQuery query = RecordQuery.newBuilder().setRecordType("luceneJoinedPartitionedIdx").setFilter((QueryComponent)filter).setRequiredResults(List.of(Key.Expressions.field((String)"simple").nest("text"))).build();
            RecordQueryPlan plan = this.planner.plan(query);
            List results = (List)plan.execute(this.recordStore).asList().join();
            Assertions.assertNotNull((Object)results);
            Assertions.assertEquals((int)1, (int)results.size());
        }
    }

    private Pair<Index, Consumer<FDBRecordContext>> setupIndex(Map<String, String> options, boolean isGrouped, boolean isSynthetic) {
        Consumer<FDBRecordContext> schemaSetup;
        Index index;
        if (isGrouped) {
            if (isSynthetic) {
                index = LuceneIndexTest.getJoinedIndex(options);
                schemaSetup = context -> this.openRecordStore((FDBRecordContext)context, metaDataBuilder -> metaDataBuilder.addIndex((RecordTypeIndexesBuilder)LuceneIndexTest.joinedMetadataHook(metaDataBuilder), index));
            } else {
                index = LuceneIndexTest.complexPartitionedIndex(options);
                schemaSetup = context -> this.rebuildIndexMetaData((FDBRecordContext)context, "ComplexDocument", index);
            }
        } else if (isSynthetic) {
            index = LuceneIndexTest.getJoinedIndexNoGroup(options);
            schemaSetup = context -> this.openRecordStore((FDBRecordContext)context, metaDataBuilder -> metaDataBuilder.addIndex((RecordTypeIndexesBuilder)LuceneIndexTest.joinedMetadataHook(metaDataBuilder), index));
        } else {
            index = LuceneIndexTest.complexPartitionedIndexNoGroup(options);
            schemaSetup = context -> this.rebuildIndexMetaData((FDBRecordContext)context, "ComplexDocument", index);
        }
        return Pair.of((Object)index, schemaSetup);
    }

    static Stream<Arguments> continuationDuringRepartitioningTest() {
        return Stream.of(true, false).flatMap(grouped -> Stream.of(true, false).flatMap(uniqueTimestamps -> Stream.of(true, false).flatMap(synthetic -> Arrays.stream(SortType.values()).map(sortType -> Arguments.of((Object[])new Object[]{grouped, synthetic, uniqueTimestamps, sortType})))));
    }

    @ParameterizedTest(name="isGrouped: {0}, isSynthetic: {1}, with unique timestamps: {2}, sort type: {3}")
    @MethodSource
    void continuationDuringRepartitioningTest(boolean isGrouped, boolean isSynthetic, boolean uniqueTimestamps, SortType sortType) throws IOException, ExecutionException, InterruptedException {
        byte[] continuation;
        List entries;
        RecordCursor indexEntryCursor;
        Map<String, String> options = Map.of("partitionFieldName", isSynthetic ? "complex.timestamp" : "timestamp", "partitionHighWatermark", String.valueOf(10));
        Pair<Index, Consumer<FDBRecordContext>> indexConsumerPair = this.setupIndex(options, isGrouped, isSynthetic);
        Index index = (Index)indexConsumerPair.getLeft();
        Consumer schemaSetup = (Consumer)indexConsumerPair.getRight();
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)6).build();
        int group = isGrouped ? 1 : 0;
        Tuple groupTuple = isGrouped ? Tuple.from((Object[])new Object[]{group}) : Tuple.from((Object[])new Object[0]);
        long start = Instant.now().toEpochMilli();
        String luceneSearch = isSynthetic ? "simple_text:forth" : "text:about";
        int docCount = 25;
        ArrayList<Tuple> primaryKeys = new ArrayList<Tuple>();
        try (FDBRecordContext context = this.openContext(contextProps);){
            schemaSetup.accept(context);
            for (int i = 0; i < 25; ++i) {
                Tuple primaryKey;
                TestRecordsTextProto.ComplexDocument complexDocument = TestRecordsTextProto.ComplexDocument.newBuilder().setGroup((long)group).setDocId(1000L + (long)i).setIsSeen(true).setText("A word about what I want to say").setTimestamp(uniqueTimestamps ? start + (long)(i * 100) : start).setHeader(TestRecordsTextProto.ComplexDocument.Header.newBuilder().setHeaderId(1000L - (long)i)).build();
                if (isSynthetic) {
                    TestRecordsTextProto.SimpleDocument simpleDocument = TestRecordsTextProto.SimpleDocument.newBuilder().setGroup((long)group).setDocId(1000L - (long)i).setText("Four score and seven years ago our fathers brought forth").build();
                    Tuple syntheticRecordTypeKey = this.recordStore.getRecordMetaData().getSyntheticRecordType("luceneJoinedPartitionedIdx").getRecordTypeKeyTuple();
                    primaryKey = Tuple.from((Object[])new Object[]{syntheticRecordTypeKey.getItems().get(0), this.recordStore.saveRecord((Message)complexDocument).getPrimaryKey().getItems(), this.recordStore.saveRecord((Message)simpleDocument).getPrimaryKey().getItems()});
                } else {
                    primaryKey = this.recordStore.saveRecord((Message)complexDocument).getPrimaryKey();
                }
                primaryKeys.add(primaryKey);
            }
            this.commit(context);
        }
        List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfos = this.getPartitionMeta(index, groupTuple, contextProps, schemaSetup);
        Assertions.assertEquals((int)1, (int)partitionInfos.size());
        Assertions.assertEquals((int)25, (int)partitionInfos.get(0).getCount());
        Sort sort = sortType == SortType.UNSORTED ? null : new Sort(new SortField(isSynthetic ? "complex_timestamp" : "timestamp", SortField.Type.LONG, sortType == SortType.DESCENDING));
        LuceneScanQueryParameters scan = new LuceneScanQueryParameters(isGrouped ? (ScanComparisons)Verify.verifyNotNull((Object)ScanComparisons.from((Comparisons.Comparison)new Comparisons.SimpleComparison(Comparisons.Type.EQUALS, (Object)group))) : ScanComparisons.EMPTY, (LuceneQueryClause)new LuceneQueryMultiFieldSearchClause(LuceneQueryType.QUERY, luceneSearch, false), sort, null, null, null);
        LuceneScanQuery scanQuery = scan.bind((FDBRecordStoreBase)this.recordStore, index, EvaluationContext.EMPTY);
        try (FDBRecordContext context = this.openContext(contextProps);){
            schemaSetup.accept(context);
            indexEntryCursor = this.recordStore.scanIndex(index, (IndexScanBounds)scanQuery, null, ExecuteProperties.newBuilder().setReturnedRowLimit(15).build().asScanProperties(false));
            entries = (List)indexEntryCursor.asList().join();
            Assertions.assertEquals((int)15, (int)entries.size());
            RecordCursorResult lastResult = (RecordCursorResult)indexEntryCursor.onNext().get();
            Assertions.assertEquals((Object)RecordCursor.NoNextReason.RETURN_LIMIT_REACHED, (Object)lastResult.getNoNextReason());
            LuceneContinuationProto.LuceneIndexContinuation parsed = LuceneContinuationProto.LuceneIndexContinuation.parseFrom((byte[])lastResult.getContinuation().toBytes());
            Assertions.assertEquals((int)0, (int)parsed.getPartitionId());
            Set expectedKeys = sortType == SortType.ASCENDING || sortType == SortType.UNSORTED ? Set.copyOf(primaryKeys.subList(0, 15)) : Set.copyOf(primaryKeys.subList(10, 25));
            Assertions.assertEquals(expectedKeys, entries.stream().map(IndexEntry::getPrimaryKey).collect(Collectors.toSet()));
            continuation = lastResult.getContinuation().toBytes();
        }
        this.explicitMergeIndex(index, contextProps, schemaSetup);
        context = this.openContext(contextProps);
        try {
            schemaSetup.accept(context);
            Assertions.assertEquals((int)1, (int)this.getCounter(context, (StoreTimer.Event)LuceneEvents.Counts.LUCENE_REPARTITION_CALLS).getCount());
            this.validateDocsInPartition(index, 0, groupTuple, Set.copyOf(primaryKeys.subList(18, 25)), luceneSearch);
            this.validateDocsInPartition(index, 3, groupTuple, Set.copyOf(primaryKeys.subList(12, 18)), luceneSearch);
            this.validateDocsInPartition(index, 2, groupTuple, Set.copyOf(primaryKeys.subList(6, 12)), luceneSearch);
            this.validateDocsInPartition(index, 1, groupTuple, Set.copyOf(primaryKeys.subList(0, 6)), luceneSearch);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext(contextProps);
        try {
            int expectedCount;
            Set expectedKeys;
            schemaSetup.accept(context);
            indexEntryCursor = this.recordStore.scanIndex(index, (IndexScanBounds)scanQuery, continuation, ExecuteProperties.newBuilder().build().asScanProperties(false));
            entries = (List)indexEntryCursor.asList().join();
            RecordCursorResult lastResult = (RecordCursorResult)indexEntryCursor.onNext().get();
            if (sortType == SortType.ASCENDING) {
                expectedKeys = Set.copyOf(primaryKeys.subList(15, 25));
                expectedCount = 10;
            } else if (sortType == SortType.DESCENDING) {
                expectedKeys = Set.copyOf(primaryKeys.subList(0, 10));
                expectedCount = 10;
            } else {
                expectedKeys = Set.copyOf(primaryKeys.subList(0, 18));
                expectedCount = 18;
            }
            Assertions.assertEquals((int)expectedCount, (int)entries.size());
            Assertions.assertEquals(expectedKeys, entries.stream().map(IndexEntry::getPrimaryKey).collect(Collectors.toSet()));
            Assertions.assertEquals((Object)RecordCursor.NoNextReason.SOURCE_EXHAUSTED, (Object)lastResult.getNoNextReason());
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    Pair<int[], Integer> calculateAndValidateRepartitioningExpectations(List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfos, int docCount, int highWaterMark, int docCountPerTxn, int maxCountPerRebalanceCall, int actualRepartitionCallCount) {
        int[] docDistribution;
        int countActuallyMovedPerTxn = Math.min(docCountPerTxn, highWaterMark);
        int maxCreatedPartitionCapacity = (int)Math.floor((double)highWaterMark / (double)countActuallyMovedPerTxn) * countActuallyMovedPerTxn;
        int partitionCount = docCount / maxCreatedPartitionCapacity;
        if (maxCreatedPartitionCapacity + docCount % maxCreatedPartitionCapacity > highWaterMark) {
            ++partitionCount;
        }
        if (partitionCount == 1) {
            docDistribution = new int[]{docCount};
        } else {
            docDistribution = new int[partitionCount];
            if (partitionCount > 2) {
                Arrays.fill(docDistribution, 1, docDistribution.length - 1, maxCreatedPartitionCapacity);
            }
            int remainder = docCount - (docDistribution.length - 2) * maxCreatedPartitionCapacity;
            int lastCount = (int)Math.ceil((double)(remainder - highWaterMark) / (double)countActuallyMovedPerTxn) * countActuallyMovedPerTxn;
            docDistribution[0] = remainder - lastCount;
            docDistribution[docDistribution.length - 1] = lastCount;
        }
        int maxIterations = Math.max(1, maxCountPerRebalanceCall / docCountPerTxn);
        int docsMovedPerCall = maxIterations * countActuallyMovedPerTxn;
        int totalMovedDocs = docCount - docDistribution[0];
        int expectedRepartitionCallCount = (int)Math.ceil((double)totalMovedDocs / (double)docsMovedPerCall);
        if (totalMovedDocs % docsMovedPerCall == 0) {
            ++expectedRepartitionCallCount;
        }
        Assertions.assertTrue((actualRepartitionCallCount == -1 || expectedRepartitionCallCount == actualRepartitionCallCount ? 1 : 0) != 0);
        Assertions.assertEquals((int)partitionInfos.size(), (int)partitionCount);
        Assertions.assertEquals(partitionInfos.stream().sorted(Comparator.comparing(LucenePartitionInfoProto.LucenePartitionInfo::getId)).map(LucenePartitionInfoProto.LucenePartitionInfo::getCount).collect(Collectors.toList()), Arrays.stream(docDistribution).boxed().collect(Collectors.toList()));
        return Pair.of((Object)docDistribution, (Object)expectedRepartitionCallCount);
    }

    static Stream<Arguments> capDocCountMovedDuringRepartitioningMultigroupTest() {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        return Stream.of(Arguments.of((Object[])new Object[]{10, 4, 6, new int[]{51, 32}}), Arguments.of((Object[])new Object[]{((Random)r).nextInt(30) + 5, ((Random)r).nextInt(8) + 2, ((Random)r).nextInt(16) + 1, new int[]{((Random)r).nextInt(30) + 20, ((Random)r).nextInt(30) + 20, ((Random)r).nextInt(30) + 20}}), Arguments.of((Object[])new Object[]{((Random)r).nextInt(30) + 5, ((Random)r).nextInt(8) + 2, ((Random)r).nextInt(16) + 1, new int[]{((Random)r).nextInt(80) + 20}}), Arguments.of((Object[])new Object[]{20, 5, 5, new int[]{20}}), Arguments.of((Object[])new Object[]{9, 5, 4, new int[]{20}}));
    }

    @ParameterizedTest
    @MethodSource
    void capDocCountMovedDuringRepartitioningMultigroupTest(int highWaterMark, int docCountPerTxn, int maxCountPerRepartitionCall, int ... docCounts) throws IOException {
        Map<String, String> options = Map.of("partitionFieldName", "timestamp", "partitionHighWatermark", String.valueOf(highWaterMark));
        Pair<Index, Consumer<FDBRecordContext>> indexConsumerPair = this.setupIndex(options, true, false);
        Index index = (Index)indexConsumerPair.getLeft();
        Consumer schemaSetup = (Consumer)indexConsumerPair.getRight();
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)docCountPerTxn).addProp(LuceneRecordContextProperties.LUCENE_MAX_DOCUMENTS_TO_MOVE_DURING_REPARTITIONING, (Object)maxCountPerRepartitionCall).build();
        class GroupSpec {
            final int value;
            final int docCount;
            final Tuple groupTuple;

            GroupSpec(int value, int docCount) {
                this.value = value;
                this.docCount = docCount;
                this.groupTuple = Tuple.from((Object[])new Object[]{value});
            }
        }
        GroupSpec[] groupSpecs = new GroupSpec[docCounts.length];
        for (int i = 0; i < docCounts.length; ++i) {
            groupSpecs[i] = new GroupSpec(i + 1, docCounts[i]);
        }
        long start = Instant.now().toEpochMilli();
        String luceneSearch = "text:about";
        HashMap<Integer, List> primaryKeys = new HashMap<Integer, List>();
        try (GroupSpec[] context = this.openContext(contextProps);){
            schemaSetup.accept(context);
            for (int k = 0; k < groupSpecs.length; ++k) {
                for (int i = 0; i < groupSpecs[k].docCount; ++i) {
                    TestRecordsTextProto.ComplexDocument cd = TestRecordsTextProto.ComplexDocument.newBuilder().setGroup((long)groupSpecs[k].value).setDocId(1000L * (long)(k + 1) + (long)i).setIsSeen(true).setText("A word about what I want to say").setTimestamp(start + (long)i * 100L + (long)k * 100000L).setHeader(TestRecordsTextProto.ComplexDocument.Header.newBuilder().setHeaderId(1000L * (long)(k + 1) - (long)i)).build();
                    Tuple primaryKey = this.recordStore.saveRecord((Message)cd).getPrimaryKey();
                    primaryKeys.computeIfAbsent(groupSpecs[k].value, v -> new ArrayList()).add(primaryKey);
                }
            }
            this.commit((FDBRecordContext)context);
        }
        for (GroupSpec groupSpec : groupSpecs) {
            List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfos = this.getPartitionMeta(index, groupSpec.groupTuple, contextProps, schemaSetup);
            Assertions.assertEquals((int)1, (int)partitionInfos.size());
            Assertions.assertEquals((int)groupSpec.docCount, (int)partitionInfos.get(0).getCount());
        }
        this.explicitMergeIndex(index, contextProps, schemaSetup);
        HashMap<Integer, List<LucenePartitionInfoProto.LucenePartitionInfo>> partitionInfos = new HashMap<Integer, List<LucenePartitionInfoProto.LucenePartitionInfo>>();
        for (GroupSpec groupSpec : groupSpecs) {
            partitionInfos.put(groupSpec.value, this.getPartitionMeta(index, groupSpec.groupTuple, contextProps, schemaSetup));
        }
        try (FDBRecordContext context = this.openContext(contextProps);){
            schemaSetup.accept(context);
            int actualRepartitionCallCount = this.getCounter(context, (StoreTimer.Event)LuceneEvents.Counts.LUCENE_REPARTITION_CALLS).getCount();
            int totalExpectedRepartitionCallCount = 0;
            for (GroupSpec groupSpec : groupSpecs) {
                List groupPartitionInfos = (List)partitionInfos.get(groupSpec.value);
                Pair<int[], Integer> spreadAndCallCount = this.calculateAndValidateRepartitioningExpectations(groupPartitionInfos, groupSpec.docCount, highWaterMark, docCountPerTxn, maxCountPerRepartitionCall, -1);
                totalExpectedRepartitionCallCount += ((Integer)spreadAndCallCount.getRight()).intValue();
                int[] docDistribution = (int[])spreadAndCallCount.getLeft();
                int edge = groupSpec.docCount - docDistribution[0];
                this.validateDocsInPartition(index, 0, groupSpec.groupTuple, Set.copyOf(((List)primaryKeys.get(groupSpec.value)).subList(edge, groupSpec.docCount)), "text:about");
                for (int i = docDistribution.length - 1; i > 0; --i) {
                    this.validateDocsInPartition(index, i, groupSpec.groupTuple, Set.copyOf(((List)primaryKeys.get(groupSpec.value)).subList(edge - docDistribution[i], edge)), "text:about");
                    edge -= docDistribution[i];
                }
            }
            if (groupSpecs.length > 1) {
                Assertions.assertTrue((Math.abs(totalExpectedRepartitionCallCount - actualRepartitionCallCount) <= groupSpecs.length ? 1 : 0) != 0);
            } else {
                Assertions.assertEquals((int)totalExpectedRepartitionCallCount, (int)actualRepartitionCallCount);
            }
        }
    }

    LuceneScanQuery buildLuceneScanQuery(Index index, boolean isSynthetic, Comparisons.Type comparisonType, SortType sortType, long predicateComparand, String luceneSearch) {
        RecordQuery recordQuery;
        QueryComponent filter;
        Map<Comparisons.Type, BiFunction<Field, Object, QueryComponent>> comparisonToQueryFunction = Map.of(Comparisons.Type.GREATER_THAN, Field::greaterThan, Comparisons.Type.GREATER_THAN_OR_EQUALS, Field::greaterThanOrEquals, Comparisons.Type.LESS_THAN, Field::lessThan, Comparisons.Type.LESS_THAN_OR_EQUALS, Field::lessThanOrEquals, Comparisons.Type.EQUALS, Field::equalsValue, Comparisons.Type.NOT_EQUALS, Field::notEquals);
        String partitionFieldName = "timestamp";
        ArrayList<Object> queryComponents = new ArrayList<Object>();
        if (isSynthetic) {
            queryComponents.add(com.apple.foundationdb.record.query.expressions.Query.field((String)"complex").matches(com.apple.foundationdb.record.query.expressions.Query.field((String)"group").equalsParameter("group_value")));
            if (comparisonType != Comparisons.Type.NOT_EQUALS) {
                queryComponents.add(com.apple.foundationdb.record.query.expressions.Query.field((String)"complex").matches(comparisonToQueryFunction.get(comparisonType).apply(com.apple.foundationdb.record.query.expressions.Query.field((String)partitionFieldName), predicateComparand)));
            }
            if (luceneSearch != null) {
                queryComponents.add(new LuceneQueryComponent(luceneSearch, List.of("simple_text")));
            }
            filter = queryComponents.size() > 1 ? com.apple.foundationdb.record.query.expressions.Query.and(queryComponents) : (QueryComponent)queryComponents.get(0);
            recordQuery = RecordQuery.newBuilder().setRecordType("luceneJoinedPartitionedIdx").setFilter(filter).setSort((KeyExpression)Key.Expressions.field((String)"complex").nest("timestamp"), sortType != SortType.ASCENDING).build();
        } else {
            queryComponents.add(com.apple.foundationdb.record.query.expressions.Query.field((String)"group").equalsParameter("group_value"));
            if (comparisonType != Comparisons.Type.NOT_EQUALS) {
                queryComponents.add(comparisonToQueryFunction.get(comparisonType).apply(com.apple.foundationdb.record.query.expressions.Query.field((String)partitionFieldName), predicateComparand));
            }
            if (luceneSearch != null) {
                queryComponents.add(new LuceneQueryComponent(luceneSearch, List.of("text")));
            }
            filter = queryComponents.size() > 1 ? com.apple.foundationdb.record.query.expressions.Query.and(queryComponents) : (QueryComponent)queryComponents.get(0);
            recordQuery = RecordQuery.newBuilder().setRecordType("ComplexDocument").setFilter(filter).setSort((KeyExpression)Key.Expressions.field((String)partitionFieldName), sortType != SortType.ASCENDING).build();
        }
        LucenePlanner planner = new LucenePlanner(this.recordStore.getRecordMetaData(), this.recordStore.getRecordStoreState(), PlannableIndexTypes.DEFAULT, this.recordStore.getTimer());
        RecordQueryPlan plan = planner.plan(recordQuery);
        Assertions.assertTrue((boolean)(plan instanceof LuceneIndexQueryPlan));
        LuceneIndexQueryPlan luceneIndexQueryPlan = (LuceneIndexQueryPlan)plan;
        LuceneScanParameters scanParameters = (LuceneScanParameters)luceneIndexQueryPlan.getScanParameters();
        return (LuceneScanQuery)scanParameters.bind((FDBRecordStoreBase)this.recordStore, index, EvaluationContext.forBinding((String)"group_value", (Object)1));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void partitionFieldPredicateDetectionTest(boolean isSynthetic) {
        Map<String, String> options = Map.of("partitionFieldName", isSynthetic ? "complex.timestamp" : "timestamp", "partitionHighWatermark", String.valueOf(8));
        Pair<Index, Consumer<FDBRecordContext>> indexConsumerPair = this.setupIndex(options, true, isSynthetic);
        Index index = (Index)indexConsumerPair.getLeft();
        Consumer schemaSetup = (Consumer)indexConsumerPair.getRight();
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)8).build();
        String luceneSearch = isSynthetic ? "simple_text:about" : "text:about";
        try (FDBRecordContext context = this.openContext(contextProps);){
            schemaSetup.accept(context);
            LucenePartitioner partitioner = this.getIndexMaintainer(index).getPartitioner();
            for (Comparisons.Type comparisonType : List.of(Comparisons.Type.NOT_EQUALS, Comparisons.Type.LESS_THAN, Comparisons.Type.LESS_THAN_OR_EQUALS, Comparisons.Type.GREATER_THAN, Comparisons.Type.LESS_THAN_OR_EQUALS, Comparisons.Type.EQUALS)) {
                for (SortType sortType : EnumSet.allOf(SortType.class)) {
                    LuceneScanQuery luceneScanQuery = this.buildLuceneScanQuery(index, isSynthetic, comparisonType, sortType, 15L, luceneSearch);
                    LuceneComparisonQuery luceneComparisonQuery = partitioner.checkQueryForPartitionFieldPredicate(luceneScanQuery);
                    LuceneComparisonQuery expectedLuceneComparisonQuery = comparisonType == Comparisons.Type.NOT_EQUALS ? null : new LuceneComparisonQuery(this.toRangeQuery(Objects.requireNonNull(partitioner.getPartitionFieldNameInLucene()), comparisonType, 15L), partitioner.getPartitionFieldNameInLucene(), comparisonType, (Object)15L);
                    Assertions.assertEquals(expectedLuceneComparisonQuery, (Object)luceneComparisonQuery);
                }
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void partitionFieldPredicateNotDetectedTest(boolean isSynthetic) {
        Map<String, String> options = Map.of("partitionFieldName", isSynthetic ? "complex.timestamp" : "timestamp", "partitionHighWatermark", String.valueOf(8));
        Pair<Index, Consumer<FDBRecordContext>> indexConsumerPair = this.setupIndex(options, true, isSynthetic);
        Index index = (Index)indexConsumerPair.getLeft();
        Consumer schemaSetup = (Consumer)indexConsumerPair.getRight();
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)8).build();
        String luceneSearch = isSynthetic ? "simple_text:about" : "text:about";
        String luceneSearch2 = isSynthetic ? "simple_text:mary" : "text:mary";
        String textFieldName = isSynthetic ? "simple_text" : "text";
        String partitionFieldName = isSynthetic ? "complex_timestamp" : "timestamp";
        try (FDBRecordContext context = this.openContext(contextProps);){
            QueryComponent groupPredicate;
            QueryComponent secondPartitionFieldPredicate;
            QueryComponent partitionFieldPredicate;
            schemaSetup.accept(context);
            LucenePartitioner partitioner = this.getIndexMaintainer(index).getPartitioner();
            LuceneQueryComponent textSearchPredicate = new LuceneQueryComponent(luceneSearch, List.of(textFieldName));
            LuceneQueryComponent secondTextSearchPredicate = new LuceneQueryComponent(luceneSearch2, List.of(textFieldName));
            LuceneQueryComponent luceneDslPredicate = new LuceneQueryComponent(luceneSearch + " " + partitionFieldName + ":[1 TO 10]", List.of(textFieldName, partitionFieldName));
            if (isSynthetic) {
                partitionFieldPredicate = com.apple.foundationdb.record.query.expressions.Query.field((String)"complex").matches(com.apple.foundationdb.record.query.expressions.Query.field((String)"timestamp").greaterThan((Object)15L));
                secondPartitionFieldPredicate = com.apple.foundationdb.record.query.expressions.Query.field((String)"complex").matches(com.apple.foundationdb.record.query.expressions.Query.field((String)"timestamp").greaterThan((Object)55L));
                groupPredicate = com.apple.foundationdb.record.query.expressions.Query.field((String)"complex").matches(com.apple.foundationdb.record.query.expressions.Query.field((String)"group").equalsParameter("group_value"));
            } else {
                partitionFieldPredicate = com.apple.foundationdb.record.query.expressions.Query.field((String)partitionFieldName).greaterThan((Object)15L);
                secondPartitionFieldPredicate = com.apple.foundationdb.record.query.expressions.Query.field((String)partitionFieldName).greaterThan((Object)55L);
                groupPredicate = com.apple.foundationdb.record.query.expressions.Query.field((String)"group").equalsParameter("group_value");
            }
            Map<QueryComponent, QueryPlanningExpectation> filterToOutcomeMap = Map.of(com.apple.foundationdb.record.query.expressions.Query.or((QueryComponent)groupPredicate, (QueryComponent)textSearchPredicate, (QueryComponent[])new QueryComponent[]{partitionFieldPredicate}), new QueryPlanningExpectation(QueryPlanningExpectation.DetectionStatus.NON_LUCENE_PLAN, QueryPlanningExpectation.DetectionStatus.EXCEPTION_THROWN), com.apple.foundationdb.record.query.expressions.Query.and((QueryComponent)groupPredicate, (QueryComponent)com.apple.foundationdb.record.query.expressions.Query.or((QueryComponent)textSearchPredicate, (QueryComponent)partitionFieldPredicate, (QueryComponent[])new QueryComponent[0]), (QueryComponent[])new QueryComponent[0]), new QueryPlanningExpectation(QueryPlanningExpectation.DetectionStatus.NON_LUCENE_PLAN, QueryPlanningExpectation.DetectionStatus.NON_LUCENE_PLAN), com.apple.foundationdb.record.query.expressions.Query.and((QueryComponent)groupPredicate, (QueryComponent)textSearchPredicate, (QueryComponent[])new QueryComponent[]{partitionFieldPredicate, secondPartitionFieldPredicate}), new QueryPlanningExpectation(QueryPlanningExpectation.DetectionStatus.PREDICATE_NOT_SELECTED, QueryPlanningExpectation.DetectionStatus.PREDICATE_NOT_SELECTED), com.apple.foundationdb.record.query.expressions.Query.and((QueryComponent)groupPredicate, (QueryComponent)com.apple.foundationdb.record.query.expressions.Query.or((QueryComponent)textSearchPredicate, (QueryComponent)com.apple.foundationdb.record.query.expressions.Query.and((QueryComponent)secondTextSearchPredicate, (QueryComponent)partitionFieldPredicate, (QueryComponent[])new QueryComponent[0]), (QueryComponent[])new QueryComponent[0]), (QueryComponent[])new QueryComponent[0]), new QueryPlanningExpectation(QueryPlanningExpectation.DetectionStatus.NON_LUCENE_PLAN, QueryPlanningExpectation.DetectionStatus.NON_LUCENE_PLAN), com.apple.foundationdb.record.query.expressions.Query.and((QueryComponent)textSearchPredicate, (QueryComponent)partitionFieldPredicate, (QueryComponent[])new QueryComponent[0]), new QueryPlanningExpectation(QueryPlanningExpectation.DetectionStatus.NON_LUCENE_PLAN, QueryPlanningExpectation.DetectionStatus.EXCEPTION_THROWN), com.apple.foundationdb.record.query.expressions.Query.and((QueryComponent)groupPredicate, (QueryComponent)luceneDslPredicate, (QueryComponent[])new QueryComponent[0]), new QueryPlanningExpectation(QueryPlanningExpectation.DetectionStatus.PREDICATE_NOT_SELECTED, QueryPlanningExpectation.DetectionStatus.PREDICATE_NOT_SELECTED));
            for (Map.Entry<QueryComponent, QueryPlanningExpectation> entry : filterToOutcomeMap.entrySet()) {
                QueryComponent filter = entry.getKey();
                QueryPlanningExpectation expectation = entry.getValue();
                RecordQuery recordQuery = RecordQuery.newBuilder().setRecordType(isSynthetic ? "luceneJoinedPartitionedIdx" : "ComplexDocument").setFilter(filter).build();
                if (isSynthetic && expectation.forSynthetic == QueryPlanningExpectation.DetectionStatus.EXCEPTION_THROWN || !isSynthetic && expectation.forSimple == QueryPlanningExpectation.DetectionStatus.EXCEPTION_THROWN) {
                    Assertions.assertThrows(RecordCoreException.class, () -> this.planner.plan(recordQuery));
                    continue;
                }
                RecordQueryPlan plan = this.planner.plan(recordQuery);
                if (isSynthetic && expectation.forSynthetic == QueryPlanningExpectation.DetectionStatus.NON_LUCENE_PLAN || !isSynthetic && expectation.forSimple == QueryPlanningExpectation.DetectionStatus.NON_LUCENE_PLAN) {
                    Assertions.assertFalse((boolean)(plan instanceof LuceneIndexQueryPlan));
                    continue;
                }
                LuceneIndexQueryPlan luceneIndexQueryPlan = (LuceneIndexQueryPlan)plan;
                LuceneScanParameters scanParameters = (LuceneScanParameters)luceneIndexQueryPlan.getScanParameters();
                LuceneScanQuery luceneScanQuery = (LuceneScanQuery)scanParameters.bind((FDBRecordStoreBase)this.recordStore, index, EvaluationContext.forBinding((String)"group_value", (Object)1));
                LuceneComparisonQuery detectedPredicate = partitioner.checkQueryForPartitionFieldPredicate(luceneScanQuery);
                Assertions.assertEquals((Object)(detectedPredicate != null ? 1 : 0), (Object)(expectation == QueryPlanningExpectation.SELECTED ? 1 : 0));
            }
        }
    }

    private Query toRangeQuery(String fieldName, Comparisons.Type comparisonType, Long comparand) {
        switch (comparisonType) {
            case EQUALS: {
                return LongPoint.newExactQuery((String)fieldName, (long)comparand);
            }
            case LESS_THAN: {
                return LongPoint.newRangeQuery((String)fieldName, (long)Long.MIN_VALUE, (long)(comparand - 1L));
            }
            case LESS_THAN_OR_EQUALS: {
                return LongPoint.newRangeQuery((String)fieldName, (long)Long.MIN_VALUE, (long)comparand);
            }
            case GREATER_THAN: {
                return LongPoint.newRangeQuery((String)fieldName, (long)(comparand + 1L), (long)Long.MAX_VALUE);
            }
            case GREATER_THAN_OR_EQUALS: {
                return LongPoint.newRangeQuery((String)fieldName, (long)comparand, (long)Long.MAX_VALUE);
            }
        }
        throw new IllegalArgumentException("unsupported comparison type: " + String.valueOf(comparisonType));
    }

    static Stream<Arguments> functionalPartitionFieldPredicateTest() {
        return Stream.concat(Stream.of(23045978L, 98432L, -439208L, -547118062778370833L, -8561053686039912077L).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0})), RandomizedTestUtils.randomArguments(random -> Arguments.of((Object[])new Object[]{random.nextLong()})));
    }

    @ParameterizedTest
    @MethodSource
    void functionalPartitionFieldPredicateTest(long seed) {
        Random random = new Random(seed);
        boolean isSynthetic = false;
        Map<String, String> options = Map.of("partitionFieldName", isSynthetic ? "complex.timestamp" : "timestamp", "partitionHighWatermark", String.valueOf(3));
        Pair<Index, Consumer<FDBRecordContext>> indexConsumerPair = this.setupIndex(options, true, isSynthetic);
        Index index = (Index)indexConsumerPair.getLeft();
        Consumer schemaSetup = (Consumer)indexConsumerPair.getRight();
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)8).build();
        String luceneSearch = isSynthetic ? "simple_text:about" : "text:about";
        HashMap<Tuple, Long> primaryKeys = new HashMap<Tuple, Long>();
        int docCount = 30;
        for (SortType sortType : EnumSet.allOf(SortType.class)) {
            for (Comparisons.Type comparisonType : List.of(Comparisons.Type.EQUALS, Comparisons.Type.LESS_THAN, Comparisons.Type.LESS_THAN_OR_EQUALS, Comparisons.Type.GREATER_THAN_OR_EQUALS, Comparisons.Type.GREATER_THAN)) {
                FDBRecordContext context = this.openContext(contextProps);
                try {
                    schemaSetup.accept(context);
                    for (int i = 0; i < docCount; ++i) {
                        long timestamp = (long)random.nextInt(10) + 2L;
                        long docId = 1000L + (long)i;
                        TestRecordsTextProto.ComplexDocument cd = TestRecordsTextProto.ComplexDocument.newBuilder().setGroup(1L).setDocId(docId).setIsSeen(true).setText("A word about what I want to say").setTimestamp(timestamp).setHeader(TestRecordsTextProto.ComplexDocument.Header.newBuilder().setHeaderId(1000L + (long)i)).build();
                        Tuple primaryKey = this.recordStore.saveRecord((Message)cd).getPrimaryKey();
                        primaryKeys.put(primaryKey, timestamp);
                        for (long queriedValue = 1L; queriedValue <= 12L; ++queriedValue) {
                            LOGGER.debug("i={}, queriedValue={}, comparisonType={}, sortType={}", new Object[]{i, queriedValue, comparisonType, sortType});
                            LuceneScanQuery luceneScanQuery = this.buildLuceneScanQuery(index, isSynthetic, comparisonType, sortType, queriedValue, luceneSearch);
                            try (RecordCursor indexEntryCursor = this.recordStore.scanIndex(index, (IndexScanBounds)luceneScanQuery, null, ExecuteProperties.newBuilder().setReturnedRowLimit(Integer.MAX_VALUE).build().asScanProperties(false));){
                                Stream<Tuple> actualKeys = ((List)indexEntryCursor.asList().join()).stream().map(IndexEntry::getPrimaryKey);
                                List<Tuple> expectedKeys = this.queryLocal(primaryKeys, comparisonType, queriedValue, sortType);
                                if (sortType == SortType.UNSORTED) {
                                    actualKeys = actualKeys.sorted();
                                    expectedKeys.sort(Comparator.naturalOrder());
                                }
                                Assertions.assertEquals(expectedKeys, actualKeys.collect(Collectors.toList()), () -> {
                                    LuceneIndexMaintainer indexMaintainer = (LuceneIndexMaintainer)this.recordStore.getIndexMaintainer(index);
                                    return primaryKeys.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(entry -> String.valueOf(entry.getValue()) + " " + String.valueOf(entry.getKey())).collect(Collectors.joining(", ", "All data: [", "]\n")) + ((List)indexMaintainer.getPartitioner().getAllPartitionMetaInfo(Tuple.from((Object[])new Object[]{1})).join()).stream().sorted(Comparator.comparing(partitionInfo -> Tuple.fromBytes((byte[])partitionInfo.getFrom().toByteArray()))).map(partitionInfo -> partitionInfo.getId() + " (" + partitionInfo.getCount() + "): [" + String.valueOf(Tuple.fromBytes((byte[])partitionInfo.getFrom().toByteArray())) + "," + String.valueOf(Tuple.fromBytes((byte[])partitionInfo.getTo().toByteArray())) + "]").collect(Collectors.joining(", ", "Partitions: [", "]"));
                                });
                                continue;
                            }
                        }
                    }
                    this.commit(context);
                }
                finally {
                    if (context == null) continue;
                    context.close();
                }
            }
        }
    }

    private List<Tuple> queryLocal(Map<Tuple, Long> dataset, Comparisons.Type comparisonType, long comparand, SortType sortType) {
        List hits = dataset.entrySet().stream().filter(entry -> {
            long value = (Long)entry.getValue();
            switch (comparisonType) {
                case EQUALS: {
                    return value == comparand;
                }
                case LESS_THAN: {
                    return value < comparand;
                }
                case LESS_THAN_OR_EQUALS: {
                    return value <= comparand;
                }
                case GREATER_THAN: {
                    return value > comparand;
                }
                case GREATER_THAN_OR_EQUALS: {
                    return value >= comparand;
                }
            }
            return false;
        }).collect(Collectors.toList());
        if (sortType == SortType.ASCENDING) {
            hits.sort(Comparator.comparing(Map.Entry::getValue).thenComparing(Map.Entry::getKey));
        } else {
            hits.sort(Comparator.comparing(Map.Entry::getValue).thenComparing(Map.Entry::getKey).reversed());
        }
        return hits.stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }

    static Stream<Arguments> integratedConsolidationTest() {
        return Stream.of(true, false).flatMap(isSynthetic -> Stream.of(Arguments.of((Object[])new Object[]{isSynthetic, 8, 5, 2, 24, new int[]{4, 4, 0}}), Arguments.of((Object[])new Object[]{isSynthetic, 8, 5, 2, 24, new int[]{2, 4, 2}}), Arguments.of((Object[])new Object[]{isSynthetic, 8, 5, 2, 14, new int[]{2, 4}}), Arguments.of((Object[])new Object[]{isSynthetic, 8, 5, 2, 13, new int[]{1, 1}})));
    }

    @ParameterizedTest
    @MethodSource
    void integratedConsolidationTest(boolean isSynthetic, int highWatermark, int lowWatermark, int repartitionDocCount, int docCount, int ... docCountsToDelete) throws IOException {
        Map<String, String> options = Map.of("partitionFieldName", isSynthetic ? "complex.timestamp" : "timestamp", "primaryKeySegmentIndexV2Enabled", "true", "partitionLowWatermark", String.valueOf(lowWatermark), "partitionHighWatermark", String.valueOf(highWatermark));
        Pair<Index, Consumer<FDBRecordContext>> indexConsumerPair = this.setupIndex(options, true, isSynthetic);
        Index index = (Index)indexConsumerPair.getLeft();
        Consumer schemaSetup = (Consumer)indexConsumerPair.getRight();
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)repartitionDocCount).build();
        long start = Instant.now().toEpochMilli();
        String textFieldValue = "A word about what I want to say";
        String luceneSearch = isSynthetic ? "simple_text:about" : "text:about";
        Tuple groupTuple = Tuple.from((Object[])new Object[]{1L});
        HashMap<Tuple, Tuple> primaryKeyToTimestamp = new HashMap<Tuple, Tuple>();
        try (FDBRecordContext context2 = this.openContext(contextProps);){
            schemaSetup.accept(context2);
            this.recordStore.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(false);
            for (int i = 0; i < docCount; ++i) {
                Tuple primaryKey;
                long timestamp = start + (long)i * 100000L;
                long complexDocId = 1000L + (long)i;
                long simpleDocId = 1000L - (long)i;
                TestRecordsTextProto.ComplexDocument complexDocument = TestRecordsTextProto.ComplexDocument.newBuilder().setGroup(1L).setDocId(complexDocId).setIsSeen(true).setText("A word about what I want to say").setTimestamp(timestamp).setHeader(TestRecordsTextProto.ComplexDocument.Header.newBuilder().setHeaderId(1000L - (long)i)).build();
                if (isSynthetic) {
                    TestRecordsTextProto.SimpleDocument simpleDocument = TestRecordsTextProto.SimpleDocument.newBuilder().setGroup(1L).setDocId(simpleDocId).setText("A word about what I want to say").build();
                    Tuple syntheticRecordTypeKey = this.recordStore.getRecordMetaData().getSyntheticRecordType("luceneJoinedPartitionedIdx").getRecordTypeKeyTuple();
                    primaryKey = Tuple.from((Object[])new Object[]{syntheticRecordTypeKey.getItems().get(0), this.recordStore.saveRecord((Message)complexDocument).getPrimaryKey().getItems(), this.recordStore.saveRecord((Message)simpleDocument).getPrimaryKey().getItems()});
                } else {
                    primaryKey = this.recordStore.saveRecord((Message)complexDocument).getPrimaryKey();
                }
                primaryKeyToTimestamp.put(primaryKey, Tuple.from((Object[])new Object[]{timestamp}));
            }
            this.commit(context2);
        }
        List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfos = this.getPartitionMeta(index, groupTuple, contextProps, schemaSetup);
        Assertions.assertEquals((int)1, (int)partitionInfos.size());
        Assertions.assertEquals((int)docCount, (int)partitionInfos.get(0).getCount());
        this.explicitMergeIndex(index, contextProps, schemaSetup);
        partitionInfos = this.getPartitionMeta(index, groupTuple, contextProps, schemaSetup);
        LuceneIndexTestValidator luceneIndexTestValidator = new LuceneIndexTestValidator(() -> this.openContext(contextProps), context -> {
            schemaSetup.accept(context);
            return this.recordStore;
        });
        luceneIndexTestValidator.validate(Objects.requireNonNull(index), Map.of(groupTuple, primaryKeyToTimestamp), luceneSearch, false);
        try (FDBRecordContext context3 = this.openContext(contextProps);){
            schemaSetup.accept(context3);
            this.recordStore.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(false);
            Collections.reverse(partitionInfos);
            List sortedPrimaryKeys = primaryKeyToTimestamp.keySet().stream().sorted().collect(Collectors.toList());
            int docOffset = 0;
            for (int i = 0; i < docCountsToDelete.length; ++i) {
                int howManyToDelete = docCountsToDelete[i];
                for (int j = 0; j < howManyToDelete; ++j) {
                    Tuple primaryKeyToDelete = (Tuple)sortedPrimaryKeys.get(docOffset + j);
                    if (isSynthetic) {
                        Tuple complexDocKey = Tuple.fromList((List)((List)primaryKeyToDelete.get(1)));
                        Tuple simpleDocKey = Tuple.fromList((List)((List)primaryKeyToDelete.get(2)));
                        this.recordStore.deleteRecord(complexDocKey);
                        this.recordStore.deleteRecord(simpleDocKey);
                    } else {
                        this.recordStore.deleteRecord(primaryKeyToDelete);
                    }
                    primaryKeyToTimestamp.remove(primaryKeyToDelete);
                }
                docOffset += partitionInfos.get(i).getCount();
            }
            context3.commit();
        }
        this.explicitMergeIndex(index, contextProps, schemaSetup);
        luceneIndexTestValidator.validate(Objects.requireNonNull(index), Map.of(groupTuple, primaryKeyToTimestamp), luceneSearch, false);
    }

    static Stream<Arguments> simplePartitionConsolidationTest() {
        return Stream.concat(Stream.of(Arguments.of((Object[])new Object[]{2, 4, 3, new int[]{1, 1}, new int[]{2}, 5090921730160662578L}), Arguments.of((Object[])new Object[]{2, 4, 3, new int[]{2, 2, 1}, new int[]{2, 3}, 8296455389870328158L}), Arguments.of((Object[])new Object[]{3, 7, 3, new int[]{5, 2, 5}, new int[]{7, 5}, 1881263071588622897L}), Arguments.of((Object[])new Object[]{3, 7, 3, new int[]{6, 2, 6}, new int[]{7, 7}, -8067607788952349037L}), Arguments.of((Object[])new Object[]{3, 7, 3, new int[]{6, 2, 7}, new int[]{6, 2, 7}, -6499413518552747008L}), Arguments.of((Object[])new Object[]{3, 7, 3, new int[]{7, 2, 6}, new int[]{7, 2, 6}, 4964771431262174260L}), Arguments.of((Object[])new Object[]{3, 7, 3, new int[]{6, 2, 7, 3}, new int[]{6, 2, 7, 3}, -7701497187073700392L}), Arguments.of((Object[])new Object[]{4, 7, 3, new int[]{6, 3, 4, 5, 5, 5, 5}, new int[]{6, 7, 5, 5, 5, 5}, -4754040892014544273L}), Arguments.of((Object[])new Object[]{3, 7, 3, new int[]{6, 2, 6, 1}, new int[]{6, 2, 7}, -1401482865167966197L}), Arguments.of((Object[])new Object[]{3, 7, 3, new int[]{6, 1, 8}, new int[]{6, 4, 5}, 5083428474768878225L}), Arguments.of((Object[])new Object[]{3, 7, 3, new int[]{6, 1, 1, 6}, new int[]{7, 7}, -481285513446860421L}), Arguments.of((Object[])new Object[]{5, 7, 3, new int[]{3, 4}, new int[]{7}, 7075276337057098368L}), Arguments.of((Object[])new Object[]{3, 7, 3, new int[]{15}, new int[]{6, 3, 6}, -1986718910463673038L}), Arguments.of((Object[])new Object[]{3, 6, 2, new int[]{13, 2}, new int[]{6, 2, 5, 2}, -3793471484163361678L}), Arguments.of((Object[])new Object[]{10, 20, 3, new int[]{15, 8, 20}, new int[]{15, 8, 20}, 9002508147645127223L})), LongStream.of(1358611700989865537L, -4569118774337319100L, -3377995767497306027L, 8516771127753321444L).mapToObj(seed -> Arguments.of((Object[])new Object[]{3, 7, 3, new int[]{15}, new int[]{6, 3, 6}, seed})));
    }

    @ParameterizedTest
    @MethodSource
    void simplePartitionConsolidationTest(int lowWatermark, int highWatermark, int repartitionCount, int[] initialPartitionCounts, int[] expectedPartitionCounts, long seed) throws IOException {
        Map<Tuple, Map<Tuple, Tuple>> createdKeys;
        Random random = new Random(seed);
        boolean isSynthetic = false;
        Map<String, String> options = Map.of("partitionFieldName", "timestamp", "partitionHighWatermark", String.valueOf(highWatermark), "partitionLowWatermark", String.valueOf(lowWatermark));
        Pair<Index, Consumer<FDBRecordContext>> indexConsumerPair = this.setupIndex(options, true, isSynthetic);
        Index index = (Index)indexConsumerPair.getLeft();
        Consumer schemaSetup = (Consumer)indexConsumerPair.getRight();
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)repartitionCount).build();
        String luceneSearch = "text:vision";
        try (FDBRecordContext context2 = this.openContext(contextProps);){
            schemaSetup.accept(context2);
            this.recordStore.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(false);
            createdKeys = this.createPartitionsAndComplexDocs(index, initialPartitionCounts, random);
            context2.commit();
        }
        List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfos = this.getPartitionMeta(index, Tuple.from((Object[])new Object[]{1}), contextProps, schemaSetup);
        Collections.reverse(partitionInfos);
        Assertions.assertEquals((int)initialPartitionCounts.length, (int)partitionInfos.size());
        Assertions.assertArrayEquals((int[])initialPartitionCounts, (int[])partitionInfos.stream().mapToInt(LucenePartitionInfoProto.LucenePartitionInfo::getCount).toArray());
        this.explicitMergeIndex(index, contextProps, schemaSetup);
        partitionInfos = this.getPartitionMeta(index, Tuple.from((Object[])new Object[]{1}), contextProps, schemaSetup);
        partitionInfos.sort(Comparator.comparing(pInfo -> Tuple.fromBytes((byte[])pInfo.getFrom().toByteArray())));
        Assertions.assertEquals((int)expectedPartitionCounts.length, (int)partitionInfos.size());
        Assertions.assertArrayEquals((int[])expectedPartitionCounts, (int[])partitionInfos.stream().mapToInt(LucenePartitionInfoProto.LucenePartitionInfo::getCount).toArray());
        LuceneIndexTestValidator luceneIndexTestValidator = new LuceneIndexTestValidator(() -> this.openContext(contextProps), context -> {
            schemaSetup.accept(context);
            return this.recordStore;
        });
        luceneIndexTestValidator.validate(Objects.requireNonNull(index), createdKeys, "text:vision", false);
    }

    @Test
    void simpleCrossPartitionQuery() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "ComplexDocument", COMPLEX_PARTITIONED);
            this.setTimestamps();
            this.createDualPartitionsWithComplexDocs(1);
            this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{1, 0L}), Tuple.from((Object[])new Object[]{1, 1000L})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(COMPLEX_PARTITIONED, (IndexScanBounds)this.groupedTextSearch(COMPLEX_PARTITIONED, "text:propose", 1), null, ScanProperties.FORWARD_SCAN));
            Assertions.assertEquals((int)2, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            this.commit(context);
        }
    }

    static Stream<Arguments> findStartingPartitionTest() {
        return Stream.concat(Stream.of(true, false).map(isSynthetic -> Arguments.of((Object[])new Object[]{isSynthetic, 1714058544895L})), RandomizedTestUtils.randomArguments(random -> Arguments.of((Object[])new Object[]{random.nextBoolean(), random.nextLong()})));
    }

    @ParameterizedTest
    @MethodSource
    void findStartingPartitionTest(boolean isSynthetic, long startTime) {
        Map<String, String> options = Map.of("partitionFieldName", isSynthetic ? "complex.timestamp" : "timestamp", "partitionHighWatermark", String.valueOf(8));
        Pair<Index, Consumer<FDBRecordContext>> indexConsumerPair = this.setupIndex(options, true, isSynthetic);
        Index index = (Index)indexConsumerPair.getLeft();
        Consumer schemaSetup = (Consumer)indexConsumerPair.getRight();
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_REPARTITION_DOCUMENT_COUNT, (Object)8).build();
        String luceneSearch = isSynthetic ? "simple_text:about" : "text:about";
        try (FDBRecordContext context = this.openContext(contextProps);){
            schemaSetup.accept(context);
            LucenePartitioner partitioner = this.getIndexMaintainer(index).getPartitioner();
            Tuple groupKey = Tuple.from((Object[])new Object[]{1L});
            long time0 = Math.abs(startTime);
            long time1 = time0 + 1000L;
            long time2 = time0 + 2000L;
            long time1_2 = time1 + 500L;
            long timeTooOld = time0 - 500L;
            long timeTooNew = time2 + 500L;
            Map<Long, String> timesForLogging = Map.of(time0, "time0", time1, "time1", time2, "time2", time1_2, "time1_2", timeTooOld, "timeTooOld", timeTooNew, "timeTooNew");
            this.createPartitionMetadata(index, groupKey, 0, time0, time0, Tuple.from((Object[])new Object[]{1, 1300}), Tuple.from((Object[])new Object[]{1, 1400}));
            this.createPartitionMetadata(index, groupKey, 1, time0, time1, Tuple.from((Object[])new Object[]{1, 1500}), Tuple.from((Object[])new Object[]{1, 1100}));
            this.createPartitionMetadata(index, groupKey, 2, time1, time2 - 200L, Tuple.from((Object[])new Object[]{1, 1700}), Tuple.from((Object[])new Object[]{1, 1000}));
            this.createPartitionMetadata(index, groupKey, 3, time2, time2, Tuple.from((Object[])new Object[]{1, 900}), Tuple.from((Object[])new Object[]{1, 910}));
            HashMap<Long, Map<Comparisons.Type, Map<SortType, Integer>>> startingPartitionExpectation = new HashMap<Long, Map<Comparisons.Type, Map<SortType, Integer>>>();
            Map<Comparisons.Type, Map<SortType, Integer>> expectationsForTime0 = Map.of(Comparisons.Type.GREATER_THAN, Map.of(SortType.ASCENDING, 1, SortType.DESCENDING, 3, SortType.UNSORTED, 3), Comparisons.Type.GREATER_THAN_OR_EQUALS, Map.of(SortType.ASCENDING, 0, SortType.DESCENDING, 3, SortType.UNSORTED, 3), Comparisons.Type.LESS_THAN, Map.of(SortType.ASCENDING, -1, SortType.DESCENDING, -1, SortType.UNSORTED, -1), Comparisons.Type.LESS_THAN_OR_EQUALS, Map.of(SortType.ASCENDING, 0, SortType.DESCENDING, 1, SortType.UNSORTED, 1), Comparisons.Type.EQUALS, Map.of(SortType.ASCENDING, 0, SortType.DESCENDING, 1, SortType.UNSORTED, 1));
            startingPartitionExpectation.put(time0, expectationsForTime0);
            Map<Comparisons.Type, Map<SortType, Integer>> expectationsForTime1 = Map.of(Comparisons.Type.GREATER_THAN, Map.of(SortType.ASCENDING, 2, SortType.DESCENDING, 3, SortType.UNSORTED, 3), Comparisons.Type.GREATER_THAN_OR_EQUALS, Map.of(SortType.ASCENDING, 1, SortType.DESCENDING, 3, SortType.UNSORTED, 3), Comparisons.Type.LESS_THAN, Map.of(SortType.ASCENDING, 0, SortType.DESCENDING, 1, SortType.UNSORTED, 1), Comparisons.Type.LESS_THAN_OR_EQUALS, Map.of(SortType.ASCENDING, 0, SortType.DESCENDING, 2, SortType.UNSORTED, 2), Comparisons.Type.EQUALS, Map.of(SortType.ASCENDING, 1, SortType.DESCENDING, 2, SortType.UNSORTED, 2));
            startingPartitionExpectation.put(time1, expectationsForTime1);
            Map<Comparisons.Type, Map<SortType, Integer>> expectationsForTime2 = Map.of(Comparisons.Type.GREATER_THAN, Map.of(SortType.ASCENDING, 3, SortType.DESCENDING, 3, SortType.UNSORTED, 3), Comparisons.Type.GREATER_THAN_OR_EQUALS, Map.of(SortType.ASCENDING, 3, SortType.DESCENDING, 3, SortType.UNSORTED, 3), Comparisons.Type.LESS_THAN, Map.of(SortType.ASCENDING, 0, SortType.DESCENDING, 2, SortType.UNSORTED, 2), Comparisons.Type.LESS_THAN_OR_EQUALS, Map.of(SortType.ASCENDING, 0, SortType.DESCENDING, 3, SortType.UNSORTED, 3), Comparisons.Type.EQUALS, Map.of(SortType.ASCENDING, 3, SortType.DESCENDING, 3, SortType.UNSORTED, 3));
            startingPartitionExpectation.put(time2, expectationsForTime2);
            Map<Comparisons.Type, Map<SortType, Integer>> expectationsForTime1_2 = Map.of(Comparisons.Type.GREATER_THAN, Map.of(SortType.ASCENDING, 2, SortType.DESCENDING, 3, SortType.UNSORTED, 3), Comparisons.Type.GREATER_THAN_OR_EQUALS, Map.of(SortType.ASCENDING, 2, SortType.DESCENDING, 3, SortType.UNSORTED, 3), Comparisons.Type.LESS_THAN, Map.of(SortType.ASCENDING, 0, SortType.DESCENDING, 2, SortType.UNSORTED, 2), Comparisons.Type.LESS_THAN_OR_EQUALS, Map.of(SortType.ASCENDING, 0, SortType.DESCENDING, 2, SortType.UNSORTED, 2), Comparisons.Type.EQUALS, Map.of(SortType.ASCENDING, 2, SortType.DESCENDING, 2, SortType.UNSORTED, 2));
            startingPartitionExpectation.put(time1_2, expectationsForTime1_2);
            Map<Comparisons.Type, Map<SortType, Integer>> expectationsForTimeTooOld = Map.of(Comparisons.Type.GREATER_THAN, Map.of(SortType.ASCENDING, 0, SortType.DESCENDING, 3, SortType.UNSORTED, 3), Comparisons.Type.GREATER_THAN_OR_EQUALS, Map.of(SortType.ASCENDING, 0, SortType.DESCENDING, 3, SortType.UNSORTED, 3), Comparisons.Type.LESS_THAN, Map.of(SortType.ASCENDING, -1, SortType.DESCENDING, -1, SortType.UNSORTED, -1), Comparisons.Type.LESS_THAN_OR_EQUALS, Map.of(SortType.ASCENDING, -1, SortType.DESCENDING, -1, SortType.UNSORTED, -1), Comparisons.Type.EQUALS, Map.of(SortType.ASCENDING, -1, SortType.DESCENDING, -1, SortType.UNSORTED, -1));
            startingPartitionExpectation.put(timeTooOld, expectationsForTimeTooOld);
            Map<Comparisons.Type, Map<SortType, Integer>> expectationsForTimeTooNew = Map.of(Comparisons.Type.GREATER_THAN, Map.of(SortType.ASCENDING, -1, SortType.DESCENDING, -1, SortType.UNSORTED, -1), Comparisons.Type.GREATER_THAN_OR_EQUALS, Map.of(SortType.ASCENDING, -1, SortType.DESCENDING, -1, SortType.UNSORTED, -1), Comparisons.Type.LESS_THAN, Map.of(SortType.ASCENDING, 0, SortType.DESCENDING, 3, SortType.UNSORTED, 3), Comparisons.Type.LESS_THAN_OR_EQUALS, Map.of(SortType.ASCENDING, 0, SortType.DESCENDING, 3, SortType.UNSORTED, 3), Comparisons.Type.EQUALS, Map.of(SortType.ASCENDING, -1, SortType.DESCENDING, -1, SortType.UNSORTED, -1));
            startingPartitionExpectation.put(timeTooNew, expectationsForTimeTooNew);
            for (Long predicateComparand : List.of(Long.valueOf(time0), Long.valueOf(time1), Long.valueOf(time2), Long.valueOf(time1_2), Long.valueOf(timeTooOld), Long.valueOf(timeTooNew))) {
                for (Comparisons.Type comparisonType : List.of(Comparisons.Type.NOT_EQUALS, Comparisons.Type.GREATER_THAN, Comparisons.Type.GREATER_THAN_OR_EQUALS, Comparisons.Type.LESS_THAN, Comparisons.Type.LESS_THAN_OR_EQUALS, Comparisons.Type.EQUALS)) {
                    for (SortType sortType : EnumSet.allOf(SortType.class)) {
                        LOGGER.debug("comparison: {} sort: {} time: {}", new Object[]{comparisonType, sortType, timesForLogging.get(predicateComparand)});
                        LuceneScanQuery luceneScanQuery = this.buildLuceneScanQuery(index, isSynthetic, comparisonType, sortType, predicateComparand, luceneSearch);
                        LucenePartitionInfoProto.LucenePartitionInfo selectedPartitionInfo = partitioner.selectQueryPartition((Tuple)groupKey, (LuceneScanQuery)luceneScanQuery).startPartition;
                        if (comparisonType == Comparisons.Type.NOT_EQUALS) {
                            Assertions.assertNotNull((Object)selectedPartitionInfo);
                            Assertions.assertTrue((sortType == SortType.ASCENDING && selectedPartitionInfo.getId() == 0 || selectedPartitionInfo.getId() == 3 ? 1 : 0) != 0);
                            continue;
                        }
                        Assertions.assertEquals((Integer)((Integer)((Map)((Map)startingPartitionExpectation.get(predicateComparand)).get(comparisonType)).get((Object)sortType)), (int)(selectedPartitionInfo == null ? -1 : selectedPartitionInfo.getId()));
                    }
                }
            }
        }
    }

    @Test
    void testPartitionedLimit() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "ComplexDocument", COMPLEX_PARTITIONED);
            this.setTimestamps();
            this.createDualPartitionsWithComplexDocs(15);
            this.assertIndexEntryPrimaryKeyTuples(this.makeKeyTuples(1L, 1000, 1014, 0, 4), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(COMPLEX_PARTITIONED, (IndexScanBounds)this.groupedTextSearch(COMPLEX_PARTITIONED, "text:propose", 1), null, ExecuteProperties.newBuilder().setReturnedRowLimit(20).build().asScanProperties(false)));
            this.validatePartitionSegmentIntegrity(COMPLEX_PARTITIONED, context, 1L, 0, 1);
        }
    }

    @Test
    void testPartitionedSkip() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "ComplexDocument", COMPLEX_PARTITIONED);
            this.setTimestamps();
            this.createDualPartitionsWithComplexDocs(30);
            this.assertIndexEntryPrimaryKeyTuples(this.makeKeyTuples(1L, 5, 29), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(COMPLEX_PARTITIONED, (IndexScanBounds)this.groupedTextSearch(COMPLEX_PARTITIONED, "text:propose", 1), null, ExecuteProperties.newBuilder().setSkip(35).build().asScanProperties(false)));
            this.validatePartitionSegmentIntegrity(COMPLEX_PARTITIONED, context, 1L, 0, 1);
        }
    }

    @Test
    void testPartitionedSkipWithLimit() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "ComplexDocument", COMPLEX_PARTITIONED);
            this.setTimestamps();
            this.createDualPartitionsWithComplexDocs(30);
            this.assertIndexEntryPrimaryKeyTuples(this.makeKeyTuples(1L, 5, 24), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(COMPLEX_PARTITIONED, (IndexScanBounds)this.groupedTextSearch(COMPLEX_PARTITIONED, "text:propose", 1), null, ExecuteProperties.newBuilder().setReturnedRowLimit(20).setSkip(35).build().asScanProperties(false)));
            this.validatePartitionSegmentIntegrity(COMPLEX_PARTITIONED, context, 1L, 0, 1);
        }
    }

    @Test
    void testPartitionedLimitWithContinuation() throws ExecutionException, InterruptedException, InvalidProtocolBufferException {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "ComplexDocument", COMPLEX_PARTITIONED);
            this.setTimestamps();
            this.createDualPartitionsWithComplexDocs(10);
            RecordCursor indexEntryCursor = this.recordStore.scanIndex(COMPLEX_PARTITIONED, (IndexScanBounds)this.groupedTextSearch(COMPLEX_PARTITIONED, "text:propose", 1), null, ExecuteProperties.newBuilder().setReturnedRowLimit(5).build().asScanProperties(false));
            List entries = (List)indexEntryCursor.asList().join();
            Assertions.assertEquals((int)5, (int)entries.size());
            Assertions.assertEquals((int)5, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            RecordCursorResult lastResult = (RecordCursorResult)indexEntryCursor.onNext().get();
            Assertions.assertEquals((Object)RecordCursor.NoNextReason.RETURN_LIMIT_REACHED, (Object)lastResult.getNoNextReason());
            LuceneContinuationProto.LuceneIndexContinuation parsed = LuceneContinuationProto.LuceneIndexContinuation.parseFrom((byte[])lastResult.getContinuation().toBytes());
            Assertions.assertEquals((int)1, (int)parsed.getPartitionId());
            RecordCursor indexEntryCursor2 = this.recordStore.scanIndex(COMPLEX_PARTITIONED, (IndexScanBounds)this.groupedTextSearch(COMPLEX_PARTITIONED, "text:propose", 1), lastResult.getContinuation().toBytes(), ExecuteProperties.newBuilder().setReturnedRowLimit(10).build().asScanProperties(false));
            List entries2 = (List)indexEntryCursor2.asList().join();
            Assertions.assertEquals((int)10, (int)entries2.size());
            RecordCursorResult lastResult2 = (RecordCursorResult)indexEntryCursor2.onNext().get();
            Assertions.assertEquals((Object)RecordCursor.NoNextReason.RETURN_LIMIT_REACHED, (Object)lastResult.getNoNextReason());
            LuceneContinuationProto.LuceneIndexContinuation parsed2 = LuceneContinuationProto.LuceneIndexContinuation.parseFrom((byte[])lastResult2.getContinuation().toBytes());
            Assertions.assertEquals((int)0, (int)parsed2.getPartitionId());
            Assertions.assertEquals(this.makeKeyTuples(1L, 1005, 1009, 0, 4), entries2.stream().map(IndexEntry::getPrimaryKey).collect(Collectors.toSet()));
            this.validatePartitionSegmentIntegrity(COMPLEX_PARTITIONED, context, 1L, 0, 1);
        }
    }

    @Test
    void testPartitionedLimitNeedsMultipleScans() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "ComplexDocument", COMPLEX_PARTITIONED);
            this.setTimestamps();
            this.createDualPartitionsWithComplexDocs(300);
            Assertions.assertEquals((int)451, (Integer)((Integer)this.recordStore.scanIndex(COMPLEX_PARTITIONED, (IndexScanBounds)this.groupedTextSearch(COMPLEX_PARTITIONED, "text:propose", 1), null, ExecuteProperties.newBuilder().setReturnedRowLimit(451).build().asScanProperties(false)).getCount().join()));
            Assertions.assertEquals((int)3, (int)this.getCounter(context, (StoreTimer.Event)LuceneEvents.Events.LUCENE_INDEX_SCAN).getCount());
            Assertions.assertEquals((int)451, (int)this.getCounter(context, (StoreTimer.Event)LuceneEvents.Counts.LUCENE_SCAN_MATCHED_DOCUMENTS).getCount());
            this.validatePartitionSegmentIntegrity(COMPLEX_PARTITIONED, context, 1L, 0, 1);
        }
    }

    @Test
    void testPartitionedSkipOverMaxPageSize() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "ComplexDocument", COMPLEX_PARTITIONED);
            this.setTimestamps();
            this.createDualPartitionsWithComplexDocs(150);
            Assertions.assertEquals((int)99, (Integer)((Integer)this.recordStore.scanIndex(COMPLEX_PARTITIONED, (IndexScanBounds)this.groupedTextSearch(COMPLEX_PARTITIONED, "text:propose", 1), null, ExecuteProperties.newBuilder().setReturnedRowLimit(351).setSkip(201).build().asScanProperties(false)).getCount().join()));
            Assertions.assertEquals((int)3, (int)this.getCounter(context, (StoreTimer.Event)LuceneEvents.Events.LUCENE_INDEX_SCAN).getCount());
            Assertions.assertEquals((int)300, (int)this.getCounter(context, (StoreTimer.Event)LuceneEvents.Counts.LUCENE_SCAN_MATCHED_DOCUMENTS).getCount());
            this.validatePartitionSegmentIntegrity(COMPLEX_PARTITIONED, context, 1L, 0, 1);
        }
    }

    @Test
    void testPartitionedSorted() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "ComplexDocument", COMPLEX_PARTITIONED);
            this.setTimestamps();
            this.createDualPartitionsWithComplexDocs(10);
            LuceneScanQuery scanQuery = (LuceneScanQuery)this.groupedSortedTextSearch(COMPLEX_PARTITIONED, "text:propose", new Sort(new SortField("timestamp", SortField.Type.LONG, true)), 1);
            RecordCursor cursor = this.recordStore.scanIndex(COMPLEX_PARTITIONED, (IndexScanBounds)scanQuery, null, ExecuteProperties.newBuilder().setReturnedRowLimit(15).build().asScanProperties(false));
            List entries = (List)cursor.asList().join();
            Assertions.assertEquals((int)15, (int)entries.size());
            Assertions.assertEquals((int)15, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            List timestamps = entries.stream().map(a -> ((FieldDoc)((LuceneRecordCursor.ScoreDocIndexEntry)a).getScoreDoc()).fields[0]).map(Long.class::cast).collect(Collectors.toList());
            Comparator comparator = Long::compareTo;
            Assertions.assertTrue((boolean)Comparators.isInOrder(timestamps, comparator.reversed()));
            this.validatePartitionSegmentIntegrity(COMPLEX_PARTITIONED, context, 1L, 0, 1);
        }
    }

    private void setTimestamps() {
        this.timestamp60DaysAgo = Instant.now().minus(60L, ChronoUnit.DAYS).toEpochMilli();
        this.timestamp30DaysAgo = Instant.now().minus(30L, ChronoUnit.DAYS).toEpochMilli();
        this.timestamp29DaysAgo = Instant.now().minus(29L, ChronoUnit.DAYS).toEpochMilli();
        this.yesterday = Instant.now().minus(1L, ChronoUnit.DAYS).toEpochMilli();
    }

    Map<Tuple, Map<Tuple, Tuple>> createPartitionsAndComplexDocs(Index index, int[] docCounts, Random random) {
        List partitionIds = IntStream.rangeClosed(0, docCounts.length - 1).boxed().collect(Collectors.toList());
        Collections.shuffle(partitionIds, random);
        HashMap<Tuple, Map<Tuple, Tuple>> keys = new HashMap<Tuple, Map<Tuple, Tuple>>();
        Tuple groupingKey = Tuple.from((Object[])new Object[]{1L});
        keys.put(groupingKey, new HashMap());
        long startTime = 1000L;
        for (int i = 0; i < docCounts.length; ++i) {
            long from = startTime * (long)(i + 1);
            int timestampRange = 999;
            long to = from + 999L;
            this.createPartitionMetadata(index, groupingKey, (Integer)partitionIds.get(i), from, to);
            for (int j = 0; j < docCounts[i]; ++j) {
                long timestamp = from + (long)random.nextInt(1000);
                MatcherAssert.assertThat((Object)timestamp, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(from)));
                MatcherAssert.assertThat((Object)timestamp, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(to)));
                ((Map)keys.get(groupingKey)).put(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument((long)i * 100L + (long)j, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1L, timestamp)).getPrimaryKey(), Tuple.from((Object[])new Object[]{timestamp}));
            }
        }
        return keys;
    }

    void createDualPartitionsWithComplexDocs(int docCount) {
        this.createDualPartitionsWithComplexDocs(COMPLEX_PARTITIONED, docCount);
    }

    void createDualPartitionsWithComplexDocs(Index index, int docCount) {
        int i;
        this.createPartitionMetadata(index, Tuple.from((Object[])new Object[]{1L}), 0, this.timestamp60DaysAgo, this.timestamp30DaysAgo);
        this.createPartitionMetadata(index, Tuple.from((Object[])new Object[]{1L}), 1, this.timestamp29DaysAgo, this.yesterday);
        for (i = 0; i < docCount; ++i) {
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument((long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1L, ThreadLocalRandom.current().nextLong(this.timestamp60DaysAgo, this.timestamp30DaysAgo + 1L)));
        }
        for (i = 0; i < docCount; ++i) {
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1000L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1L, ThreadLocalRandom.current().nextLong(this.timestamp29DaysAgo, this.yesterday + 1L)));
        }
    }

    void createPartitionMetadata(Index index, Tuple groupKey, int partitionId, long fromTimestamp, long toTimestamp, Tuple fromPrimaryKey, Tuple toPrimaryKey) {
        Tuple from = Tuple.from((Object[])new Object[]{fromTimestamp}).add(fromPrimaryKey);
        Tuple to = Tuple.from((Object[])new Object[]{toTimestamp}).add(toPrimaryKey);
        LucenePartitionInfoProto.LucenePartitionInfo partitionInfo = LucenePartitionInfoProto.LucenePartitionInfo.newBuilder().setCount(0).setFrom(ByteString.copyFrom((byte[])from.pack())).setTo(ByteString.copyFrom((byte[])to.pack())).setId(partitionId).build();
        byte[] primaryKey = this.recordStore.indexSubspace(index).pack(groupKey.add(0L).addAll(from));
        this.recordStore.getContext().ensureActive().set(primaryKey, partitionInfo.toByteArray());
    }

    void createPartitionMetadata(Index index, Tuple groupKey, int partitionId, long fromTimestamp, long toTimestamp) {
        Tuple from = Tuple.from((Object[])new Object[]{fromTimestamp}).add(Tuple.from((Object[])new Object[]{1, 0}));
        Tuple to = Tuple.from((Object[])new Object[]{toTimestamp}).add(Tuple.from((Object[])new Object[]{1, Long.MAX_VALUE}));
        LucenePartitionInfoProto.LucenePartitionInfo partitionInfo = LucenePartitionInfoProto.LucenePartitionInfo.newBuilder().setCount(0).setFrom(ByteString.copyFrom((byte[])from.pack())).setTo(ByteString.copyFrom((byte[])to.pack())).setId(partitionId).build();
        byte[] primaryKey = this.recordStore.indexSubspace(index).pack(groupKey.add(0L).addAll(from));
        this.recordStore.getContext().ensureActive().set(primaryKey, partitionInfo.toByteArray());
    }

    void validatePartitionSegmentIntegrity(Index index, FDBRecordContext context, long group, int ... partitionIds) {
        for (int partitionId : partitionIds) {
            Subspace subspace = this.recordStore.indexSubspace(COMPLEX_PARTITIONED).subspace(Tuple.from((Object[])new Object[]{group, 1}).add((long)partitionId));
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, subspace, context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void simpleInsertAndSearch(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                this.createComplexRecordJoinedToSimple(1, 1547L, 1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "", true, System.currentTimeMillis(), 0);
                this.timer.reset();
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"propose a Vision\""), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\""), null, ScanProperties.FORWARD_SCAN));
            }
            Assertions.assertEquals((int)1, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void largeMetadataTest(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("many_fields_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToManyFields(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToManyFields(1, 1623L, 1623L, "propose a Vision", "", true, System.currentTimeMillis(), 0);
                this.createComplexRecordJoinedToManyFields(2, 1547L, 1547L, "different smoochies", "", false, System.currentTimeMillis(), 0);
                this.timer.reset();
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "many_text0:Vision AND many_bool0: true"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "ManyFieldsDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createManyFieldsDocument(1623L, "propose a Vision", 1L, true));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createManyFieldsDocument(1547L, "different smoochies", 2L, false));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{1623L})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "text0:Vision AND bool0: true"), null, ScanProperties.FORWARD_SCAN));
            }
            Assertions.assertEquals((int)1, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void differentFieldSearch(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("many_fields_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToManyFields(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToManyFields(1, 11L, 11L, "matching text for field 0 pineapple", "non matching text for field 1 orange", true, System.currentTimeMillis(), 0);
                Tuple primaryKey2 = this.createComplexRecordJoinedToManyFields(2, 387L, 387L, "non matching text for field 0 orange", "matching text for field 1 pineapple", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "many_text0:pineapple"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey2), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "many_text1:pineapple"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "ManyFieldsDocument", index);
                TestRecordsTextProto.ManyFieldsDocument doc1 = TestRecordsTextProto.ManyFieldsDocument.newBuilder().setDocId(11L).setText0("matching text for field 0 pineapple").setText1("non matching text for field 1 orange").build();
                TestRecordsTextProto.ManyFieldsDocument doc2 = TestRecordsTextProto.ManyFieldsDocument.newBuilder().setDocId(387L).setText0("non matching text for field 0 orange").setText1("matching text for field 1 pineapple").build();
                this.recordStore.saveRecord((Message)doc1);
                this.recordStore.saveRecord((Message)doc2);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{11})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "text0:pineapple"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{387})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "text1:pineapple"), null, ScanProperties.FORWARD_SCAN));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void differentFieldSearchNoOverlap(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("many_fields_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToManyFields(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToManyFields(1, 11L, 11L, "matching text for field 0 pineapple", "non matching text for field 1 orange", true, System.currentTimeMillis(), 0);
                Tuple primaryKey2 = this.createComplexRecordJoinedToManyFields(2, 387L, 387L, "non matching text for field 3 orange", "matching text for field 4 pineapple", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "many_text0:pineapple"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey2), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "many_text4:pineapple"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "ManyFieldsDocument", index);
                TestRecordsTextProto.ManyFieldsDocument doc1 = TestRecordsTextProto.ManyFieldsDocument.newBuilder().setDocId(11L).setText0("matching text for field 0 pineapple").setText1("non matching text for field 1 orange").build();
                TestRecordsTextProto.ManyFieldsDocument doc2 = TestRecordsTextProto.ManyFieldsDocument.newBuilder().setDocId(387L).setText3("non matching text for field 3 orange").setText4("matching text for field 4 pineapple").build();
                this.recordStore.saveRecord((Message)doc1);
                this.recordStore.saveRecord((Message)doc2);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{11})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "text0:pineapple"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{387})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "text4:pineapple"), null, ScanProperties.FORWARD_SCAN));
            }
        }
    }

    private static Stream<Arguments> specialCharacterParams() {
        return LuceneIndexTestUtils.luceneIndexMapParams().flatMap(indexedType -> Stream.of("\u03a9", "\u00e7").map(param2 -> Arguments.of((Object[])new Object[]{indexedType, param2})));
    }

    @Nonnull
    private String specialCharacterText(String specialCharacter) {
        return "Do we match special characters like " + specialCharacter + ", even when its mashed together like " + specialCharacter + "noSpaces?";
    }

    @ParameterizedTest
    @MethodSource(value={"specialCharacterParams"})
    void insertAndSearchWithSpecialCharacters(LuceneIndexTestUtils.IndexedType indexedType, String specialCharacter) {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, this.specialCharacterText(specialCharacter), "", true, System.currentTimeMillis(), 0);
                this.createComplexRecordJoinedToSimple(1, 1547L, 1547L, this.specialCharacterText(" "), "", true, System.currentTimeMillis(), 0);
                this.timer.reset();
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, specialCharacter), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, this.specialCharacterText(specialCharacter), 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, this.specialCharacterText(" "), 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, specialCharacter), null, ScanProperties.FORWARD_SCAN));
            }
            Assertions.assertEquals((int)1, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchTextQueryWithBooleanEquals(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("text_and_boolean_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "propose a Vision", true, System.currentTimeMillis(), 0);
                this.createComplexRecordJoinedToSimple(1, 1547L, 1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "different smoochies", false, System.currentTimeMillis(), 0);
                this.timer.reset();
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND complex_is_seen: true"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "ComplexDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "propose a Vision", 2, true));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "different smoochies", 2, false));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{2, 1623L})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND is_seen: true"), null, ScanProperties.FORWARD_SCAN));
            }
            Assertions.assertEquals((int)1, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchTextQueryWithBooleanNotEquals(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("text_and_boolean_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "propose a Vision", true, System.currentTimeMillis(), 0);
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(1, 1547L, 1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "different smoochies", false, System.currentTimeMillis(), 0);
                this.timer.reset();
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND NOT complex_is_seen: true"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "ComplexDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "propose a Vision", 2, true));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "different smoochies", 2, false));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{2, 1547L})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND NOT is_seen: true"), null, ScanProperties.FORWARD_SCAN));
            }
            Assertions.assertEquals((int)1, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchTextQueryWithBooleanRange(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("text_and_boolean_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "propose a Vision", true, System.currentTimeMillis(), 0);
                Tuple primaryKey2 = this.createComplexRecordJoinedToSimple(1, 1547L, 1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "different smoochies", false, System.currentTimeMillis(), 0);
                this.timer.reset();
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey, primaryKey2), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND complex_is_seen: [false TO true]"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "ComplexDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "propose a Vision", 2, true));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "different smoochies", 2, false));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{2, 1623L}), Tuple.from((Object[])new Object[]{2, 1547L})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND is_seen: [false TO true]"), null, ScanProperties.FORWARD_SCAN));
            }
            Assertions.assertEquals((int)2, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchTextQueryWithBooleanBoth(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("text_and_boolean_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "propose a Vision", true, System.currentTimeMillis(), 0);
                this.createComplexRecordJoinedToSimple(1, 1547L, 1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "different smoochies", false, System.currentTimeMillis(), 0);
                this.timer.reset();
                this.assertIndexEntryPrimaryKeyTuples(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND complex_is_seen: true AND complex_is_seen: false"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "ComplexDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "propose a Vision", 2, true));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "different smoochies", 2, false));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND is_seen: true AND is_seen: false"), null, ScanProperties.FORWARD_SCAN));
            }
            Assertions.assertNull((Object)((FDBStoreTimer)Verify.verifyNotNull((Object)context.getTimer())).getCounter((StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY));
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchTextQueryWithBooleanEither(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("text_and_boolean_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "propose a Vision", true, System.currentTimeMillis(), 0);
                Tuple primaryKey2 = this.createComplexRecordJoinedToSimple(1, 1547L, 1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "different smoochies", false, System.currentTimeMillis(), 0);
                this.timer.reset();
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey, primaryKey2), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND (complex_is_seen: true OR complex_is_seen: false)"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "ComplexDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "propose a Vision", 2, true));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "different smoochies", 2, false));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{2, 1623L}), Tuple.from((Object[])new Object[]{2, 1547L})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND (is_seen: true OR is_seen: false)"), null, ScanProperties.FORWARD_SCAN));
            }
            Assertions.assertEquals((int)2, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchTextQueryWithNumberEquals(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("text_and_number_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 2);
                this.createComplexRecordJoinedToSimple(1, 1547L, 1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", false, System.currentTimeMillis(), 1);
                this.createComplexRecordJoinedToSimple(3, 1548L, 1548L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", false, System.currentTimeMillis(), null);
                this.timer.reset();
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND complex_score:2"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1548L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", null));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND group:2"), null, ScanProperties.FORWARD_SCAN));
            }
            Assertions.assertEquals((int)1, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchTextWithEmailPrefix(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("text_and_number_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(1, 1241L, 1623L, "{to: aburritoofjoy@tacos.com, from: tacosareevil@badfoodtakes.net}", "", true, System.currentTimeMillis(), 1);
                this.createComplexRecordJoinedToSimple(2, 1342L, 1547L, "{to: aburritoofjoy@tacos.com, from: tacosareevil@badfoodtakes.net}", "", false, System.currentTimeMillis(), 2);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "aburritoofjoy@tacos.com* AND complex_score: 1"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1241L, "{to: aburritoofjoy@tacos.com, from: tacosareevil@badfoodtakes.net}", 1));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1342L, "{to: aburritoofjoy@tacos.com, from: tacosareevil@badfoodtakes.net}", 2));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1241L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "aburritoofjoy@tacos.com* AND group: 1"), null, ScanProperties.FORWARD_SCAN));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchTextQueryWithNumberRange(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("text_and_number_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 2);
                this.createComplexRecordJoinedToSimple(1, 1547L, 1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", false, System.currentTimeMillis(), 1);
                this.timer.reset();
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND complex_score:[2 TO 4]"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND group:[2 TO 4]"), null, ScanProperties.FORWARD_SCAN));
            }
            Assertions.assertEquals((int)1, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchTextWithNumberRangeInfinite(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("text_and_number_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 2);
                this.createComplexRecordJoinedToSimple(1, 1547L, 1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", false, System.currentTimeMillis(), 1);
                this.assertIndexEntryPrimaryKeys(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND complex_score:{9223372036854775807 TO 9223372036854775807]"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND complex_score:[-9223372036854775808 TO -9223372036854775808}"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", LuceneIndexTestUtils.TEXT_AND_NUMBER_INDEX);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND group:{9223372036854775807 TO 9223372036854775807]"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.TEXT_AND_NUMBER_INDEX, "\"propose a Vision\" AND group:[-9223372036854775808 TO -9223372036854775808}"), null, ScanProperties.FORWARD_SCAN));
            }
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    private static Stream<Arguments> bitsetParams() {
        return LuceneIndexTestUtils.luceneIndexMapParams().flatMap(indexedType -> Stream.of(Arguments.of((Object[])new Object[]{0, List.of(Long.valueOf(1623L), Long.valueOf(1547L)), Set.of(Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(28), Integer.valueOf(1623)), List.of(Integer.valueOf(1623))}), Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(26), Integer.valueOf(1547)), List.of(Integer.valueOf(1547))}))}), Arguments.of((Object[])new Object[]{4, List.of(Long.valueOf(1623L)), Set.of(Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(28), Integer.valueOf(1623)), List.of(Integer.valueOf(1623))}))}), Arguments.of((Object[])new Object[]{2, List.of(Long.valueOf(1547L)), Set.of(Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(26), Integer.valueOf(1547)), List.of(Integer.valueOf(1547))}))}), Arguments.of((Object[])new Object[]{8, List.of(Long.valueOf(1623L), Long.valueOf(1547L)), Set.of(Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(28), Integer.valueOf(1623)), List.of(Integer.valueOf(1623))}), Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(26), Integer.valueOf(1547)), List.of(Integer.valueOf(1547))}))}), Arguments.of((Object[])new Object[]{6, List.of(), Set.of()}), Arguments.of((Object[])new Object[]{24, List.of(Long.valueOf(1623L), Long.valueOf(1547L)), Set.of(Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(28), Integer.valueOf(1623)), List.of(Integer.valueOf(1623))}), Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(26), Integer.valueOf(1547)), List.of(Integer.valueOf(1547))}))}), Arguments.of((Object[])new Object[]{12, List.of(Long.valueOf(1623L)), Set.of(Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(28), Integer.valueOf(1623)), List.of(Integer.valueOf(1623))}))})).map(param2 -> Arguments.of((Object[])new Object[]{indexedType, param2.get()[0], param2.get()[1], param2.get()[2]})));
    }

    @ParameterizedTest
    @MethodSource(value={"bitsetParams"})
    void bitset(LuceneIndexTestUtils.IndexedType indexedType, int mask, List<Long> expectedResult, Set<Tuple> syntheticExpectedResult) {
        Index index = indexedType.getIndex("text_and_number_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.createComplexRecordJoinedToSimple(28, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 28);
                this.createComplexRecordJoinedToSimple(26, 1547L, 1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", false, System.currentTimeMillis(), 26);
                this.assertIndexEntryPrimaryKeyTuples(syntheticExpectedResult, (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND complex_group:BITSET_CONTAINS(" + mask + ")"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(syntheticExpectedResult, (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "complex_group:BITSET_CONTAINS(" + mask + ")"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 28));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 26));
                this.assertIndexEntryPrimaryKeys(expectedResult, (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"propose a Vision\" AND group:BITSET_CONTAINS(" + mask + ")"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(expectedResult, (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "group:BITSET_CONTAINS(" + mask + ")"), null, ScanProperties.FORWARD_SCAN));
            }
        }
    }

    private static Stream<Arguments> bitsetOrParams() {
        return LuceneIndexTestUtils.luceneIndexMapParams().flatMap(indexedType -> Stream.of(Arguments.of((Object[])new Object[]{0, 0, List.of(Long.valueOf(1623L), Long.valueOf(1547L)), Set.of(Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(28), Integer.valueOf(1623)), List.of(Integer.valueOf(1623))}), Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(26), Integer.valueOf(1547)), List.of(Integer.valueOf(1547))}))}), Arguments.of((Object[])new Object[]{4, 1, List.of(Long.valueOf(1623L)), Set.of(Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(28), Integer.valueOf(1623)), List.of(Integer.valueOf(1623))}))}), Arguments.of((Object[])new Object[]{2, 1, List.of(Long.valueOf(1547L)), Set.of(Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(26), Integer.valueOf(1547)), List.of(Integer.valueOf(1547))}))}), Arguments.of((Object[])new Object[]{8, 8, List.of(Long.valueOf(1623L), Long.valueOf(1547L)), Set.of(Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(28), Integer.valueOf(1623)), List.of(Integer.valueOf(1623))}), Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(26), Integer.valueOf(1547)), List.of(Integer.valueOf(1547))}))}), Arguments.of((Object[])new Object[]{4, 2, List.of(Long.valueOf(1623L), Long.valueOf(1547L)), Set.of(Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(28), Integer.valueOf(1623)), List.of(Integer.valueOf(1623))}), Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(26), Integer.valueOf(1547)), List.of(Integer.valueOf(1547))}))}), Arguments.of((Object[])new Object[]{16, 8, List.of(Long.valueOf(1623L), Long.valueOf(1547L)), Set.of(Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(28), Integer.valueOf(1623)), List.of(Integer.valueOf(1623))}), Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(26), Integer.valueOf(1547)), List.of(Integer.valueOf(1547))}))}), Arguments.of((Object[])new Object[]{8, 4, List.of(Long.valueOf(1623L), Long.valueOf(1547L)), Set.of(Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(28), Integer.valueOf(1623)), List.of(Integer.valueOf(1623))}), Tuple.from((Object[])new Object[]{-1, List.of(Integer.valueOf(26), Integer.valueOf(1547)), List.of(Integer.valueOf(1547))}))})).map(param2 -> Arguments.of((Object[])new Object[]{indexedType, param2.get()[0], param2.get()[1], param2.get()[2], param2.get()[3]})));
    }

    @ParameterizedTest
    @MethodSource(value={"bitsetOrParams"})
    void bitsetOr(LuceneIndexTestUtils.IndexedType indexedType, int mask1, int mask2, List<Long> expectedResult, Set<Tuple> syntheticExpectedResult) {
        Index index = indexedType.getIndex("text_and_number_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.createComplexRecordJoinedToSimple(28, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 28);
                this.createComplexRecordJoinedToSimple(26, 1547L, 1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", false, System.currentTimeMillis(), 26);
                this.assertIndexEntryPrimaryKeyTuples(syntheticExpectedResult, (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "complex_group:BITSET_CONTAINS(" + mask1 + ") OR complex_group:BITSET_CONTAINS(" + mask2 + ")"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 28));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 26));
                this.assertIndexEntryPrimaryKeys(expectedResult, (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "group:BITSET_CONTAINS(" + mask1 + ") OR group:BITSET_CONTAINS(" + mask2 + ")"), null, ScanProperties.FORWARD_SCAN));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void simpleEmptyIndex(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
            }
            try (RecordCursor cursor = this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "something"), null, ScanProperties.FORWARD_SCAN);){
                Assertions.assertEquals((Object)RecordCursorResult.exhausted(), (Object)cursor.getNext());
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void simpleEmptyAutoComplete(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("simple_text_with_auto_complete_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
            }
            try (RecordCursor cursor = this.recordStore.scanIndex(index, (IndexScanBounds)this.autoCompleteBounds(index, "something", (Iterable<String>)ImmutableSet.of((Object)"text")), null, ScanProperties.FORWARD_SCAN);){
                Assertions.assertEquals((Object)RecordCursorResult.exhausted(), (Object)cursor.getNext());
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void simpleInsertAndSearchNumFDBFetches(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                this.createComplexRecordJoinedToSimple(1, 1547L, 1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "", false, System.currentTimeMillis(), 0);
                this.timer.reset();
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
            }
            Assertions.assertEquals((int)1, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testContinuation(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        try (FDBRecordContext context = this.openContext();){
            LuceneContinuationProto.LuceneIndexContinuation continuation = LuceneContinuationProto.LuceneIndexContinuation.newBuilder().setDoc(1L).setScore(0.21973526f).setShard(0L).build();
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                this.createComplexRecordJoinedToSimple(3, 1624L, 1624L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                Tuple primaryKey3 = this.createComplexRecordJoinedToSimple(4, 1625L, 1625L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                Tuple primaryKey4 = this.createComplexRecordJoinedToSimple(5, 1626L, 1626L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                this.createComplexRecordJoinedToSimple(1, 1547L, 1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey3, primaryKey4), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:Vision"), continuation.toByteArray(), ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1624L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1625L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1626L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1625L), Long.valueOf(1626L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), continuation.toByteArray(), ScanProperties.FORWARD_SCAN));
            }
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testNullValue(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, null, "", true, System.currentTimeMillis(), 0);
                this.createComplexRecordJoinedToSimple(3, 1632L, 1632L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                this.createComplexRecordJoinedToSimple(1, 1547L, 1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "*:* AND NOT simple_text:[* TO *]"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1632L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 2));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "*:* AND NOT text:[* TO *]"), null, ScanProperties.FORWARD_SCAN));
            }
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testLimit(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        try (FDBRecordContext context = this.openContext();){
            int i;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                for (i = 0; i < 200; ++i) {
                    this.createComplexRecordJoinedToSimple(2 + i, 1623L + (long)i, 1623L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                }
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                for (i = 0; i < 200; ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                }
            }
            String searchString = indexedType.isSynthetic() ? "simple_text:Vision" : "Vision";
            Assertions.assertEquals((int)50, (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, searchString), null, ExecuteProperties.newBuilder().setReturnedRowLimit(50).build().asScanProperties(false)).getCount().join()));
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testSkip(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        try (FDBRecordContext context = this.openContext();){
            int i;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                for (i = 0; i < 50; ++i) {
                    this.createComplexRecordJoinedToSimple(2 + i, 1623L + (long)i, 1623L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                }
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                for (i = 0; i < 50; ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                }
            }
            String searchString = indexedType.isSynthetic() ? "simple_text:Vision" : "Vision";
            Assertions.assertEquals((int)40, (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, searchString), null, ExecuteProperties.newBuilder().setSkip(10).build().asScanProperties(false)).getCount().join()));
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testSkipWithLimit(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        try (FDBRecordContext context = this.openContext();){
            int i;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                for (i = 0; i < 50; ++i) {
                    this.createComplexRecordJoinedToSimple(2 + i, 1623L + (long)i, 1623L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                }
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES);
                for (i = 0; i < 50; ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                }
            }
            String searchString = indexedType.isSynthetic() ? "simple_text:Vision" : "Vision";
            Assertions.assertEquals((int)40, (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, searchString), null, ExecuteProperties.newBuilder().setReturnedRowLimit(50).setSkip(10).build().asScanProperties(false)).getCount().join()));
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testLimitWithContinuation(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        try (FDBRecordContext context = this.openContext();){
            int i;
            LuceneContinuationProto.LuceneIndexContinuation continuation = LuceneContinuationProto.LuceneIndexContinuation.newBuilder().setDoc(151L).setScore(0.0019047183f).setShard(0L).build();
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                for (i = 0; i < 200; ++i) {
                    this.createComplexRecordJoinedToSimple(2 + i, 1623L + (long)i, 1623L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                }
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                for (i = 0; i < 200; ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                }
            }
            String searchString = indexedType.isSynthetic() ? "simple_text:Vision" : "Vision";
            Assertions.assertEquals((int)48, (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, searchString), continuation.toByteArray(), ExecuteProperties.newBuilder().setReturnedRowLimit(50).build().asScanProperties(false)).getCount().join()));
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testLimitNeedsMultipleScans(LuceneIndexTestUtils.IndexedType indexedType) {
        RecordLayerPropertyStorage.Builder storageBuilder = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_INDEX_CURSOR_PAGE_SIZE, (Object)201);
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        try (FDBRecordContext context = this.openContext(storageBuilder);){
            int i;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                for (i = 0; i < 800; ++i) {
                    this.createComplexRecordJoinedToSimple(2 + i, 1623L + (long)i, 1623L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                }
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                for (i = 0; i < 800; ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                }
            }
            String searchString = indexedType.isSynthetic() ? "simple_text:Vision" : "Vision";
            Assertions.assertEquals((int)251, (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, searchString), null, ExecuteProperties.newBuilder().setReturnedRowLimit(251).build().asScanProperties(false)).getCount().join()));
            Assertions.assertEquals((int)2, (int)this.getCounter(context, (StoreTimer.Event)LuceneEvents.Events.LUCENE_INDEX_SCAN).getCount());
            Assertions.assertEquals((int)251, (int)this.getCounter(context, (StoreTimer.Event)LuceneEvents.Counts.LUCENE_SCAN_MATCHED_DOCUMENTS).getCount());
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testSkipOverMultipleScans(LuceneIndexTestUtils.IndexedType indexedType) {
        RecordLayerPropertyStorage.Builder storageBuilder = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_INDEX_CURSOR_PAGE_SIZE, (Object)201);
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        try (FDBRecordContext context = this.openContext(storageBuilder);){
            int i;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                for (i = 0; i < 251; ++i) {
                    this.createComplexRecordJoinedToSimple(2 + i, 1623L + (long)i, 1623L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                }
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                for (i = 0; i < 251; ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                }
            }
            String searchString = indexedType.isSynthetic() ? "simple_text:Vision" : "Vision";
            Assertions.assertEquals((int)50, (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, searchString), null, ExecuteProperties.newBuilder().setReturnedRowLimit(251).setSkip(201).build().asScanProperties(false)).getCount().join()));
            Assertions.assertEquals((int)2, (int)this.getCounter(context, (StoreTimer.Event)LuceneEvents.Events.LUCENE_INDEX_SCAN).getCount());
            Assertions.assertEquals((int)251, (int)this.getCounter(context, (StoreTimer.Event)LuceneEvents.Counts.LUCENE_SCAN_MATCHED_DOCUMENTS).getCount());
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testNestedFieldSearch(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("map_on_value_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToMap(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToMap(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "sampleTextSong", "", "", true, System.currentTimeMillis(), 0);
                this.createComplexRecordJoinedToMap(3, 1547L, 1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "sampleTextPhrase", "", "", true, System.currentTimeMillis(), 0);
                this.timer.reset();
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "map_entry_value:Vision", "sampleTextSong"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "map_entry_value:random", "sampleTextSong"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "map_entry_value:Vision", "sampleTextBook"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "MapDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexMapDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "sampleTextSong", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexMapDocument(1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "sampleTextPhrase", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "entry_value:Vision", "sampleTextSong"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "entry_value:random", "sampleTextSong"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "entry_value:Vision", "sampleTextBook"), null, ScanProperties.FORWARD_SCAN));
            }
            Assertions.assertEquals((int)1, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index).subspace(Tuple.from((Object[])new Object[]{"sampleTextSong"})), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testGroupedRecordSearch(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("map_on_value_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToMap(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToMap(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "sampleTextPhrase", "", "sampleTextSong", true, System.currentTimeMillis(), 0);
                this.timer.reset();
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "map_entry_value:Vision", "sampleTextPhrase"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "map_entry_value:random", "sampleTextSong"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "map_entry_value:Vision", "sampleTextBook"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "MapDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createMultiEntryMapDoc(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "sampleTextPhrase", "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "sampleTextSong", 2));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "entry_value:Vision", "sampleTextPhrase"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "entry_value:random", "sampleTextSong"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "entry_value:Vision", "sampleTextBook"), null, ScanProperties.FORWARD_SCAN));
            }
            Assertions.assertEquals((int)1, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index).subspace(Tuple.from((Object[])new Object[]{"sampleTextPhrase"})), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testMultipleFieldSearch(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("complex_multiple_text_indexes_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "john_doe@example.com", true, System.currentTimeMillis(), 0);
                this.createComplexRecordJoinedToSimple(3, 1547L, 1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "hering@gmail.com", true, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"Vision\" AND complex_text2:\"john_doe@example.com\""), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "ComplexDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "john_doe@example.com", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "hering@gmail.com", 3));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{2L, 1623L})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "text:\"Vision\" AND text2:\"john_doe@example.com\""), null, ScanProperties.FORWARD_SCAN));
            }
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testFuzzySearchWithDefaultEdit2(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("complex_multiple_text_indexes_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "john_doe@example.com", true, System.currentTimeMillis(), 0);
                this.createComplexRecordJoinedToSimple(3, 1547L, 1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "hering@gmail.com", true, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"Vision\" AND complex_text2:johndoe@example.com~"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "ComplexDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "john_doe@example.com", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "hering@gmail.com", 2));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{2L, 1623L})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "text:\"Vision\" AND text2:johndoe@example.com~"), null, ScanProperties.FORWARD_SCAN));
            }
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void simpleInsertDeleteAndSearch(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey1 = this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                Tuple primaryKey2 = this.createComplexRecordJoinedToSimple(3, 1624L, 1624L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                this.createComplexRecordJoinedToSimple(1, 1547L, 1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey1, primaryKey2), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
                Assertions.assertTrue((boolean)this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{3, 1624L})));
                Assertions.assertTrue((boolean)this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{1624L})));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey1), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1624L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 2));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L), Long.valueOf(1624L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
                Assertions.assertTrue((boolean)this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{1624L})));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
            }
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void simpleInsertAndSearchSingleTransaction(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        LuceneOptimizedPostingsFormat.setAllowCheckDataIntegrity((boolean)false);
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                for (int docId = 0; docId < 100; ++docId) {
                    this.createComplexRecordJoinedToSimple(100 + docId, docId, docId, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                    Assertions.assertEquals((int)(docId + 1), (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "formulate"), null, ScanProperties.FORWARD_SCAN).getCount().join()));
                }
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                for (int docId = 0; docId < 100; ++docId) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(docId, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                    Assertions.assertEquals((int)(docId + 1), (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "formulate"), null, ScanProperties.FORWARD_SCAN).getCount().join()));
                }
            }
            this.commit(context);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testCommit(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        Tuple primaryKey1 = null;
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                primaryKey1 = this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                this.createComplexRecordJoinedToSimple(1, 1547L, 1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey1), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
            }
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
            this.commit(context);
        }
        context = this.openContext();
        try {
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey1), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
            }
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testRollback(LuceneIndexTestUtils.IndexedType indexedType) {
        Tuple primaryKey1;
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                primaryKey1 = this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                this.createComplexRecordJoinedToSimple(1, 1547L, 1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey1), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
            }
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
            context.ensureActive().cancel();
        }
        context = this.openContext();
        try {
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.createComplexRecordJoinedToSimple(1, 1547L, 1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
                primaryKey1 = this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", true, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey1), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 1));
                this.assertIndexEntryPrimaryKeys(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
            }
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testDataLoad(LuceneIndexTestUtils.IndexedType indexedType) throws IOException {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        FDBRecordContext context = this.openContext();
        if (indexedType.isSynthetic()) {
            for (int i = 0; i < 1000; ++i) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                String[] randomWords = LuceneIndexTestUtils.generateRandomWords(500);
                this.createComplexRecordJoinedToSimple(2000 + i, i, i, randomWords[1], "", false, System.currentTimeMillis(), 0);
                if ((i + 1) % 10 != 0) continue;
                this.commit(context);
                context = this.openContext();
                LuceneIndexTest.validateIndexIntegrity(index, this.recordStore.indexSubspace(index), context, null, null);
            }
        } else {
            for (int i = 0; i < 2000; ++i) {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                String[] randomWords = LuceneIndexTestUtils.generateRandomWords(500);
                TestRecordsTextProto.SimpleDocument dylan = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId((long)i).setText(randomWords[1]).setGroup(2L).build();
                this.recordStore.saveRecord((Message)dylan);
                if ((i + 1) % 50 != 0) continue;
                this.commit(context);
                context = this.openContext();
                LuceneIndexTest.validateIndexIntegrity(index, this.recordStore.indexSubspace(index), context, null, null);
            }
        }
        context.close();
    }

    private static Stream<Arguments> primaryKeySegmentIndexEnabledParams() {
        return LuceneIndexTestUtils.luceneIndexMapParams().flatMap(indexedType -> Stream.of(true, false).map(primaryKeySegmentIndexEnabled -> Arguments.of((Object[])new Object[]{indexedType, primaryKeySegmentIndexEnabled})));
    }

    @ParameterizedTest
    @MethodSource(value={"primaryKeySegmentIndexEnabledParams"})
    void testSimpleUpdate(LuceneIndexTestUtils.IndexedType indexedType, boolean primaryKeySegmentIndexEnabled) throws IOException {
        Index index = indexedType.getIndex(primaryKeySegmentIndexEnabled ? "simple_text_suffixes_with_primary_key_segment_index_key" : "simple_text_suffixes_key");
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)3.0).build();
        if (indexedType.isSynthetic()) {
            HashMap<Long, Tuple> primaryKeys = new HashMap<Long, Tuple>();
            for (int i = 0; i < 20; ++i) {
                try (FDBRecordContext context = this.openContext(contextProps);){
                    this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                    FDBRecordStoreBase.RecordExistenceCheck existenceCheck = i < 5 ? FDBRecordStoreBase.RecordExistenceCheck.ERROR_IF_EXISTS : FDBRecordStoreBase.RecordExistenceCheck.ERROR_IF_NOT_EXISTS;
                    Tuple primaryKey = this.createComplexRecordJoinedToSimple(3000 + i, 1000L + (long)(i % 5), 1000L + (long)(i % 5), this.numbersText(i + 1), "", false, System.currentTimeMillis(), 0, existenceCheck);
                    primaryKeys.put((Long)((List)primaryKey.getItems().get(2)).get(0), primaryKey);
                    context.commit();
                    continue;
                }
            }
            if (primaryKeySegmentIndexEnabled) {
                MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY), (Matcher)Matchers.equalTo((Object)0));
                MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(10)));
                MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_MERGE_SEGMENTS), (Matcher)Matchers.equalTo((Object)0));
            } else {
                MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(10)));
                MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY), (Matcher)Matchers.equalTo((Object)0));
                MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_MERGE_SEGMENTS), (Matcher)Matchers.equalTo((Object)0));
            }
            try (FDBRecordContext context = this.openContext();){
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{-1, Tuple.from((Object[])new Object[]{3017, 1002}), Tuple.from((Object[])new Object[]{1002})})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "three"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{-1, Tuple.from((Object[])new Object[]{3015, 1000}), Tuple.from((Object[])new Object[]{1000})}), Tuple.from((Object[])new Object[]{-1, Tuple.from((Object[])new Object[]{3019, 1004}), Tuple.from((Object[])new Object[]{1004})})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "four"), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "seven"), null, ScanProperties.FORWARD_SCAN));
                if (primaryKeySegmentIndexEnabled) {
                    LucenePrimaryKeySegmentIndex primaryKeySegmentIndex = this.getDirectory(index, Tuple.from((Object[])new Object[0])).getPrimaryKeySegmentIndex();
                    Assertions.assertEquals(new ArrayList<ArrayList>(Arrays.asList(new ArrayList<Serializable>(Arrays.asList(-1L, new ArrayList<Long>(Arrays.asList(3015L, 1000L)), new ArrayList<Long>(Arrays.asList(1000L)), "_q", 2)), new ArrayList<Serializable>(Arrays.asList(-1L, new ArrayList<Long>(Arrays.asList(3016L, 1001L)), new ArrayList<Long>(Arrays.asList(1001L)), "_q", 0)), new ArrayList<Serializable>(Arrays.asList(-1L, new ArrayList<Long>(Arrays.asList(3017L, 1002L)), new ArrayList<Long>(Arrays.asList(1002L)), "_o", 0)), new ArrayList<Serializable>(Arrays.asList(-1L, new ArrayList<Long>(Arrays.asList(3018L, 1003L)), new ArrayList<Long>(Arrays.asList(1003L)), "_q", 1)), new ArrayList<Serializable>(Arrays.asList(-1L, new ArrayList<Long>(Arrays.asList(3019L, 1004L)), new ArrayList<Long>(Arrays.asList(1004L)), "_r", 0)))), (Object)primaryKeySegmentIndex.readAllEntries());
                }
                LuceneIndexTestValidator.validatePrimaryKeySegmentIndex(this.recordStore, index, Tuple.from((Object[])new Object[0]), null, new HashSet<Tuple>(primaryKeys.values()), false);
            }
        }
        HashSet<Tuple> primaryKeys = new HashSet<Tuple>();
        for (int i = 0; i < 20; ++i) {
            try (FDBRecordContext context = this.openContext(contextProps);){
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                FDBRecordStoreBase.RecordExistenceCheck existenceCheck = i < 5 ? FDBRecordStoreBase.RecordExistenceCheck.ERROR_IF_EXISTS : FDBRecordStoreBase.RecordExistenceCheck.ERROR_IF_NOT_EXISTS;
                TestRecordsTextProto.SimpleDocument record = LuceneIndexTestUtils.createSimpleDocument(1000L + (long)(i % 5), this.numbersText(i + 1), null);
                primaryKeys.add(this.recordStore.saveRecord((Message)record, existenceCheck).getPrimaryKey());
                context.commit();
                continue;
            }
        }
        if (primaryKeySegmentIndexEnabled) {
            MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY), (Matcher)Matchers.equalTo((Object)0));
            MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(10)));
            MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_MERGE_SEGMENTS), (Matcher)Matchers.equalTo((Object)0));
        } else {
            MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(10)));
            MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY), (Matcher)Matchers.equalTo((Object)0));
            MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_MERGE_SEGMENTS), (Matcher)Matchers.equalTo((Object)0));
        }
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1002L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "three"), null, ScanProperties.FORWARD_SCAN));
            this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1000L), Long.valueOf(1004L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "four"), null, ScanProperties.FORWARD_SCAN));
            this.assertIndexEntryPrimaryKeys(Set.of(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "seven"), null, ScanProperties.FORWARD_SCAN));
            if (primaryKeySegmentIndexEnabled) {
                LucenePrimaryKeySegmentIndex primaryKeySegmentIndex = this.getDirectory(index, Tuple.from((Object[])new Object[0])).getPrimaryKeySegmentIndex();
                Assertions.assertEquals(List.of(List.of(Long.valueOf(1000L), "_q", Integer.valueOf(2)), List.of(Long.valueOf(1001L), "_q", Integer.valueOf(0)), List.of(Long.valueOf(1002L), "_o", Integer.valueOf(0)), List.of(Long.valueOf(1003L), "_q", Integer.valueOf(1)), List.of(Long.valueOf(1004L), "_r", Integer.valueOf(0))), (Object)primaryKeySegmentIndex.readAllEntries());
            }
            LuceneIndexTestValidator.validatePrimaryKeySegmentIndex(this.recordStore, index, Tuple.from((Object[])new Object[0]), null, primaryKeys, false);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void simpleDeleteSegmentIndex(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("simple_text_suffixes_with_primary_key_segment_index_key");
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)3.0).build();
        Tuple primaryKey1 = null;
        Tuple primaryKey2 = null;
        Tuple primaryKey3 = null;
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                primaryKey1 = this.createComplexRecordJoinedToSimple(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", false, System.currentTimeMillis(), 0);
                primaryKey2 = this.createComplexRecordJoinedToSimple(3, 1624L, 1624L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", false, System.currentTimeMillis(), 0);
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1624L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
            }
            context.commit();
        }
        context = this.openContext();
        try {
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                primaryKey3 = this.createComplexRecordJoinedToSimple(4, 1547L, 1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "", false, System.currentTimeMillis(), 0);
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 2));
            }
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey1, primaryKey2), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:Vision"), null, ScanProperties.FORWARD_SCAN));
                Assertions.assertTrue((boolean)this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{3, 1624L})));
                Assertions.assertTrue((boolean)this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{1624L})));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey1), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:Vision"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L), Long.valueOf(1624L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
                Assertions.assertTrue((boolean)this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{1624L})));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
            }
            MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY), (Matcher)Matchers.equalTo((Object)0));
            MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY), (Matcher)Matchers.equalTo((Object)1));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        this.timer.reset();
        context = this.openContext();
        try {
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey1, primaryKey2, primaryKey3), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:way"), null, ScanProperties.FORWARD_SCAN));
                Assertions.assertTrue((boolean)this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{4, 1547L})));
                Assertions.assertTrue((boolean)this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{1547L})));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey1, primaryKey2), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:way"), null, ScanProperties.FORWARD_SCAN));
                primaryKey3 = this.createComplexRecordJoinedToSimple(4, 1547L, 1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey1, primaryKey2, primaryKey3), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:Vision"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L), Long.valueOf(1624L), Long.valueOf(1547L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "way"), null, ScanProperties.FORWARD_SCAN));
                Assertions.assertTrue((boolean)this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{1547L})));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L), Long.valueOf(1624L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "way"), null, ScanProperties.FORWARD_SCAN));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1547L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L), Long.valueOf(1624L), Long.valueOf(1547L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN));
            }
            MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY), (Matcher)Matchers.equalTo((Object)0));
            MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY), (Matcher)Matchers.equalTo((Object)1));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void fullDeleteSegmentIndex(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        this.fullDeleteHelper((TestHelpers.DangerousConsumer<LuceneIndexMaintainer>)((TestHelpers.DangerousConsumer)indexMaintainer -> {
            LucenePrimaryKeySegmentIndex primaryKeySegmentIndex1 = indexMaintainer.getDirectory(Tuple.from((Object[])new Object[0]), null).getPrimaryKeySegmentIndex();
            Assertions.assertEquals(List.of(), (Object)primaryKeySegmentIndex1.readAllEntries());
        }), (TestHelpers.DangerousConsumer<LuceneIndexMaintainer>)((TestHelpers.DangerousConsumer)indexMaintainer -> {
            LucenePrimaryKeySegmentIndex primaryKeySegmentIndex = indexMaintainer.getDirectory(Tuple.from((Object[])new Object[0]), null).getPrimaryKeySegmentIndex();
            Assertions.assertNotEquals(List.of(), (Object)primaryKeySegmentIndex.readAllEntries());
        }), indexedType);
    }

    @Nonnull
    private Index fullDeleteHelper(TestHelpers.DangerousConsumer<LuceneIndexMaintainer> assertEmpty, TestHelpers.DangerousConsumer<LuceneIndexMaintainer> assertNotEmpty, LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        FDBRecordContext context;
        Index index = indexedType.getIndex("simple_text_suffixes_with_primary_key_segment_index_key");
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)3.0).build();
        try (FDBRecordContext context2 = this.openContext(contextProps);){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context2, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
            } else {
                this.rebuildIndexMetaData(context2, "SimpleDocument", index);
            }
            Assertions.assertTrue((boolean)this.recordStore.getIndexDeferredMaintenanceControl().shouldAutoMergeDuringCommit());
            assertEmpty.accept((Object)this.getIndexMaintainer(index));
        }
        HashSet<Tuple> primaryKeys = new HashSet<Tuple>();
        for (int i = 0; i < 10; ++i) {
            context = this.openContext(contextProps);
            try {
                if (indexedType.isSynthetic()) {
                    this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                    primaryKeys.add(this.createComplexRecordJoinedToSimple(2000 + i, 1000 + i, 1000 + i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", false, System.currentTimeMillis(), 0));
                    primaryKeys.add(this.createComplexRecordJoinedToSimple(2010 + i, 1010 + i, 1010 + i, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "", false, System.currentTimeMillis(), 0));
                } else {
                    this.rebuildIndexMetaData(context, "SimpleDocument", index);
                    primaryKeys.add(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1000 + i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2)).getPrimaryKey());
                    primaryKeys.add(this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1010 + i, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 2)).getPrimaryKey());
                }
                context.commit();
                continue;
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
        }
        try (FDBRecordContext context3 = this.openContext(contextProps);){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context3, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
            } else {
                this.rebuildIndexMetaData(context3, "SimpleDocument", index);
            }
            Assertions.assertTrue((boolean)this.recordStore.getIndexDeferredMaintenanceControl().shouldAutoMergeDuringCommit());
            assertNotEmpty.accept((Object)this.getIndexMaintainer(index));
            LuceneIndexTestValidator.validatePrimaryKeySegmentIndex(this.recordStore, index, Tuple.from((Object[])new Object[0]), null, primaryKeys, false);
        }
        for (int i = 0; i < 4; ++i) {
            context = this.openContext(contextProps);
            try {
                int docId;
                int j;
                if (indexedType.isSynthetic()) {
                    this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                    Assertions.assertTrue((boolean)this.recordStore.getIndexDeferredMaintenanceControl().shouldAutoMergeDuringCommit());
                    for (j = 0; j < 5; ++j) {
                        docId = 1000 + i * 5 + j;
                        int group = 2000 + i * 5 + j;
                        this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{group, docId}));
                        this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{docId}));
                        primaryKeys.remove(Tuple.from((Object[])new Object[]{-1, new ArrayList<Integer>(Arrays.asList(group, docId)), new ArrayList<Integer>(Arrays.asList(docId))}));
                    }
                } else {
                    this.rebuildIndexMetaData(context, "SimpleDocument", index);
                    Assertions.assertTrue((boolean)this.recordStore.getIndexDeferredMaintenanceControl().shouldAutoMergeDuringCommit());
                    for (j = 0; j < 5; ++j) {
                        docId = 1000 + i * 5 + j;
                        this.recordStore.deleteRecord(Tuple.from((Object[])new Object[]{docId}));
                        primaryKeys.remove(Tuple.from((Object[])new Object[]{docId}));
                    }
                }
                context.commit();
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
            context = this.openContext(contextProps);
            try {
                if (indexedType.isSynthetic()) {
                    this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                } else {
                    this.rebuildIndexMetaData(context, "SimpleDocument", index);
                }
                LuceneIndexTestValidator.validatePrimaryKeySegmentIndex(this.recordStore, index, Tuple.from((Object[])new Object[0]), null, primaryKeys, false);
                continue;
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
        }
        try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).build();){
            indexBuilder.mergeIndex();
        }
        context = this.openContext(contextProps);
        try {
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
            }
            assertEmpty.accept((Object)this.getIndexMaintainer(index));
            LuceneIndexTestValidator.validatePrimaryKeySegmentIndex(this.recordStore, index, Tuple.from((Object[])new Object[0]), null, Set.of(), false);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        return index;
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void fullDeleteFieldInfos(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        this.fullDeleteHelper((TestHelpers.DangerousConsumer<LuceneIndexMaintainer>)((TestHelpers.DangerousConsumer)indexMaintainer -> {
            FDBDirectory fdbDirectory = indexMaintainer.getDirectory(Tuple.from((Object[])new Object[0]), null);
            Map allFieldInfos = fdbDirectory.getFieldInfosStorage().getAllFieldInfos();
            Assertions.assertEquals(Map.of(), (Object)allFieldInfos, () -> LuceneIndexTest.listAll(indexMaintainer));
        }), (TestHelpers.DangerousConsumer<LuceneIndexMaintainer>)((TestHelpers.DangerousConsumer)indexMaintainer -> {
            FDBDirectory fdbDirectory = indexMaintainer.getDirectory(Tuple.from((Object[])new Object[0]), null);
            Map allFieldInfos = fdbDirectory.getFieldInfosStorage().getAllFieldInfos();
            Assertions.assertNotEquals(Map.of(), (Object)allFieldInfos, () -> LuceneIndexTest.listAll(indexMaintainer));
        }), indexedType);
    }

    @Nonnull
    private static String listAll(LuceneIndexMaintainer indexMaintainer) {
        try {
            return String.join((CharSequence)", ", indexMaintainer.getDirectory(Tuple.from((Object[])new Object[0]), null).listAll());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void checkFileCountAfterMerge(LuceneIndexTestUtils.IndexedType indexedType) throws IOException {
        Index index = indexedType.getIndex("simple_text_suffixes_with_primary_key_segment_index_key");
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)3.0).build();
        int lastFileCount = -1;
        boolean mergeHappened = false;
        for (int i = 0; i < 10; ++i) {
            try (FDBRecordContext context = this.openContext(contextProps);){
                if (indexedType.isSynthetic()) {
                    this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                    this.createComplexRecordJoinedToSimple(2000 + i, 1000 + i, 1000 + i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", false, System.currentTimeMillis(), 0);
                    this.createComplexRecordJoinedToSimple(2010 + i, 1010 + i, 1010 + i, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "", false, System.currentTimeMillis(), 0);
                } else {
                    this.rebuildIndexMetaData(context, "SimpleDocument", index);
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1000 + i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1010 + i, "There's always one more way to do things and that's your way, and you have a right to try it at least once.", 2));
                }
                context.commit();
            }
            context = this.openContext(contextProps);
            try {
                if (indexedType.isSynthetic()) {
                    this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                } else {
                    this.rebuildIndexMetaData(context, "SimpleDocument", index);
                }
                LuceneIndexTest.validateIndexIntegrity(index, this.recordStore.indexSubspace(index), context, null, null);
                int fileCount = this.getDirectory(index, Tuple.from((Object[])new Object[0])).listAll().length;
                if (fileCount < lastFileCount) {
                    mergeHappened = true;
                }
                lastFileCount = fileCount;
                context.commit();
                continue;
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
        }
        Assertions.assertTrue((boolean)mergeHappened);
    }

    private static Stream<Arguments> autoMergeParams() {
        return LuceneIndexTestUtils.luceneIndexMapParams().flatMap(indexedType -> Stream.of(true, false).map(autoMerge -> Arguments.of((Object[])new Object[]{indexedType, autoMerge})));
    }

    @ParameterizedTest
    @MethodSource(value={"autoMergeParams"})
    void testMultipleUpdateSegments(LuceneIndexTestUtils.IndexedType indexedType, boolean autoMerge) throws IOException {
        long segmentCountBefore;
        Index index = indexedType.getIndex("complex_grouped_with_primary_key_segment_index_key");
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)3.0).build();
        try (FDBRecordContext context = this.openContext(contextProps);){
            int i;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                for (i = 0; i < 20; ++i) {
                    this.createComplexRecordJoinedToSimple(1000 + i, i, i, "", "", false, System.currentTimeMillis(), 0);
                }
            } else {
                this.rebuildIndexMetaData(context, "ComplexDocument", index);
                for (i = 0; i < 20; ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument((long)i, "", "", 0));
                }
            }
            context.commit();
        }
        try (FDBRecordContext context = this.openContext(contextProps);){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                segmentCountBefore = this.getSegmentCount(index, Tuple.from((Object[])new Object[]{-1, Tuple.from((Object[])new Object[]{1000, 0}), Tuple.from((Object[])new Object[]{0})}));
            } else {
                this.rebuildIndexMetaData(context, "ComplexDocument", index);
                segmentCountBefore = this.getSegmentCount(index, Tuple.from((Object[])new Object[]{0}));
            }
        }
        context = this.openContext(contextProps);
        try {
            int i;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.recordStore.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(autoMerge);
                for (i = 0; i < 10; ++i) {
                    this.createComplexRecordJoinedToSimple(2000 + i, i, i, "", "", false, System.currentTimeMillis(), 0);
                }
            } else {
                this.rebuildIndexMetaData(context, "ComplexDocument", index);
                this.recordStore.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(autoMerge);
                for (i = 0; i < 10; ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument((long)i, this.numbersText(i), "", 0));
                }
            }
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY), (Matcher)Matchers.equalTo((Object)10));
        MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_FIND_MERGES), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(5)));
        context = this.openContext(contextProps);
        try {
            long segmentCountAfter;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                segmentCountAfter = this.getSegmentCount(index, Tuple.from((Object[])new Object[]{0}));
            } else {
                this.rebuildIndexMetaData(context, "ComplexDocument", index);
                segmentCountAfter = this.getSegmentCount(index, Tuple.from((Object[])new Object[]{-1, Tuple.from((Object[])new Object[]{1000, 0}), Tuple.from((Object[])new Object[]{0})}));
            }
            MatcherAssert.assertThat((Object)(segmentCountAfter - segmentCountBefore), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(5L)));
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testGroupedMultipleUpdate(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("complex_grouped_with_primary_key_segment_index_key");
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)3.0).build();
        for (int g = 0; g < 3; ++g) {
            for (int i2 = 0; i2 < 5; ++i2) {
                try (FDBRecordContext context = this.openContext(contextProps);){
                    int n;
                    int j;
                    if (indexedType.isSynthetic()) {
                        this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                        for (j = 0; j < 10; ++j) {
                            n = i2 * 10 + j + 1;
                            this.createComplexRecordJoinedToSimple(1000 * (g + 1) + n, 100 * g + n, 100 * g + n, "", this.numbersText(n), false, System.currentTimeMillis(), g);
                        }
                    } else {
                        this.rebuildIndexMetaData(context, "ComplexDocument", index);
                        for (j = 0; j < 10; ++j) {
                            n = i2 * 10 + j + 1;
                            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument((long)n, this.numbersText(n), "", g));
                        }
                    }
                    context.commit();
                    continue;
                }
            }
        }
        try (FDBRecordContext context = this.openContext(contextProps);){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Assertions.assertEquals(IntStream.rangeClosed(1, 7).mapToObj(i -> new ArrayList<Long>(Arrays.asList((long)i * 7L))).collect(Collectors.toSet()), new HashSet((Collection)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "complex_text2:seven", 0), null, ScanProperties.FORWARD_SCAN).map(x -> x.getPrimaryKey().getItems().get(2)).asList().join()));
            } else {
                this.rebuildIndexMetaData(context, "ComplexDocument", index);
                Assertions.assertEquals(IntStream.rangeClosed(1, 7).mapToObj(i -> Tuple.from((Object[])new Object[]{0, i * 7})).collect(Collectors.toSet()), new HashSet((Collection)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "text:seven", 0L), null, ScanProperties.FORWARD_SCAN).map(IndexEntry::getPrimaryKey).asList().join()));
            }
        }
        context = this.openContext(contextProps);
        try {
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.recordStore.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(false);
                this.createComplexRecordJoinedToSimple(4000, 49L, 49L, "", "not here", false, System.currentTimeMillis(), 0);
                this.createComplexRecordJoinedToSimple(4001, 35L, 35L, "", "nor here either", false, System.currentTimeMillis(), 0);
            } else {
                this.rebuildIndexMetaData(context, "ComplexDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(49L, "not here", "", 0));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(35L, "nor here either", "", 0));
            }
            context.commit();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext(contextProps);
        try {
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Assertions.assertEquals(Stream.of(1, 2, 3, 4, 6).map(i -> new ArrayList<Long>(Arrays.asList((long)i.intValue() * 7L))).collect(Collectors.toSet()), new HashSet((Collection)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "complex_text2:seven", 0L), null, ScanProperties.FORWARD_SCAN).map(x -> x.getPrimaryKey().getItems().get(2)).asList().join()));
                Assertions.assertEquals(Stream.of(5, 7).map(i -> new ArrayList<Long>(Arrays.asList((long)i.intValue() * 7L))).collect(Collectors.toSet()), new HashSet((Collection)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "complex_text2:here", 0L), null, ScanProperties.FORWARD_SCAN).map(x -> x.getPrimaryKey().getItems().get(2)).asList().join()));
            } else {
                this.rebuildIndexMetaData(context, "ComplexDocument", index);
                Assertions.assertEquals(Stream.of(1, 2, 3, 4, 6).map(i -> Tuple.from((Object[])new Object[]{0, i * 7})).collect(Collectors.toSet()), new HashSet((Collection)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "text:seven", 0L), null, ScanProperties.FORWARD_SCAN).map(IndexEntry::getPrimaryKey).asList().join()));
                Assertions.assertEquals(Stream.of(5, 7).map(i -> Tuple.from((Object[])new Object[]{0, i * 7})).collect(Collectors.toSet()), new HashSet((Collection)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedTextSearch(index, "text:here", 0L), null, ScanProperties.FORWARD_SCAN).map(IndexEntry::getPrimaryKey).asList().join()));
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY), (Matcher)Matchers.equalTo((Object)2));
    }

    private String numbersText(int i) {
        String[] nums = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
        return IntStream.range(1, nums.length).filter(n -> i % n == 0).mapToObj(n -> nums[n]).collect(Collectors.joining(" "));
    }

    private String matchAll(String luceneField, String ... words) {
        return luceneField + ":(" + Arrays.stream(words).map(word -> "+\"" + word + "\"").collect(Collectors.joining(" AND ")) + ")";
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void scanWithQueryOnlySynonymIndex(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("query_only_synonym_lucene_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(1, 1623L, 1623L, "Hello record layer", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "hullo record layer"), null, ScanProperties.FORWARD_SCAN));
                primaryKey = this.createComplexRecordJoinedToSimple(1, 1623L, 1623L, "Hello recor layer", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "hullo record layer"), null, ScanProperties.FORWARD_SCAN));
                primaryKey = this.createComplexRecordJoinedToSimple(1, 1623L, 1623L, "Hello record layer", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, this.matchAll("simple_text", "hullo", "record", "layer")), null, ScanProperties.FORWARD_SCAN));
                primaryKey = this.createComplexRecordJoinedToSimple(1, 1623L, 1623L, "Hello record layer", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, this.matchAll("simple_text", "hullo", "recor", "layer")), null, ScanProperties.FORWARD_SCAN));
                primaryKey = this.createComplexRecordJoinedToSimple(1, 1623L, 1623L, "Hello record layer", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, this.matchAll("simple_text", "hullo", "show", "layer")), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Hello record layer", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "hullo record layer"), null, ScanProperties.FORWARD_SCAN));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Hello recor layer", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "hullo record layer"), null, ScanProperties.FORWARD_SCAN));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Hello record layer", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, this.matchAll("text", "hullo", "record", "layer")), null, ScanProperties.FORWARD_SCAN));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Hello record layer", 1));
                this.assertIndexEntryPrimaryKeys(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, this.matchAll("text", "hullo", "recor", "layer")), null, ScanProperties.FORWARD_SCAN));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Hello record layer", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, this.matchAll("text", "hullo", "show", "layer")), null, ScanProperties.FORWARD_SCAN));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void scanWithAuthoritativeSynonymOnlyIndex(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("authoritative_synonym_only_lucene_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.createComplexRecordJoinedToSimple(1, 1623L, 1623L, "Hello record layer", "", false, System.currentTimeMillis(), 0);
                Assertions.assertEquals((int)1, (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "hullo record layer"), null, ScanProperties.FORWARD_SCAN).getCount().join()));
                this.createComplexRecordJoinedToSimple(1, 1623L, 1623L, "Hello recor layer", "", false, System.currentTimeMillis(), 0);
                Assertions.assertEquals((int)1, (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "hullo record layer"), null, ScanProperties.FORWARD_SCAN).getCount().join()));
                this.createComplexRecordJoinedToSimple(1, 1623L, 1623L, "Hello record layer", "", false, System.currentTimeMillis(), 0);
                Assertions.assertEquals((int)1, (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, this.matchAll("simple_text", "hullo", "record", "layer")), null, ScanProperties.FORWARD_SCAN).getCount().join()));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Hello record layer", 1));
                Assertions.assertEquals((int)0, (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, this.matchAll("simple_text", "hullo", "recor", "layer")), null, ScanProperties.FORWARD_SCAN).getCount().join()));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Hello record layer", 1));
                Assertions.assertEquals((int)1, (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, this.matchAll("simple_text", "hullo", "show", "layer")), null, ScanProperties.FORWARD_SCAN).getCount().join()));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Hello record layer", 1));
                Assertions.assertEquals((int)1, (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "hullo record layer"), null, ScanProperties.FORWARD_SCAN).getCount().join()));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Hello recor layer", 1));
                Assertions.assertEquals((int)1, (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "hullo record layer"), null, ScanProperties.FORWARD_SCAN).getCount().join()));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Hello record layer", 1));
                Assertions.assertEquals((int)1, (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, this.matchAll("text", "hullo", "record", "layer")), null, ScanProperties.FORWARD_SCAN).getCount().join()));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Hello record layer", 1));
                Assertions.assertEquals((int)0, (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, this.matchAll("text", "hullo", "recor", "layer")), null, ScanProperties.FORWARD_SCAN).getCount().join()));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Hello record layer", 1));
                Assertions.assertEquals((int)1, (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, this.matchAll("text", "hullo", "show", "layer")), null, ScanProperties.FORWARD_SCAN).getCount().join()));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void phraseSearchBasedOnQueryOnlySynonymIndex(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("query_only_synonym_lucene_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(1, 1623L, 1623L, "I think you need to search with Lucene index", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"you need to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"need you to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"you motivation to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"motivation you to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"you motive to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"motive you to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:motivation simple_text:you simple_text:to"), null, ScanProperties.FORWARD_SCAN));
                primaryKey = this.createComplexRecordJoinedToSimple(2, 1624L, 1624L, "He is leaving for New York next week", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"is departure for\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"is going away for\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"is going for\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"is away for\""), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "I think you need to search with Lucene index", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"you need to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"need you to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"you motivation to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"motivation you to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"you motive to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"motive you to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "motivation you to"), null, ScanProperties.FORWARD_SCAN));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1624L, "He is leaving for New York next week", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1624L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"is departure for\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1624L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"is going away for\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1624L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"is going for\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"is away for\""), null, ScanProperties.FORWARD_SCAN));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void phraseSearchBasedOnAuthoritativeSynonymOnlyIndex(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("authoritative_synonym_only_lucene_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(1, 1623L, 1623L, "I think you need to search with Lucene index", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"you need to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"need you to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"you motivation to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"motivation you to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"you motive to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"motive you to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:motivation simple_text:you simple_text:to"), null, ScanProperties.FORWARD_SCAN));
                primaryKey = this.createComplexRecordJoinedToSimple(2, 1624L, 1624L, "He is leaving for New York next week", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"is departure for\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"is going away for\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"is going for\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"is away for\""), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "I think you need to search with Lucene index", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"you need to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"need you to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"you motivation to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"motivation you to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"you motive to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"motive you to\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "motivation you to"), null, ScanProperties.FORWARD_SCAN));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1624L, "He is leaving for New York next week", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1624L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"is departure for\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1624L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"is going away for\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1624L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"is going for\""), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1624L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"is away for\""), null, ScanProperties.FORWARD_SCAN));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void scanWithCombinedSetsSynonymIndex(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index1 = indexedType.getIndex("query_only_synonym_lucene_index_key");
        Index index2 = indexedType.getIndex("query_only_synonym_lucene_combined_sets_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index1, index2));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(1, 1623L, 1623L, "synonym is fun", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index1, (IndexScanBounds)this.fullTextSearch(index1, this.matchAll("simple_text", "nonsynonym", "is", "fun")), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index2, (IndexScanBounds)this.fullTextSearch(index2, this.matchAll("simple_text", "nonsynonym", "is", "fun")), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.openRecordStore(context, metaDataBuilder -> {
                    metaDataBuilder.removeIndex("SimpleDocument$text");
                    metaDataBuilder.addIndex("SimpleDocument", index1);
                    metaDataBuilder.addIndex("SimpleDocument", index2);
                });
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "synonym is fun", 1));
                this.assertIndexEntryPrimaryKeys(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index1, (IndexScanBounds)this.fullTextSearch(index1, this.matchAll("text", "nonsynonym", "is", "fun")), null, ScanProperties.FORWARD_SCAN));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index2, (IndexScanBounds)this.fullTextSearch(index2, this.matchAll("text", "nonsynonym", "is", "fun")), null, ScanProperties.FORWARD_SCAN));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void proximitySearchOnMultiFieldWithMultiWordSynonym(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("query_only_synonym_lucene_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(1, 1623L, 1623L, "Hello FoundationDB record layer", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "simple_text:\"hello record\"~10"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Hello FoundationDB record layer", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"hello record\"~10"), null, ScanProperties.FORWARD_SCAN));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void proximitySearchOnSpecificFieldWithMultiWordSynonym(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("query_only_synonym_lucene_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                Tuple primaryKey = this.createComplexRecordJoinedToSimple(1, 1623L, 1623L, "Hello FoundationDB record layer", "", false, System.currentTimeMillis(), 0);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(primaryKey), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.specificFieldSearch(index, "simple_text:\"hello record\"~10", "text"), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Hello FoundationDB record layer", 1));
                this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.specificFieldSearch(index, "\"hello record\"~10", "text"), null, ScanProperties.FORWARD_SCAN));
            }
        }
    }

    @Test
    void scanWithNgramIndex() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", LuceneIndexTestUtils.NGRAM_LUCENE_INDEX);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Hello record layer", 1));
            this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, "hello record layer"), null, ScanProperties.FORWARD_SCAN));
            this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, "hello"), null, ScanProperties.FORWARD_SCAN));
            this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, "hel"), null, ScanProperties.FORWARD_SCAN));
            this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, "ell"), null, ScanProperties.FORWARD_SCAN));
            this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, "ecord"), null, ScanProperties.FORWARD_SCAN));
            this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, "hel ord aye"), null, ScanProperties.FORWARD_SCAN));
            this.assertIndexEntryPrimaryKeys(Set.of(Long.valueOf(1623L)), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, "ello record"), null, ScanProperties.FORWARD_SCAN));
            this.assertIndexEntryPrimaryKeys(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, "ella"), null, ScanProperties.FORWARD_SCAN));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchForAutoComplete(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        this.searchForAutoCompleteAndAssert(indexedType, "good", true, false, indexedType.getPlanHashes().get(0));
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchForAutoCompleteWithPrefix(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        this.searchForAutoCompleteAndAssert(indexedType, "goo", true, false, indexedType.getPlanHashes().get(1));
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchForAutoCompleteWithHighlight(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        this.searchForAutoCompleteAndAssert(indexedType, "good", true, true, indexedType.getPlanHashes().get(0));
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchForAutoCompleteWithLoadingNoRecords(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("simple_text_with_auto_complete_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.assertIndexEntryPrimaryKeys(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.autoCompleteBounds(index, "hello", (Iterable<String>)ImmutableSet.of((Object)"simple_text")), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.openRecordStore(context, metaDataBuilder -> {
                    metaDataBuilder.removeIndex("SimpleDocument$text");
                    metaDataBuilder.addIndex("SimpleDocument", index);
                });
                this.assertIndexEntryPrimaryKeys(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.autoCompleteBounds(index, "hello", (Iterable<String>)ImmutableSet.of((Object)"text")), null, ScanProperties.FORWARD_SCAN));
            }
            Assertions.assertEquals((int)0, (int)((FDBStoreTimer)Verify.verifyNotNull((Object)context.getTimer())).getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_SCAN_MATCHED_AUTO_COMPLETE_SUGGESTIONS));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchForAutoCompleteAcrossMultipleFields(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("complex_multiple_text_indexes_with_auto_complete_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.createComplexRecordJoinedToSimple(1, 1623L, 1623L, "Good morning", "", false, System.currentTimeMillis(), 1);
                this.createComplexRecordJoinedToSimple(2, 1624L, 1624L, "Good afternoon", "", false, System.currentTimeMillis(), 1);
                this.createComplexRecordJoinedToSimple(3, 1625L, 1625L, "good evening", "", false, System.currentTimeMillis(), 1);
                this.createComplexRecordJoinedToSimple(4, 1626L, 1626L, "Good night", "", false, System.currentTimeMillis(), 1);
                this.createComplexRecordJoinedToSimple(5, 1627L, 1627L, "", "That's really good!", false, System.currentTimeMillis(), 1);
                this.createComplexRecordJoinedToSimple(6, 1628L, 1628L, "Good day", "I'm good", false, System.currentTimeMillis(), 1);
                this.createComplexRecordJoinedToSimple(7, 1629L, 1629L, "", "Hello Record Layer", false, System.currentTimeMillis(), 1);
                this.createComplexRecordJoinedToSimple(8, 1630L, 1630L, "", "Hello FoundationDB!", false, System.currentTimeMillis(), 1);
            } else {
                this.openRecordStore(context, metaDataBuilder -> {
                    metaDataBuilder.removeIndex("SimpleDocument$text");
                    metaDataBuilder.addIndex("ComplexDocument", index);
                });
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "Good morning", "", 1));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1624L, "Good afternoon", "", 1));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1625L, "good evening", "", 1));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1626L, "Good night", "", 1));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1627L, "", "That's really good!", 1));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1628L, "Good day", "I'm good", 1));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1629L, "", "Hello Record Layer", 1));
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1630L, "", "Hello FoundationDB!", 1));
            }
            LuceneIndexQueryPlan luceneIndexPlan = LuceneIndexQueryPlan.of((String)index.getName(), (LuceneScanParameters)this.autoCompleteScanParams("good", (Iterable<String>)(indexedType.isSynthetic() ? ImmutableSet.of((Object)"simple_text", (Object)"complex_text2") : ImmutableSet.of((Object)"text", (Object)"text2"))), (RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords)(indexedType.isSynthetic() ? RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.SYNTHETIC_CONSTITUENTS : RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY), (boolean)false, null, indexedType.isSynthetic() ? LuceneIndexTestUtils.JOINED_COMPLEX_MULTI_GROUPED_WITH_AUTO_COMPLETE_STORED_FIELDS : LuceneIndexTestUtils.COMPLEX_MULTI_GROUPED_WITH_AUTO_COMPLETE_STORED_FIELDS);
            Assertions.assertEquals((Integer)indexedType.getPlanHashes().get(2), (int)luceneIndexPlan.planHash(PlanHashable.CURRENT_LEGACY));
            List results = (List)this.recordStore.executeQuery((RecordQueryPlan)luceneIndexPlan, null, ExecuteProperties.SERIAL_EXECUTE).asList().get();
            ImmutableList expectedResults = ImmutableList.of((Object)Pair.of((Object)"Good day", (Object)"I'm good"), (Object)Pair.of((Object)"Good morning", (Object)""), (Object)Pair.of((Object)"Good afternoon", (Object)""), (Object)Pair.of((Object)"good evening", (Object)""), (Object)Pair.of((Object)"Good night", (Object)""), (Object)Pair.of((Object)"", (Object)"That's really good!"));
            Assertions.assertEquals((int)expectedResults.size(), (int)results.size());
            Assertions.assertTrue((boolean)Streams.zip((Stream)expectedResults.stream(), results.stream(), (expectedResult, result) -> {
                Message record = (Message)Verify.verifyNotNull((Object)result.getRecord());
                if (indexedType.isSynthetic()) {
                    DynamicMessage dm = (DynamicMessage)record.getField(record.getDescriptorForType().findFieldByName("simple"));
                    Descriptors.Descriptor descriptor = dm.getDescriptorForType();
                    Descriptors.FieldDescriptor textDescriptor = descriptor.findFieldByName("text");
                    Assertions.assertEquals((Object)expectedResult.getLeft(), (Object)dm.getField(textDescriptor));
                    DynamicMessage dm2 = (DynamicMessage)record.getField(record.getDescriptorForType().findFieldByName("complex"));
                    Descriptors.Descriptor descriptor2 = dm2.getDescriptorForType();
                    Descriptors.FieldDescriptor textDescriptor2 = descriptor2.findFieldByName("text2");
                    Assertions.assertEquals((Object)expectedResult.getRight(), (Object)dm2.getField(textDescriptor2));
                } else {
                    Descriptors.Descriptor descriptor = record.getDescriptorForType();
                    Descriptors.FieldDescriptor textDescriptor = descriptor.findFieldByName("text");
                    Assertions.assertEquals((Object)expectedResult.getLeft(), (Object)record.getField(textDescriptor));
                    Descriptors.FieldDescriptor text2Descriptor = descriptor.findFieldByName("text2");
                    Assertions.assertEquals((Object)expectedResult.getRight(), (Object)record.getField(text2Descriptor));
                }
                return true;
            }).allMatch(r -> r));
            Subspace subspace = this.recordStore.indexSubspace(index);
            LuceneIndexTest.validateSegmentAndIndexIntegrity(index, subspace, context, "_0.cfs");
            ImmutableList expectedPks = indexedType.isSynthetic() ? ImmutableList.of((Object)Tuple.from((Object[])new Object[]{-1, Tuple.from((Object[])new Object[]{6, 1628}), Tuple.from((Object[])new Object[]{1628})}), (Object)Tuple.from((Object[])new Object[]{-1, Tuple.from((Object[])new Object[]{1, 1623}), Tuple.from((Object[])new Object[]{1623})}), (Object)Tuple.from((Object[])new Object[]{-1, Tuple.from((Object[])new Object[]{2, 1624}), Tuple.from((Object[])new Object[]{1624})}), (Object)Tuple.from((Object[])new Object[]{-1, Tuple.from((Object[])new Object[]{3, 1625}), Tuple.from((Object[])new Object[]{1625})}), (Object)Tuple.from((Object[])new Object[]{-1, Tuple.from((Object[])new Object[]{4, 1626}), Tuple.from((Object[])new Object[]{1626})}), (Object)Tuple.from((Object[])new Object[]{-1, Tuple.from((Object[])new Object[]{5, 1627}), Tuple.from((Object[])new Object[]{1627})})) : ImmutableList.of((Object)Tuple.from((Object[])new Object[]{1L, 1628L}), (Object)Tuple.from((Object[])new Object[]{1L, 1623L}), (Object)Tuple.from((Object[])new Object[]{1L, 1624L}), (Object)Tuple.from((Object[])new Object[]{1L, 1625L}), (Object)Tuple.from((Object[])new Object[]{1L, 1626L}), (Object)Tuple.from((Object[])new Object[]{1L, 1627L}));
            List primaryKeys = results.stream().map(FDBQueriedRecord::getIndexEntry).map(Verify::verifyNotNull).map(IndexEntry::getPrimaryKey).collect(Collectors.toList());
            Assertions.assertEquals((Object)expectedPks, primaryKeys);
            this.commit(context);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchForAutoCompleteWithContinueTyping(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("simple_text_with_auto_complete_key");
        try (FDBRecordContext context = this.openContext();){
            this.addIndexAndSaveRecordForAutoComplete(context, index, indexedType.isSynthetic(), autoCompletes);
            LuceneIndexQueryPlan luceneIndexPlan = LuceneIndexQueryPlan.of((String)index.getName(), (LuceneScanParameters)this.autoCompleteScanParams("good mor", (Iterable<String>)ImmutableSet.of((Object)(indexedType.isSynthetic() ? "simple_text" : "text"))), (RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords)(indexedType.isSynthetic() ? RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.SYNTHETIC_CONSTITUENTS : RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY), (boolean)false, null, (List)ImmutableList.of((Object)(indexedType.isSynthetic() ? LuceneIndexTestUtils.JOINED_SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD : LuceneIndexTestUtils.SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD)));
            Assertions.assertEquals((Integer)indexedType.getPlanHashes().get(3), (int)luceneIndexPlan.planHash(PlanHashable.CURRENT_LEGACY));
            List results = (List)this.recordStore.executeQuery((RecordQueryPlan)luceneIndexPlan, null, ExecuteProperties.SERIAL_EXECUTE).asList().get();
            Assertions.assertEquals((int)1, (int)results.size());
            FDBQueriedRecord result = (FDBQueriedRecord)Iterables.getOnlyElement((Iterable)results);
            Message record = result.getRecord();
            if (indexedType.isSynthetic()) {
                record = (DynamicMessage)record.getField(record.getDescriptorForType().findFieldByName("simple"));
            }
            Descriptors.Descriptor descriptor = record.getDescriptorForType();
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName("text");
            String field = (String)Verify.verifyNotNull((Object)((String)record.getField(fieldDescriptor)));
            Assertions.assertEquals((Object)"Good morning", (Object)field);
            IndexEntry entry = result.getIndexEntry();
            Assertions.assertNotNull((Object)entry);
            Assertions.assertEquals((Object)1623L, (Object)(indexedType.isSynthetic() ? ((ArrayList)entry.getPrimaryKey().get(2)).get(0) : entry.getPrimaryKey().get(0)));
            LuceneIndexTest.assertAutoCompleteEntriesAndSegmentInfoStoredInCompoundFile(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
            this.commit(context);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchForAutoCompleteForGroupedRecord(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("map_on_value_index_with_auto_complete_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToMap(metaDataBuilder, index));
                this.createComplexRecordJoinedToMap(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "sampleTextPhrase", "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "sampleTextSong", true, System.currentTimeMillis(), 0);
            } else {
                this.openRecordStore(context, metaDataBuilder -> {
                    metaDataBuilder.removeIndex("SimpleDocument$text");
                    TextIndexTestUtils.addRecordTypePrefix((RecordMetaDataBuilder)metaDataBuilder);
                    metaDataBuilder.addIndex("MapDocument", index);
                });
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createMultiEntryMapDoc(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "sampleTextPhrase", "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "sampleTextSong", 2));
            }
            LuceneIndexQueryPlan luceneIndexPlan = LuceneIndexQueryPlan.of((String)index.getName(), (LuceneScanParameters)LuceneIndexTest.groupedAutoCompleteScanParams("Vision", "sampleTextPhrase", (Iterable<String>)ImmutableSet.of((Object)(indexedType.isSynthetic() ? "map_entry_value" : "entry_value"))), (RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords)(indexedType.isSynthetic() ? RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.SYNTHETIC_CONSTITUENTS : RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY), (boolean)false, null, indexedType.isSynthetic() ? LuceneIndexTestUtils.JOINED_MAP_ON_VALUE_INDEX_STORED_FIELDS : LuceneIndexTestUtils.MAP_ON_VALUE_INDEX_STORED_FIELDS);
            Assertions.assertEquals((Integer)indexedType.getPlanHashes().get(4), (int)luceneIndexPlan.planHash(PlanHashable.CURRENT_LEGACY));
            List results = (List)this.recordStore.executeQuery((RecordQueryPlan)luceneIndexPlan, null, ExecuteProperties.SERIAL_EXECUTE).asList().get();
            Assertions.assertEquals((int)1, (int)results.size());
            FDBQueriedRecord resultRecord = (FDBQueriedRecord)results.get(0);
            IndexEntry indexEntry = resultRecord.getIndexEntry();
            Assertions.assertNotNull((Object)indexEntry);
            Message message = resultRecord.getRecord();
            if (indexedType.isSynthetic()) {
                message = (DynamicMessage)message.getField(message.getDescriptorForType().findFieldByName("map"));
            }
            Descriptors.Descriptor recordDescriptor = TestRecordsTextProto.MapDocument.getDescriptor();
            Descriptors.FieldDescriptor docIdDescriptor = recordDescriptor.findFieldByName("doc_id");
            Assertions.assertEquals((Object)1623L, (Object)message.getField(docIdDescriptor));
            Descriptors.FieldDescriptor entryDescriptor = recordDescriptor.findFieldByName("entry");
            Message entry = (Message)message.getRepeatedField(entryDescriptor, 0);
            Descriptors.FieldDescriptor keyDescriptor = entryDescriptor.getMessageType().findFieldByName("key");
            Descriptors.FieldDescriptor valueDescriptor = entryDescriptor.getMessageType().findFieldByName("value");
            Assertions.assertEquals((Object)"sampleTextPhrase", (Object)entry.getField(keyDescriptor));
            Assertions.assertEquals((Object)"A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", (Object)entry.getField(valueDescriptor));
            LuceneIndexTest.assertAutoCompleteEntriesAndSegmentInfoStoredInCompoundFile(index, this.recordStore.indexSubspace(index).subspace(Tuple.from((Object[])new Object[]{"sampleTextPhrase"})), context, "_0.cfs");
            this.commit(context);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchForAutoCompleteExcludedFieldsForGroupedRecord(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("map_on_value_index_with_auto_complete_excluded_fields_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToMap(metaDataBuilder, index));
                this.createComplexRecordJoinedToMap(2, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "sampleTextPhrase", "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "sampleTextSong", true, System.currentTimeMillis(), 0);
            } else {
                this.openRecordStore(context, metaDataBuilder -> {
                    metaDataBuilder.removeIndex("SimpleDocument$text");
                    TextIndexTestUtils.addRecordTypePrefix((RecordMetaDataBuilder)metaDataBuilder);
                    metaDataBuilder.addIndex("MapDocument", index);
                });
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createMultiEntryMapDoc(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "sampleTextPhrase", "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "sampleTextSong", 2));
            }
            LuceneIndexQueryPlan luceneIndexPlan = LuceneIndexQueryPlan.of((String)index.getName(), (LuceneScanParameters)LuceneIndexTest.groupedAutoCompleteScanParams("Vision", "sampleTextPhrase", (Iterable<String>)ImmutableSet.of((Object)(indexedType.isSynthetic() ? "map_entry_second_value" : "entry_second_value"))), (RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords)(indexedType.isSynthetic() ? RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.SYNTHETIC_CONSTITUENTS : RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY), (boolean)false, null, indexedType.isSynthetic() ? LuceneIndexTestUtils.JOINED_MAP_ON_VALUE_INDEX_STORED_FIELDS : LuceneIndexTestUtils.MAP_ON_VALUE_INDEX_STORED_FIELDS);
            Assertions.assertEquals((Integer)indexedType.getPlanHashes().get(5), (int)luceneIndexPlan.planHash(PlanHashable.CURRENT_LEGACY));
            List results = (List)this.recordStore.executeQuery((RecordQueryPlan)luceneIndexPlan, null, ExecuteProperties.SERIAL_EXECUTE).asList().get();
            Assertions.assertEquals((int)0, (int)results.size());
            this.commit(context);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testAutoCompleteSearchForPhrase(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("simple_text_with_auto_complete_key");
        try (FDBRecordContext context = this.openContext();){
            ImmutableList storedFields = ImmutableList.of((Object)(indexedType.isSynthetic() ? LuceneIndexTestUtils.JOINED_SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD : LuceneIndexTestUtils.SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD));
            this.addIndexAndSaveRecordForAutoComplete(context, index, indexedType.isSynthetic(), autoCompletePhrases);
            this.queryAndAssertAutoCompleteSuggestionsReturned(index, indexedType.isSynthetic(), indexedType.isSynthetic() ? "simple" : null, (List<KeyExpression>)storedFields, "text", "united states", (List<String>)ImmutableList.of((Object)"united states of america", (Object)"united states is a country in the continent of america", (Object)"united kingdom, france, the states", (Object)"states united as a country", (Object)"states have been united as a country", (Object)"all the states united as a country", (Object)"all the states have been united as a country", (Object)"welcome to the united states of america", (Object)"The countries are united kingdom, france, the states"));
            this.queryAndAssertAutoCompleteSuggestionsReturned(index, indexedType.isSynthetic(), indexedType.isSynthetic() ? "simple" : null, (List<KeyExpression>)storedFields, "text", "\"united states \"", (List<String>)ImmutableList.of((Object)"united states of america", (Object)"united states is a country in the continent of america", (Object)"welcome to the united states of america"));
            this.queryAndAssertAutoCompleteSuggestionsReturned(index, indexedType.isSynthetic(), indexedType.isSynthetic() ? "simple" : null, (List<KeyExpression>)storedFields, "text", "\"united states\"", (List<String>)ImmutableList.of((Object)"united states of america", (Object)"united states is a country in the continent of america", (Object)"welcome to the united states of america"));
            this.queryAndAssertAutoCompleteSuggestionsReturned(index, indexedType.isSynthetic(), indexedType.isSynthetic() ? "simple" : null, (List<KeyExpression>)storedFields, "text", "\"united state\"", (List<String>)ImmutableList.of((Object)"united states of america", (Object)"united states is a country in the continent of america", (Object)"welcome to the united states of america"));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void autoCompletePhraseSearchIncludingStopWords(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("simple_text_with_auto_complete_key");
        try (FDBRecordContext context = this.openContext();){
            ImmutableList storedFields = ImmutableList.of((Object)(indexedType.isSynthetic() ? LuceneIndexTestUtils.JOINED_SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD : LuceneIndexTestUtils.SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD));
            this.addIndexAndSaveRecordForAutoComplete(context, index, indexedType.isSynthetic(), autoCompletePhrases);
            this.queryAndAssertAutoCompleteSuggestionsReturned(index, indexedType.isSynthetic(), indexedType.isSynthetic() ? "simple" : null, (List<KeyExpression>)storedFields, "text", "\"united states of ameri\"", (List<String>)ImmutableList.of((Object)"united states of america", (Object)"welcome to the united states of america"));
            this.queryAndAssertAutoCompleteSuggestionsReturned(index, indexedType.isSynthetic(), indexedType.isSynthetic() ? "simple" : null, (List<KeyExpression>)storedFields, "text", "\"united states of \"", (List<String>)ImmutableList.of((Object)"united states of america", (Object)"welcome to the united states of america", (Object)"united states is a country in the continent of america"));
            this.queryAndAssertAutoCompleteSuggestionsReturned(index, indexedType.isSynthetic(), indexedType.isSynthetic() ? "simple" : null, (List<KeyExpression>)storedFields, "text", "\"united states of\"", (List<String>)ImmutableList.of((Object)"united states of america", (Object)"welcome to the united states of america", (Object)"united states is a country in the continent of america"));
            this.queryAndAssertAutoCompleteSuggestionsReturned(index, indexedType.isSynthetic(), indexedType.isSynthetic() ? "simple" : null, (List<KeyExpression>)storedFields, "text", "\"united states o\"", (List<String>)ImmutableList.of());
            this.commit(context);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void autoCompletePhraseSearchWithLeadingStopWords(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("simple_text_with_auto_complete_key");
        try (FDBRecordContext context = this.openContext();){
            ImmutableList storedFields = ImmutableList.of((Object)(indexedType.isSynthetic() ? LuceneIndexTestUtils.JOINED_SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD : LuceneIndexTestUtils.SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD));
            this.addIndexAndSaveRecordForAutoComplete(context, index, indexedType.isSynthetic(), autoCompletePhrases);
            this.queryAndAssertAutoCompleteSuggestionsReturned(index, indexedType.isSynthetic(), indexedType.isSynthetic() ? "simple" : null, (List<KeyExpression>)storedFields, "text", "\"of ameri\"", (List<String>)ImmutableList.of((Object)"united states of america", (Object)"welcome to the united states of america", (Object)"united states is a country in the continent of america"));
            this.queryAndAssertAutoCompleteSuggestionsReturned(index, indexedType.isSynthetic(), indexedType.isSynthetic() ? "simple" : null, (List<KeyExpression>)storedFields, "text", "\"and of ameri\"", (List<String>)ImmutableList.of((Object)"united states of america", (Object)"welcome to the united states of america", (Object)"united states is a country in the continent of america"));
            this.commit(context);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testAutoCompleteSearchMultipleResultsSingleDocument(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("complex_multiple_text_indexes_with_auto_complete_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.createComplexRecordJoinedToSimple(2, 1597L, 1597L, "Good night! Good night! Parting is such sweet sorrow", "That I shall say good night till it be morrow", true, System.currentTimeMillis(), 0);
            } else {
                this.openRecordStore(context, metaDataBuilder -> {
                    metaDataBuilder.removeIndex("SimpleDocument$text");
                    metaDataBuilder.addIndex("ComplexDocument", index);
                });
                TestRecordsTextProto.ComplexDocument doc = TestRecordsTextProto.ComplexDocument.newBuilder().setDocId(1597L).setText("Good night! Good night! Parting is such sweet sorrow").setText2("That I shall say good night till it be morrow").build();
                this.recordStore.saveRecord((Message)doc);
            }
            LuceneIndexQueryPlan luceneIndexPlan = LuceneIndexQueryPlan.of((String)index.getName(), (LuceneScanParameters)this.autoCompleteScanParams("good night", (Iterable<String>)ImmutableSet.of((Object)(indexedType.isSynthetic() ? "simple_text" : "text"))), (RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords)(indexedType.isSynthetic() ? RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.SYNTHETIC_CONSTITUENTS : RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY), (boolean)false, null, indexedType.isSynthetic() ? LuceneIndexTestUtils.JOINED_COMPLEX_MULTI_GROUPED_WITH_AUTO_COMPLETE_STORED_FIELDS : LuceneIndexTestUtils.COMPLEX_MULTIPLE_TEXT_INDEXES_WITH_AUTO_COMPLETE_STORED_FIELDS);
            Assertions.assertEquals((Integer)indexedType.getPlanHashes().get(6), (int)luceneIndexPlan.planHash(PlanHashable.CURRENT_LEGACY));
            List results = (List)this.recordStore.executeQuery((RecordQueryPlan)luceneIndexPlan, null, ExecuteProperties.SERIAL_EXECUTE).asList().get();
            MatcherAssert.assertThat((Object)results, (Matcher)IsCollectionWithSize.hasSize((int)1));
            FDBQueriedRecord result = (FDBQueriedRecord)Iterables.getOnlyElement((Iterable)results);
            if (indexedType.isSynthetic()) {
                Assertions.assertEquals((Object)Tuple.from((Object[])new Object[]{-1, Tuple.from((Object[])new Object[]{2, 1597L}), Tuple.from((Object[])new Object[]{1597L})}), (Object)((IndexEntry)Verify.verifyNotNull((Object)result.getIndexEntry())).getPrimaryKey());
            } else {
                Assertions.assertEquals((Object)Tuple.from((Object[])new Object[]{null, 1597L}), (Object)((IndexEntry)Verify.verifyNotNull((Object)result.getIndexEntry())).getPrimaryKey());
            }
            this.commit(context);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testAutoCompleteSearchForPhraseWithoutFreqsAndPositions(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("simple_text_with_auto_complete_no_freqs_positions");
        try (FDBRecordContext context = this.openContext();){
            ImmutableList storedFields = ImmutableList.of((Object)index.getRootExpression());
            this.addIndexAndSaveRecordForAutoComplete(context, index, indexedType.isSynthetic(), autoCompletePhrases);
            Assertions.assertThrows(ExecutionException.class, () -> this.lambda$testAutoCompleteSearchForPhraseWithoutFreqsAndPositions$151(index, indexedType, (List)storedFields));
            this.commit(context);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void autoCompletePhraseSearchWithMixedCases(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("email_cjk_sym_text_with_auto_complete_key");
        try (FDBRecordContext context = this.openContext();){
            ImmutableList storedFields = ImmutableList.of((Object)(indexedType.isSynthetic() ? LuceneIndexTestUtils.JOINED_SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD : LuceneIndexTestUtils.SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD));
            this.addIndexAndSaveRecordForAutoComplete(context, index, indexedType.isSynthetic(), capitalizedAutoCaseCompletePhrases);
            BiFunction<String, List, Object> test = (arg_0, arg_1) -> this.lambda$autoCompletePhraseSearchWithMixedCases$152(index, indexedType, (List)storedFields, arg_0, arg_1);
            test.apply("\"STateS of AMeri\"", (List)ImmutableList.of((Object)"United States of America", (Object)"welcome to the United States of America"));
            test.apply("\"THE oF ameri\"", (List)ImmutableList.of((Object)"United States of America", (Object)"welcome to the United States of America", (Object)"United States is a country in the continent of America"));
            test.apply("\"THE\"", (List)ImmutableList.of((Object)"There is a country called Armenia"));
            this.commit(context);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void autoCompleteCjkPhraseSearch(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("email_cjk_sym_text_with_auto_complete_key");
        boolean isSynthetic = indexedType.isSynthetic();
        try (FDBRecordContext context = this.openContext();){
            ImmutableList storedFields = ImmutableList.of((Object)(isSynthetic ? LuceneIndexTestUtils.JOINED_SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD : LuceneIndexTestUtils.SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD));
            this.addIndexAndSaveRecordForAutoComplete(context, index, isSynthetic, autoCompleteCJKPhrases);
            BiFunction<String, List, Object> test = (arg_0, arg_1) -> this.lambda$autoCompleteCjkPhraseSearch$153(index, indexedType, (List)storedFields, arg_0, arg_1);
            test.apply("\"\u4e16\u4e0a\u65e0\"", (List)ImmutableList.of((Object)"\u4e16\u4e0a\u65e0\u96be\u4e8b", (Object)"\u4e16\u4e0a\u65e0English word"));
            test.apply("\"\u4e16\"", (List)ImmutableList.of((Object)"\u4e16\u4e0a\u65e0\u96be\u4e8b", (Object)"\u4e16\u4e0a\u65e0English word", (Object)"\u4e16\u306e\u4e2d\u306b\u96e3\u3057\u3044\u3053\u3068\u306a\u3093\u3066\u306a\u3044"));
            test.apply("\"\u306b\u96e3\u3057\u3044\"", (List)ImmutableList.of((Object)"\u4e16\u306e\u4e2d\u306b\u96e3\u3057\u3044\u3053\u3068\u306a\u3093\u3066\u306a\u3044"));
            test.apply("\"\u30b7\u30de\u30b9\"", (List)ImmutableList.of((Object)"\u30b7\u30de\u30b9\u98a8\u30c8\u96f7\u30f2", (Object)"\u30b7\u30de\u30b9\u98a8\u30c8 \uc2dc\ud5d8@\uae40\uce58\uc624\ub79c"));
            test.apply("\"\ud3c9\uac00\"", (List)ImmutableList.of((Object)"\ud3c9\uac00\ud588\ub2e4"));
            test.apply("\"\uc0c1\uc5d0 \uc5b4\"", (List)ImmutableList.of((Object)"\uc138\uc0c1\uc5d0 \uc5b4\ub824\uc6b4 \uc77c\uc740 \uc5c6\ub2e4"));
            this.commit(context);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void autoCompleteCjkEmailSearch(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("email_cjk_sym_text_with_auto_complete_key");
        boolean isSynthetic = indexedType.isSynthetic();
        try (FDBRecordContext context = this.openContext();){
            ImmutableList storedFields = ImmutableList.of((Object)(isSynthetic ? LuceneIndexTestUtils.JOINED_SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD : LuceneIndexTestUtils.SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD));
            this.addIndexAndSaveRecordForAutoComplete(context, index, isSynthetic, autoCompleteCJKPhrases);
            BiFunction<String, List, Object> test = (arg_0, arg_1) -> this.lambda$autoCompleteCjkEmailSearch$154(index, indexedType, (List)storedFields, arg_0, arg_1);
            test.apply("\"\u7528\u6237\"", (List)ImmutableList.of((Object)"\u7528\u6237@\u4f8b\u5b50.\u5e7f\u544a"));
            test.apply("\"\u7528\u6237\\@\"", (List)ImmutableList.of((Object)"\u7528\u6237@\u4f8b\u5b50.\u5e7f\u544a"));
            test.apply("\"\u3044\\@\u3059\u3057\"", (List)ImmutableList.of((Object)"\u304a\u3044\u3057\u3044@\u3059\u3057.\u3042\u3069 \u306a\u3093\u3066\u306a\u3044"));
            test.apply("\"\u30b7\u30a4\\@\u30b9\u30b7.\u30a2\u30c9\"", (List)ImmutableList.of((Object)"\u30aa\u30a4\u30b7\u30a4@\u30b9\u30b7.\u30a2\u30c9 \u306a\u3093\u3066\u306a\u3044"));
            test.apply("\"\uc2dc\ud5d8@\uae40\"", (List)ImmutableList.of((Object)"\uc2dc\ud5d8@\uae40\uce58\uc624\ub79c.\uad11\uace0", (Object)"\u30b7\u30de\u30b9\u98a8\u30c8 \uc2dc\ud5d8@\uae40\uce58\uc624\ub79c"));
            this.commit(context);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void autoCompleteMultiPhraseLuceneQuery(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("email_cjk_sym_text_with_auto_complete_key");
        boolean isSynthetic = indexedType.isSynthetic();
        try (FDBRecordContext context = this.openContext();){
            ImmutableList storedFields = ImmutableList.of((Object)(isSynthetic ? LuceneIndexTestUtils.JOINED_SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD : LuceneIndexTestUtils.SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD));
            this.addIndexAndSaveRecordForAutoComplete(context, index, isSynthetic, autoCompleteCJKPhrases);
            BiFunction<String, List, Object> test = (arg_0, arg_1) -> this.lambda$autoCompleteMultiPhraseLuceneQuery$155(index, indexedType, (List)storedFields, arg_0, arg_1);
            test.apply("\"\u3044\\@\u3059\u3057.\u3042\u3069 \u306a\u3093\u3042\u3069\"", (List)ImmutableList.of());
            test.apply("\"\u3044\\@\u3059\u3057.\u3042\u3069 \u306a\u3093\"", (List)ImmutableList.of((Object)"\u304a\u3044\u3057\u3044@\u3059\u3057.\u3042\u3069 \u306a\u3093\u3066\u306a\u3044"));
            test.apply("\"\u30b7\u30a4\\@\u30b9\u30b7.\u30a2\u30c9 \u306a\"", (List)ImmutableList.of((Object)"\u30aa\u30a4\u30b7\u30a4@\u30b9\u30b7.\u30a2\u30c9 \u306a\u3093\u3066\u306a\u3044"));
            test.apply("\"asb@icloud.com \uae40\uce58\uc624\"", (List)ImmutableList.of((Object)"asb@icloud.com \uae40\uce58\uc624\ub79c"));
            this.commit(context);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchForSpellCheck(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("spellcheck_index_key");
        try (FDBRecordContext context = this.openContext();){
            long docId;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                docId = 1623L;
                int i = 1;
                for (String word : spellcheckWords) {
                    this.createComplexRecordJoinedToSimple(i++, docId, docId++, word, "", false, System.currentTimeMillis(), 1);
                }
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                docId = 1623L;
                for (String word : spellcheckWords) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(docId++, word, 1));
                }
            }
            CompletableFuture resultsI = this.recordStore.scanIndex(index, (IndexScanBounds)this.spellCheck(index, "keyboad"), null, ScanProperties.FORWARD_SCAN).asList();
            List results = (List)resultsI.get();
            Assertions.assertEquals((int)1, (int)results.size());
            IndexEntry result = (IndexEntry)results.get(0);
            Assertions.assertEquals((Object)"keyboard", (Object)result.getKey().getString(1));
            Assertions.assertEquals((Object)(indexedType.isSynthetic() ? "simple_text" : "text"), (Object)result.getKey().getString(0));
            Assertions.assertEquals((Object)Float.valueOf(0.85714287f), (Object)result.getValue().get(0));
            List results2 = (List)this.recordStore.scanIndex(index, (IndexScanBounds)this.spellCheck(index, indexedType.isSynthetic() ? "simple_text:keyboad" : "text:keyboad"), null, ScanProperties.FORWARD_SCAN).asList().get();
            Assertions.assertEquals((int)1, (int)results2.size());
            IndexEntry result2 = (IndexEntry)results2.get(0);
            Assertions.assertEquals((Object)"keyboard", (Object)result2.getKey().get(1));
            Assertions.assertEquals((Object)(indexedType.isSynthetic() ? "simple_text" : "text"), (Object)result2.getKey().get(0));
            Assertions.assertEquals((Object)Float.valueOf(0.85714287f), (Object)result2.getValue().get(0));
            this.commit(context);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void searchForSpellcheckForGroupedRecord(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("map_on_value_index_key");
        try (FDBRecordContext context = this.openContext();){
            RecordType recordType;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToMap(metaDataBuilder, index));
                this.createComplexRecordJoinedToMap(1, 1623L, 1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "sampleTextPhrase", "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "sampleTextSong", true, System.currentTimeMillis(), 1);
                recordType = this.recordStore.getRecordMetaData().getSyntheticRecordType("luceneSyntheticComplexJoinedToMap");
            } else {
                this.openRecordStore(context, metaDataBuilder -> {
                    metaDataBuilder.removeIndex("SimpleDocument$text");
                    metaDataBuilder.addIndex("MapDocument", index);
                });
                recordType = this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createMultiEntryMapDoc(1623L, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "sampleTextPhrase", "There's always one more way to do things and that's your way, and you have a right to try it at least once.", "sampleTextSong", 2)).getRecordType();
            }
            List indexEntries = (List)this.recordStore.scanIndex(index, (IndexScanBounds)this.groupedSpellCheck(index, "Visin", "sampleTextPhrase"), null, ScanProperties.FORWARD_SCAN).asList().get();
            Assertions.assertEquals((int)1, (int)indexEntries.size());
            IndexEntry indexEntry = (IndexEntry)indexEntries.get(0);
            Assertions.assertEquals((Object)Float.valueOf(0.8f), (Object)indexEntry.getValue().get(0));
            Descriptors.Descriptor recordDescriptor = recordType.getDescriptor();
            IndexKeyValueToPartialRecord toPartialRecord = LuceneIndexKeyValueToPartialRecordUtils.getToPartialRecord((Index)index, (RecordType)recordType, (IndexScanType)LuceneScanTypes.BY_LUCENE_SPELL_CHECK);
            Message message = toPartialRecord.toRecord(recordDescriptor, indexEntry);
            if (indexedType.isSynthetic()) {
                message = (DynamicMessage)message.getField(message.getDescriptorForType().findFieldByName("map"));
                recordDescriptor = message.getDescriptorForType();
            }
            Descriptors.FieldDescriptor entryDescriptor = recordDescriptor.findFieldByName("entry");
            Message entry = (Message)message.getRepeatedField(entryDescriptor, 0);
            Descriptors.FieldDescriptor keyDescriptor = entryDescriptor.getMessageType().findFieldByName("key");
            Descriptors.FieldDescriptor valueDescriptor = entryDescriptor.getMessageType().findFieldByName("value");
            Assertions.assertEquals((Object)"sampleTextPhrase", (Object)entry.getField(keyDescriptor));
            Assertions.assertEquals((Object)"vision", (Object)entry.getField(valueDescriptor));
            this.commit(context);
        }
    }

    private void spellCheckHelper(Index index, @Nonnull String query, List<Pair<String, String>> expectedSuggestions) throws ExecutionException, InterruptedException {
        List suggestions = (List)this.recordStore.scanIndex(index, (IndexScanBounds)this.spellCheck(index, query), null, ScanProperties.FORWARD_SCAN).asList().get();
        Assertions.assertEquals((int)expectedSuggestions.size(), (int)suggestions.size());
        for (int i = 0; i < expectedSuggestions.size(); ++i) {
            MatcherAssert.assertThat((Object)((IndexEntry)suggestions.get(i)).getKey().get(1), (Matcher)Matchers.equalTo((Object)expectedSuggestions.get(i).getKey()));
            MatcherAssert.assertThat((Object)((IndexEntry)suggestions.get(i)).getKey().get(0), (Matcher)Matchers.equalTo((Object)expectedSuggestions.get(i).getValue()));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void spellCheckMultipleMatches(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("spellcheck_index_key");
        try (FDBRecordContext context = this.openContext();){
            long docId;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                docId = 1623L;
                int i = 1;
                for (String word : spellcheckWords) {
                    this.createComplexRecordJoinedToSimple(i++, docId, docId++, word, "", false, System.currentTimeMillis(), 1);
                }
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                docId = 1623L;
                for (String word : spellcheckWords) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(docId++, word, 1));
                }
            }
            String field = indexedType.isSynthetic() ? "simple_text" : "text";
            this.spellCheckHelper(index, "keyboad", List.of(Pair.of((Object)"keyboard", (Object)field)));
            this.spellCheckHelper(index, indexedType.isSynthetic() ? "simple_text:keyboad" : "text:keyboad", List.of(Pair.of((Object)"keyboard", (Object)field)));
            this.spellCheckHelper(index, "helo", List.of(Pair.of((Object)"hello", (Object)field), Pair.of((Object)"helm", (Object)field), Pair.of((Object)"help", (Object)field), Pair.of((Object)"helms", (Object)field), Pair.of((Object)"helps", (Object)field)));
            this.spellCheckHelper(index, "hello", List.of());
            this.spellCheckHelper(index, "mous", List.of(Pair.of((Object)"mouse", (Object)field)));
            List emptyList = List.of();
            Assertions.assertThrows(RecordCoreException.class, () -> this.spellCheckHelper(index, "wrongField:helo", emptyList), (String)"Invalid field name in Lucene index query");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void spellCheckComplexDocument(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("spellcheck_index_complex_key");
        try (FDBRecordContext context = this.openContext();){
            long docId;
            List<String> textList = List.of("beaver", "leopard", "hello", "help", "helm", "boat", "road", "foot", "tare", "tire");
            List<String> text2List = List.of("beavers", "lizards", "hell", "helps", "helms", "boot", "read", "fool", "tire", "tire");
            MatcherAssert.assertThat(text2List, (Matcher)IsCollectionWithSize.hasSize((int)textList.size()));
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                docId = 1623L;
                for (int i = 0; i < textList.size(); ++i) {
                    this.createComplexRecordJoinedToSimple(i, docId, docId++, textList.get(i), text2List.get(i), false, System.currentTimeMillis(), 1);
                }
            } else {
                this.rebuildIndexMetaData(context, "ComplexDocument", index);
                docId = 1623L;
                for (int i = 0; i < textList.size(); ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(docId++, textList.get(i), text2List.get(i), 1));
                }
            }
            String text = indexedType.isSynthetic() ? "simple_text" : "text";
            String text2 = indexedType.isSynthetic() ? "complex_text2" : "text2";
            this.spellCheckHelper(index, "baver", List.of(Pair.of((Object)"beaver", (Object)text), Pair.of((Object)"beavers", (Object)text2)));
            this.spellCheckHelper(index, text + ":baver", List.of(Pair.of((Object)"beaver", (Object)text)));
            this.spellCheckHelper(index, text2 + ":baver", List.of(Pair.of((Object)"beavers", (Object)text2)));
            this.spellCheckHelper(index, "lepard", List.of(Pair.of((Object)"leopard", (Object)text)));
            this.spellCheckHelper(index, text + ":lepard", List.of(Pair.of((Object)"leopard", (Object)text)));
            this.spellCheckHelper(index, text2 + ":lepard", List.of());
            this.spellCheckHelper(index, "lizerds", List.of(Pair.of((Object)"lizards", (Object)text2)));
            this.spellCheckHelper(index, text + ":lizerds", List.of());
            this.spellCheckHelper(index, text2 + ":lizerds", List.of(Pair.of((Object)"lizards", (Object)text2)));
            this.spellCheckHelper(index, "hela", List.of(Pair.of((Object)"hell", (Object)text2), Pair.of((Object)"helm", (Object)text), Pair.of((Object)"help", (Object)text), Pair.of((Object)"hello", (Object)text), Pair.of((Object)"helms", (Object)text2)));
            this.spellCheckHelper(index, "bost", List.of(Pair.of((Object)"boat", (Object)text), Pair.of((Object)"boot", (Object)text2)));
            this.spellCheckHelper(index, "rlad", List.of(Pair.of((Object)"read", (Object)text2), Pair.of((Object)"road", (Object)text)));
            this.spellCheckHelper(index, "foml", List.of(Pair.of((Object)"fool", (Object)text2), Pair.of((Object)"foot", (Object)text)));
            this.spellCheckHelper(index, "tbre", List.of(Pair.of((Object)"tire", (Object)text2), Pair.of((Object)"tare", (Object)text)));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testDeleteWhereSimple(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        TestRecordsTextProto.SimpleDocument simple = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(1066L).setText("foo bar").setGroup(1L).build();
        try (FDBRecordContext context = this.openContext();){
            Tuple primaryKey;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> {
                    this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index);
                    TextIndexTestUtils.addRecordTypePrefix((RecordMetaDataBuilder)metaDataBuilder);
                    metaDataBuilder.getRecordType("SimpleDocument").setPrimaryKey((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.recordType(), (KeyExpression)Key.Expressions.field((String)"text"), (KeyExpression[])new KeyExpression[0]));
                });
                primaryKey = this.createComplexRecordJoinedToSimple(1, 1066L, 1066L, "foo bar", "bar foo", false, System.currentTimeMillis(), 1, null);
            } else {
                this.openRecordStore(context, metaDataBuilder -> {
                    TextIndexTestUtils.addRecordTypePrefix((RecordMetaDataBuilder)metaDataBuilder);
                    metaDataBuilder.removeIndex("SimpleDocument$text");
                    metaDataBuilder.addIndex("SimpleDocument", index);
                    metaDataBuilder.getRecordType("SimpleDocument").setPrimaryKey((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.recordType(), (KeyExpression)Key.Expressions.field((String)"text"), (KeyExpression[])new KeyExpression[0]));
                });
                primaryKey = this.recordStore.saveRecord((Message)simple).getPrimaryKey();
            }
            QueryComponent qc = com.apple.foundationdb.record.query.expressions.Query.field((String)"text").equalsValue((Object)"foo bar");
            Query.InvalidExpressionException err = (Query.InvalidExpressionException)Assertions.assertThrows(Query.InvalidExpressionException.class, () -> this.recordStore.deleteRecordsWhere("SimpleDocument", indexedType.isSynthetic() ? com.apple.foundationdb.record.query.expressions.Query.field((String)"simple").matches(qc) : qc));
            MatcherAssert.assertThat((Object)err.getMessage(), (Matcher)Matchers.containsString((String)(indexedType.isSynthetic() ? "deleteRecordsWhere not matching primary key SimpleDocument" : "deleteRecordsWhere not supported by index " + index.getName())));
            FDBStoredRecord storedRecord = indexedType.isSynthetic() ? ((FDBSyntheticRecord)this.recordStore.loadSyntheticRecord(primaryKey).get()).getConstituent("simple") : this.recordStore.loadRecord(primaryKey);
            Assertions.assertNotNull((Object)storedRecord);
            Assertions.assertEquals((Object)simple, (Object)TestRecordsTextProto.SimpleDocument.newBuilder().mergeFrom(storedRecord.getRecord()).build());
            this.commit(context);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testDeleteWhereComplexGrouped(LuceneIndexTestUtils.IndexedType indexedType) {
        FDBRecordContext context;
        FDBRecordStoreTestBase.RecordMetaDataHook hook;
        Index index = indexedType.getIndex("complex_multiple_grouped_key");
        TestRecordsTextProto.ComplexDocument zeroGroupDoc = TestRecordsTextProto.ComplexDocument.newBuilder().setGroup(0L).setDocId(1623L).setText("Two households, both alike in dignity,\nIn fair Verona, where we lay our scene,\nFrom ancient grudge break to new mutiny,\nWhere civil blood makes civil hands unclean.\nFrom forth the fatal loins of these two foes\nA pair of star-cross\u2019d lovers take their life;\nWhose misadventur\u2019d piteous overthrows\nDoth with their death bury their parents\u2019 strife.\nThe fearful passage of their death-mark\u2019d love,\nAnd the continuance of their parents\u2019 rage,\nWhich, but their children\u2019s end, nought could remove,\nIs now the two hours\u2019 traffic of our stage;\nThe which, if you with patient ears attend,\nWhat here shall miss, our toil shall strive to mend.").setText2("The Angstrom unit (\u212b) was named after Anders \u00c5ngstr\u00f6m.").setScore(0).build();
        TestRecordsTextProto.ComplexDocument oneGroupDoc = TestRecordsTextProto.ComplexDocument.newBuilder().setGroup(1L).setDocId(1624L).setText("Two households, both alike in dignity,\nIn fair Verona, where we lay our scene,\nFrom ancient grudge break to new mutiny,\nWhere civil blood makes civil hands unclean.\nFrom forth the fatal loins of these two foes\nA pair of star-cross\u2019d lovers take their life;\nWhose misadventur\u2019d piteous overthrows\nDoth with their death bury their parents\u2019 strife.\nThe fearful passage of their death-mark\u2019d love,\nAnd the continuance of their parents\u2019 rage,\nWhich, but their children\u2019s end, nought could remove,\nIs now the two hours\u2019 traffic of our stage;\nThe which, if you with patient ears attend,\nWhat here shall miss, our toil shall strive to mend.").setText2("The Angstrom unit (\u212b) was named after Anders \u00c5ngstr\u00f6m.").setScore(1).build();
        if (indexedType.isSynthetic()) {
            hook = metaDataBuilder -> {
                TextIndexTestUtils.addRecordTypePrefix((RecordMetaDataBuilder)metaDataBuilder);
                this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index);
                metaDataBuilder.getRecordType("ComplexDocument").setPrimaryKey((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.recordType(), (KeyExpression)Key.Expressions.concatenateFields((String)"score", (String)"doc_id", (String[])new String[0]), (KeyExpression[])new KeyExpression[0]));
            };
            context = this.openContext();
            try {
                this.openRecordStore(context, hook);
                TestRecordsTextProto.SimpleDocument simpleDocument = LuceneIndexTestUtils.createSimpleDocument(1623L, "Two households, both alike in dignity,\nIn fair Verona, where we lay our scene,\nFrom ancient grudge break to new mutiny,\nWhere civil blood makes civil hands unclean.\nFrom forth the fatal loins of these two foes\nA pair of star-cross\u2019d lovers take their life;\nWhose misadventur\u2019d piteous overthrows\nDoth with their death bury their parents\u2019 strife.\nThe fearful passage of their death-mark\u2019d love,\nAnd the continuance of their parents\u2019 rage,\nWhich, but their children\u2019s end, nought could remove,\nIs now the two hours\u2019 traffic of our stage;\nThe which, if you with patient ears attend,\nWhat here shall miss, our toil shall strive to mend.", 0);
                this.recordStore.getRecordMetaData().getSyntheticRecordType("luceneSyntheticComplexJoinedToSimple").getRecordTypeKeyTuple();
                this.recordStore.saveRecord((Message)simpleDocument);
                this.recordStore.saveRecord((Message)zeroGroupDoc);
                simpleDocument = LuceneIndexTestUtils.createSimpleDocument(1624L, "Two households, both alike in dignity,\nIn fair Verona, where we lay our scene,\nFrom ancient grudge break to new mutiny,\nWhere civil blood makes civil hands unclean.\nFrom forth the fatal loins of these two foes\nA pair of star-cross\u2019d lovers take their life;\nWhose misadventur\u2019d piteous overthrows\nDoth with their death bury their parents\u2019 strife.\nThe fearful passage of their death-mark\u2019d love,\nAnd the continuance of their parents\u2019 rage,\nWhich, but their children\u2019s end, nought could remove,\nIs now the two hours\u2019 traffic of our stage;\nThe which, if you with patient ears attend,\nWhat here shall miss, our toil shall strive to mend.", 1);
                this.recordStore.getRecordMetaData().getSyntheticRecordType("luceneSyntheticComplexJoinedToSimple").getRecordTypeKeyTuple();
                this.recordStore.saveRecord((Message)simpleDocument);
                this.recordStore.saveRecord((Message)oneGroupDoc);
                this.commit(context);
            }
            finally {
                if (context != null) {
                    context.close();
                }
            }
        }
        hook = metaDataBuilder -> {
            TextIndexTestUtils.addRecordTypePrefix((RecordMetaDataBuilder)metaDataBuilder);
            metaDataBuilder.addIndex("ComplexDocument", index);
        };
        context = this.openContext();
        try {
            this.openRecordStore(context, hook);
            this.recordStore.saveRecord((Message)zeroGroupDoc);
            this.recordStore.saveRecord((Message)oneGroupDoc);
            this.commit(context);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.openRecordStore(context, hook);
            RecordQuery recordQuery = indexedType.isSynthetic() ? RecordQuery.newBuilder().setRecordType("luceneSyntheticComplexJoinedToSimple").setFilter(com.apple.foundationdb.record.query.expressions.Query.and((QueryComponent)com.apple.foundationdb.record.query.expressions.Query.field((String)"complex").matches(com.apple.foundationdb.record.query.expressions.Query.field((String)"score").equalsParameter("group_value")), (QueryComponent)new LuceneQueryComponent("simple_text:\"continuance\" AND complex_text2:\"named\"", List.of("simple_text", "complex_text2")), (QueryComponent[])new QueryComponent[0])).build() : RecordQuery.newBuilder().setRecordType("ComplexDocument").setFilter(com.apple.foundationdb.record.query.expressions.Query.and((QueryComponent)com.apple.foundationdb.record.query.expressions.Query.field((String)"group").equalsParameter("group_value"), (QueryComponent)new LuceneQueryComponent("text:\"continuance\" AND text2:\"named\"", List.of("text", "text2")), (QueryComponent[])new QueryComponent[0])).build();
            LucenePlanner planner = new LucenePlanner(this.recordStore.getRecordMetaData(), this.recordStore.getRecordStoreState(), PlannableIndexTypes.DEFAULT, this.recordStore.getTimer());
            RecordQueryPlan plan = planner.plan(recordQuery);
            MatcherAssert.assertThat((Object)plan, (Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)index.getName()), LucenePlanMatchers.scanParams((Matcher<IndexScanParameters>)Matchers.allOf(LucenePlanMatchers.group((Matcher<ScanComparisons>)PlanMatchers.hasTupleString((String)"[EQUALS $group_value]")), LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)(indexedType.isSynthetic() ? "simple_text:\"continuance\" AND complex_text2:\"named\"" : "text:\"continuance\" AND text2:\"named\""))))))));
            Assertions.assertEquals(Collections.singletonList(zeroGroupDoc), plan.execute(this.recordStore, EvaluationContext.forBinding((String)"group_value", (Object)zeroGroupDoc.getGroup())).map(r -> {
                if (indexedType.isSynthetic()) {
                    return r.getConstituent("complex").getRecord();
                }
                return r.getRecord();
            }).map(rec -> TestRecordsTextProto.ComplexDocument.newBuilder().mergeFrom(rec).build()).asList().join());
            Assertions.assertEquals(Collections.singletonList(oneGroupDoc), plan.execute(this.recordStore, EvaluationContext.forBinding((String)"group_value", (Object)oneGroupDoc.getGroup())).map(r -> {
                if (indexedType.isSynthetic()) {
                    return r.getConstituent("complex").getRecord();
                }
                return r.getRecord();
            }).map(rec -> TestRecordsTextProto.ComplexDocument.newBuilder().mergeFrom(rec).build()).asList().join());
            if (indexedType.isSynthetic()) {
                Assertions.assertThrows(Query.InvalidExpressionException.class, () -> this.recordStore.deleteRecordsWhere("ComplexDocument", com.apple.foundationdb.record.query.expressions.Query.field((String)"score").equalsValue((Object)zeroGroupDoc.getScore())));
                return;
            }
            this.recordStore.deleteRecordsWhere("ComplexDocument", com.apple.foundationdb.record.query.expressions.Query.field((String)"group").equalsValue((Object)zeroGroupDoc.getGroup()));
            Assertions.assertEquals(Collections.emptyList(), plan.execute(this.recordStore, EvaluationContext.forBinding((String)"group_value", (Object)zeroGroupDoc.getGroup())).map(FDBRecord::getRecord).map(rec -> TestRecordsTextProto.ComplexDocument.newBuilder().mergeFrom(rec).build()).asList().join());
            Assertions.assertEquals(Collections.singletonList(oneGroupDoc), plan.execute(this.recordStore, EvaluationContext.forBinding((String)"group_value", (Object)oneGroupDoc.getGroup())).map(FDBRecord::getRecord).map(rec -> TestRecordsTextProto.ComplexDocument.newBuilder().mergeFrom(rec).build()).asList().join());
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testDeleteWhereAutoComplete(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("complex_multi_grouped_with_auto_complete_key");
        String groupField = indexedType.isSynthetic() ? "score" : "group";
        FDBRecordStoreTestBase.RecordMetaDataHook hook = indexedType.isSynthetic() ? metaDataBuilder -> {
            TextIndexTestUtils.addRecordTypePrefix((RecordMetaDataBuilder)metaDataBuilder);
            this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index);
        } : metaDataBuilder -> {
            TextIndexTestUtils.addRecordTypePrefix((RecordMetaDataBuilder)metaDataBuilder);
            metaDataBuilder.addIndex("ComplexDocument", index);
        };
        int maxGroup = 10;
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, hook, groupField);
            for (int group = 0; group < 10; ++group) {
                for (long docId = 0L; docId < 10L; ++docId) {
                    if (indexedType.isSynthetic()) {
                        int newId = group + (int)docId;
                        this.createComplexRecordJoinedToSimple(newId, newId, newId, "\u0c32\u0c47\u0c26\u0c3e \u0c05\u0c26\u0c3f \u0c05\u0c30\u0c4d\u0c27\u0c02\u0c32\u0c47\u0c28\u0c3f\u0c26\u0c47\u0c28\u0c3e?", "hello there " + group, false, System.currentTimeMillis(), group);
                        continue;
                    }
                    TestRecordsTextProto.ComplexDocument doc = TestRecordsTextProto.ComplexDocument.newBuilder().setGroup((long)group).setDocId(docId).setText("hello there " + group).setText2("\u0c32\u0c47\u0c26\u0c3e \u0c05\u0c26\u0c3f \u0c05\u0c30\u0c4d\u0c27\u0c02\u0c32\u0c47\u0c28\u0c3f\u0c26\u0c47\u0c28\u0c3e?").build();
                    this.recordStore.saveRecord((Message)doc);
                }
            }
            this.commit(context);
        }
        context = this.openContext();
        try {
            this.openRecordStore(context, hook, groupField);
            for (long group = 0L; group < 10L; ++group) {
                LuceneIndexQueryPlan luceneIndexPlan = LuceneIndexQueryPlan.of((String)index.getName(), (LuceneScanParameters)LuceneIndexTest.groupedAutoCompleteScanParams("hello", group, (Iterable<String>)(indexedType.isSynthetic() ? ImmutableList.of((Object)"simple_text", (Object)"complex_text2") : ImmutableList.of((Object)"text", (Object)"text2"))), (RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords)(indexedType.isSynthetic() ? RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.SYNTHETIC_CONSTITUENTS : RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY), (boolean)false, null, indexedType.isSynthetic() ? LuceneIndexTestUtils.JOINED_COMPLEX_MULTI_GROUPED_WITH_AUTO_COMPLETE_STORED_FIELDS : LuceneIndexTestUtils.COMPLEX_MULTI_GROUPED_WITH_AUTO_COMPLETE_STORED_FIELDS);
                List results = (List)this.recordStore.executeQuery((RecordQueryPlan)luceneIndexPlan, null, ExecuteProperties.SERIAL_EXECUTE).asList().get();
                MatcherAssert.assertThat((Object)results, (Matcher)IsCollectionWithSize.hasSize((int)10));
                int docId = 0;
                for (FDBQueriedRecord result : results) {
                    Message record = result.getRecord();
                    if (indexedType.isSynthetic()) {
                        record = (DynamicMessage)record.getField(record.getDescriptorForType().findFieldByName("complex"));
                    }
                    Descriptors.Descriptor descriptor = record.getDescriptorForType();
                    Descriptors.FieldDescriptor textFieldDescriptor = descriptor.findFieldByName(indexedType.isSynthetic() ? "text2" : "text");
                    Assertions.assertTrue((boolean)record.hasField(textFieldDescriptor));
                    String textField = (String)record.getField(textFieldDescriptor);
                    Assertions.assertEquals((Object)("hello there " + group), (Object)textField);
                    IndexEntry entry = result.getIndexEntry();
                    Assertions.assertNotNull((Object)entry);
                    Tuple primaryKey = entry.getPrimaryKey();
                    Assertions.assertEquals((Object)group, (Object)(indexedType.isSynthetic() ? ((ArrayList)primaryKey.get(1)).get(1) : primaryKey.get(1)));
                    Assertions.assertEquals((Object)(indexedType.isSynthetic() ? group + (long)docId : (long)docId), (Object)(indexedType.isSynthetic() ? ((ArrayList)primaryKey.get(1)).get(2) : primaryKey.get(2)));
                    ++docId;
                }
            }
            int groupToDelete = 5;
            if (indexedType.isSynthetic()) {
                Assertions.assertThrows(Query.InvalidExpressionException.class, () -> this.recordStore.deleteRecordsWhere("ComplexDocument", com.apple.foundationdb.record.query.expressions.Query.field((String)"score").equalsValue((Object)5)));
                return;
            }
            this.recordStore.deleteRecordsWhere("ComplexDocument", com.apple.foundationdb.record.query.expressions.Query.field((String)"group").equalsValue((Object)5));
            for (long group = 0L; group < 10L; ++group) {
                LuceneIndexQueryPlan luceneIndexPlan = LuceneIndexQueryPlan.of((String)index.getName(), (LuceneScanParameters)LuceneIndexTest.groupedAutoCompleteScanParams("hello", group, (Iterable<String>)ImmutableList.of((Object)"text", (Object)"text2")), (RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords)RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY, (boolean)false, null, LuceneIndexTestUtils.COMPLEX_MULTI_GROUPED_WITH_AUTO_COMPLETE_STORED_FIELDS);
                List results = (List)this.recordStore.executeQuery((RecordQueryPlan)luceneIndexPlan, null, ExecuteProperties.SERIAL_EXECUTE).asList().get();
                if (group == 5L) {
                    MatcherAssert.assertThat((Object)results, (Matcher)Matchers.empty());
                    continue;
                }
                MatcherAssert.assertThat((Object)results, (Matcher)IsCollectionWithSize.hasSize((int)10));
                int docId = 0;
                for (FDBQueriedRecord result : results) {
                    Message record = result.getRecord();
                    Descriptors.Descriptor descriptor = record.getDescriptorForType();
                    Descriptors.FieldDescriptor textFieldDescriptor = descriptor.findFieldByName("text");
                    Assertions.assertTrue((boolean)record.hasField(textFieldDescriptor));
                    String textField = (String)record.getField(textFieldDescriptor);
                    Assertions.assertEquals((Object)("hello there " + group), (Object)textField);
                    IndexEntry entry = result.getIndexEntry();
                    Assertions.assertNotNull((Object)entry);
                    Tuple primaryKey = entry.getPrimaryKey();
                    Assertions.assertEquals((Object)group, (Object)primaryKey.get(1));
                    Assertions.assertEquals((Object)docId, (Object)primaryKey.get(2));
                    ++docId;
                }
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @Test
    void analyzerPerField() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "ComplexDocument", MULTIPLE_ANALYZER_LUCENE_INDEX);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "Hello, I am working on record layer", "Hello, I am working on FoundationDB", 1));
            this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{1L, 1623L})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(MULTIPLE_ANALYZER_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(MULTIPLE_ANALYZER_LUCENE_INDEX, "text:hullo"), null, ScanProperties.FORWARD_SCAN));
            this.assertIndexEntryPrimaryKeyTuples(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(MULTIPLE_ANALYZER_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(MULTIPLE_ANALYZER_LUCENE_INDEX, "text2:hullo"), null, ScanProperties.FORWARD_SCAN));
            this.assertIndexEntryPrimaryKeyTuples(Collections.emptySet(), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(MULTIPLE_ANALYZER_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(MULTIPLE_ANALYZER_LUCENE_INDEX, "text:orkin"), null, ScanProperties.FORWARD_SCAN));
            this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{1L, 1623L})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(MULTIPLE_ANALYZER_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(MULTIPLE_ANALYZER_LUCENE_INDEX, "text2:orkin"), null, ScanProperties.FORWARD_SCAN));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void testSimpleAutoComplete(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("auto_complete_simple_lucene_index_key");
        try (FDBRecordContext context = this.openContext();){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                this.createComplexRecordJoinedToSimple(1, 1623L, 1623L, "Hello, I am working on record layer", "Hello, I am working on FoundationDB", false, System.currentTimeMillis(), 1);
                this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{-1, Tuple.from((Object[])new Object[]{1L, 1623L}), Tuple.from((Object[])new Object[]{1623})})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.autoCompleteBounds(index, "record layer", (Iterable<String>)ImmutableSet.of((Object)"simple_text")), null, ScanProperties.FORWARD_SCAN));
            } else {
                this.rebuildIndexMetaData(context, "ComplexDocument", index);
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "Hello, I am working on record layer", "Hello, I am working on FoundationDB", 1));
                this.assertIndexEntryPrimaryKeyTuples(Set.of(Tuple.from((Object[])new Object[]{1L, 1623L})), (RecordCursor<IndexEntry>)this.recordStore.scanIndex(index, (IndexScanBounds)this.autoCompleteBounds(index, "record layer", (Iterable<String>)ImmutableSet.of((Object)"text")), null, ScanProperties.FORWARD_SCAN));
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void basicLuceneCursorTest(LuceneIndexTestUtils.IndexedType indexedType) {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        try (FDBRecordContext context = this.openContext();){
            int i;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                for (i = 0; i < 20; ++i) {
                    this.createComplexRecordJoinedToSimple(i, 1600L + (long)i, 1600L + (long)i, "testing text" + i, "", false, System.currentTimeMillis(), 1);
                }
                this.timer.reset();
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                for (i = 0; i < 20; ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1600L + (long)i, "testing text" + i, 1));
                }
            }
            RecordCursor indexEntries = this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"testing\""), null, ScanProperties.FORWARD_SCAN);
            List entries = (List)indexEntries.asList().join();
            Assertions.assertEquals((int)20, (int)entries.size());
            Assertions.assertEquals((int)20, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void luceneCursorTestWithMultiplePages(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        RecordLayerPropertyStorage.Builder storageBuilder = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_INDEX_CURSOR_PAGE_SIZE, (Object)10);
        try (FDBRecordContext context = this.openContext(storageBuilder);){
            int i;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                for (i = 0; i < 20; ++i) {
                    this.createComplexRecordJoinedToSimple(i, 1600L + (long)i, 1600L + (long)i, "testing text" + i, "", false, System.currentTimeMillis(), 1);
                }
                this.timer.reset();
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                for (i = 0; i < 20; ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1600L + (long)i, "testing text" + i, 1));
                }
            }
            ScanProperties scanProperties = new ScanProperties(ExecuteProperties.newBuilder().setIsolationLevel(IsolationLevel.SERIALIZABLE).build());
            RecordCursor indexEntries = this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"testing\""), null, scanProperties);
            List entries = (List)indexEntries.asList().join();
            Assertions.assertEquals((int)20, (int)entries.size());
            Assertions.assertEquals((int)20, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            Assertions.assertEquals((Object)RecordCursor.NoNextReason.SOURCE_EXHAUSTED, (Object)((RecordCursorResult)indexEntries.onNext().get()).getNoNextReason());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void luceneCursorTestWith3rdPage(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        RecordLayerPropertyStorage.Builder storageBuilder = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_INDEX_CURSOR_PAGE_SIZE, (Object)10);
        try (FDBRecordContext context = this.openContext(storageBuilder);){
            int i;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                for (i = 0; i < 21; ++i) {
                    this.createComplexRecordJoinedToSimple(i, 1600L + (long)i, 1600L + (long)i, "testing text" + i, "", false, System.currentTimeMillis(), 1);
                }
                this.timer.reset();
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                for (i = 0; i < 21; ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1600L + (long)i, "testing text" + i, 1));
                }
            }
            ScanProperties scanProperties = new ScanProperties(ExecuteProperties.newBuilder().setIsolationLevel(IsolationLevel.SERIALIZABLE).build());
            RecordCursor indexEntries = this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"testing\""), null, scanProperties);
            List entries = (List)indexEntries.asList().join();
            Assertions.assertEquals((int)21, (int)entries.size());
            Assertions.assertEquals((int)21, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            Assertions.assertEquals((Object)RecordCursor.NoNextReason.SOURCE_EXHAUSTED, (Object)((RecordCursorResult)indexEntries.onNext().get()).getNoNextReason());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void luceneCursorTestWithMultiplePagesWithSkip(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        RecordLayerPropertyStorage.Builder storageBuilder = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_INDEX_CURSOR_PAGE_SIZE, (Object)10);
        try (FDBRecordContext context = this.openContext(storageBuilder);){
            int i;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                for (i = 0; i < 31; ++i) {
                    this.createComplexRecordJoinedToSimple(i, 1600L + (long)i, 1600L + (long)i, "testing text" + i, "", false, System.currentTimeMillis(), 1);
                }
                this.timer.reset();
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                for (i = 0; i < 31; ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1600L + (long)i, "testing text" + i, 1));
                }
            }
            ScanProperties scanProperties = new ScanProperties(ExecuteProperties.newBuilder().setIsolationLevel(IsolationLevel.SERIALIZABLE).setSkip(12).build());
            RecordCursor indexEntries = this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"testing\""), null, scanProperties);
            List entries = (List)indexEntries.asList().join();
            Assertions.assertEquals((int)19, (int)entries.size());
            Assertions.assertEquals((int)19, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            Assertions.assertEquals((Object)RecordCursor.NoNextReason.SOURCE_EXHAUSTED, (Object)((RecordCursorResult)indexEntries.onNext().get()).getNoNextReason());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void luceneCursorTestWithLimit(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        RecordLayerPropertyStorage.Builder storageBuilder = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_INDEX_CURSOR_PAGE_SIZE, (Object)10);
        try (FDBRecordContext context = this.openContext(storageBuilder);){
            int i;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                for (i = 0; i < 21; ++i) {
                    this.createComplexRecordJoinedToSimple(i, 1600L + (long)i, 1600L + (long)i, "testing text" + i, "", false, System.currentTimeMillis(), 1);
                }
                this.timer.reset();
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                for (i = 0; i < 21; ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1600L + (long)i, "testing text" + i, 1));
                }
            }
            ScanProperties scanProperties = new ScanProperties(ExecuteProperties.newBuilder().setIsolationLevel(IsolationLevel.SERIALIZABLE).setReturnedRowLimit(8).build());
            RecordCursor indexEntries = this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"testing\""), null, scanProperties);
            List entries = (List)indexEntries.asList().join();
            Assertions.assertEquals((int)8, (int)entries.size());
            Assertions.assertEquals((int)8, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            RecordCursorResult lastResult = (RecordCursorResult)indexEntries.onNext().get();
            Assertions.assertEquals((Object)RecordCursor.NoNextReason.RETURN_LIMIT_REACHED, (Object)lastResult.getNoNextReason());
            indexEntries = this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"testing\""), lastResult.getContinuation().toBytes(), scanProperties);
            entries = (List)indexEntries.asList().join();
            Assertions.assertEquals((int)8, (int)entries.size());
            Assertions.assertEquals((int)16, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            lastResult = (RecordCursorResult)indexEntries.onNext().get();
            Assertions.assertEquals((Object)RecordCursor.NoNextReason.RETURN_LIMIT_REACHED, (Object)lastResult.getNoNextReason());
            indexEntries = this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"testing\""), lastResult.getContinuation().toBytes(), scanProperties);
            entries = (List)indexEntries.asList().join();
            Assertions.assertEquals((int)5, (int)entries.size());
            Assertions.assertEquals((int)21, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            Assertions.assertEquals((Object)RecordCursor.NoNextReason.SOURCE_EXHAUSTED, (Object)((RecordCursorResult)indexEntries.onNext().get()).getNoNextReason());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void luceneCursorTestWithLimitAndSkip(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        RecordLayerPropertyStorage.Builder storageBuilder = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_INDEX_CURSOR_PAGE_SIZE, (Object)10);
        try (FDBRecordContext context = this.openContext(storageBuilder);){
            int i;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                for (i = 0; i < 21; ++i) {
                    this.createComplexRecordJoinedToSimple(i, 1600L + (long)i, 1600L + (long)i, "testing text" + i, "", false, System.currentTimeMillis(), 1);
                }
                this.timer.reset();
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                for (i = 0; i < 21; ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1600L + (long)i, "testing text" + i, 1));
                }
            }
            ScanProperties scanProperties = new ScanProperties(ExecuteProperties.newBuilder().setIsolationLevel(IsolationLevel.SERIALIZABLE).setReturnedRowLimit(8).setSkip(2).build());
            RecordCursor indexEntries = this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"testing\""), null, scanProperties);
            List entries = (List)indexEntries.asList().join();
            Assertions.assertEquals((int)8, (int)entries.size());
            Assertions.assertEquals((int)8, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            RecordCursorResult lastResult = (RecordCursorResult)indexEntries.onNext().get();
            Assertions.assertEquals((Object)RecordCursor.NoNextReason.RETURN_LIMIT_REACHED, (Object)lastResult.getNoNextReason());
            scanProperties = new ScanProperties(ExecuteProperties.newBuilder().setIsolationLevel(IsolationLevel.SERIALIZABLE).setReturnedRowLimit(8).build());
            indexEntries = this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"testing\""), lastResult.getContinuation().toBytes(), scanProperties);
            entries = (List)indexEntries.asList().join();
            Assertions.assertEquals((int)8, (int)entries.size());
            Assertions.assertEquals((int)16, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            lastResult = (RecordCursorResult)indexEntries.onNext().get();
            Assertions.assertEquals((Object)RecordCursor.NoNextReason.RETURN_LIMIT_REACHED, (Object)lastResult.getNoNextReason());
            indexEntries = this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"testing\""), lastResult.getContinuation().toBytes(), scanProperties);
            entries = (List)indexEntries.asList().join();
            Assertions.assertEquals((int)3, (int)entries.size());
            Assertions.assertEquals((int)19, (int)this.getCounter(context, (StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY).getCount());
            Assertions.assertEquals((Object)RecordCursor.NoNextReason.SOURCE_EXHAUSTED, (Object)((RecordCursorResult)indexEntries.onNext().get()).getNoNextReason());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"com.apple.foundationdb.record.lucene.LuceneIndexTestUtils#luceneIndexMapParams"})
    void luceneCursorTestAllMatchesSkipped(LuceneIndexTestUtils.IndexedType indexedType) throws Exception {
        Index index = indexedType.getIndex("simple_text_suffixes_key");
        RecordLayerPropertyStorage.Builder storageBuilder = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_INDEX_CURSOR_PAGE_SIZE, (Object)10);
        try (FDBRecordContext context = this.openContext(storageBuilder);){
            int i;
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                for (i = 0; i < 6; ++i) {
                    this.createComplexRecordJoinedToSimple(i, 1600L + (long)i, 1600L + (long)i, "testing text" + i, "", false, System.currentTimeMillis(), 1);
                }
                this.timer.reset();
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                for (i = 0; i < 6; ++i) {
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1600L + (long)i, "testing text" + i, 1));
                }
            }
            ScanProperties scanProperties = new ScanProperties(ExecuteProperties.newBuilder().setIsolationLevel(IsolationLevel.SERIALIZABLE).setSkip(15).build());
            RecordCursor indexEntries = this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "\"testing\""), null, scanProperties);
            RecordCursorResult next = (RecordCursorResult)indexEntries.onNext().get();
            Assertions.assertFalse((boolean)next.hasNext());
            Assertions.assertEquals((Object)RecordCursor.NoNextReason.SOURCE_EXHAUSTED, (Object)next.getNoNextReason());
            Assertions.assertNull((Object)((FDBStoreTimer)Verify.verifyNotNull((Object)context.getTimer())).getCounter((StoreTimer.Event)FDBStoreTimer.Counts.LOAD_SCAN_ENTRY));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"primaryKeySegmentIndexEnabledParams"})
    void manySegmentsParallelOpen(LuceneIndexTestUtils.IndexedType indexedType, boolean primaryKeySegmentIndexEnabled) throws IOException {
        Index index = indexedType.getIndex(primaryKeySegmentIndexEnabled ? "simple_text_suffixes_with_primary_key_segment_index_key" : "simple_text_suffixes_key");
        for (int i = 0; i < 20; ++i) {
            RecordLayerPropertyStorage.Builder insertProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_MERGE_MAX_SIZE, (Object)0.001);
            try (FDBRecordContext context = this.openContext(insertProps);){
                if (indexedType.isSynthetic()) {
                    this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
                    this.createComplexRecordJoinedToSimple(i, 1000L + (long)i, 1000L + (long)i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", "", false, System.currentTimeMillis(), 1);
                } else {
                    this.rebuildIndexMetaData(context, "SimpleDocument", index);
                    this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1000 + i, "A software engineer, a hardware engineer, and a departmental manager were driving down a steep mountain road when suddenly the brakes on their car failed. The car careened out of control down the road, bouncing off the crash barriers, ground to a halt scraping along the mountainside. The occupants were stuck halfway down a mountain in a car with no brakes. What were they to do?'I know,' said the departmental manager. 'Let's have a meeting, propose a Vision, formulate a Mission Statement, define some Goals, and by a process of Continuous Improvement find a solution to the Critical Problems, and we can be on our way.''No, no,' said the hardware engineer. 'That will take far too long, and that method has never worked before. In no time at all, I can strip down the car's braking system, isolate the fault, fix it, and we can be on our way.''Wait, said the software engineer. 'Before we do anything, I think we should push the car back up the road and see if it happens again.'", 2));
                }
                context.commit();
                continue;
            }
        }
        RecordLayerPropertyStorage.Builder scanProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_OPEN_PARALLELISM, (Object)2);
        try (FDBRecordContext context = this.openContext(scanProps);){
            if (indexedType.isSynthetic()) {
                this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
            } else {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
            }
            Assertions.assertEquals((int)20, (Integer)((Integer)this.recordStore.scanIndex(index, (IndexScanBounds)this.fullTextSearch(index, "Vision"), null, ScanProperties.FORWARD_SCAN).getCount().join()));
            try (FDBDirectory directory = new FDBDirectory(this.recordStore.indexSubspace(index), context, index.getOptions());){
                Assertions.assertEquals((int)61, (int)directory.listAll().length);
            }
        }
    }

    private static void assertAutoCompleteEntriesAndSegmentInfoStoredInCompoundFile(Index index, @Nonnull Subspace subspace, @Nonnull FDBRecordContext context, @Nonnull String segment) {
        LuceneIndexTest.validateSegmentAndIndexIntegrity(index, subspace, context, segment);
    }

    private static void validateSegmentAndIndexIntegrity(Index index, @Nonnull Subspace subspace, @Nonnull FDBRecordContext context, @Nonnull String segmentFile) {
        try (FDBDirectory directory = new FDBDirectory(subspace, context, index.getOptions());){
            FDBLuceneFileReference reference = directory.getFDBLuceneFileReference(segmentFile);
            Assertions.assertNotNull((Object)reference);
            String segmentName = segmentFile.substring(0, segmentFile.indexOf("."));
            LuceneIndexTest.validateIndexIntegrity(index, subspace, context, directory, segmentName);
        }
        catch (Exception ex) {
            throw new AssertionFailedError("Validation failed: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private static void validateIndexIntegrity(Index index, @Nonnull Subspace subspace, @Nonnull FDBRecordContext context, @Nullable FDBDirectory fdbDirectory, @Nullable String segmentName) throws IOException {
        FDBDirectory directory = fdbDirectory == null ? new FDBDirectory(subspace, context, index.getOptions()) : fdbDirectory;
        String[] allFiles = directory.listAll();
        HashSet<Long> usedFieldInfos = new HashSet<Long>();
        Set allFieldInfos = (Set)Assertions.assertDoesNotThrow(() -> directory.getFieldInfosStorage().getAllFieldInfos().keySet());
        int segmentCount = 0;
        for (String file : allFiles) {
            FDBLuceneFileReference fileReference = directory.getFDBLuceneFileReference(file);
            if (FDBDirectory.isEntriesFile((String)file) || FDBDirectory.isSegmentInfo((String)file) || FDBDirectory.isFieldInfoFile((String)file) || file.endsWith(".pky")) {
                Assertions.assertFalse((boolean)fileReference.getContent().isEmpty(), (String)("fileName=" + file));
            } else if (FDBDirectory.isStoredFieldsFile((String)file) && segmentName != null) {
                if (file.startsWith(segmentName)) {
                    Assertions.fail((String)"Found stored fields file that should have been removed");
                }
            } else {
                Assertions.assertTrue((FDBDirectory.isCompoundFile((String)file) || file.startsWith("segments") ? 1 : 0) != 0, (String)("fileName=" + file));
                Assertions.assertTrue((boolean)fileReference.getContent().isEmpty(), (String)("fileName=" + file));
            }
            if (FDBDirectory.isSegmentInfo((String)file)) {
                ++segmentCount;
            }
            usedFieldInfos.add(LuceneIndexTest.validateFieldInfos(file, fileReference, directory));
        }
        usedFieldInfos.remove(0L);
        Assertions.assertEquals((Object)allFieldInfos, usedFieldInfos);
        MatcherAssert.assertThat((Object)allFieldInfos.size(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(segmentCount)));
    }

    private static long validateFieldInfos(String file, FDBLuceneFileReference fileReference, FDBDirectory directory) {
        if (FDBDirectory.isFieldInfoFile((String)file) || FDBDirectory.isEntriesFile((String)file)) {
            Assertions.assertNotEquals((long)0L, (long)fileReference.getFieldInfosId());
            Assertions.assertNotEquals((Object)ByteString.EMPTY, (Object)fileReference.getFieldInfosBitSet());
            LuceneFieldInfosProto.FieldInfos fieldInfos = (LuceneFieldInfosProto.FieldInfos)Assertions.assertDoesNotThrow(() -> directory.getFieldInfosStorage().readFieldInfos(fileReference.getFieldInfosId()));
            BitSet bitSet = BitSet.valueOf(fileReference.getFieldInfosBitSet().toByteArray());
            Set fieldNumbers = fieldInfos.getFieldInfoList().stream().map(LuceneFieldInfosProto.FieldInfo::getNumber).collect(Collectors.toSet());
            int i = bitSet.nextSetBit(0);
            while (i >= 0 && i != Integer.MAX_VALUE) {
                Assertions.assertTrue((boolean)fieldNumbers.contains(i));
                i = bitSet.nextSetBit(i + 1);
            }
        } else {
            Assertions.assertEquals((long)0L, (long)fileReference.getFieldInfosId());
            Assertions.assertEquals((Object)ByteString.EMPTY, (Object)fileReference.getFieldInfosBitSet());
        }
        return fileReference.getFieldInfosId();
    }

    private void searchForAutoCompleteAndAssert(LuceneIndexTestUtils.IndexedType indexedType, String query, boolean matches, boolean highlight, int planHash) throws Exception {
        Index index = indexedType.getIndex("simple_text_with_auto_complete_key");
        try (FDBRecordContext context = this.openContext();){
            this.addIndexAndSaveRecordForAutoComplete(context, index, indexedType.isSynthetic(), autoCompletes);
            LuceneIndexQueryPlan luceneIndexPlan = LuceneIndexQueryPlan.of((String)index.getName(), (LuceneScanParameters)this.autoCompleteScanParams(query, (Iterable<String>)ImmutableSet.of((Object)(indexedType.isSynthetic() ? "simple_text" : "text"))), (RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords)(indexedType.isSynthetic() ? RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.SYNTHETIC_CONSTITUENTS : RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY), (boolean)false, null, (List)ImmutableList.of((Object)(indexedType.isSynthetic() ? LuceneIndexTestUtils.JOINED_SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD : LuceneIndexTestUtils.SIMPLE_TEXT_WITH_AUTO_COMPLETE_STORED_FIELD)));
            Assertions.assertEquals((int)planHash, (int)luceneIndexPlan.planHash(PlanHashable.CURRENT_LEGACY));
            List results = (List)this.recordStore.executeQuery((RecordQueryPlan)luceneIndexPlan, null, ExecuteProperties.SERIAL_EXECUTE).asList().get();
            FDBStoreTimer timer = (FDBStoreTimer)Verify.verifyNotNull((Object)context.getTimer());
            if (!matches) {
                Assertions.assertTrue((boolean)results.isEmpty());
                Assertions.assertEquals((int)0, (int)timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_SCAN_MATCHED_AUTO_COMPLETE_SUGGESTIONS));
                return;
            }
            Assertions.assertEquals((int)6, (int)results.size());
            List suggestions = results.stream().map(FDBRecord::getRecord).map(record -> {
                if (indexedType.isSynthetic()) {
                    record = (DynamicMessage)record.getField(record.getDescriptorForType().findFieldByName("simple"));
                }
                Descriptors.Descriptor descriptor = record.getDescriptorForType();
                Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName("text");
                Assertions.assertTrue((boolean)record.hasField(fieldDescriptor));
                return (String)Verify.verifyNotNull((Object)((String)record.getField(fieldDescriptor)));
            }).collect(Collectors.toList());
            if (highlight) {
                Assertions.assertEquals((Object)ImmutableList.of((Object)"Good morning", (Object)"Good afternoon", (Object)"good evening", (Object)"Good night", (Object)"That's really good!", (Object)"I'm good"), suggestions);
            } else {
                Assertions.assertEquals((Object)ImmutableList.of((Object)"Good morning", (Object)"Good afternoon", (Object)"good evening", (Object)"Good night", (Object)"That's really good!", (Object)"I'm good"), suggestions);
            }
            LuceneIndexTest.assertAutoCompleteEntriesAndSegmentInfoStoredInCompoundFile(index, this.recordStore.indexSubspace(index), context, "_0.cfs");
            this.commit(context);
        }
    }

    private void addIndexAndSaveRecordForAutoComplete(@Nonnull FDBRecordContext context, Index index, boolean isSynthetic, List<String> autoCompletes) {
        if (isSynthetic) {
            this.openRecordStore(context, metaDataBuilder -> this.metaDataHookSyntheticRecordComplexJoinedToSimple(metaDataBuilder, index));
            for (int i = 0; i < autoCompletes.size(); ++i) {
                this.createComplexRecordJoinedToSimple(1 + i, 1623L + (long)i, 1623L + (long)i, autoCompletes.get(i), "", false, System.currentTimeMillis(), 1);
            }
        } else {
            this.openRecordStore(context, metaDataBuilder -> {
                metaDataBuilder.removeIndex("SimpleDocument$text");
                metaDataBuilder.addIndex("SimpleDocument", index);
            });
            for (int i = 0; i < autoCompletes.size(); ++i) {
                this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L + (long)i, autoCompletes.get(i), 1));
            }
        }
    }

    private void queryAndAssertAutoCompleteSuggestionsReturned(@Nonnull Index index, boolean isSynthetic, @Nullable String queriedConstituent, @Nonnull List<KeyExpression> storedFields, @Nonnull String queriedField, @Nonnull String searchKey, @Nonnull List<String> expectedSuggestions) throws Exception {
        LuceneIndexQueryPlan luceneIndexPlan = LuceneIndexQueryPlan.of((String)index.getName(), (LuceneScanParameters)this.autoCompleteScanParams(searchKey, (Iterable<String>)ImmutableSet.of((Object)(isSynthetic ? queriedConstituent + "_" + queriedField : queriedField))), (RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords)(isSynthetic ? RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.SYNTHETIC_CONSTITUENTS : RecordQueryFetchFromPartialRecordPlan.FetchIndexRecords.PRIMARY_KEY), (boolean)false, null, storedFields);
        List results = (List)this.recordStore.executeQuery((RecordQueryPlan)luceneIndexPlan, null, ExecuteProperties.SERIAL_EXECUTE).asList().get();
        Assertions.assertEquals((int)expectedSuggestions.size(), (int)results.size());
        List suggestions = results.stream().map(FDBRecord::getRecord).map(record -> {
            if (isSynthetic) {
                record = (DynamicMessage)record.getField(record.getDescriptorForType().findFieldByName(queriedConstituent));
            }
            Descriptors.Descriptor descriptor = record.getDescriptorForType();
            Descriptors.FieldDescriptor fieldDescriptor = descriptor.findFieldByName(queriedField);
            Assertions.assertTrue((boolean)record.hasField(fieldDescriptor));
            return (String)Verify.verifyNotNull((Object)((String)record.getField(fieldDescriptor)));
        }).collect(Collectors.toList());
        MatcherAssert.assertThat(suggestions, (Matcher)Matchers.containsInAnyOrder((Collection)expectedSuggestions.stream().map(Matchers::equalTo).collect(Collectors.toList())));
    }

    private void rebuildIndexMetaData(FDBRecordContext context, String document, Index index) {
        Pair<FDBRecordStore, QueryPlanner> pair = LuceneIndexTestUtils.rebuildIndexMetaData(context, this.path, document, index, this.isUseCascadesPlanner());
        this.recordStore = (FDBRecordStore)pair.getLeft();
        this.planner = (QueryPlanner)pair.getRight();
        this.recordStore.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(true);
    }

    private void assertIndexEntryPrimaryKeys(Collection<Long> primaryKeys, RecordCursor<IndexEntry> cursor) {
        List indexEntries = (List)cursor.asList().join();
        Assertions.assertEquals(primaryKeys.stream().map(xva$0 -> Tuple.from((Object[])new Object[]{xva$0})).collect(Collectors.toSet()), indexEntries.stream().map(IndexEntry::getPrimaryKey).collect(Collectors.toSet()));
    }

    private void assertIndexEntryPrimaryKeyTuples(Set<Tuple> primaryKeys, RecordCursor<IndexEntry> cursor) {
        List indexEntries = (List)cursor.asList().join();
        Assertions.assertEquals(primaryKeys, indexEntries.stream().map(IndexEntry::getPrimaryKey).collect(Collectors.toSet()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testConflictWithLock() throws IOException {
        Index index = LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES;
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            context.commit();
        }
        Tuple conflictTuple = Tuple.from((Object[])new Object[]{100, 100, 100});
        try (FDBRecordContext context = this.fdb.openContext();){
            FDBRecordStore.Builder builder = this.recordStore.asBuilder().setContext(context).setMetaDataProvider(this.recordStore.getMetaDataProvider());
            FDBRecordStore store = (FDBRecordStore)builder.createOrOpen(FDBRecordStoreBase.StoreExistenceCheck.NONE);
            AgilityContext agile = AgilityContext.agile((FDBRecordContext)context, (long)TimeUnit.SECONDS.toMillis(4L), (long)100000L);
            FDBDirectory directory = new FDBDirectory(store.indexSubspace(index), index.getOptions(), null, null, true, agile);
            Lock lock = directory.obtainLock("write.lock");
            this.testConflictWithLockAgileSet(agile, conflictTuple);
            this.testConflictWithLockCauseConflict(conflictTuple);
            boolean gotException = false;
            try {
                block29: {
                    block28: {
                        try {
                            lock.close();
                        }
                        catch (IOException ex) {
                            if (!(ex.getCause() instanceof RuntimeException)) break block28;
                            gotException = true;
                        }
                    }
                    try {
                        directory.close();
                    }
                    catch (IOException ex) {
                        if (!(ex.getCause() instanceof RuntimeException)) break block29;
                        gotException = true;
                    }
                }
                agile.flushAndClose();
                context.commit();
            }
            catch (RuntimeException ex) {
                gotException = true;
            }
            finally {
                Assertions.assertTrue((boolean)gotException);
            }
        }
        TestRecordsTextProto.SimpleDocument doc3 = LuceneIndexTestUtils.createSimpleDocument(1623L, "Salesmen jokes are funnier", 2);
        try (FDBRecordContext context = this.fdb.openContext();){
            FDBRecordStore.Builder builder = this.recordStore.asBuilder().setContext(context).setMetaDataProvider(this.recordStore.getMetaDataProvider());
            FDBRecordStore store = (FDBRecordStore)builder.createOrOpen(FDBRecordStoreBase.StoreExistenceCheck.NONE);
            store.saveRecord((Message)doc3);
            context.commit();
        }
    }

    private void testConflictWithLockAgileSet(AgilityContext agile1, Tuple conflictTuple) {
        agile1.accept(aContext -> {
            byte[] conflictKey = this.path.toSubspace(aContext).pack(conflictTuple);
            Transaction tr = aContext.ensureActive();
            tr.get(conflictKey).join();
            tr.set(conflictKey, Tuple.from((Object[])new Object[]{100, 20}).pack());
        });
    }

    private void testConflictWithLockCauseConflict(Tuple conflictTuple) {
        try (FDBRecordContext context = this.fdb.openContext();){
            byte[] conflictKey = this.path.toSubspace(context).pack(conflictTuple);
            Transaction tr = context.ensureActive();
            tr.get(conflictKey).join();
            tr.set(conflictKey, Tuple.from((Object[])new Object[]{100, 10}).pack());
            context.commit();
        }
    }

    private /* synthetic */ Object lambda$autoCompleteMultiPhraseLuceneQuery$155(Index index, LuceneIndexTestUtils.IndexedType indexedType, List storedFields, String query, List expected) {
        try {
            this.queryAndAssertAutoCompleteSuggestionsReturned(index, indexedType.isSynthetic(), indexedType.isSynthetic() ? "simple" : null, storedFields, "text", query, expected);
        }
        catch (Exception ex) {
            Assertions.fail((Throwable)ex);
        }
        return null;
    }

    private /* synthetic */ Object lambda$autoCompleteCjkEmailSearch$154(Index index, LuceneIndexTestUtils.IndexedType indexedType, List storedFields, String query, List expected) {
        try {
            this.queryAndAssertAutoCompleteSuggestionsReturned(index, indexedType.isSynthetic(), indexedType.isSynthetic() ? "simple" : null, storedFields, "text", query, expected);
        }
        catch (Exception ex) {
            Assertions.fail((Throwable)ex);
        }
        return null;
    }

    private /* synthetic */ Object lambda$autoCompleteCjkPhraseSearch$153(Index index, LuceneIndexTestUtils.IndexedType indexedType, List storedFields, String query, List expected) {
        try {
            this.queryAndAssertAutoCompleteSuggestionsReturned(index, indexedType.isSynthetic(), indexedType.isSynthetic() ? "simple" : null, storedFields, "text", query, expected);
        }
        catch (Exception ex) {
            Assertions.fail((Throwable)ex);
        }
        return null;
    }

    private /* synthetic */ Object lambda$autoCompletePhraseSearchWithMixedCases$152(Index index, LuceneIndexTestUtils.IndexedType indexedType, List storedFields, String query, List expected) {
        try {
            this.queryAndAssertAutoCompleteSuggestionsReturned(index, indexedType.isSynthetic(), indexedType.isSynthetic() ? "simple" : null, storedFields, "text", query, expected);
        }
        catch (Exception ex) {
            Assertions.fail((Throwable)ex);
        }
        return null;
    }

    private /* synthetic */ void lambda$testAutoCompleteSearchForPhraseWithoutFreqsAndPositions$151(Index index, LuceneIndexTestUtils.IndexedType indexedType, List storedFields) throws Throwable {
        this.queryAndAssertAutoCompleteSuggestionsReturned(index, indexedType.isSynthetic(), indexedType.isSynthetic() ? "simple" : null, storedFields, "text", "\"united states \"", (List<String>)ImmutableList.of());
    }

    private static enum SortType {
        ASCENDING,
        DESCENDING,
        UNSORTED;

    }

    static class QueryPlanningExpectation {
        static final QueryPlanningExpectation SELECTED = new QueryPlanningExpectation(DetectionStatus.PREDICATE_SELECTED, DetectionStatus.PREDICATE_SELECTED);
        DetectionStatus forSynthetic;
        DetectionStatus forSimple;

        QueryPlanningExpectation(DetectionStatus forSimple, DetectionStatus forSynthetic) {
            this.forSynthetic = forSynthetic;
            this.forSimple = forSimple;
        }

        static enum DetectionStatus {
            NON_LUCENE_PLAN,
            EXCEPTION_THROWN,
            PREDICATE_SELECTED,
            PREDICATE_NOT_SELECTED;

        }
    }

    public static class LuceneIndexWithLuceneAsyncToSyncTest
    extends LuceneIndexTest {
        @Override
        protected RecordLayerPropertyStorage.Builder addDefaultProps(RecordLayerPropertyStorage.Builder props) {
            return super.addDefaultProps(props).addProp(LuceneRecordContextProperties.LUCENE_USE_LEGACY_ASYNC_TO_SYNC, (Object)false);
        }
    }

    public static class CombinedSynonymSetsConfig
    implements SynonymMapConfig {
        public String getName() {
            return "COMBINED_SYNONYM_SETS";
        }

        public boolean expand() {
            return true;
        }

        public InputStream getSynonymInputStream() {
            InputStream is1 = null;
            InputStream is2 = null;
            try {
                is1 = new EnglishSynonymMapConfig.ExpandedEnglishSynonymMapConfig().getSynonymInputStream();
                is2 = SynonymMapConfig.openFile((String)"test.txt");
                return new SequenceInputStream(is1, is2);
            }
            catch (RecordCoreException e) {
                try {
                    if (is1 != null) {
                        is1.close();
                    }
                    if (is2 != null) {
                        is2.close();
                    }
                    throw e;
                }
                catch (IOException ignored) {
                    throw e;
                }
            }
        }
    }
}

