/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.synonym;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.synonym.SynonymMapConfig;
import com.apple.foundationdb.record.lucene.synonym.SynonymMapRegistry;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.util.ServiceLoaderProvider;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.FlattenGraphFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.synonym.SolrSynonymParser;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynonymMapRegistryImpl
implements SynonymMapRegistry {
    @Nonnull
    private static final Logger LOGGER = LoggerFactory.getLogger(SynonymMapRegistryImpl.class);
    private static final SynonymMapRegistryImpl INSTANCE = new SynonymMapRegistryImpl();
    @Nonnull
    private final Map<String, SynonymMap> registry = SynonymMapRegistryImpl.initRegistry();

    private SynonymMapRegistryImpl() {
    }

    @Nonnull
    public static SynonymMapRegistry instance() {
        return INSTANCE;
    }

    @Override
    @Nonnull
    public SynonymMap getSynonymMap(@Nonnull String name) {
        SynonymMap map = this.registry.get(name);
        if (map == null) {
            throw new MetaDataException("unrecognized synonym map", new Object[]{LogMessageKeys.SYNONYM_NAME, name});
        }
        return map;
    }

    @Nonnull
    private static Map<String, SynonymMap> initRegistry() {
        HashMap<String, SynonymMap> registry = new HashMap<String, SynonymMap>();
        for (SynonymMapConfig config : ServiceLoaderProvider.load(SynonymMapConfig.class)) {
            if (registry.containsKey(config.getName()) && LOGGER.isWarnEnabled()) {
                LOGGER.warn(KeyValueLogMessage.of((String)"duplicate synonym map", (Object[])new Object[]{LogMessageKeys.SYNONYM_NAME, config.getName()}));
            }
            registry.put(config.getName(), SynonymMapRegistryImpl.buildSynonymMap(config));
        }
        return registry;
    }

    private static SynonymMap buildSynonymMap(SynonymMapConfig config) {
        try {
            SolrSynonymParser parser = new SolrSynonymParser(true, true, new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    StandardTokenizer src = new StandardTokenizer();
                    LowerCaseFilter tok = new LowerCaseFilter((TokenStream)src);
                    tok = new FlattenGraphFilter((TokenStream)tok);
                    return new Analyzer.TokenStreamComponents((Tokenizer)src, (TokenStream)tok);
                }
            });
            parser.parse((Reader)new InputStreamReader(config.getSynonymInputStream(), StandardCharsets.UTF_8));
            return parser.build();
        }
        catch (IOException ex) {
            throw LuceneExceptions.toRecordCoreException("Failed to build synonym map", ex, LogMessageKeys.SYNONYM_NAME, config.getName());
        }
        catch (ParseException ex) {
            throw new RecordCoreException("Failed to build synonym map", (Throwable)ex).addLogInfo(new Object[]{LogMessageKeys.SYNONYM_NAME, config.getName()});
        }
    }
}

