/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.search;

import com.apple.foundationdb.record.lucene.search.LuceneOptimizedMultiFieldStopWordsQueryParser;
import com.apple.foundationdb.record.lucene.search.LuceneOptimizedStopWordsQueryParser;
import com.apple.foundationdb.record.lucene.search.LuceneQueryParserFactory;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.util.ServiceLoaderProvider;
import com.google.common.base.Suppliers;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.PointsConfig;

public class LuceneQueryParserFactoryProvider {
    private static final Supplier<LuceneQueryParserFactoryProvider> INSTANCE = Suppliers.memoize(LuceneQueryParserFactoryProvider::new);
    @Nonnull
    private final LuceneQueryParserFactory parserFactory = LuceneQueryParserFactoryProvider.initRegistry();

    private LuceneQueryParserFactoryProvider() {
    }

    @Nonnull
    public static LuceneQueryParserFactoryProvider instance() {
        return INSTANCE.get();
    }

    @Nonnull
    public LuceneQueryParserFactory getParserFactory() {
        return this.parserFactory;
    }

    @Nonnull
    private static LuceneQueryParserFactory initRegistry() {
        LuceneQueryParserFactory first = null;
        for (LuceneQueryParserFactory factory : ServiceLoaderProvider.load(LuceneQueryParserFactory.class)) {
            if (first == null) {
                first = factory;
                continue;
            }
            throw new MetaDataException("Too many query parser factories", new Object[0]);
        }
        if (first == null) {
            first = new DefaultParserFactory();
        }
        return first;
    }

    public static class DefaultParserFactory
    implements LuceneQueryParserFactory {
        @Override
        public QueryParser createQueryParser(String field, Analyzer analyzer, @Nonnull Map<String, PointsConfig> pointsConfig) {
            return new LuceneOptimizedStopWordsQueryParser(field, analyzer, pointsConfig, this.getStopWords());
        }

        @Override
        @Nonnull
        public QueryParser createMultiFieldQueryParser(String[] fields, Analyzer analyzer, @Nonnull Map<String, PointsConfig> pointsConfig) {
            LuceneOptimizedMultiFieldStopWordsQueryParser parser = new LuceneOptimizedMultiFieldStopWordsQueryParser(fields, analyzer, pointsConfig, this.getStopWords());
            parser.setDefaultOperator(QueryParser.Operator.OR);
            return parser;
        }

        @Nonnull
        protected CharArraySet getStopWords() {
            return EnglishAnalyzer.ENGLISH_STOP_WORDS_SET;
        }
    }
}

