/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.search;

import com.apple.foundationdb.record.lucene.search.ConfigAwareQueryParser;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.Token;
import org.apache.lucene.queryparser.flexible.standard.config.PointsConfig;
import org.apache.lucene.search.Query;

public class LuceneOptimizedQueryParser
extends QueryParser
implements ConfigAwareQueryParser {
    @Nonnull
    private final Map<String, PointsConfig> pointsConfig;

    public LuceneOptimizedQueryParser(String field, Analyzer analyzer, @Nonnull Map<String, PointsConfig> pointsConfig) {
        super(field, analyzer);
        this.pointsConfig = pointsConfig;
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        Query query = this.getFieldQuery(field, queryText, true);
        return this.addSlop(query, slop);
    }

    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        return this.attemptConstructFieldQueryWithPointsConfig(field, queryText, quoted);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        return this.attemptConstructRangeQueryWithPointsConfig(field, part1, part2, startInclusive, endInclusive);
    }

    @Override
    @Nonnull
    public Map<String, PointsConfig> getPointsConfig() {
        return this.pointsConfig;
    }

    @Override
    @Nonnull
    public Query constructFieldWithoutPointsConfig(@Nonnull String field, @Nonnull String queryText, boolean quoted) throws ParseException {
        return super.getFieldQuery(field, queryText, quoted);
    }

    @Override
    @Nonnull
    public Query constructRangeQueryWithoutPointsConfig(@Nonnull String field, @Nonnull String part1, @Nonnull String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        return super.getRangeQuery(field, part1, part2, startInclusive, endInclusive);
    }

    @Override
    @Nonnull
    public final Token nextToken() {
        return this.getNextToken();
    }
}

