/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.idformat;

import com.apple.foundationdb.record.lucene.idformat.RecordCoreFormatException;
import com.apple.foundationdb.record.lucene.idformat.RecordIdFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RecordIdFormatParser {
    public static final String BEGIN_TUPLE_STR = "[";
    public static final String END_TUPLE_STR = "]";
    public static final char BEGIN_TUPLE_CHAR = '[';
    public static final char END_TUPLE_CHAR = ']';

    private RecordIdFormatParser() {
    }

    @Nonnull
    public static RecordIdFormat parse(String formatString) throws RecordCoreFormatException {
        RecordIdFormat.TupleElement tupleElement = RecordIdFormatParser.parseTuple(formatString.trim());
        return new RecordIdFormat(tupleElement);
    }

    @Nonnull
    private static RecordIdFormat.FormatElement parseElement(String s) throws RecordCoreFormatException {
        String trimmed = s.trim();
        RecordIdFormat.FormatElementType formatElementType = RecordIdFormatParser.parseType(trimmed);
        if (formatElementType != null) {
            return formatElementType;
        }
        return RecordIdFormatParser.parseTuple(trimmed);
    }

    @Nonnull
    private static RecordIdFormat.TupleElement parseTuple(String s) {
        if (!s.startsWith(BEGIN_TUPLE_STR) || !s.endsWith(END_TUPLE_STR)) {
            throw new RecordCoreFormatException("Format error: syntax error", new Object[0]).addLogInfo("syntaxError", "missing beginning or end of tuple");
        }
        String content = s.substring(1, s.length() - 1);
        List<String> splits = RecordIdFormatParser.tokenize(content);
        List<RecordIdFormat.FormatElement> elements = splits.stream().map(RecordIdFormatParser::parseElement).collect(Collectors.toList());
        return new RecordIdFormat.TupleElement(elements);
    }

    @Nullable
    private static RecordIdFormat.FormatElementType parseType(String s) {
        try {
            return RecordIdFormat.FormatElementType.valueOf(s);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private static List<String> tokenize(String s) {
        ArrayList<String> result = new ArrayList<String>();
        int tokenStart = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ',') {
                result.add(s.substring(tokenStart, i));
                tokenStart = i + 1;
                continue;
            }
            if (c == '[') {
                i = RecordIdFormatParser.matchBalanced(s, i);
                continue;
            }
            if (c != ']') continue;
            throw new RecordCoreFormatException("Unmatched ']'", new Object[0]);
        }
        if (tokenStart >= s.length()) {
            throw new RecordCoreFormatException("Unmatched ',' (no token following)", new Object[0]);
        }
        result.add(s.substring(tokenStart));
        return result;
    }

    private static int matchBalanced(String s, int start) {
        int count = 0;
        for (int i = start; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '[') {
                ++count;
                continue;
            }
            if (c != ']' || --count != 0) continue;
            return i;
        }
        throw new RecordCoreFormatException("Unmatched [] in format string", new Object[0]);
    }
}

