/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.idformat;

import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.lucene.idformat.RecordCoreFormatException;
import com.apple.foundationdb.record.lucene.idformat.RecordCoreSizeException;
import com.apple.foundationdb.record.lucene.idformat.RecordIdFormat;
import com.apple.foundationdb.record.lucene.idformat.RecordIdFormatParser;
import com.apple.foundationdb.tuple.Tuple;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LuceneIndexKeySerializer {
    public static final int BINARY_POINT_DIMENSION_SIZE = 9;
    public static final int MAX_STRING_16_LENGTH = 16;
    public static final int MAX_STRING_16_ENCODED_LENGTH = 27;
    private static final String ACTUAL_TYPE = "actualType";
    @Nullable
    private final RecordIdFormat format;

    public LuceneIndexKeySerializer(@Nullable RecordIdFormat format) {
        this.format = format;
    }

    public static LuceneIndexKeySerializer fromStringFormat(@Nullable String formatString) {
        RecordIdFormat format = formatString == null ? null : RecordIdFormatParser.parse(formatString);
        return new LuceneIndexKeySerializer(format);
    }

    public byte[] asPackedByteArray(@Nonnull Tuple key) {
        return key.pack();
    }

    public byte[][] asPackedBinaryPoint(@Nonnull Tuple key) {
        List<byte[]> splitBytes = LuceneIndexKeySerializer.split(key.pack(), 9);
        return (byte[][])splitBytes.toArray((T[])new byte[splitBytes.size()][]);
    }

    public byte[][] asFormattedBinaryPoint(@Nonnull Tuple key) throws RecordCoreFormatException {
        if (this.format == null) {
            throw new RecordCoreFormatException("Missing format, cannot format to a BinaryPoint", new Object[0]);
        }
        List<byte[]> formattedBytes = this.applyFormat(this.format.getElement(), key);
        List<byte[]> splitBytes = LuceneIndexKeySerializer.splitAll(formattedBytes);
        return (byte[][])splitBytes.toArray((T[])new byte[splitBytes.size()][]);
    }

    public boolean hasFormat() {
        return this.format != null;
    }

    private static List<byte[]> splitAll(List<byte[]> byteArrayList) {
        return byteArrayList.stream().flatMap(byteArray -> {
            if (((byte[])byteArray).length == 9) {
                return Stream.of(byteArray);
            }
            return LuceneIndexKeySerializer.split(byteArray, 9).stream();
        }).collect(Collectors.toList());
    }

    static List<byte[]> split(byte[] source, int splitLength) {
        int numSubArrays = source.length / splitLength;
        if (source.length % splitLength != 0) {
            ++numSubArrays;
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>(numSubArrays);
        for (int i = 0; i < numSubArrays; ++i) {
            result.add(Arrays.copyOfRange(source, i * splitLength, (i + 1) * splitLength));
        }
        return result;
    }

    private Tuple verifyTuple(Object keyElement) {
        if (!(keyElement instanceof Tuple)) {
            throw new RecordCoreFormatException("Format mismatch: expected Tuple", new Object[0]).addLogInfo(ACTUAL_TYPE, keyElement.getClass().getName());
        }
        return (Tuple)keyElement;
    }

    private List<byte[]> applyFormat(@Nonnull RecordIdFormat.TupleElement format, @Nonnull Tuple key) throws RecordCoreArgumentException {
        List<RecordIdFormat.FormatElement> formatElements = format.getChildren();
        if (key.size() != formatElements.size()) {
            throw new RecordCoreFormatException("Key tuple and format have different sizes, format cannot be applied", new Object[0]).addLogInfo("tupleSize", key.size()).addLogInfo("keySize", (Object)formatElements.size());
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (int i = 0; i < formatElements.size(); ++i) {
            RecordIdFormat.FormatElement formatElement = formatElements.get(i);
            Object keyElement = key.get(i);
            if (formatElement instanceof RecordIdFormat.TupleElement) {
                result.addAll(this.applyFormat((RecordIdFormat.TupleElement)formatElement, this.verifyTuple(keyElement)));
                continue;
            }
            if (formatElement instanceof RecordIdFormat.FormatElementType) {
                byte[] byteArray = this.applyFormat((RecordIdFormat.FormatElementType)formatElement, keyElement);
                if (byteArray == null) continue;
                result.add(byteArray);
                continue;
            }
            throw new RecordCoreFormatException("Unknown element type", new Object[0]).addLogInfo("type", formatElement.getClass().getName());
        }
        return result;
    }

    @Nullable
    private byte[] applyFormat(RecordIdFormat.FormatElementType formatElement, Object tupleElement) {
        byte[] value;
        switch (formatElement) {
            case NONE: {
                return null;
            }
            case NULL: {
                value = Tuple.from((Object[])new Object[]{null}).pack();
                break;
            }
            case INT32: {
                if (!(tupleElement instanceof Integer)) {
                    throw new RecordCoreFormatException("Format mismatch: Expected Integer", new Object[0]).addLogInfo(ACTUAL_TYPE, tupleElement.getClass().getName());
                }
                value = Tuple.from((Object[])new Object[]{tupleElement}).pack();
                break;
            }
            case INT64: {
                if (!(tupleElement instanceof Long)) {
                    throw new RecordCoreFormatException("Format mismatch: Expected Long", new Object[0]).addLogInfo(ACTUAL_TYPE, tupleElement.getClass().getName());
                }
                value = Tuple.from((Object[])new Object[]{tupleElement}).pack();
                break;
            }
            case INT32_OR_NULL: {
                if (tupleElement != null && !(tupleElement instanceof Integer)) {
                    throw new RecordCoreFormatException("Format mismatch: Expected Integer OR null", new Object[0]).addLogInfo(ACTUAL_TYPE, tupleElement.getClass().getName());
                }
                value = Tuple.from((Object[])new Object[]{tupleElement}).pack();
                break;
            }
            case INT64_OR_NULL: {
                if (tupleElement != null && !(tupleElement instanceof Long)) {
                    throw new RecordCoreFormatException("Format mismatch: Expected Long OR null", new Object[0]).addLogInfo(ACTUAL_TYPE, tupleElement.getClass().getName());
                }
                value = Tuple.from((Object[])new Object[]{tupleElement}).pack();
                break;
            }
            case STRING_16: {
                if (!(tupleElement instanceof String)) {
                    throw new RecordCoreFormatException("Format mismatch: Expected String", new Object[0]).addLogInfo(ACTUAL_TYPE, tupleElement.getClass().getName());
                }
                if (((String)tupleElement).length() > 16) {
                    throw new RecordCoreFormatException("Format mismatch: String too long", new Object[0]).addLogInfo("allowedLength", 16).addLogInfo("actualLength", (Object)((String)tupleElement).length());
                }
                value = ((String)tupleElement).getBytes(StandardCharsets.UTF_8);
                if (value.length <= 27) break;
                throw new RecordCoreSizeException("Encoded string too long", new Object[0]).addLogInfo("allowedLength", 27).addLogInfo("actualLength", (Object)value.length);
            }
            case UUID_AS_STRING: {
                if (!(tupleElement instanceof String)) {
                    throw new RecordCoreFormatException("Format mismatch: Expected String", new Object[0]).addLogInfo(ACTUAL_TYPE, tupleElement.getClass().getName());
                }
                try {
                    value = Tuple.from((Object[])new Object[]{UUID.fromString((String)tupleElement)}).pack();
                    break;
                }
                catch (Exception ex) {
                    throw new RecordCoreFormatException("Format mismatch: Failed to parse UUID", ex).addLogInfo("actualValue", tupleElement);
                }
            }
            default: {
                throw new RecordCoreFormatException("Format mismatch: unknown format", new Object[0]).addLogInfo("format", formatElement);
            }
        }
        int length = formatElement.getAllocatedSize();
        return Arrays.copyOfRange(value, 0, length);
    }
}

