/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.filter;

import com.apple.foundationdb.record.lucene.filter.CjkUnigramFilter;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.lucene.analysis.FilteringTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public final class AlphanumericLengthFilter
extends FilteringTokenFilter {
    private final int minAlphanumLength;
    private final int maxAlphanumLength;
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

    public AlphanumericLengthFilter(TokenStream in, int minAlphanumLength, int maxAlphanumLength) {
        super(in);
        Preconditions.checkArgument((minAlphanumLength >= 0 ? 1 : 0) != 0, (Object)"minimum length must be greater than or equal to zero");
        Preconditions.checkArgument((minAlphanumLength <= maxAlphanumLength ? 1 : 0) != 0, (Object)"maximum length must not be greater than minimum length");
        this.minAlphanumLength = minAlphanumLength;
        this.maxAlphanumLength = maxAlphanumLength;
    }

    protected boolean accept() {
        return CjkUnigramFilter.isUnigramTokenType(this.typeAtt.type()) || this.isLengthWithinRange(this.termAtt.length());
    }

    private boolean isLengthWithinRange(int len) {
        return len >= this.minAlphanumLength && len <= this.maxAlphanumLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AlphanumericLengthFilter that = (AlphanumericLengthFilter)((Object)o);
        return this.minAlphanumLength == that.minAlphanumLength && this.maxAlphanumLength == that.maxAlphanumLength && this.typeAtt.equals(that.typeAtt) && this.termAtt.equals(that.termAtt);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minAlphanumLength, this.maxAlphanumLength, this.typeAtt, this.termAtt);
    }
}

