/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneFileSystemProto;
import com.apple.foundationdb.record.lucene.LuceneLogMessageKeys;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@SpotBugsSuppressWarnings(value={"EI_EXPOSE_REP"})
@API(value=API.Status.EXPERIMENTAL)
public class FDBLuceneFileReference {
    private final long id;
    private final long size;
    private final long actualSize;
    private final long blockSize;
    @Nonnull
    private final ByteString content;
    private long fieldInfosId;
    @Nonnull
    private ByteString fieldInfosBitSet;

    private static ByteString getContentFromProto(@Nonnull LuceneFileSystemProto.LuceneFileReference protoMessage) {
        if (protoMessage.getColumnBitSetWordsCount() != 0 || protoMessage.hasEntries() || protoMessage.hasSegmentInfo()) {
            throw new RecordCoreException("FileReference has old file content", new Object[0]).addLogInfo(new Object[]{LuceneLogMessageKeys.REF_ID, protoMessage.getId()});
        }
        return protoMessage.getContent();
    }

    private FDBLuceneFileReference(@Nonnull LuceneFileSystemProto.LuceneFileReference protoMessage) {
        this(protoMessage.getId(), protoMessage.getSize(), protoMessage.getActualSize(), protoMessage.getBlockSize(), FDBLuceneFileReference.getContentFromProto(protoMessage), protoMessage.getFieldInfosId(), protoMessage.getFieldInfosBitset());
    }

    public FDBLuceneFileReference(long id, byte[] content) {
        this(id, content.length, 1L, content.length, ByteString.copyFrom((byte[])content), 0L, ByteString.EMPTY);
    }

    public FDBLuceneFileReference(long id, long size, long actualSize, long blockSize) {
        this(id, size, actualSize, blockSize, ByteString.EMPTY, 0L, ByteString.EMPTY);
    }

    private FDBLuceneFileReference(long id, long size, long actualSize, long blockSize, @Nonnull ByteString content, long fieldInfosId, @Nonnull ByteString fieldInfosBitSet) {
        this.id = id;
        this.size = size;
        this.actualSize = actualSize;
        this.blockSize = blockSize;
        this.content = content;
        this.fieldInfosId = fieldInfosId;
        this.fieldInfosBitSet = fieldInfosBitSet;
    }

    public long getId() {
        return this.id;
    }

    public long getSize() {
        return this.size;
    }

    public long getActualSize() {
        return this.actualSize;
    }

    public long getBlockSize() {
        return this.blockSize;
    }

    public ByteString getContent() {
        return this.content;
    }

    @Nonnull
    public byte[] getBytes() {
        LuceneFileSystemProto.LuceneFileReference.Builder builder = LuceneFileSystemProto.LuceneFileReference.newBuilder();
        builder.setId(this.id);
        builder.setSize(this.size);
        builder.setBlockSize(this.blockSize);
        builder.setActualSize(this.actualSize);
        if (!this.content.isEmpty()) {
            builder.setContent(this.content);
        }
        if (this.fieldInfosId != 0L) {
            builder.setFieldInfosId(this.fieldInfosId);
        }
        if (!this.fieldInfosBitSet.isEmpty()) {
            builder.setFieldInfosBitset(this.fieldInfosBitSet);
        }
        return builder.build().toByteArray();
    }

    public String toString() {
        return "Reference [ id=" + this.id + ", size=" + this.size + ", actualSize=" + this.actualSize + ", blockSize=" + this.blockSize + ", content=" + this.content.size() + "]";
    }

    @Nullable
    public static FDBLuceneFileReference parseFromBytes(@Nullable byte[] value) {
        try {
            return value == null ? null : new FDBLuceneFileReference(LuceneFileSystemProto.LuceneFileReference.parseFrom(value));
        }
        catch (InvalidProtocolBufferException ex) {
            throw new RecordCoreException("Invalid bytes for parsing of lucene file reference", (Throwable)ex);
        }
    }

    public void setFieldInfosId(long fieldInfosId) {
        this.fieldInfosId = fieldInfosId;
    }

    public long getFieldInfosId() {
        return this.fieldInfosId;
    }

    public void setFieldInfosBitSet(ByteString bitSet) {
        this.fieldInfosBitSet = bitSet;
    }

    @Nonnull
    public ByteString getFieldInfosBitSet() {
        return this.fieldInfosBitSet;
    }
}

