/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.MutationType;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.StreamingMode;
import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCoreStorageException;
import com.apple.foundationdb.record.logging.CompletionExceptionLogHelper;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LuceneLogMessageKeys;
import com.apple.foundationdb.record.lucene.LucenePrimaryKeySegmentIndex;
import com.apple.foundationdb.record.lucene.LucenePrimaryKeySegmentIndexV1;
import com.apple.foundationdb.record.lucene.LucenePrimaryKeySegmentIndexV2;
import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.lucene.codec.PrefetchableBufferedChecksumIndexInput;
import com.apple.foundationdb.record.lucene.directory.AgilityContext;
import com.apple.foundationdb.record.lucene.directory.EmptyIndexInput;
import com.apple.foundationdb.record.lucene.directory.EmptyIndexOutput;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryLockFactory;
import com.apple.foundationdb.record.lucene.directory.FDBDirectorySharedCache;
import com.apple.foundationdb.record.lucene.directory.FDBDirectorySharedCacheManager;
import com.apple.foundationdb.record.lucene.directory.FDBIndexInput;
import com.apple.foundationdb.record.lucene.directory.FDBIndexOutput;
import com.apple.foundationdb.record.lucene.directory.FDBLuceneFileReference;
import com.apple.foundationdb.record.lucene.directory.FieldInfosStorage;
import com.apple.foundationdb.record.lucene.directory.LuceneSerializer;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.util.pair.ComparablePair;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil2;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.ByteBuffersIndexInput;
import org.apache.lucene.store.ByteBuffersIndexOutput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(value=API.Status.EXPERIMENTAL)
@NotThreadSafe
public class FDBDirectory
extends Directory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FDBDirectory.class);
    public static final int DEFAULT_BLOCK_SIZE = 1024;
    public static final int DEFAULT_BLOCK_CACHE_MAXIMUM_SIZE = 1024;
    public static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    public static final int DEFAULT_INITIAL_CAPACITY = 128;
    private static final int SEQUENCE_SUBSPACE = 0;
    private static final int META_SUBSPACE = 1;
    @VisibleForTesting
    public static final int DATA_SUBSPACE = 2;
    private static final int SCHEMA_SUBSPACE = 3;
    private static final int PRIMARY_KEY_SUBSPACE = 4;
    private static final int FIELD_INFOS_SUBSPACE = 5;
    private static final int STORED_FIELDS_SUBSPACE = 6;
    @VisibleForTesting
    public static final int FILE_LOCK_SUBSPACE = 7;
    private final AtomicLong nextTempFileCounter = new AtomicLong();
    @Nonnull
    private final Map<String, String> indexOptions;
    private final Subspace subspace;
    private final Subspace metaSubspace;
    private final Subspace dataSubspace;
    private final Subspace fieldInfosSubspace;
    protected final Subspace storedFieldsSubspace;
    private final Subspace fileLockSubspace;
    private final byte[] sequenceSubspaceKey;
    private final FDBDirectoryLockFactory lockFactory;
    private FDBDirectoryLockFactory.FDBDirectoryLock lastLock = null;
    private final int blockSize;
    private final Supplier<CompletableFuture<Void>> fileReferenceMapSupplier;
    private final AtomicReference<ConcurrentSkipListMap<String, FDBLuceneFileReference>> fileReferenceCache;
    private final FieldInfosStorage fieldInfosStorage;
    private final AtomicLong fileSequenceCounter;
    private final Cache<ComparablePair<Long, Integer>, CompletableFuture<byte[]>> blockCache;
    private final boolean compressionEnabled;
    private final boolean encryptionEnabled;
    @Nullable
    private final FDBDirectorySharedCacheManager sharedCacheManager;
    @Nullable
    private final Tuple sharedCacheKey;
    private final boolean deferDeleteToCompoundFile;
    @Nullable
    private FDBDirectorySharedCache sharedCache;
    private boolean sharedCachePending;
    private final AgilityContext agilityContext;
    @Nullable
    private LucenePrimaryKeySegmentIndex primaryKeySegmentIndex;

    @VisibleForTesting
    public FDBDirectory(@Nonnull Subspace subspace, @Nonnull FDBRecordContext context, @Nullable Map<String, String> indexOptions) {
        this(subspace, indexOptions, null, null, true, AgilityContext.nonAgile(context));
    }

    public FDBDirectory(@Nonnull Subspace subspace, @Nullable Map<String, String> indexOptions, @Nullable FDBDirectorySharedCacheManager sharedCacheManager, @Nullable Tuple sharedCacheKey, boolean deferDeleteToCompoundFile, AgilityContext agilityContext) {
        this(subspace, indexOptions, sharedCacheManager, sharedCacheKey, agilityContext, 1024, 128, 1024, 16, deferDeleteToCompoundFile);
    }

    public FDBDirectory(@Nonnull Subspace subspace, @Nullable Map<String, String> indexOptions, @Nullable FDBDirectorySharedCacheManager sharedCacheManager, @Nullable Tuple sharedCacheKey, boolean deferDeleteToCompoundFile, AgilityContext agilityContext, int blockCacheMaximumSize) {
        this(subspace, indexOptions, sharedCacheManager, sharedCacheKey, agilityContext, 1024, 128, blockCacheMaximumSize, 16, deferDeleteToCompoundFile);
    }

    private FDBDirectory(@Nonnull Subspace subspace, @Nullable Map<String, String> indexOptions, @Nullable FDBDirectorySharedCacheManager sharedCacheManager, @Nullable Tuple sharedCacheKey, AgilityContext agilityContext, int blockSize, int initialCapacity, int blockCacheMaximumSize, int concurrencyLevel, boolean deferDeleteToCompoundFile) {
        this.agilityContext = agilityContext;
        this.indexOptions = indexOptions == null ? Collections.emptyMap() : indexOptions;
        this.subspace = subspace;
        Subspace sequenceSubspace = subspace.subspace(Tuple.from((Object[])new Object[]{0}));
        this.sequenceSubspaceKey = sequenceSubspace.pack();
        this.metaSubspace = subspace.subspace(Tuple.from((Object[])new Object[]{1}));
        this.dataSubspace = subspace.subspace(Tuple.from((Object[])new Object[]{2}));
        this.fieldInfosSubspace = subspace.subspace(Tuple.from((Object[])new Object[]{5}));
        this.storedFieldsSubspace = subspace.subspace(Tuple.from((Object[])new Object[]{6}));
        this.fileLockSubspace = subspace.subspace(Tuple.from((Object[])new Object[]{7}));
        this.lockFactory = new FDBDirectoryLockFactory(this, Objects.requireNonNullElse(agilityContext.getPropertyValue(LuceneRecordContextProperties.LUCENE_FILE_LOCK_TIME_WINDOW_MILLISECONDS), 0));
        this.blockSize = blockSize;
        this.fileReferenceCache = new AtomicReference();
        this.blockCache = CacheBuilder.newBuilder().concurrencyLevel(concurrencyLevel).initialCapacity(initialCapacity).maximumSize((long)blockCacheMaximumSize).recordStats().removalListener(notification -> this.cacheRemovalCallback()).build();
        this.fileSequenceCounter = new AtomicLong(-1L);
        this.compressionEnabled = Objects.requireNonNullElse(agilityContext.getPropertyValue(LuceneRecordContextProperties.LUCENE_INDEX_COMPRESSION_ENABLED), false);
        this.encryptionEnabled = Objects.requireNonNullElse(agilityContext.getPropertyValue(LuceneRecordContextProperties.LUCENE_INDEX_ENCRYPTION_ENABLED), false);
        this.fileReferenceMapSupplier = Suppliers.memoize(this::loadFileReferenceCacheForMemoization);
        this.sharedCacheManager = sharedCacheManager;
        this.sharedCacheKey = sharedCacheKey;
        this.sharedCachePending = sharedCacheManager != null && sharedCacheKey != null;
        this.fieldInfosStorage = new FieldInfosStorage(this);
        this.deferDeleteToCompoundFile = deferDeleteToCompoundFile;
    }

    private void cacheRemovalCallback() {
        this.agilityContext.increment(LuceneEvents.Counts.LUCENE_BLOCK_CACHE_REMOVE);
    }

    private long deserializeFileSequenceCounter(@Nullable byte[] value) {
        return value == null ? 0L : Tuple.fromBytes((byte[])value).getLong(0);
    }

    @Nonnull
    private byte[] serializeFileSequenceCounter(long value) {
        return Tuple.from((Object[])new Object[]{value}).pack();
    }

    @Nonnull
    private CompletableFuture<Void> loadFileSequenceCounter() {
        long originalValue = this.fileSequenceCounter.get();
        if (originalValue >= 0L) {
            return AsyncUtil.DONE;
        }
        return this.agilityContext.get(this.sequenceSubspaceKey).thenAccept(serializedValue -> {
            long loadedValue = this.deserializeFileSequenceCounter((byte[])serializedValue);
            this.fileSequenceCounter.compareAndSet(originalValue, loadedValue);
        });
    }

    public long getIncrement() throws IOException {
        try {
            this.sharedCachePending = false;
            this.sharedCache = null;
            this.agilityContext.increment(LuceneEvents.Counts.LUCENE_GET_INCREMENT_CALLS);
            this.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_GET_INCREMENT, this.loadFileSequenceCounter());
            long incrementedValue = this.fileSequenceCounter.incrementAndGet();
            byte[] serializedValue = this.serializeFileSequenceCounter(incrementedValue);
            this.agilityContext.accept(aContext -> aContext.ensureActive().mutate(MutationType.BYTE_MAX, this.sequenceSubspaceKey, serializedValue));
            return incrementedValue;
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public CompletableFuture<FDBLuceneFileReference> getFDBLuceneFileReferenceAsync(@Nonnull String name) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("getFDBLuceneFileReferenceAsync", new Object[]{LuceneLogMessageKeys.FILE_NAME, name}));
        }
        return this.getFileReferenceCacheAsync().thenApply(cache -> (FDBLuceneFileReference)cache.get(name));
    }

    @Nullable
    @API(value=API.Status.INTERNAL)
    public FDBLuceneFileReference getFDBLuceneFileReference(@Nonnull String name) {
        return this.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_GET_FILE_REFERENCE, this.getFDBLuceneFileReferenceAsync(name));
    }

    public FieldInfosStorage getFieldInfosStorage() {
        return this.fieldInfosStorage;
    }

    public void setFieldInfoId(String filename, long id, ByteString bitSet) {
        FDBLuceneFileReference reference = this.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_GET_FILE_REFERENCE, this.getFDBLuceneFileReferenceAsync(filename));
        if (reference == null) {
            throw new RecordCoreException("Reference not found", new Object[0]).addLogInfo(new Object[]{LuceneLogMessageKeys.FILE_NAME, filename});
        }
        reference.setFieldInfosId(id);
        reference.setFieldInfosBitSet(bitSet);
        this.writeFDBLuceneFileReference(filename, reference);
    }

    void writeFieldInfos(long id, byte[] value) {
        if (id == 0L) {
            throw new RecordCoreArgumentException("FieldInfo id should never be 0", new Object[0]);
        }
        byte[] key = this.fieldInfosSubspace.pack((Object)id);
        this.agilityContext.recordSize(LuceneEvents.SizeEvents.LUCENE_WRITE, key.length + value.length);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("Write lucene stored field infos data", new Object[]{LuceneLogMessageKeys.DATA_SIZE, value.length, LuceneLogMessageKeys.ENCODED_DATA_SIZE, value.length}));
        }
        this.agilityContext.set(key, value);
    }

    Stream<NonnullPair<Long, byte[]>> getAllFieldInfosStream() {
        return ((List)this.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_READ_FIELD_INFOS, this.agilityContext.apply(aContext -> aContext.ensureActive().getRange(this.fieldInfosSubspace.range()).asList()))).stream().map(keyValue -> NonnullPair.of((Object)this.fieldInfosSubspace.unpack(keyValue.getKey()).getLong(0), (Object)keyValue.getValue()));
    }

    public CompletableFuture<Integer> getFieldInfosCount() {
        return this.agilityContext.apply(aContext -> aContext.ensureActive().getRange(this.fieldInfosSubspace.range()).asList()).thenApply(List::size);
    }

    public static boolean isSegmentInfo(String name) {
        return name.endsWith("si") && !name.startsWith("segments") && !name.startsWith("pending_segments");
    }

    public static boolean isCompoundFile(String name) {
        return name.endsWith("cfs") && !name.startsWith("segments") && !name.startsWith("pending_segments");
    }

    public static boolean isEntriesFile(String name) {
        return name.endsWith("cfe") && !name.startsWith("segments") && !name.startsWith("pending_segments");
    }

    public static boolean isFieldInfoFile(String name) {
        return name.endsWith("fip") && !name.startsWith("segments") && !name.startsWith("pending_segments");
    }

    public static boolean isStoredFieldsFile(String name) {
        return name.endsWith("fsf") && !name.startsWith("segments") && !name.startsWith("pending_segments");
    }

    public void writeFDBLuceneFileReference(@Nonnull String name, @Nonnull FDBLuceneFileReference reference) {
        byte[] fileReferenceBytes = reference.getBytes();
        byte[] encodedBytes = Objects.requireNonNull(LuceneSerializer.encode(fileReferenceBytes, this.compressionEnabled, this.encryptionEnabled));
        this.agilityContext.recordSize(LuceneEvents.SizeEvents.LUCENE_WRITE_FILE_REFERENCE, encodedBytes.length);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("Write lucene file reference", new Object[]{LuceneLogMessageKeys.FILE_NAME, name, LuceneLogMessageKeys.DATA_SIZE, fileReferenceBytes.length, LuceneLogMessageKeys.ENCODED_DATA_SIZE, encodedBytes.length, LuceneLogMessageKeys.FILE_REFERENCE, reference}));
        }
        this.agilityContext.set(this.metaSubspace.pack((Object)name), encodedBytes);
        this.getFileReferenceCache().put(name, reference);
        this.fieldInfosStorage.addReference(reference);
    }

    public int writeData(long id, int block, @Nonnull byte[] value) {
        byte[] encodedBytes = Objects.requireNonNull(LuceneSerializer.encode(value, this.compressionEnabled, this.encryptionEnabled));
        this.agilityContext.recordSize(LuceneEvents.SizeEvents.LUCENE_WRITE, encodedBytes.length);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("Write lucene data", new Object[]{LuceneLogMessageKeys.FILE_ID, id, LuceneLogMessageKeys.BLOCK_NUMBER, block, LuceneLogMessageKeys.DATA_SIZE, value.length, LuceneLogMessageKeys.ENCODED_DATA_SIZE, encodedBytes.length}));
        }
        Verify.verify((value.length <= this.blockSize ? 1 : 0) != 0);
        this.agilityContext.set(this.dataSubspace.pack(Tuple.from((Object[])new Object[]{id, block})), encodedBytes);
        return encodedBytes.length;
    }

    public void writeStoredFields(@Nonnull String segmentName, int docID, @Nonnull byte[] value) {
        byte[] key = this.storedFieldsSubspace.pack(Tuple.from((Object[])new Object[]{segmentName, docID}));
        this.agilityContext.recordSize(LuceneEvents.SizeEvents.LUCENE_WRITE_STORED_FIELDS, key.length + value.length);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("Write lucene stored fields data", new Object[]{LuceneLogMessageKeys.DATA_SIZE, value.length, LuceneLogMessageKeys.ENCODED_DATA_SIZE, value.length}));
        }
        this.agilityContext.set(key, value);
    }

    public void deleteStoredFields(@Nonnull String segmentName) throws IOException {
        LucenePrimaryKeySegmentIndex primaryKeyIndex;
        this.agilityContext.increment(LuceneEvents.Counts.LUCENE_DELETE_STORED_FIELDS);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("Delete Stored Fields Data", new Object[]{LuceneLogMessageKeys.RESOURCE, segmentName}));
        }
        if ((primaryKeyIndex = this.getPrimaryKeySegmentIndex()) != null) {
            primaryKeyIndex.clearForSegment(segmentName);
        }
        byte[] key = this.storedFieldsSubspace.pack(Tuple.from((Object[])new Object[]{segmentName}));
        this.agilityContext.clear(Range.startsWith((byte[])key));
    }

    @Nonnull
    @API(value=API.Status.INTERNAL)
    public CompletableFuture<byte[]> readBlock(@Nonnull IndexInput requestingInput, @Nonnull String fileName, @Nonnull CompletableFuture<FDBLuceneFileReference> referenceFuture, int block) {
        return referenceFuture.thenCompose(reference -> this.readBlock(requestingInput, fileName, (FDBLuceneFileReference)reference, block));
    }

    @Nonnull
    private CompletableFuture<byte[]> readBlock(@Nonnull IndexInput requestingInput, @Nonnull String fileName, @Nullable FDBLuceneFileReference reference, int block) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("readBlock", new Object[]{LuceneLogMessageKeys.FILE_NAME, fileName, LuceneLogMessageKeys.FILE_REFERENCE, requestingInput, LuceneLogMessageKeys.BLOCK_NUMBER, block}));
        }
        if (reference == null) {
            CompletableFuture<byte[]> exceptionalFuture = new CompletableFuture<byte[]>();
            exceptionalFuture.completeExceptionally(new RecordCoreArgumentException("No reference with for file name was found", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.EXPECTED, fileName}));
            return exceptionalFuture;
        }
        long id = reference.getId();
        try {
            return this.agilityContext.instrument(LuceneEvents.Events.LUCENE_READ_BLOCK, (CompletableFuture)this.blockCache.get((Object)ComparablePair.of((Comparable)Long.valueOf(id), (Comparable)Integer.valueOf(block)), () -> {
                if (this.sharedCache == null) {
                    return this.readData(id, block);
                }
                byte[] fromShared = this.sharedCache.getBlockIfPresent(id, block);
                if (fromShared != null) {
                    this.agilityContext.increment(LuceneEvents.Counts.LUCENE_SHARED_CACHE_HITS);
                    return CompletableFuture.completedFuture(fromShared);
                }
                this.agilityContext.increment(LuceneEvents.Counts.LUCENE_SHARED_CACHE_MISSES);
                return this.readData(id, block).thenApply(data -> {
                    this.sharedCache.putBlockIfAbsent(id, block, (byte[])data);
                    return data;
                });
            }));
        }
        catch (ExecutionException e) {
            throw new RecordCoreException(CompletionExceptionLogHelper.asCause((ExecutionException)e));
        }
    }

    private CompletableFuture<byte[]> readData(long id, int block) {
        return this.agilityContext.instrument(LuceneEvents.Events.LUCENE_FDB_READ_BLOCK, this.agilityContext.get(this.dataSubspace.pack(Tuple.from((Object[])new Object[]{id, block}))).thenApply(LuceneSerializer::decode));
    }

    @Nonnull
    public byte[] readStoredFields(String segmentName, int docId) throws IOException {
        byte[] key = this.storedFieldsSubspace.pack(Tuple.from((Object[])new Object[]{segmentName, docId}));
        byte[] rawBytes = this.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_GET_STORED_FIELDS, this.agilityContext.instrument(LuceneEvents.Events.LUCENE_READ_STORED_FIELDS, this.agilityContext.get(key)));
        if (rawBytes == null) {
            throw new RecordCoreStorageException("Could not find stored fields").addLogInfo(new Object[]{LuceneLogMessageKeys.SEGMENT, segmentName}).addLogInfo(new Object[]{LuceneLogMessageKeys.DOC_ID, docId}).addLogInfo(new Object[]{LogMessageKeys.KEY, ByteArrayUtil2.loggable((byte[])key)});
        }
        return rawBytes;
    }

    @Nonnull
    public List<KeyValue> readAllStoredFields(String segmentName) {
        Range range = this.storedFieldsSubspace.range(Tuple.from((Object[])new Object[]{segmentName}));
        List<KeyValue> list = this.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_GET_ALL_STORED_FIELDS, this.agilityContext.getRange(range.begin, range.end));
        if (list == null) {
            throw new RecordCoreStorageException("Could not find stored fields").addLogInfo(new Object[]{LuceneLogMessageKeys.SEGMENT, segmentName}).addLogInfo(new Object[]{LogMessageKeys.RANGE_START, ByteArrayUtil2.loggable((byte[])range.begin)}).addLogInfo(new Object[]{LogMessageKeys.RANGE_END, ByteArrayUtil2.loggable((byte[])range.end)});
        }
        return list;
    }

    @Nonnull
    public String[] listAll() throws IOException {
        long startTime = System.nanoTime();
        try {
            String[] stringArray = (String[])this.getFileReferenceCache().keySet().stream().filter(name -> !name.endsWith(".pky")).toArray(String[]::new);
            return stringArray;
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
        finally {
            this.agilityContext.recordEvent(LuceneEvents.Events.LUCENE_LIST_ALL, System.nanoTime() - startTime);
        }
    }

    public CompletableFuture<Collection<String>> listAllAsync() {
        return this.getFileReferenceCacheAsync().thenApply(references -> List.copyOf(references.keySet()));
    }

    @VisibleForTesting
    public CompletableFuture<List<KeyValue>> scanStoredFields(String segmentName) {
        return this.agilityContext.apply(aContext -> aContext.ensureActive().getRange(this.storedFieldsSubspace.subspace(Tuple.from((Object[])new Object[]{segmentName})).range(), 0, false, StreamingMode.ITERATOR).asList());
    }

    private CompletableFuture<Void> loadFileReferenceCacheForMemoization() {
        long start = System.nanoTime();
        ConcurrentSkipListMap outMap = new ConcurrentSkipListMap();
        ConcurrentHashMap fieldInfosCount = new ConcurrentHashMap();
        CompletableFuture rangeList = this.agilityContext.apply(aContext -> aContext.ensureActive().getRange(this.metaSubspace.range(), 0, false, StreamingMode.WANT_ALL).asList());
        CompletionStage future = ((CompletableFuture)rangeList.thenApply(list -> {
            this.agilityContext.recordSize(LuceneEvents.SizeEvents.LUCENE_FILES_COUNT, list.size());
            list.forEach(kv -> {
                String name = this.metaSubspace.unpack(kv.getKey()).getString(0);
                FDBLuceneFileReference fileReference = Objects.requireNonNull(FDBLuceneFileReference.parseFromBytes(LuceneSerializer.decode(kv.getValue())));
                outMap.put(name, fileReference);
                if (fileReference.getFieldInfosId() != 0L) {
                    fieldInfosCount.computeIfAbsent(fileReference.getFieldInfosId(), key -> new AtomicInteger(0)).incrementAndGet();
                }
            });
            return null;
        })).thenAccept(ignore -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this.fileListLog("listAllFiles", outMap).toString());
            }
            this.fileReferenceCache.compareAndSet(null, outMap);
            this.fieldInfosStorage.initializeReferenceCount(fieldInfosCount);
        });
        return this.agilityContext.instrument(LuceneEvents.Events.LUCENE_LOAD_FILE_CACHE, future, start);
    }

    private KeyValueLogMessage fileListLog(String listAllFiles, Map<String, FDBLuceneFileReference> fileMap) {
        ArrayList<String> displayList = new ArrayList<String>(fileMap.size());
        long totalSize = 0L;
        long actualTotalSize = 0L;
        for (Map.Entry<String, FDBLuceneFileReference> entry : fileMap.entrySet()) {
            if (displayList.size() < 200 || entry.getKey().startsWith("segments")) {
                displayList.add(entry.getKey());
            }
            totalSize += entry.getValue().getSize();
            actualTotalSize += entry.getValue().getActualSize();
        }
        if (displayList.size() >= 200) {
            displayList.add("...");
        }
        return this.getKeyValueLogMessage(listAllFiles, new Object[]{LuceneLogMessageKeys.FILE_COUNT, fileMap.size(), LuceneLogMessageKeys.FILE_LIST, displayList, LuceneLogMessageKeys.FILE_TOTAL_SIZE, totalSize, LuceneLogMessageKeys.FILE_ACTUAL_TOTAL_SIZE, actualTotalSize});
    }

    @Nonnull
    @VisibleForTesting
    public CompletableFuture<Map<String, FDBLuceneFileReference>> getFileReferenceCacheAsync() {
        if (this.fileReferenceCache.get() != null) {
            return CompletableFuture.completedFuture((Map)this.fileReferenceCache.get());
        }
        if (this.sharedCachePending) {
            return this.loadFileSequenceCounter().thenCompose(vignore -> {
                this.sharedCache = this.sharedCacheManager.getCache(this.sharedCacheKey, this.fileSequenceCounter.get());
                if (this.sharedCache == null) {
                    this.sharedCachePending = false;
                    return this.getFileReferenceCacheAsync();
                }
                Map<String, FDBLuceneFileReference> fromShared = this.sharedCache.getFileReferencesIfPresent();
                if (fromShared != null) {
                    ConcurrentSkipListMap<String, FDBLuceneFileReference> copy = new ConcurrentSkipListMap<String, FDBLuceneFileReference>(fromShared);
                    this.fileReferenceCache.compareAndSet(null, copy);
                    this.fieldInfosStorage.initializeReferenceCount(this.sharedCache.getFieldInfosReferenceCount());
                    this.sharedCachePending = false;
                    return CompletableFuture.completedFuture(fromShared);
                }
                return this.fileReferenceMapSupplier.get().thenApply(ignore -> {
                    ConcurrentSkipListMap<String, FDBLuceneFileReference> fromSupplier = this.fileReferenceCache.get();
                    this.sharedCache.setFileReferencesIfAbsent(fromSupplier);
                    this.sharedCache.setFieldInfosReferenceCount(this.getFieldInfosStorage().getReferenceCount());
                    this.sharedCachePending = false;
                    return fromSupplier;
                });
            });
        }
        return this.fileReferenceMapSupplier.get().thenApply(ignore -> this.fileReferenceCache.get());
    }

    @Nonnull
    private Map<String, FDBLuceneFileReference> getFileReferenceCache() {
        return Objects.requireNonNull(this.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_LOAD_FILE_CACHE, this.getFileReferenceCacheAsync()));
    }

    public void deleteFile(@Nonnull String name) throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("deleteFile", new Object[]{LuceneLogMessageKeys.FILE_NAME, name}));
        }
        try {
            boolean deleted = this.deleteFileInternal(Objects.requireNonNull(this.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_DELETE_FILE, this.getFileReferenceCacheAsync())), name);
            if (!deleted) {
                throw new NoSuchFileException(name);
            }
            if (FDBDirectory.isCompoundFile(name)) {
                Map cache = this.fileReferenceCache.get();
                String primaryKeyName = name.substring(0, name.length() - "cfs".length()) + "pky";
                this.deleteFileInternal(cache, primaryKeyName);
            }
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
        finally {
            this.agilityContext.increment(LuceneEvents.Counts.LUCENE_DELETE_FILE);
        }
    }

    @VisibleForTesting
    protected boolean deleteFileInternal(@Nonnull Map<String, FDBLuceneFileReference> cache, @Nonnull String name) throws IOException {
        FDBLuceneFileReference fileReference = cache.remove(name);
        if (fileReference == null) {
            return false;
        }
        long id = fileReference.getFieldInfosId();
        if (this.fieldInfosStorage.delete(id)) {
            this.agilityContext.clear(this.fieldInfosSubspace.pack((Object)id));
        }
        this.agilityContext.clear(this.dataSubspace.subspace(Tuple.from((Object[])new Object[]{fileReference.getId()})).range());
        String segmentName = IndexFileNames.parseSegmentName((String)name);
        if (this.deferDeleteToCompoundFile) {
            if (FDBDirectory.isCompoundFile(name) && this.usesOptimizedStoredFields()) {
                this.deleteStoredFields(segmentName);
            }
        } else if (FDBDirectory.isStoredFieldsFile(name)) {
            this.deleteStoredFields(segmentName);
        }
        this.agilityContext.clear(this.metaSubspace.pack((Object)name));
        return true;
    }

    public boolean usesOptimizedStoredFields() {
        return this.getBooleanIndexOption("optimizedStoredFieldsFormatEnabled", false) || this.getBooleanIndexOption("primaryKeySegmentIndexV2Enabled", false);
    }

    public long fileLength(@Nonnull String name) throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("fileLength", new Object[]{LuceneLogMessageKeys.FILE_NAME, name}));
        }
        long startTime = System.nanoTime();
        try {
            FDBLuceneFileReference reference = this.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_FILE_LENGTH, this.getFDBLuceneFileReferenceAsync(name));
            if (reference == null) {
                throw new NoSuchFileException(name);
            }
            long l = reference.getSize();
            return l;
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
        finally {
            this.agilityContext.recordEvent(LuceneEvents.Events.LUCENE_GET_FILE_LENGTH, System.nanoTime() - startTime);
        }
    }

    @Nonnull
    public IndexOutput createOutput(@Nonnull String name, @Nullable IOContext ioContext) throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("createOutput", new Object[]{LuceneLogMessageKeys.FILE_NAME, name}));
        }
        long startTime = System.nanoTime();
        try {
            if (FDBDirectory.isSegmentInfo(name) || FDBDirectory.isEntriesFile(name)) {
                long id = this.getIncrement();
                ByteBuffersIndexOutput byteBuffersIndexOutput = new ByteBuffersIndexOutput(new ByteBuffersDataOutput(), name, name, (Checksum)new CRC32(), dataOutput -> {
                    byte[] content = dataOutput.toArrayCopy();
                    this.writeFDBLuceneFileReference(name, new FDBLuceneFileReference(id, content));
                });
                return byteBuffersIndexOutput;
            }
            if (FDBDirectory.isFieldInfoFile(name)) {
                EmptyIndexOutput id = new EmptyIndexOutput(name, name, this);
                return id;
            }
            FDBIndexOutput id = new FDBIndexOutput(name, name, this);
            return id;
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
        finally {
            this.agilityContext.recordEvent((StoreTimer.Event)LuceneEvents.Waits.WAIT_LUCENE_CREATE_OUTPUT, System.nanoTime() - startTime);
        }
    }

    @Nonnull
    public IndexOutput createTempOutput(@Nonnull String prefix, @Nonnull String suffix, @Nonnull IOContext ioContext) throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("createTempOutput", new Object[]{LuceneLogMessageKeys.FILE_PREFIX, prefix, LuceneLogMessageKeys.FILE_SUFFIX, suffix}));
        }
        return this.createOutput(FDBDirectory.getTempFileName(prefix, suffix, this.nextTempFileCounter.getAndIncrement()), ioContext);
    }

    @Nonnull
    protected static String getTempFileName(@Nonnull String prefix, @Nonnull String suffix, long counter) {
        return IndexFileNames.segmentFileName((String)prefix, (String)(suffix + "_" + Long.toString(counter, 36)), (String)"tmp");
    }

    public void sync(@Nonnull Collection<String> collection) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("sync", new Object[]{LuceneLogMessageKeys.FILE_NAME, String.join((CharSequence)", ", collection)}));
        }
    }

    public void syncMetaData() throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("syncMetaData", new Object[0]));
        }
    }

    public void rename(@Nonnull String source, @Nonnull String dest) throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("rename", new Object[]{LogMessageKeys.SOURCE_FILE, source, LuceneLogMessageKeys.DEST_FILE, dest}));
        }
        try {
            byte[] key = this.metaSubspace.pack((Object)source);
            this.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_RENAME, (CompletableFuture)this.getFileReferenceCacheAsync().thenApply(cache -> {
                FDBLuceneFileReference value = (FDBLuceneFileReference)cache.get(source);
                if (value == null) {
                    throw new RecordCoreArgumentException("Invalid source name in rename function for source", new Object[0]).addLogInfo(new Object[]{LogMessageKeys.SOURCE_FILE, source}).addLogInfo(new Object[]{LogMessageKeys.INDEX_TYPE, "lucene"}).addLogInfo(new Object[]{LogMessageKeys.SUBSPACE, this.subspace}).addLogInfo(new Object[]{LuceneLogMessageKeys.COMPRESSION_SUPPOSED, this.compressionEnabled}).addLogInfo(new Object[]{LuceneLogMessageKeys.ENCRYPTION_SUPPOSED, this.encryptionEnabled});
                }
                byte[] encodedBytes = LuceneSerializer.encode(value.getBytes(), this.compressionEnabled, this.encryptionEnabled);
                this.agilityContext.set(this.metaSubspace.pack((Object)dest), encodedBytes);
                this.agilityContext.clear(key);
                cache.remove(source);
                cache.put(dest, value);
                return null;
            }));
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
        finally {
            this.agilityContext.increment(LuceneEvents.Counts.LUCENE_RENAME_FILE);
        }
    }

    @Nonnull
    public IndexInput openInput(@Nonnull String name, @Nonnull IOContext ioContext) throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("openInput", new Object[]{LuceneLogMessageKeys.FILE_NAME, name}));
        }
        try {
            if (FDBDirectory.isSegmentInfo(name) || FDBDirectory.isEntriesFile(name)) {
                FDBLuceneFileReference reference = this.getFDBLuceneFileReference(name);
                if (reference.getContent().isEmpty()) {
                    throw new RecordCoreException("File content is not stored in reference", new Object[0]).addLogInfo(new Object[]{LuceneLogMessageKeys.FILE_NAME, name});
                }
                return new ByteBuffersIndexInput(new ByteBuffersDataInput(reference.getContent().asReadOnlyByteBufferList()), name);
            }
            if (FDBDirectory.isFieldInfoFile(name) || FDBDirectory.isStoredFieldsFile(name)) {
                return new EmptyIndexInput(name);
            }
            return new FDBIndexInput(name, this);
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    @Nonnull
    public Lock obtainLock(@Nonnull String lockName) throws IOException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("obtainLock", new Object[]{LuceneLogMessageKeys.LOCK_NAME, lockName}));
        }
        Lock lock = this.lockFactory.obtainLock(null, lockName);
        this.lastLock = (FDBDirectoryLockFactory.FDBDirectoryLock)lock;
        return lock;
    }

    private void clearLockIfLocked() {
        if (this.lastLock != null) {
            this.lastLock.fileLockClearIfLocked();
        }
    }

    public void close() throws IOException {
        try {
            this.clearLockIfLocked();
            this.agilityContext.flush();
        }
        catch (RecordCoreException ex) {
            this.agilityContext.abortAndClose();
            this.clearLockIfLocked();
            throw LuceneExceptions.toIoException(ex, null);
        }
        catch (RuntimeException ex) {
            this.agilityContext.abortAndClose();
            this.clearLockIfLocked();
            throw ex;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.fileListLog("Closed FDBDirectory", Objects.requireNonNullElse((Map)this.fileReferenceCache.get(), Map.of())).addKeyAndValue((Object)LuceneLogMessageKeys.BLOCK_CACHE_STATS, (Object)this.blockCache.stats()).toString());
        }
    }

    @Nonnull
    public Set<String> getPendingDeletions() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(this.getLogMessage("getPendingDeletions", new Object[0]));
        }
        return Collections.emptySet();
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    @VisibleForTesting
    FDBRecordContext getCallerContext() {
        return this.agilityContext.getCallerContext();
    }

    public AgilityContext getAgilityContext() {
        return this.agilityContext;
    }

    @Nullable
    public <T> T asyncToSync(@Nonnull StoreTimer.Wait event, @Nonnull CompletableFuture<T> async) {
        return this.agilityContext.asyncToSync(event, async);
    }

    public Subspace getSubspace() {
        return this.subspace;
    }

    @Nonnull
    private String getLogMessage(@Nonnull String staticMsg, Object ... keysAndValues) {
        return this.getKeyValueLogMessage(staticMsg, keysAndValues).toString();
    }

    private KeyValueLogMessage getKeyValueLogMessage(@Nonnull String staticMsg, Object ... keysAndValues) {
        return KeyValueLogMessage.build((String)staticMsg, (Object[])keysAndValues).addKeyAndValue((Object)LogMessageKeys.SUBSPACE, (Object)this.subspace).addKeyAndValue((Object)LuceneLogMessageKeys.COMPRESSION_SUPPOSED, (Object)this.compressionEnabled).addKeyAndValue((Object)LuceneLogMessageKeys.ENCRYPTION_SUPPOSED, (Object)this.encryptionEnabled);
    }

    public ChecksumIndexInput openChecksumInput(String name, IOContext context) throws IOException {
        return new PrefetchableBufferedChecksumIndexInput(this.openInput(name, context));
    }

    Cache<ComparablePair<Long, Integer>, CompletableFuture<byte[]>> getBlockCache() {
        return this.blockCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LucenePrimaryKeySegmentIndex getPrimaryKeySegmentIndex() {
        if (this.getBooleanIndexOption("primaryKeySegmentIndexEnabled", false)) {
            FDBDirectory fDBDirectory = this;
            synchronized (fDBDirectory) {
                if (this.primaryKeySegmentIndex == null) {
                    Subspace primaryKeySubspace = this.subspace.subspace(Tuple.from((Object[])new Object[]{4}));
                    this.primaryKeySegmentIndex = new LucenePrimaryKeySegmentIndexV1(this, primaryKeySubspace);
                }
            }
            return this.primaryKeySegmentIndex;
        }
        if (this.getBooleanIndexOption("primaryKeySegmentIndexV2Enabled", false)) {
            FDBDirectory fDBDirectory = this;
            synchronized (fDBDirectory) {
                if (this.primaryKeySegmentIndex == null) {
                    Subspace primaryKeySubspace = this.subspace.subspace(Tuple.from((Object[])new Object[]{4}));
                    this.primaryKeySegmentIndex = new LucenePrimaryKeySegmentIndexV2(this, primaryKeySubspace);
                }
            }
            return this.primaryKeySegmentIndex;
        }
        return null;
    }

    public long primaryKeySegmentId(@Nonnull String segmentName, boolean create) throws IOException {
        try {
            String fileName = IndexFileNames.segmentFileName((String)segmentName, (String)"", (String)"pky");
            FDBLuceneFileReference ref = this.getFDBLuceneFileReference(fileName);
            if (ref == null) {
                if (!create) {
                    throw new NoSuchFileException(segmentName);
                }
                ref = new FDBLuceneFileReference(this.getIncrement(), 0L, 0L, 0L);
                this.writeFDBLuceneFileReference(fileName, ref);
            }
            return ref.getId();
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    byte[] fileLockKey(String lockName) {
        return this.fileLockSubspace.pack(Tuple.from((Object[])new Object[]{lockName}));
    }

    @Nullable
    public String primaryKeySegmentName(long segmentId) {
        for (Map.Entry<String, FDBLuceneFileReference> entry : this.getFileReferenceCache().entrySet()) {
            if (entry.getValue().getId() != segmentId) continue;
            String fileName = entry.getKey();
            if (!fileName.endsWith(".pky")) {
                throw new IllegalArgumentException("Given segment id is not for a pky file: " + fileName);
            }
            return fileName.substring(0, fileName.length() - 4);
        }
        return null;
    }

    public boolean getBooleanIndexOption(@Nonnull String key, boolean defaultValue) {
        String option = this.getIndexOption(key);
        if (option == null) {
            return defaultValue;
        }
        return Boolean.valueOf(option);
    }

    @Nullable
    public String getIndexOption(@Nonnull String key) {
        return this.indexOptions.get(key);
    }
}

