/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LucenePrimaryKeySegmentIndexV1;
import com.apple.foundationdb.record.lucene.LuceneStoredFieldsProto;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.Accountable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneOptimizedStoredFieldsReader
extends StoredFieldsReader
implements LucenePrimaryKeySegmentIndexV1.StoredFieldsReaderSegmentInfo {
    private static final Logger LOG = LoggerFactory.getLogger(LuceneOptimizedStoredFieldsReader.class);
    private final FDBDirectory directory;
    private final SegmentInfo si;
    private final FieldInfos fieldInfos;
    private final String segmentName;

    public LuceneOptimizedStoredFieldsReader(FDBDirectory directory, SegmentInfo si, FieldInfos fieldInfos) {
        this.si = si;
        this.fieldInfos = fieldInfos;
        this.directory = directory;
        this.segmentName = si.name;
    }

    public static List<byte[]> getPrimaryKeys(String segmentName, FDBDirectory directory) throws IOException {
        try {
            List<KeyValue> rawStoredFields = directory.readAllStoredFields(segmentName);
            ArrayList<byte[]> primaryKeys = new ArrayList<byte[]>();
            for (KeyValue rawStoredField : rawStoredFields) {
                LuceneStoredFieldsProto.LuceneStoredFields storedFields = LuceneStoredFieldsProto.LuceneStoredFields.parseFrom(rawStoredField.getValue());
                primaryKeys.add(storedFields.getPrimaryKey().toByteArray());
            }
            return primaryKeys;
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    public void visitDocument(int docID, StoredFieldVisitor visitor) throws IOException {
        try {
            byte[] rawStoredFields = this.directory.readStoredFields(this.segmentName, docID);
            List<LuceneStoredFieldsProto.StoredField> storedFieldList = LuceneStoredFieldsProto.LuceneStoredFields.parseFrom(rawStoredFields).getStoredFieldsList();
            block7: for (LuceneStoredFieldsProto.StoredField storedField : storedFieldList) {
                FieldInfo info = this.fieldInfos.fieldInfo(storedField.getFieldNumber());
                switch (visitor.needsField(info)) {
                    case YES: {
                        if (storedField.hasBytesValue()) {
                            visitor.binaryField(info, storedField.getBytesValue().toByteArray());
                            continue block7;
                        }
                        if (storedField.hasStringValue()) {
                            visitor.stringField(info, storedField.getStringValueBytes().toByteArray());
                            continue block7;
                        }
                        if (storedField.hasIntValue()) {
                            visitor.intField(info, storedField.getIntValue());
                            continue block7;
                        }
                        if (storedField.hasFloatValue()) {
                            visitor.floatField(info, storedField.getFloatValue());
                            continue block7;
                        }
                        if (storedField.hasLongValue()) {
                            visitor.longField(info, storedField.getLongValue());
                            continue block7;
                        }
                        if (storedField.hasDoubleValue()) {
                            visitor.doubleField(info, storedField.getDoubleValue());
                            continue block7;
                        }
                        throw new IOException("empty stored field, not supported: " + String.valueOf(storedField));
                    }
                    case NO: {
                        continue block7;
                    }
                    case STOP: {
                        return;
                    }
                }
                throw new IllegalStateException("Unexpected value: " + String.valueOf(visitor.needsField(info)));
            }
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    @SpotBugsSuppressWarnings(value={"CN"})
    public LuceneOptimizedStoredFieldsReader clone() {
        return new LuceneOptimizedStoredFieldsReader(this.directory, this.si, this.fieldInfos);
    }

    public void checkIntegrity() throws IOException {
    }

    public void close() throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("close");
        }
    }

    public long ramBytesUsed() {
        return 1024L;
    }

    public Collection<Accountable> getChildResources() {
        return super.getChildResources();
    }

    public String toString() {
        return this.si.name;
    }

    @Override
    public SegmentInfo getSegmentInfo() {
        return this.si;
    }
}

