/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerCombinationProvider;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerRegistryImpl;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerType;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneQueryType;
import com.apple.foundationdb.record.lucene.search.LuceneQueryParserFactory;
import com.apple.foundationdb.record.lucene.search.LuceneQueryParserFactoryProvider;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.PointsConfig;

@API(value=API.Status.UNSTABLE)
public class LuceneQuerySearchClause
extends LuceneQueryClause {
    public static final LuceneQueryClause MATCH_ALL_DOCS_QUERY = new LuceneQuerySearchClause(LuceneQueryType.QUERY, "*:*", false);
    @Nonnull
    private final String defaultField;
    @Nonnull
    private final String search;
    private final boolean isParameter;

    public LuceneQuerySearchClause(@Nonnull LuceneQueryType queryType, @Nonnull String search, boolean isParameter) {
        this(queryType, "_s", search, isParameter);
    }

    public LuceneQuerySearchClause(@Nonnull LuceneQueryType queryType, @Nonnull String defaultField, @Nonnull String search, boolean isParameter) {
        super(queryType);
        this.defaultField = defaultField;
        this.search = search;
        this.isParameter = isParameter;
    }

    @Nonnull
    public String getDefaultField() {
        return this.defaultField;
    }

    @Nonnull
    public String getSearch() {
        return this.search;
    }

    public boolean isParameter() {
        return this.isParameter;
    }

    @Override
    public LuceneQueryClause.BoundQuery bind(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, @Nonnull EvaluationContext context) {
        Map<String, LuceneIndexExpressions.DocumentFieldDerivation> fieldInfos = LuceneIndexExpressions.getDocumentFieldDerivations(index, store.getRecordMetaData());
        LuceneAnalyzerCombinationProvider analyzerSelector = LuceneAnalyzerRegistryImpl.instance().getLuceneAnalyzerCombinationProvider(index, LuceneAnalyzerType.FULL_TEXT, fieldInfos);
        String searchString = this.isParameter ? (String)context.getBinding(this.search) : this.search;
        Map<String, PointsConfig> pointsConfigMap = LuceneIndexExpressions.constructPointConfigMap(store, index);
        LuceneQueryParserFactory parserFactory = LuceneQueryParserFactoryProvider.instance().getParserFactory();
        QueryParser parser = parserFactory.createQueryParser(this.defaultField, analyzerSelector.provideQueryAnalyzer().getAnalyzer(), pointsConfigMap);
        try {
            return this.toBoundQuery(parser.parse(searchString));
        }
        catch (Exception ioe) {
            throw new RecordCoreException("Unable to parse search given for query", (Throwable)ioe);
        }
    }

    @Override
    public void getPlannerGraphDetails(@Nonnull ImmutableList.Builder<String> detailsBuilder, @Nonnull ImmutableMap.Builder<String, Attribute> attributeMapBuilder) {
        if (!"_s".equals(this.defaultField)) {
            detailsBuilder.add((Object)"field: {{field}}");
            attributeMapBuilder.put((Object)"field", (Object)Attribute.gml((Object)this.defaultField));
        }
        if (this.isParameter) {
            detailsBuilder.add((Object)"param: {{param}}");
            attributeMapBuilder.put((Object)"param", (Object)Attribute.gml((Object)this.search));
        } else {
            detailsBuilder.add((Object)"search: {{search}}");
            attributeMapBuilder.put((Object)"search", (Object)Attribute.gml((Object)this.search));
        }
    }

    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.objectsPlanHash((PlanHashable.PlanHashMode)mode, (Object[])new Object[]{this.defaultField, this.search, this.isParameter});
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        if (!"_s".equals(this.defaultField)) {
            str.append(this.defaultField).append(":");
        }
        if (this.isParameter) {
            str.append("$");
        }
        str.append(this.search);
        return str.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LuceneQuerySearchClause that = (LuceneQuerySearchClause)o;
        if (this.isParameter != that.isParameter) {
            return false;
        }
        if (!this.defaultField.equals(that.defaultField)) {
            return false;
        }
        return this.search.equals(that.search);
    }

    public int hashCode() {
        int result = this.defaultField.hashCode();
        result = 31 * result + this.search.hashCode();
        result = 31 * result + (this.isParameter ? 1 : 0);
        return result;
    }
}

