/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class LuceneIndexOptions {
    public static final String DELIMITER_BETWEEN_KEY_AND_VALUE = ":";
    public static final String DELIMITER_BETWEEN_ELEMENTS = ",";
    public static final String NGRAM_TOKEN_EDGES_ONLY = "ngramTokenEdgesOnly";
    public static final String LUCENE_ANALYZER_NAME_OPTION = "luceneAnalyzerName";
    public static final String LUCENE_ANALYZER_NAME_PER_FIELD_OPTION = "luceneAnalyzerNamePerField";
    public static final String AUTO_COMPLETE_ANALYZER_NAME_OPTION = "autoCompleteAnalyzerName";
    public static final String AUTO_COMPLETE_ANALYZER_NAME_PER_FIELD_OPTION = "autoCompleteAnalyzerNamePerField";
    public static final String TEXT_SYNONYM_SET_NAME_OPTION = "textSynonymSetName";
    public static final String PRIMARY_KEY_SERIALIZATION_FORMAT = "primaryKeySerializationFormat";
    public static final String PRIMARY_KEY_SEGMENT_INDEX_ENABLED = "primaryKeySegmentIndexEnabled";
    public static final String OPTIMIZED_STORED_FIELDS_FORMAT_ENABLED = "optimizedStoredFieldsFormatEnabled";
    public static final String INDEX_PARTITION_BY_FIELD_NAME = "partitionFieldName";
    public static final String INDEX_PARTITION_HIGH_WATERMARK = "partitionHighWatermark";
    public static final String INDEX_PARTITION_LOW_WATERMARK = "partitionLowWatermark";
    public static final String PRIMARY_KEY_SEGMENT_INDEX_V2_ENABLED = "primaryKeySegmentIndexV2Enabled";

    private LuceneIndexOptions() {
    }

    public static Map<String, String> parseKeyValuePairOptionValue(@Nonnull String optionValue) {
        String[] elements = optionValue.strip().split(DELIMITER_BETWEEN_ELEMENTS);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String element : elements) {
            String[] keyValuePair = element.split(DELIMITER_BETWEEN_KEY_AND_VALUE);
            String key = keyValuePair[0].strip();
            String value = keyValuePair[1].strip();
            map.put(key, value);
        }
        return map;
    }

    public static Set<String> parseMultipleElementsOptionValue(@Nonnull String optionValue) {
        String[] elements = optionValue.strip().split(DELIMITER_BETWEEN_ELEMENTS);
        HashSet<String> list = new HashSet<String>();
        for (String fieldName : elements) {
            list.add(fieldName.strip());
        }
        return list;
    }

    public static void validateKeyValuePairOptionValue(@Nonnull String optionValue, @Nonnull RecordCoreException exceptionToThrow) {
        String[] keyValuePairs;
        if ((optionValue = optionValue.strip()).startsWith(DELIMITER_BETWEEN_ELEMENTS) || optionValue.endsWith(DELIMITER_BETWEEN_ELEMENTS)) {
            throw exceptionToThrow;
        }
        for (String rawString : keyValuePairs = optionValue.split(DELIMITER_BETWEEN_ELEMENTS)) {
            String keyValue = rawString.strip();
            int firstIndex = keyValue.indexOf(DELIMITER_BETWEEN_KEY_AND_VALUE);
            if (!keyValue.isEmpty() && firstIndex >= 1 && firstIndex <= keyValue.length() - 2 && firstIndex == keyValue.lastIndexOf(DELIMITER_BETWEEN_KEY_AND_VALUE)) continue;
            throw exceptionToThrow;
        }
    }

    public static void validateMultipleElementsOptionValue(@Nonnull String optionValue, @Nonnull RecordCoreException exceptionToThrow) {
        String[] fieldNames;
        if ((optionValue = optionValue.strip()).startsWith(DELIMITER_BETWEEN_ELEMENTS) || optionValue.endsWith(DELIMITER_BETWEEN_ELEMENTS) || optionValue.contains(DELIMITER_BETWEEN_KEY_AND_VALUE)) {
            throw exceptionToThrow;
        }
        for (String rawString : fieldNames = optionValue.split(DELIMITER_BETWEEN_ELEMENTS)) {
            if (!rawString.isBlank()) continue;
            throw exceptionToThrow;
        }
    }
}

