/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryLockFactory;
import com.apple.foundationdb.record.provider.foundationdb.FDBExceptions;
import com.apple.foundationdb.util.LoggableKeysAndValues;
import java.io.IOException;
import org.apache.lucene.store.LockObtainFailedException;

public class LuceneExceptions {
    public static RuntimeException toRecordCoreException(String message, IOException ex, Object ... additionalLogInfo) {
        if (ex instanceof LockObtainFailedException) {
            return new FDBExceptions.FDBStoreLockTakenException(message + ": " + ex.getMessage(), (Exception)ex).addLogInfo(additionalLogInfo);
        }
        if (ex instanceof LuceneTransactionTooOldException) {
            Throwable cause = ex.getCause();
            if (cause instanceof FDBExceptions.FDBStoreTransactionIsTooOldException) {
                FDBExceptions.FDBStoreTransactionIsTooOldException transactionIsTooOldException = (FDBExceptions.FDBStoreTransactionIsTooOldException)cause;
                transactionIsTooOldException.addSuppressed((Throwable)ex);
                return transactionIsTooOldException;
            }
            RecordCoreException result = new FDBExceptions.FDBStoreTransactionIsTooOldException(message + ": " + ex.getMessage(), null).addLogInfo(additionalLogInfo);
            result.addSuppressed((Throwable)ex);
            return result;
        }
        if (ex.getCause() instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)ex.getCause();
            runtimeException.addSuppressed(ex);
            if (runtimeException instanceof LoggableKeysAndValues) {
                ((LoggableKeysAndValues)runtimeException).addLogInfo(additionalLogInfo);
            }
            return runtimeException;
        }
        return new RecordCoreException(message + ": " + ex.getMessage(), (Throwable)ex).addLogInfo(additionalLogInfo);
    }

    public static IOException toIoException(Throwable ex, Throwable suppressed) {
        Object result = ex instanceof FDBExceptions.FDBStoreTransactionIsTooOldException ? new LuceneTransactionTooOldException((FDBExceptions.FDBStoreTransactionIsTooOldException)ex) : (ex instanceof FDBDirectoryLockFactory.FDBDirectoryLockException ? new LockObtainFailedException(ex.getMessage(), ex) : (ex instanceof IOException ? (IOException)ex : new IOException(ex)));
        if (suppressed != null) {
            ((Throwable)result).addSuppressed(suppressed);
        }
        return result;
    }

    private LuceneExceptions() {
    }

    public static class LuceneTransactionTooOldException
    extends IOException {
        private static final long serialVersionUID = -1L;

        public LuceneTransactionTooOldException(String message) {
            super(message);
        }

        public LuceneTransactionTooOldException(FDBExceptions.FDBStoreTransactionIsTooOldException cause) {
            super((Throwable)cause);
        }

        public LuceneTransactionTooOldException(String message, FDBExceptions.FDBStoreTransactionIsTooOldException cause) {
            super(message, (Throwable)cause);
        }
    }
}

