/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class LuceneEvents {
    private LuceneEvents() {
    }

    public static enum SizeEvents implements StoreTimer.SizeEvent
    {
        LUCENE_WRITE_FILE_REFERENCE("lucene write file references"),
        LUCENE_WRITE("lucene index writes", true),
        LUCENE_WRITE_STORED_FIELDS("lucene write stored fields"),
        LUCENE_REBALANCE_PARTITION_DOCS("lucene rebalance partition count"),
        LUCENE_FILES_COUNT("lucene files");

        private final String title;
        private final boolean delayedUntilCommit;

        private SizeEvents(String title) {
            this(title, false);
        }

        private SizeEvents(String title, boolean delayedUntilCommit) {
            this.title = title;
            this.delayedUntilCommit = delayedUntilCommit;
        }

        public String title() {
            return this.title;
        }

        public boolean isDelayedUntilCommit() {
            return this.delayedUntilCommit;
        }
    }

    public static enum Counts implements StoreTimer.Count
    {
        LUCENE_GET_INCREMENT_CALLS("lucene increments", false),
        LUCENE_BLOCK_READS("lucene block reads", false),
        LUCENE_SCAN_MATCHED_DOCUMENTS("lucene scan matched documents", false),
        LUCENE_SCAN_MATCHED_AUTO_COMPLETE_SUGGESTIONS("lucene scan matched auto complete suggestions", false),
        LUCENE_SCAN_SPELLCHECKER_SUGGESTIONS("lucene scan matched spellchecker suggestions", false),
        LUCENE_SHARED_CACHE_HITS("lucene shared cache hits", false),
        LUCENE_SHARED_CACHE_MISSES("lucene shared cache misses", false),
        PLAN_HIGHLIGHT_TERMS("lucene highlight plans", false),
        LUCENE_DELETE_FILE("lucene delete file", false),
        LUCENE_RENAME_FILE("lucene rename file", false),
        LUCENE_MERGE_DOCUMENTS("lucene merge document", false),
        LUCENE_MERGE_SEGMENTS("lucene merge segment", false),
        LUCENE_DELETE_STORED_FIELDS("lucene delete stored fields", false),
        LUCENE_AGILE_COMMITS_SIZE_QUOTA("lucene agile commits size quota", false),
        LUCENE_AGILE_COMMITS_TIME_QUOTA("lucene agile commits time quota", false),
        LUCENE_REPARTITION_CALLS("Count of Lucene repartition calls", false),
        LUCENE_BLOCK_CACHE_REMOVE("Count of blocks removed from cache", false);

        private final String title;
        private final boolean isSize;
        private final String logKey;
        private final boolean delayedUntilCommit;

        private Counts(String title, boolean isSize, String logKey, boolean delayedUntilCommit) {
            this.title = title;
            this.isSize = isSize;
            this.logKey = logKey != null ? logKey : super.logKey();
            this.delayedUntilCommit = delayedUntilCommit;
        }

        private Counts(String title, boolean isSize) {
            this(title, isSize, null, false);
        }

        public String title() {
            return this.title;
        }

        @Nonnull
        public String logKey() {
            return this.logKey;
        }

        public boolean isDelayedUntilCommit() {
            return this.delayedUntilCommit;
        }

        public boolean isSize() {
            return this.isSize;
        }
    }

    public static enum Waits implements StoreTimer.Wait
    {
        WAIT_LUCENE_DELETE_FILE("lucene delete file"),
        WAIT_LUCENE_FILE_LENGTH("lucene file length"),
        WAIT_LUCENE_RENAME("lucene rename"),
        WAIT_LUCENE_GET_INCREMENT("lucene file counter increment"),
        WAIT_LUCENE_GET_FILE_REFERENCE("lucene get file reference"),
        WAIT_LUCENE_GET_SCHEMA("lucene get schema"),
        WAIT_LUCENE_GET_ALL_STORED_FIELDS("lucene get stored all fields"),
        WAIT_LUCENE_GET_STORED_FIELDS("lucene get stored fields"),
        WAIT_LUCENE_GET_DATA_BLOCK("lucene get data block"),
        WAIT_LUCENE_LOAD_FILE_CACHE("lucene load file cache"),
        WAIT_LUCENE_CREATE_OUTPUT("lucene create output"),
        WAIT_LUCENE_FIND_PRIMARY_KEY("lucene find primary key"),
        WAIT_LUCENE_READ_FIELD_INFOS("lucene read field infos"),
        WAIT_LUCENE_FILE_LOCK_SET("lucene set file lock"),
        WAIT_LUCENE_FILE_LOCK_GET("lucene get file lock"),
        WAIT_LUCENE_FILE_LOCK_CLEAR("lucene clear file lock");

        private final String title;
        private final String logKey;

        private Waits(String title, String logKey) {
            this.title = title;
            this.logKey = logKey != null ? logKey : super.logKey();
        }

        private Waits(String title) {
            this(title, null);
        }

        public String title() {
            return this.title;
        }

        @Nonnull
        public String logKey() {
            return this.logKey;
        }
    }

    public static final class DetailEvents
    extends Enum<DetailEvents>
    implements StoreTimer.DetailEvent {
        private final String title;
        private final String logKey;
        private static final /* synthetic */ DetailEvents[] $VALUES;

        public static DetailEvents[] values() {
            return (DetailEvents[])$VALUES.clone();
        }

        public static DetailEvents valueOf(String name) {
            return Enum.valueOf(DetailEvents.class, name);
        }

        private DetailEvents(String title, String logKey) {
            this.title = title;
            this.logKey = logKey != null ? logKey : super.logKey();
        }

        private DetailEvents(String title) {
            this(title, null);
        }

        public String title() {
            return this.title;
        }

        @Nonnull
        public String logKey() {
            return this.logKey;
        }

        private static /* synthetic */ DetailEvents[] $values() {
            return new DetailEvents[0];
        }

        static {
            $VALUES = DetailEvents.$values();
        }
    }

    public static enum Events implements StoreTimer.Event
    {
        LUCENE_READ_BLOCK("lucene block reads"),
        LUCENE_READ_SCHEMA("lucene schema read"),
        LUCENE_READ_STORED_FIELDS("lucene stored fields read"),
        LUCENE_FDB_READ_BLOCK("lucene read from fdb"),
        LUCENE_LIST_ALL("lucene list all"),
        LUCENE_LOAD_FILE_CACHE("lucene load file cache"),
        LUCENE_GET_FILE_LENGTH("lucene get file length"),
        LUCENE_INDEX_SCAN("lucene search returned documents"),
        LUCENE_AUTO_COMPLETE_SUGGESTIONS_SCAN("lucene search returned auto complete suggestions"),
        LUCENE_SPELLCHECK_SCAN("lucene search returned spellcheck suggestions"),
        LUCENE_ADD_DOCUMENT("lucene add document"),
        LUCENE_DELETE_DOCUMENT_BY_QUERY("lucene delete document by query"),
        LUCENE_DELETE_DOCUMENT_BY_QUERY_IN_WRITE_ONLY_MODE("lucene delete document by query in WRITE_ONLY mode"),
        LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY("lucene delete document by primary key"),
        LUCENE_MERGE("Lucene merge"),
        LUCENE_FIND_MERGES("Lucene find merges"),
        LUCENE_REBALANCE_PARTITION_TRANSACTION("Lucene rebalance partition transaction"),
        LUCENE_REBALANCE_PARTITION("Lucene rebalance partition"),
        LUCENE_FILE_LOCK_DURATION("Lucene lock duration");

        private final String title;
        private final String logKey;

        private Events(String title, String logKey) {
            this.title = title;
            this.logKey = logKey != null ? logKey : super.logKey();
        }

        private Events(String title) {
            this(title, null);
        }

        public String title() {
            return this.title;
        }

        @Nonnull
        public String logKey() {
            return this.logKey;
        }
    }
}

