/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.PlanHashable;
import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneQueryType;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreBase;
import com.apple.foundationdb.record.query.plan.cascades.explain.Attribute;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;

@API(value=API.Status.UNSTABLE)
public class LuceneBooleanQuery
extends LuceneQueryClause {
    @Nonnull
    private final List<LuceneQueryClause> children;
    @Nonnull
    private final BooleanClause.Occur occur;

    public LuceneBooleanQuery(@Nonnull LuceneQueryType queryType, @Nonnull List<LuceneQueryClause> children, @Nonnull BooleanClause.Occur occur) {
        super(queryType);
        this.children = children;
        this.occur = occur;
    }

    @Nonnull
    protected List<LuceneQueryClause> getChildren() {
        return this.children;
    }

    @Nonnull
    protected BooleanClause.Occur getOccur() {
        return this.occur;
    }

    @Override
    public LuceneQueryClause.BoundQuery bind(@Nonnull FDBRecordStoreBase<?> store, @Nonnull Index index, @Nonnull EvaluationContext context) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        HashMap highlightingTermsMap = null;
        for (LuceneQueryClause child : this.children) {
            LuceneQueryClause.BoundQuery childBoundQuery = child.bind(store, index, context);
            builder.add(childBoundQuery.getLuceneQuery(), this.occur);
            Map<String, Set<String>> childHighlightingTermsMap = childBoundQuery.getHighlightingTermsMap();
            if (childHighlightingTermsMap == null) continue;
            if (highlightingTermsMap == null) {
                highlightingTermsMap = Maps.newHashMap();
            }
            LuceneBooleanQuery.combineHighlightingTermsMaps(highlightingTermsMap, childHighlightingTermsMap);
        }
        return new LuceneQueryClause.BoundQuery((Query)builder.build(), highlightingTermsMap);
    }

    @Override
    public void getPlannerGraphDetails(@Nonnull ImmutableList.Builder<String> detailsBuilder, @Nonnull ImmutableMap.Builder<String, Attribute> attributeMapBuilder) {
        detailsBuilder.add((Object)"occur: {{occur}}");
        attributeMapBuilder.put((Object)"occur", (Object)Attribute.gml((Object)this.occur));
        for (LuceneQueryClause child : this.children) {
            child.getPlannerGraphDetails(detailsBuilder, attributeMapBuilder);
        }
    }

    public int planHash(@Nonnull PlanHashable.PlanHashMode mode) {
        return PlanHashable.iterablePlanHash((PlanHashable.PlanHashMode)mode, this.children);
    }

    public String toString() {
        Object op;
        switch (this.occur) {
            case MUST: {
                op = " AND ";
                break;
            }
            case SHOULD: {
                op = " OR ";
                break;
            }
            default: {
                op = " " + this.occur.name() + " ";
            }
        }
        return this.children.stream().map(Objects::toString).collect(Collectors.joining((CharSequence)op));
    }
}

