/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.SpotBugsSuppressWarnings;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.lucene.AnalyzerChooser;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerCombinationProvider;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerFactory;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerRegistry;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerType;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerWrapper;
import com.apple.foundationdb.record.lucene.LuceneIndexExpressions;
import com.apple.foundationdb.record.lucene.LuceneIndexOptions;
import com.apple.foundationdb.record.lucene.LuceneLogMessageKeys;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.MetaDataException;
import com.apple.foundationdb.record.util.ServiceLoaderProvider;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneAnalyzerRegistryImpl
implements LuceneAnalyzerRegistry {
    @Nonnull
    private static final Logger LOGGER = LoggerFactory.getLogger(LuceneAnalyzerRegistryImpl.class);
    @Nonnull
    private static final LuceneAnalyzerRegistryImpl INSTANCE = new LuceneAnalyzerRegistryImpl();
    @Nonnull
    private final Map<LuceneAnalyzerType, Map<String, LuceneAnalyzerFactory>> registry = LuceneAnalyzerRegistryImpl.initRegistry();

    @Nonnull
    private static Map<LuceneAnalyzerType, Map<String, LuceneAnalyzerFactory>> initRegistry() {
        HashMap<LuceneAnalyzerType, Map<String, LuceneAnalyzerFactory>> registry = new HashMap<LuceneAnalyzerType, Map<String, LuceneAnalyzerFactory>>();
        for (LuceneAnalyzerFactory factory : ServiceLoaderProvider.load(LuceneAnalyzerFactory.class)) {
            String name = factory.getName();
            LuceneAnalyzerType type = factory.getType();
            if (registry.containsKey((Object)type) && ((Map)registry.get((Object)type)).containsKey(name)) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(KeyValueLogMessage.of((String)"duplicate lucene analyzer", (Object[])new Object[]{LuceneLogMessageKeys.ANALYZER_NAME, name, LuceneLogMessageKeys.ANALYZER_TYPE, type.name()}));
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(KeyValueLogMessage.of((String)"found lucene analyzer", (Object[])new Object[]{LuceneLogMessageKeys.ANALYZER_NAME, name, LuceneLogMessageKeys.ANALYZER_TYPE, type.name()}));
            }
            registry.putIfAbsent(type, new HashMap());
            ((Map)registry.get((Object)type)).put(name, factory);
        }
        return registry;
    }

    @Nonnull
    @SpotBugsSuppressWarnings(value={"MS_EXPOSE_REP"}, justification="Object is actually immutable")
    public static LuceneAnalyzerRegistry instance() {
        return INSTANCE;
    }

    private LuceneAnalyzerRegistryImpl() {
    }

    @Override
    @Nonnull
    public LuceneAnalyzerCombinationProvider getLuceneAnalyzerCombinationProvider(@Nonnull Index index, @Nonnull LuceneAnalyzerType type, @Nonnull Map<String, LuceneIndexExpressions.DocumentFieldDerivation> auxiliaryFieldInfo) {
        String defaultAnalyzerName = index.getOption(type.getAnalyzerOptionKey());
        String analyzerPerFieldName = index.getOption(type.getAnalyzerPerFieldOptionKey());
        NonnullPair<AnalyzerChooser, AnalyzerChooser> defaultAnalyzerChooserPair = this.getAnalyzerChooser(index, defaultAnalyzerName, type);
        TreeMap<String, AnalyzerChooser> indexAnalyzerChooserPerFieldOverride = new TreeMap<String, AnalyzerChooser>();
        TreeMap<String, AnalyzerChooser> queryAnalyzerChooserPerFieldOverride = new TreeMap<String, AnalyzerChooser>();
        if (analyzerPerFieldName != null) {
            LuceneIndexOptions.parseKeyValuePairOptionValue(analyzerPerFieldName).forEach((fieldName, analyzerName) -> {
                NonnullPair<AnalyzerChooser, AnalyzerChooser> perFieldAnalyzerChooserPair = this.getAnalyzerChooser(index, (String)analyzerName, type);
                indexAnalyzerChooserPerFieldOverride.put((String)fieldName, (AnalyzerChooser)perFieldAnalyzerChooserPair.getLeft());
                queryAnalyzerChooserPerFieldOverride.put((String)fieldName, (AnalyzerChooser)perFieldAnalyzerChooserPair.getRight());
            });
        }
        auxiliaryFieldInfo.forEach((fieldName, fieldInfo) -> {
            this.addPerFieldAnalyzerIfNecessary((Map<String, AnalyzerChooser>)indexAnalyzerChooserPerFieldOverride, (String)fieldName, (LuceneIndexExpressions.DocumentFieldDerivation)fieldInfo, index, type);
            this.addPerFieldAnalyzerIfNecessary((Map<String, AnalyzerChooser>)queryAnalyzerChooserPerFieldOverride, (String)fieldName, (LuceneIndexExpressions.DocumentFieldDerivation)fieldInfo, index, type);
        });
        return new LuceneAnalyzerCombinationProvider((AnalyzerChooser)defaultAnalyzerChooserPair.getLeft(), (AnalyzerChooser)defaultAnalyzerChooserPair.getRight(), indexAnalyzerChooserPerFieldOverride, queryAnalyzerChooserPerFieldOverride);
    }

    private void addPerFieldAnalyzerIfNecessary(@Nonnull Map<String, AnalyzerChooser> chooserPerFieldOverride, @Nonnull String fieldName, @Nonnull LuceneIndexExpressions.DocumentFieldDerivation fieldInfo, @Nonnull Index index, @Nonnull LuceneAnalyzerType type) {
        if (chooserPerFieldOverride.containsKey(fieldName)) {
            return;
        }
        if (type != LuceneAnalyzerType.FULL_TEXT) {
            return;
        }
        if (LuceneAnalyzerRegistryImpl.isEligibleForNoOpAnalyzer(fieldInfo)) {
            if (this.registry.isEmpty() || this.registry.get((Object)type) == null || this.registry.get((Object)type).get("QUERY_ONLY_EXACT_ANALYZER") == null) {
                throw new MetaDataException("could not retrieve analyzer", new Object[]{LuceneLogMessageKeys.ANALYZER_NAME, "QUERY_ONLY_EXACT_ANALYZER", LuceneLogMessageKeys.ANALYZER_TYPE, type});
            }
            chooserPerFieldOverride.put(fieldName, this.registry.get((Object)type).get("QUERY_ONLY_EXACT_ANALYZER").getIndexAnalyzerChooser(index));
        }
    }

    private static boolean isEligibleForNoOpAnalyzer(@Nonnull LuceneIndexExpressions.DocumentFieldDerivation fieldInfo) {
        return fieldInfo.getType() != LuceneIndexExpressions.DocumentFieldType.TEXT;
    }

    private NonnullPair<AnalyzerChooser, AnalyzerChooser> getAnalyzerChooser(@Nonnull Index index, @Nullable String analyzerName, @Nonnull LuceneAnalyzerType type) {
        Map registryForType = Objects.requireNonNullElse(this.registry.get((Object)type), Collections.emptyMap());
        if (analyzerName == null || !registryForType.containsKey(analyzerName)) {
            return NonnullPair.of(LuceneAnalyzerWrapper::getStandardAnalyzerWrapper, LuceneAnalyzerWrapper::getStandardAnalyzerWrapper);
        }
        LuceneAnalyzerFactory analyzerFactory = (LuceneAnalyzerFactory)registryForType.get(analyzerName);
        if (analyzerFactory == null) {
            throw new MetaDataException("unrecognized lucene analyzer for tokenizer", new Object[]{LuceneLogMessageKeys.ANALYZER_NAME, analyzerName, LuceneLogMessageKeys.ANALYZER_TYPE, type.name()});
        }
        AnalyzerChooser indexAnalyzerChooser = analyzerFactory.getIndexAnalyzerChooser(index);
        return NonnullPair.of((Object)indexAnalyzerChooser, (Object)analyzerFactory.getQueryAnalyzerChooser(index, indexAnalyzerChooser));
    }
}

