/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import com.apple.foundationdb.record.lucene.codec.TestFDBDirectory;
import com.apple.foundationdb.record.lucene.codec.TestingCodec;
import com.apple.foundationdb.record.test.FDBDatabaseExtension;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.codecs.compressing.CompressingCodec;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.BaseIndexFileFormatTestCase;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.EmptyDocValuesProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.Version;

public final class BaseIndexFileFormatTestCaseUtils {
    public static final FDBDatabaseExtension dbExtension = new FDBDatabaseExtension();

    private BaseIndexFileFormatTestCaseUtils() {
    }

    public static boolean isUsingFDBDirectory() {
        return System.getProperty("tests.directory", "random").equals(TestFDBDirectory.class.getName());
    }

    @Nonnull
    public static Codec getCodec() {
        if (BaseIndexFileFormatTestCaseUtils.isUsingFDBDirectory()) {
            return new TestingCodec();
        }
        return CompressingCodec.randomInstance((Random)new Random());
    }

    public static void resetStaticConfigs() {
        TestingCodec.reset();
        TestFDBDirectory.reset();
        dbExtension.afterEach(null);
    }

    public static void testMultiClose(BaseIndexFileFormatTestCase testCase) throws IOException {
        Directory oneDocIndex = testCase.applyCreatedVersionMajor((Directory)LuceneTestCase.newDirectory());
        IndexWriter iw = new IndexWriter(oneDocIndex, new IndexWriterConfig((Analyzer)new MockAnalyzer(LuceneTestCase.random())));
        Document oneDoc = new Document();
        FieldType customType = new FieldType((IndexableFieldType)TextField.TYPE_STORED);
        customType.setStoreTermVectors(true);
        Field customField = new Field("field", (CharSequence)"contents", (IndexableFieldType)customType);
        oneDoc.add((IndexableField)customField);
        oneDoc.add((IndexableField)new NumericDocValuesField("field", 5L));
        iw.addDocument((Iterable)oneDoc);
        final LeafReader oneDocReader = LuceneTestCase.getOnlyLeafReader((IndexReader)DirectoryReader.open((IndexWriter)iw));
        iw.close();
        BaseDirectoryWrapper dir = BaseIndexFileFormatTestCaseUtils.isUsingFDBDirectory() ? LuceneTestCase.newDirectory() : LuceneTestCase.newFSDirectory((Path)LuceneTestCase.createTempDir((String)"justSoYouGetSomeChannelErrors"));
        Codec codec = testCase.getCodec();
        SegmentInfo segmentInfo = new SegmentInfo((Directory)dir, Version.LATEST, Version.LATEST, "_0", 1, false, codec, Collections.emptyMap(), StringHelper.randomId(), Collections.emptyMap(), null);
        FieldInfo proto = oneDocReader.getFieldInfos().fieldInfo("field");
        FieldInfo field = new FieldInfo(proto.name, proto.number, proto.hasVectors(), proto.omitsNorms(), proto.hasPayloads(), proto.getIndexOptions(), proto.getDocValuesType(), proto.getDocValuesGen(), new HashMap(), proto.getPointDimensionCount(), proto.getPointIndexDimensionCount(), proto.getPointNumBytes(), proto.isSoftDeletesField());
        FieldInfos fieldInfos = new FieldInfos(new FieldInfo[]{field});
        SegmentWriteState writeState = new SegmentWriteState(null, (Directory)dir, segmentInfo, fieldInfos, null, new IOContext(new FlushInfo(1, 20L)));
        SegmentReadState readState = new SegmentReadState((Directory)dir, segmentInfo, fieldInfos, IOContext.READ);
        NormsProducer fakeNorms = new NormsProducer(){

            public void close() throws IOException {
            }

            public long ramBytesUsed() {
                return 0L;
            }

            public NumericDocValues getNorms(FieldInfo field) throws IOException {
                if (!field.hasNorms()) {
                    return null;
                }
                return oneDocReader.getNormValues(field.name);
            }

            public void checkIntegrity() throws IOException {
            }
        };
        try (FieldsConsumer consumer = codec.postingsFormat().fieldsConsumer(writeState);){
            Fields fields = new Fields(){
                TreeSet<String> indexedFields;
                {
                    this.indexedFields = new TreeSet(FieldInfos.getIndexedFields((IndexReader)oneDocReader));
                }

                public Iterator<String> iterator() {
                    return this.indexedFields.iterator();
                }

                public Terms terms(String field) throws IOException {
                    return oneDocReader.terms(field);
                }

                public int size() {
                    return this.indexedFields.size();
                }
            };
            consumer.write(fields, fakeNorms);
            IOUtils.close((Closeable[])new Closeable[]{consumer});
            IOUtils.close((Closeable[])new Closeable[]{consumer});
        }
        try (FieldsProducer producer = codec.postingsFormat().fieldsProducer(readState);){
            IOUtils.close((Closeable[])new Closeable[]{producer});
            IOUtils.close((Closeable[])new Closeable[]{producer});
        }
        consumer = codec.docValuesFormat().fieldsConsumer(writeState);
        try {
            consumer.addNumericField(field, (DocValuesProducer)new EmptyDocValuesProducer(){

                public NumericDocValues getNumeric(FieldInfo field) {
                    return new NumericDocValues(){
                        int docID = -1;

                        public int docID() {
                            return this.docID;
                        }

                        public int nextDoc() {
                            ++this.docID;
                            if (this.docID == 1) {
                                this.docID = Integer.MAX_VALUE;
                            }
                            return this.docID;
                        }

                        public int advance(int target) {
                            this.docID = this.docID <= 0 && target == 0 ? 0 : Integer.MAX_VALUE;
                            return this.docID;
                        }

                        public boolean advanceExact(int target) throws IOException {
                            this.docID = target;
                            return target == 0;
                        }

                        public long cost() {
                            return 1L;
                        }

                        public long longValue() {
                            return 5L;
                        }
                    };
                }
            });
            IOUtils.close((Closeable[])new Closeable[]{consumer});
            IOUtils.close((Closeable[])new Closeable[]{consumer});
        }
        finally {
            if (consumer != null) {
                consumer.close();
            }
        }
        producer = codec.docValuesFormat().fieldsProducer(readState);
        try {
            IOUtils.close((Closeable[])new Closeable[]{producer});
            IOUtils.close((Closeable[])new Closeable[]{producer});
        }
        finally {
            if (producer != null) {
                producer.close();
            }
        }
        consumer = codec.normsFormat().normsConsumer(writeState);
        try {
            consumer.addNormsField(field, new NormsProducer(){

                public NumericDocValues getNorms(FieldInfo field) {
                    return new NumericDocValues(){
                        int docID = -1;

                        public int docID() {
                            return this.docID;
                        }

                        public int nextDoc() {
                            ++this.docID;
                            if (this.docID == 1) {
                                this.docID = Integer.MAX_VALUE;
                            }
                            return this.docID;
                        }

                        public int advance(int target) {
                            this.docID = this.docID <= 0 && target == 0 ? 0 : Integer.MAX_VALUE;
                            return this.docID;
                        }

                        public boolean advanceExact(int target) throws IOException {
                            this.docID = target;
                            return target == 0;
                        }

                        public long cost() {
                            return 1L;
                        }

                        public long longValue() {
                            return 5L;
                        }
                    };
                }

                public void checkIntegrity() {
                }

                public void close() {
                }

                public long ramBytesUsed() {
                    return 0L;
                }
            });
            IOUtils.close((Closeable[])new Closeable[]{consumer});
            IOUtils.close((Closeable[])new Closeable[]{consumer});
        }
        finally {
            if (consumer != null) {
                consumer.close();
            }
        }
        producer = codec.normsFormat().normsProducer(readState);
        try {
            IOUtils.close((Closeable[])new Closeable[]{producer});
            IOUtils.close((Closeable[])new Closeable[]{producer});
        }
        finally {
            if (producer != null) {
                producer.close();
            }
        }
        consumer = codec.termVectorsFormat().vectorsWriter((Directory)dir, segmentInfo, writeState.context);
        try {
            consumer.startDocument(1);
            consumer.startField(field, 1, false, false, false);
            consumer.startTerm(new BytesRef((CharSequence)"testing"), 2);
            consumer.finishTerm();
            consumer.finishField();
            consumer.finishDocument();
            consumer.finish(fieldInfos, 1);
            IOUtils.close((Closeable[])new Closeable[]{consumer});
            IOUtils.close((Closeable[])new Closeable[]{consumer});
        }
        finally {
            if (consumer != null) {
                consumer.close();
            }
        }
        producer = codec.termVectorsFormat().vectorsReader((Directory)dir, segmentInfo, fieldInfos, readState.context);
        try {
            IOUtils.close((Closeable[])new Closeable[]{producer});
            IOUtils.close((Closeable[])new Closeable[]{producer});
        }
        finally {
            if (producer != null) {
                producer.close();
            }
        }
        consumer = codec.storedFieldsFormat().fieldsWriter((Directory)dir, segmentInfo, writeState.context);
        try {
            consumer.startDocument();
            consumer.writeField(field, (IndexableField)customField);
            consumer.finishDocument();
            consumer.finish(fieldInfos, 1);
            IOUtils.close((Closeable[])new Closeable[]{consumer});
            IOUtils.close((Closeable[])new Closeable[]{consumer});
        }
        finally {
            if (consumer != null) {
                consumer.close();
            }
        }
        producer = codec.storedFieldsFormat().fieldsReader((Directory)dir, segmentInfo, fieldInfos, readState.context);
        try {
            IOUtils.close((Closeable[])new Closeable[]{producer});
            IOUtils.close((Closeable[])new Closeable[]{producer});
        }
        finally {
            if (producer != null) {
                producer.close();
            }
        }
        IOUtils.close((Closeable[])new Closeable[]{oneDocReader, oneDocIndex, dir});
    }
}

