/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.highlight;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.TestRecordsTextProto;
import com.apple.foundationdb.record.lucene.LuceneIndexTestUtils;
import com.apple.foundationdb.record.lucene.LuceneQueryComponent;
import com.apple.foundationdb.record.lucene.LuceneQueryType;
import com.apple.foundationdb.record.lucene.LuceneScanBounds;
import com.apple.foundationdb.record.lucene.LuceneScanQueryParameters;
import com.apple.foundationdb.record.lucene.highlight.HighlightedTerm;
import com.apple.foundationdb.record.lucene.highlight.LuceneHighlighting;
import com.apple.foundationdb.record.lucene.synonym.SynonymMapRegistryImpl;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.foundationdb.FDBIndexedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBQueriedRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.provider.foundationdb.IndexOrphanBehavior;
import com.apple.foundationdb.record.provider.foundationdb.IndexScanBounds;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.collect.Lists;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class FDBLuceneHighlightingTest
extends FDBRecordStoreTestBase {
    @BeforeAll
    public static void setup() {
        SynonymMapRegistryImpl.instance().getSynonymMap("EXPANDED_US_EN");
    }

    @Test
    void highlightedPrefix() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1645L, "Hello record layer", 1));
            this.assertRecordHighlights(List.of("Hello {record} layer"), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES, "recor*"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
        }
    }

    @Test
    void highlightedBitsetQuery() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", LuceneIndexTestUtils.TEXT_AND_STORED);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Hello record layer", 1));
            this.assertRecordHighlights(List.of("Hello {record} layer"), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.TEXT_AND_STORED, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.TEXT_AND_STORED, "text: record AND group: BITSET_CONTAINS(1)"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
            this.assertRecordHighlights(Collections.emptyList(), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.TEXT_AND_STORED, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.TEXT_AND_STORED, "group: BITSET_CONTAINS(1)"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
        }
    }

    @Test
    void highlightedNumberRangeQuery() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "ComplexDocument", LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "Hello record layer", "Hello record layer 2", 5L, 12, false, 8.123));
            this.assertRecordHighlights(List.of("Hello {record} layer"), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, "text: record AND group: 5"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
            this.assertRecordHighlights(List.of("Hello {record} layer"), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, "text: record AND group: [4 TO 6]"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
            this.assertRecordHighlights(List.of("Hello {record} layer"), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, "text: record AND score: [10 TO 15]"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
            this.assertRecordHighlights(List.of("Hello {record} layer"), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, "text: record AND time: [4.913442 TO 8.14234]"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
            this.assertRecordHighlights(Collections.emptyList(), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, "group: 5"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
            this.assertRecordHighlights(Collections.emptyList(), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, "score: [10 TO 15]"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
            this.assertRecordHighlights(Collections.emptyList(), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, "time: [4.913442 TO 8.14234]"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
        }
    }

    @Test
    void highlightedBooleanRangeQuery() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "ComplexDocument", LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "Hello record layer", "Hello record layer 2", 5, false));
            this.assertRecordHighlights(List.of("Hello {record} layer"), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, "text: record AND is_seen: [false TO true]"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
            this.assertRecordHighlights(Collections.emptyList(), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, "text: record AND is_seen: [true TO true]"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
            this.assertRecordHighlights(Collections.emptyList(), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, "is_seen: [false TO true]"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
        }
    }

    @Test
    void highlightedTermRangeQuery() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "ComplexDocument", LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "Hello record layer", "Hello record layer 2", 5, false));
            Assertions.assertThrows(RecordCoreException.class, () -> this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, "text: record AND text2: [hello TO hello]"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
        }
    }

    @Test
    void highlightedTermQuery() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "ComplexDocument", LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createComplexDocument(1623L, "Hello record layer", "inbox", 5, false));
            this.assertRecordHighlights(List.of("Hello {record} layer"), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, "text: record AND text2: \"inbox\""), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
            this.assertRecordHighlights(Collections.emptyList(), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.TEXT_AND_STORED_COMPLEX, "text2: \"inbox\""), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
        }
    }

    @Test
    void highlightedSynonymIndex() {
        String original = "peanut butter and jelly sandwich";
        String highlighted = "{peanut} butter and jelly sandwich";
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", LuceneIndexTestUtils.QUERY_ONLY_SYNONYM_LUCENE_INDEX);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1236L, "peanut butter and jelly sandwich", 1));
            this.assertRecordHighlights(List.of("{peanut} butter and jelly sandwich"), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.QUERY_ONLY_SYNONYM_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.QUERY_ONLY_SYNONYM_LUCENE_INDEX, "peanut"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
            this.assertRecordHighlights(List.of("{peanut} butter and jelly sandwich"), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.QUERY_ONLY_SYNONYM_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.QUERY_ONLY_SYNONYM_LUCENE_INDEX, "groundnut"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
            this.assertRecordHighlights(List.of("{peanut} butter and jelly sandwich"), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.QUERY_ONLY_SYNONYM_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.QUERY_ONLY_SYNONYM_LUCENE_INDEX, "\"monkey nut\""), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
        }
    }

    @Test
    void highlightedNgramIndex() {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", LuceneIndexTestUtils.NGRAM_LUCENE_INDEX);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1623L, "Hello record layer", 1));
            this.assertRecordHighlights(List.of("{Hello} record layer"), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, "hello"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
            this.assertRecordHighlights(List.of("{Hello} record layer"), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, "hel"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
            this.assertRecordHighlights(List.of("Hello {record} layer"), (RecordCursor<FDBIndexedRecord<Message>>)this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.NGRAM_LUCENE_INDEX, "cord"), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR));
        }
    }

    @Test
    void highlightingWithSnippets() {
        try (FDBRecordContext context = this.openContext();){
            String text = "Good Morning From Apple News It?s Monday, July 11. Here?s what you need to know. Top Stories Former Trump adviser Steve Bannon agreed to testify to the January 6 committee after months of defying a congressional subpoena. The Washington Post https://apple.news/AgZ7a_IT4TpKFF3kAyZsvUg?";
            this.rebuildIndexMetaData(context, "SimpleDocument", LuceneIndexTestUtils.QUERY_ONLY_SYNONYM_LUCENE_INDEX);
            this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(1241L, text, 1));
            List highlightedTerms = this.recordStore.fetchIndexRecords(this.recordStore.scanIndex(LuceneIndexTestUtils.QUERY_ONLY_SYNONYM_LUCENE_INDEX, (IndexScanBounds)this.fullTextSearch(LuceneIndexTestUtils.QUERY_ONLY_SYNONYM_LUCENE_INDEX, "appl*", 3), null, ScanProperties.FORWARD_SCAN), IndexOrphanBehavior.ERROR).map(rec -> LuceneHighlighting.highlightedTermsForMessage((FDBQueriedRecord)FDBQueriedRecord.indexed((FDBIndexedRecord)rec), null)).asStream().flatMap(Collection::stream).collect(Collectors.toList());
            List<HighlightedTerm> expectedResults = List.of(new HighlightedTerm("text", "Good Morning From Apple News It?s...", new int[]{18}, new int[]{23}));
            Assertions.assertEquals((int)expectedResults.size(), (int)highlightedTerms.size(), (String)"Incorrect number of snippets returned!");
            Iterator<HighlightedTerm> expected = expectedResults.iterator();
            Iterator actual = highlightedTerms.iterator();
            while (expected.hasNext()) {
                Assertions.assertTrue((boolean)actual.hasNext());
                HighlightedTerm expTerm = expected.next();
                HighlightedTerm actTerm = (HighlightedTerm)actual.next();
                Assertions.assertEquals((Object)expTerm.getFieldName(), (Object)actTerm.getFieldName(), (String)"Incorrect field name!");
                Assertions.assertEquals((Object)expTerm.getSummarizedText(), (Object)actTerm.getSummarizedText(), (String)"Incorrect snippet");
                Assertions.assertEquals((int)expTerm.getNumHighlights(), (int)actTerm.getNumHighlights(), (String)("Incorrect positions for snippet " + expTerm.getSummarizedText()));
                for (int i = 0; i < expTerm.getNumHighlights(); ++i) {
                    Assertions.assertEquals((int)expTerm.getHighlightStart(i), (int)actTerm.getHighlightStart(i), (String)("Incorrect position for snippet <" + expTerm.getSummarizedText() + ">"));
                }
            }
        }
    }

    @Test
    void highlightPositionsCorrectWhenPlanned() throws Exception {
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES);
            String text = "record record record record record record layer record record record record record record record record record record layer record record layer record record record record record record record record";
            TestRecordsTextProto.SimpleDocument simpleDocument = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(0L).setGroup(0L).setText("record record record record record record layer record record record record record record record record record record layer record record layer record record record record record record record record").build();
            this.recordStore.saveRecord((Message)simpleDocument);
            LuceneQueryComponent filter = new LuceneQueryComponent(LuceneQueryType.QUERY_HIGHLIGHT, "layer", false, (List)Lists.newArrayList(), true, new LuceneScanQueryParameters.LuceneQueryHighlightParameters(4, 10), null);
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter((QueryComponent)filter).build();
            RecordQueryPlan plan = this.planner.plan(query);
            try (RecordCursor cursor = this.recordStore.executeQuery(plan);){
                List queriedRecordList = (List)cursor.asList().get();
                Assertions.assertEquals((int)1, (int)queriedRecordList.size());
                FDBQueriedRecord queriedRecord = (FDBQueriedRecord)queriedRecordList.get(0);
                List highlightedTerms = LuceneHighlighting.highlightedTermsForMessage((FDBQueriedRecord)queriedRecord, null);
                Assertions.assertEquals((int)1, (int)highlightedTerms.size());
                HighlightedTerm highlightedTerm = (HighlightedTerm)highlightedTerms.get(0);
                Assertions.assertEquals((Object)"text", (Object)highlightedTerm.getFieldName());
                Assertions.assertEquals((Object)"...record record record record layer record record record record...record record record record layer record record layer record record record record...", (Object)highlightedTerm.getSummarizedText());
                Assertions.assertEquals((int)3, (int)highlightedTerm.getNumHighlights());
                for (int i = 0; i < highlightedTerm.getNumHighlights(); ++i) {
                    Assertions.assertEquals((Object)"layer", (Object)highlightedTerm.getSummarizedText().substring(highlightedTerm.getHighlightStart(i), highlightedTerm.getHighlightEnd(i)));
                }
            }
        }
    }

    @Test
    void synonymHighlightsWorksWhenPlanned() throws Exception {
        String text = "record record record record record record layer record record record record record record record record record record stratum record record layer record record record record record record record record";
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", LuceneIndexTestUtils.QUERY_ONLY_SYNONYM_LUCENE_INDEX);
            TestRecordsTextProto.SimpleDocument document = TestRecordsTextProto.SimpleDocument.newBuilder().setDocId(1L).setGroup(1L).setText("record record record record record record layer record record record record record record record record record record stratum record record layer record record record record record record record record").build();
            this.recordStore.saveRecord((Message)document);
            LuceneQueryComponent filter = new LuceneQueryComponent(LuceneQueryType.QUERY_HIGHLIGHT, "layer", false, (List)Lists.newArrayList(), true, new LuceneScanQueryParameters.LuceneQueryHighlightParameters(2, 10), null);
            RecordQuery query = RecordQuery.newBuilder().setRecordType("SimpleDocument").setFilter((QueryComponent)filter).build();
            RecordQueryPlan plan = this.planner.plan(query);
            try (RecordCursor cursor = this.recordStore.executeQuery(plan);){
                List queriedRecordList = (List)cursor.asList().get();
                Assertions.assertEquals((int)1, (int)queriedRecordList.size());
                FDBQueriedRecord queriedRecord = (FDBQueriedRecord)queriedRecordList.get(0);
                List highlightedTerms = LuceneHighlighting.highlightedTermsForMessage((FDBQueriedRecord)queriedRecord, null);
                Assertions.assertEquals((int)1, (int)highlightedTerms.size());
                HighlightedTerm highlightedTerm = (HighlightedTerm)highlightedTerms.get(0);
                Assertions.assertEquals((Object)"text", (Object)highlightedTerm.getFieldName());
                Assertions.assertEquals((Object)"...record record layer record record...record record stratum record record layer record record...", (Object)highlightedTerm.getSummarizedText());
                Assertions.assertEquals((int)3, (int)highlightedTerm.getNumHighlights());
                Assertions.assertEquals((Object)"layer", (Object)highlightedTerm.getSummarizedText().substring(highlightedTerm.getHighlightStart(0), highlightedTerm.getHighlightEnd(0)));
                Assertions.assertEquals((Object)"stratum", (Object)highlightedTerm.getSummarizedText().substring(highlightedTerm.getHighlightStart(1), highlightedTerm.getHighlightEnd(1)));
                Assertions.assertEquals((Object)"layer", (Object)highlightedTerm.getSummarizedText().substring(highlightedTerm.getHighlightStart(2), highlightedTerm.getHighlightEnd(2)));
            }
        }
    }

    private LuceneScanBounds fullTextSearch(Index index, String search) {
        return LuceneIndexTestUtils.fullTextSearch(this.recordStore, index, search, true);
    }

    private LuceneScanBounds fullTextSearch(Index index, String search, int snippetSize) {
        return LuceneIndexTestUtils.fullTextSearch(this.recordStore, index, search, true, snippetSize);
    }

    private void rebuildIndexMetaData(FDBRecordContext context, String document, Index index) {
        Pair<FDBRecordStore, QueryPlanner> pair = LuceneIndexTestUtils.rebuildIndexMetaData(context, this.path, document, index, this.isUseCascadesPlanner());
        this.recordStore = (FDBRecordStore)pair.getLeft();
        this.planner = (QueryPlanner)pair.getRight();
    }

    private void assertRecordHighlights(List<String> texts, RecordCursor<FDBIndexedRecord<Message>> cursor) {
        ArrayList highlighted = new ArrayList();
        cursor.forEach(rec -> {
            for (HighlightedTerm highlightedTerm : LuceneHighlighting.highlightedTermsForMessage((FDBQueriedRecord)FDBQueriedRecord.indexed((FDBIndexedRecord)rec), null)) {
                StringBuilder str = new StringBuilder(highlightedTerm.getSummarizedText());
                int offset = 0;
                for (int p = 0; p < highlightedTerm.getNumHighlights(); ++p) {
                    int start = highlightedTerm.getHighlightStart(p);
                    int end = highlightedTerm.getHighlightEnd(p);
                    str.insert(offset + start, "{");
                    str.insert(++offset + end, "}");
                    ++offset;
                }
                highlighted.add(str.toString());
            }
        }).join();
        Assertions.assertEquals(texts, highlighted);
    }
}

