/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.Transaction;
import com.apple.foundationdb.record.RecordCoreStorageException;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.lucene.directory.AgilityContext;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBExceptions;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContextConfig;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.provider.foundationdb.FDBTransactionPriority;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyStorage;
import com.apple.foundationdb.record.util.RandomUtil;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import com.apple.foundationdb.tuple.TupleHelpers;
import com.apple.test.BooleanSource;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@Tag(value="RequiresFDB")
class AgilityContextTest
extends FDBRecordStoreTestBase {
    int loopCount = 20;
    int threadCount = 5;
    final String prefix = RandomUtil.randomByteString((Random)ThreadLocalRandom.current(), (int)100).toString();

    AgilityContextTest() {
    }

    private AgilityContext getAgilityContextAgileProp(FDBRecordContext callerContext) {
        long timeQuotaMillis = Objects.requireNonNullElse((Integer)callerContext.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_AGILE_COMMIT_TIME_QUOTA), 4000).intValue();
        long sizeQuotaBytes = Objects.requireNonNullElse((Integer)callerContext.getPropertyStorage().getPropertyValue(LuceneRecordContextProperties.LUCENE_AGILE_COMMIT_SIZE_QUOTA), 900000).intValue();
        return AgilityContext.agile((FDBRecordContext)callerContext, (long)timeQuotaMillis, (long)sizeQuotaBytes);
    }

    private AgilityContext getAgilityContext(FDBRecordContext callerContext, boolean useAgileContext) {
        return useAgileContext ? this.getAgilityContextAgileProp(callerContext) : AgilityContext.nonAgile((FDBRecordContext)callerContext);
    }

    void testAgilityContextConcurrentSingleObject(AgilityContext agilityContext, boolean doFlush) throws ExecutionException, InterruptedException {
        this.agilityContextTestSingleThread(1, 0, agilityContext, doFlush);
        this.agilityContextTestSingleThread(1, 1, agilityContext, doFlush);
        this.agilityContextTestSingleThread(1, 1, agilityContext, doFlush);
        int loop = 0;
        while (loop < this.loopCount) {
            int loopFinal = loop++;
            IntStream.rangeClosed(0, this.threadCount).parallel().forEach(i -> {
                try {
                    this.agilityContextTestSingleThread(loopFinal, i, agilityContext, doFlush);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private void agilityContextTestSingleThread(int loop, int i, AgilityContext agilityContext, boolean explicityFlush) throws ExecutionException, InterruptedException {
        byte[] key = Tuple.from((Object[])new Object[]{500, loop, i}).pack();
        byte[] val = Tuple.from((Object[])new Object[]{loop, i}).pack();
        agilityContext.set(key, val);
        if (explicityFlush && i % 3 == 0) {
            byte[] bytes = (byte[])agilityContext.get(key).join();
            Tuple retTuple = Tuple.fromBytes((byte[])bytes);
            Assertions.assertEquals((long)retTuple.getLong(0), (long)loop);
            Assertions.assertEquals((long)retTuple.getLong(1), (long)i);
            agilityContext.flush();
            bytes = (byte[])agilityContext.get(key).join();
            retTuple = Tuple.fromBytes((byte[])bytes);
            Assertions.assertEquals((long)retTuple.getLong(0), (long)loop);
            Assertions.assertEquals((long)retTuple.getLong(1), (long)i);
        }
    }

    private void assertLoopThreadsValues() {
        try (FDBRecordContext context = this.fdb.openContext();){
            for (int loop = 0; loop < this.loopCount; ++loop) {
                AgilityContext agilityContext = this.getAgilityContext(context, false);
                for (int i = 0; i < this.threadCount; ++i) {
                    byte[] key = Tuple.from((Object[])new Object[]{500, loop, i}).pack();
                    byte[] bytes = (byte[])agilityContext.get(key).join();
                    Tuple retTuple = Tuple.fromBytes((byte[])bytes);
                    Assertions.assertEquals((long)retTuple.getLong(0), (long)loop);
                    Assertions.assertEquals((long)retTuple.getLong(1), (long)i);
                }
            }
            context.commit();
        }
    }

    @ParameterizedTest
    @BooleanSource
    void testAgilityContextConcurrent(boolean useAgile) throws ExecutionException, InterruptedException {
        try (FDBRecordContext context = this.fdb.openContext();){
            AgilityContext agilityContext = this.getAgilityContext(context, useAgile);
            this.testAgilityContextConcurrentSingleObject(agilityContext, true);
            context.commit();
        }
        this.assertLoopThreadsValues();
    }

    @ParameterizedTest
    @BooleanSource
    void testAgilityContextConcurrentNonExplicitCommits(boolean useAgile) throws ExecutionException, InterruptedException {
        for (int sizeQuota : new int[]{1, 2, 7, 21, 100, 10000}) {
            RecordLayerPropertyStorage.Builder insertProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_AGILE_COMMIT_SIZE_QUOTA, (Object)sizeQuota);
            try (FDBRecordContext context = this.openContext(insertProps);){
                AgilityContext agilityContext = this.getAgilityContext(context, useAgile);
                this.testAgilityContextConcurrentSingleObject(agilityContext, false);
                context.commit();
            }
        }
        this.assertLoopThreadsValues();
    }

    @Test
    void testAgilityContextConcurrentNonExplicitCommitsExplicitParams() throws ExecutionException, InterruptedException {
        for (int sizeQuota : new int[]{1, 2, 7, 21, 100, 10000}) {
            try (FDBRecordContext context = this.openContext();){
                AgilityContext agilityContext = AgilityContext.agile((FDBRecordContext)context, (long)10000L, (long)sizeQuota);
                this.testAgilityContextConcurrentSingleObject(agilityContext, false);
                context.commit();
            }
        }
        this.assertLoopThreadsValues();
    }

    static Stream<Arguments> agilityContextLimits() {
        return Stream.of(true, false).flatMap(useProp -> Arrays.stream(LimitType.values()).flatMap(limitType -> Arrays.stream(Method.values()).filter(method -> limitType == LimitType.Time || method == Method.Set).map(method -> Arguments.of((Object[])new Object[]{useProp, method, limitType}))));
    }

    @ParameterizedTest(name="useProp:{0},{1} by {2}")
    @MethodSource(value={"agilityContextLimits"})
    void testAgilityContextOneLongWrite(boolean useProp, Method method, LimitType limitType) {
        byte[] key;
        int i;
        AgilityContext agilityContext;
        Subspace subspace;
        int sizeLimit = limitType.sizeLimit;
        int timeLimit = limitType.timeLimit;
        RecordLayerPropertyStorage.Builder insertProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_AGILE_COMMIT_SIZE_QUOTA, (Object)sizeLimit).addProp(LuceneRecordContextProperties.LUCENE_AGILE_COMMIT_TIME_QUOTA, (Object)timeLimit);
        String RobertFrost = "Two roads diverged in a yellow wood,\nAnd sorry I could not travel both\nAnd be one traveler, long I stood\nAnd looked down one as far as I could\nTo where it bent in the undergrowth;";
        try (FDBRecordContext context = useProp ? this.openContext(insertProps) : this.openContext();){
            subspace = this.path.toSubspace(context);
            agilityContext = useProp ? this.getAgilityContextAgileProp(context) : AgilityContext.agile((FDBRecordContext)context, (long)timeLimit, (long)sizeLimit);
            for (i = 0; i < this.loopCount; ++i) {
                key = subspace.pack(Tuple.from((Object[])new Object[]{2023, i}));
                byte[] val = Tuple.from((Object[])new Object[]{i, RobertFrost, 0}).pack();
                switch (method) {
                    case Set: {
                        agilityContext.set(key, val);
                        break;
                    }
                    case Apply: {
                        agilityContext.apply(innerContext -> innerContext.ensureActive().get(key).thenApply(oldVal -> {
                            if (oldVal == null) {
                                innerContext.ensureActive().set(key, val);
                            } else {
                                Tuple oldTuple = Tuple.fromBytes((byte[])oldVal);
                                innerContext.ensureActive().set(key, TupleHelpers.subTuple((Tuple)oldTuple, (int)0, (int)2).add(oldTuple.getLong(2) + 1L).pack());
                            }
                            return oldVal;
                        })).join();
                        break;
                    }
                    case Accept: {
                        agilityContext.accept(innerContext -> innerContext.ensureActive().set(key, val));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected enum value " + String.valueOf((Object)method)));
                    }
                }
                if (0 != i % 8) continue;
                this.napTime(2);
            }
            context.commit();
            MatcherAssert.assertThat((Object)this.timer.getCount(limitType.timerEvent), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        }
        context = this.openContext(insertProps);
        try {
            subspace = this.path.toSubspace(context);
            agilityContext = this.getAgilityContext(context, false);
            for (i = 0; i < this.loopCount; ++i) {
                key = subspace.pack(Tuple.from((Object[])new Object[]{2023, i}));
                byte[] bytes = (byte[])agilityContext.get(key).join();
                Tuple retTuple = Tuple.fromBytes((byte[])bytes);
                Assertions.assertEquals((long)i, (long)retTuple.getLong(0));
                Assertions.assertEquals((Object)RobertFrost, (Object)retTuple.getString(1));
            }
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    static Stream<Arguments> agilityContextLimitsNotSet() {
        return Stream.of(true, false).flatMap(useProp -> Arrays.stream(LimitType.values()).flatMap(limitType -> Arrays.stream(Method.values()).filter(method -> method != Method.Set).map(method -> Arguments.of((Object[])new Object[]{useProp, method, limitType}))));
    }

    @ParameterizedTest(name="useProp:{0},{1} by {2}")
    @MethodSource(value={"agilityContextLimitsNotSet"})
    void testAgilityContextOneLongWriteFail(boolean useProp, Method method, LimitType limitType) {
        int sizeLimit = limitType.sizeLimit;
        int timeLimit = limitType.timeLimit;
        RecordLayerPropertyStorage.Builder insertProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_AGILE_COMMIT_SIZE_QUOTA, (Object)sizeLimit).addProp(LuceneRecordContextProperties.LUCENE_AGILE_COMMIT_TIME_QUOTA, (Object)timeLimit);
        String RobertFrost = "Two roads diverged in a yellow wood,\nAnd sorry I could not travel both\nAnd be one traveler, long I stood\nAnd looked down one as far as I could\nTo where it bent in the undergrowth;";
        try (FDBRecordContext context = useProp ? this.openContext(insertProps) : this.openContext();){
            Subspace subspace = this.path.toSubspace(context);
            AgilityContext agilityContext = useProp ? this.getAgilityContextAgileProp(context) : AgilityContext.agile((FDBRecordContext)context, (long)timeLimit, (long)sizeLimit);
            byte[] unwritableKey = new byte[]{-1};
            for (int i = 0; i < this.loopCount; ++i) {
                byte[] key = subspace.pack(Tuple.from((Object[])new Object[]{2023, i}));
                byte[] val = Tuple.from((Object[])new Object[]{i, RobertFrost, 0}).pack();
                switch (method) {
                    case Set: {
                        Assertions.assertThrows(FailException.class, () -> agilityContext.set(unwritableKey, val));
                        break;
                    }
                    case Apply: {
                        if (i == 0) {
                            CompletionException completionException = (CompletionException)Assertions.assertThrows(CompletionException.class, () -> {
                                try {
                                    agilityContext.apply(innerContext -> innerContext.ensureActive().get(key).thenApply(oldVal -> {
                                        if (oldVal == null) {
                                            innerContext.ensureActive().set(key, val);
                                        } else {
                                            Tuple oldTuple = Tuple.fromBytes((byte[])oldVal);
                                            innerContext.ensureActive().set(key, TupleHelpers.subTuple((Tuple)oldTuple, (int)0, (int)2).add(oldTuple.getLong(2) + 1L).pack());
                                        }
                                        throw new FailException();
                                    })).join();
                                }
                                catch (Exception ex) {
                                    agilityContext.abortAndClose();
                                    throw ex;
                                }
                            });
                            MatcherAssert.assertThat((Object)completionException.getCause(), (Matcher)Matchers.instanceOf(FailException.class));
                            break;
                        }
                        Assertions.assertThrows(RecordCoreStorageException.class, () -> agilityContext.apply(innerContext -> innerContext.ensureActive().get(key).thenApply(oldVal -> {
                            innerContext.ensureActive().set(key, val);
                            return oldVal;
                        })).join());
                        break;
                    }
                    case Accept: {
                        if (i == 0) {
                            Assertions.assertThrows(FailException.class, () -> {
                                try {
                                    agilityContext.accept(innerContext -> {
                                        innerContext.ensureActive().set(key, val);
                                        throw new FailException();
                                    });
                                }
                                catch (Exception ex) {
                                    agilityContext.abortAndClose();
                                    throw ex;
                                }
                            });
                            break;
                        }
                        Assertions.assertThrows(RecordCoreStorageException.class, () -> agilityContext.accept(innerContext -> innerContext.ensureActive().set(key, val)));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected enum value " + String.valueOf((Object)method)));
                    }
                }
                if (0 != i % 8) continue;
                this.napTime(2);
            }
            MatcherAssert.assertThat((Object)this.timer.getCount(limitType.timerEvent), (Matcher)Matchers.equalTo((Object)0));
            try (FDBRecordContext validationContext = this.openContext(insertProps);){
                for (int i = 0; i < this.loopCount; ++i) {
                    byte[] key = subspace.pack(Tuple.from((Object[])new Object[]{2023, i}));
                    byte[] value = (byte[])validationContext.ensureActive().get(key).join();
                    Assertions.assertNull((Object)value);
                }
            }
            agilityContext.flushAndClose();
        }
    }

    void napTime(int napTimeMilliseconds) {
        try {
            Thread.sleep(napTimeMilliseconds);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @ParameterizedTest
    @BooleanSource
    void testAgilityContextAtomicAttribute(boolean useAgile) {
        for (int sizeQuota : new int[]{1, 21, 100, 10000}) {
            RecordLayerPropertyStorage.Builder insertProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_AGILE_COMMIT_SIZE_QUOTA, (Object)sizeQuota);
            IntStream.rangeClosed(0, this.threadCount).parallel().forEach(threadNum -> {
                try (FDBRecordContext context = this.openContext(insertProps);){
                    AgilityContext agilityContext = this.getAgilityContext(context, useAgile);
                    for (int i = 1700; i < 1900; i += 17) {
                        long iFinal = i;
                        int numWriters = 1 + Integer.numberOfTrailingZeros(i) / 2;
                        if (threadNum < numWriters) {
                            agilityContext.accept(aContext -> {
                                Transaction tr = aContext.ensureActive();
                                for (int j = 0; j < 5; ++j) {
                                    tr.set(Tuple.from((Object[])new Object[]{this.prefix, iFinal, j}).pack(), Tuple.from((Object[])new Object[]{iFinal}).pack());
                                    this.napTime(1);
                                }
                            });
                            this.napTime(3);
                            continue;
                        }
                        this.napTime(3);
                        agilityContext.accept(aContext -> {
                            int j;
                            long[] values = new long[5];
                            Transaction tr = aContext.ensureActive();
                            for (j = 4; j >= 0; --j) {
                                byte[] val = (byte[])tr.get(Tuple.from((Object[])new Object[]{this.prefix, iFinal, j}).pack()).join();
                                values[j] = val == null ? 0L : Tuple.fromBytes((byte[])val).getLong(0);
                            }
                            for (j = 1; j < 5; ++j) {
                                Assertions.assertEquals((long)values[0], (long)values[j]);
                            }
                        });
                    }
                    agilityContext.flush();
                }
            });
        }
    }

    @Test
    void testAgilityContextRecoveryPath() {
        AtomicInteger refInt = new AtomicInteger(0);
        Tuple value = Tuple.from((Object[])new Object[]{800, "Green eggs and ham", 0});
        byte[] packedValue = value.pack();
        try (FDBRecordContext context = this.openContext();){
            AgilityContext agilityContext = this.getAgilityContext(context, true);
            Subspace subspace = this.path.toSubspace(context);
            byte[] keyAborted = subspace.pack(Tuple.from((Object[])new Object[]{2023, 3}));
            agilityContext.set(keyAborted, packedValue);
            agilityContext.abortAndClose();
            IntStream range = IntStream.rangeClosed(1, 10);
            range.parallel().forEach(i -> {
                if (i == 7) {
                    agilityContext.applyInRecoveryPath(aContext -> {
                        Assertions.assertNotNull((Object)aContext);
                        refInt.addAndGet(100);
                        return CompletableFuture.completedFuture(null);
                    }).join();
                } else {
                    Assertions.assertThrows(RecordCoreStorageException.class, () -> agilityContext.apply(aContext -> {
                        refInt.set(i);
                        return CompletableFuture.completedFuture(null);
                    }).join());
                }
            });
            Assertions.assertEquals((int)100, (int)refInt.get());
            context.commit();
        }
    }

    @Test
    void testAgilityContextRecoveryPath2() {
        Tuple value = Tuple.from((Object[])new Object[]{800, "Green eggs and ham", 0});
        Tuple successTuple = Tuple.from((Object[])new Object[]{this.prefix, "yes"});
        Tuple abortedTuple = Tuple.from((Object[])new Object[]{this.prefix, "abort"});
        Tuple failTuple = Tuple.from((Object[])new Object[]{this.prefix, "no"});
        byte[] packedValue = value.pack();
        try (FDBRecordContext context = this.openContext();){
            AgilityContext agilityContext = this.getAgilityContext(context, true);
            Subspace subspace = this.path.toSubspace(context);
            byte[] keyAborted = subspace.pack(abortedTuple);
            byte[] keySucceeds = subspace.pack(successTuple);
            byte[] keyFails = subspace.pack(failTuple);
            agilityContext.set(keyAborted, packedValue);
            agilityContext.abortAndClose();
            IntStream range = IntStream.rangeClosed(1, 10);
            range.parallel().forEach(i -> {
                if (i == 7) {
                    agilityContext.applyInRecoveryPath(aContext -> {
                        Assertions.assertNotNull((Object)aContext);
                        context.ensureActive().set(keySucceeds, packedValue);
                        return CompletableFuture.completedFuture(null);
                    }).join();
                } else {
                    Assertions.assertThrows(RecordCoreStorageException.class, () -> agilityContext.apply(aContext -> {
                        context.ensureActive().set(keyFails, packedValue);
                        return CompletableFuture.completedFuture(null);
                    }).join());
                    Assertions.assertThrows(RecordCoreStorageException.class, () -> agilityContext.set(keyFails, packedValue));
                }
            });
            context.commit();
        }
        context = this.openContext();
        try {
            Subspace subspace = this.path.toSubspace(context);
            byte[] keyAborted = subspace.pack(abortedTuple);
            byte[] keySucceeds = subspace.pack(successTuple);
            byte[] keyFails = subspace.pack(failTuple);
            Assertions.assertEquals((Object)value, (Object)Tuple.fromBytes((byte[])((byte[])context.ensureActive().get(keySucceeds).join())));
            Assertions.assertNull(context.ensureActive().get(keyAborted).join());
            Assertions.assertNull(context.ensureActive().get(keyFails).join());
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @ParameterizedTest
    @BooleanSource
    void testAgilityContextAtomicAttributeMultiContext(boolean useAgile) {
        IntStream.rangeClosed(0, this.threadCount).parallel().forEach(threadNum -> {
            for (int i = 1700; i < 1900; i += 17) {
                AgilityContext agilityContext;
                FDBRecordContext context;
                long iFinal = i;
                int numWriters = 1;
                if (threadNum < numWriters) {
                    context = this.openContext();
                    try {
                        agilityContext = this.getAgilityContext(context, useAgile);
                        agilityContext.accept(aContext -> {
                            for (int j = 0; j < 5; ++j) {
                                Transaction tr = aContext.ensureActive();
                                tr.set(Tuple.from((Object[])new Object[]{this.prefix, iFinal, j}).pack(), Tuple.from((Object[])new Object[]{iFinal}).pack());
                                this.napTime(1);
                            }
                            this.napTime(3);
                        });
                        agilityContext.flush();
                        continue;
                    }
                    finally {
                        if (context != null) {
                            context.close();
                        }
                    }
                }
                this.napTime(3);
                context = this.openContext();
                try {
                    agilityContext = this.getAgilityContext(context, useAgile);
                    agilityContext.accept(aContext -> {
                        int j;
                        long[] values = new long[5];
                        Transaction tr = aContext.ensureActive();
                        for (j = 4; j >= 0; --j) {
                            byte[] val = (byte[])tr.get(Tuple.from((Object[])new Object[]{this.prefix, iFinal, j}).pack()).join();
                            values[j] = val == null ? 0L : Tuple.fromBytes((byte[])val).getLong(0);
                        }
                        for (j = 1; j < 5; ++j) {
                            Assertions.assertEquals((long)values[0], (long)values[j]);
                        }
                    });
                    agilityContext.flush();
                    continue;
                }
                finally {
                    if (context != null) {
                        context.close();
                    }
                }
            }
        });
    }

    @Test
    void testCloseOnCommitFailure() {
        byte[] key;
        try (FDBRecordContext context = this.openContext();){
            key = this.path.toSubspace(context).pack((Object)Tuple.from((Object[])new Object[]{this.prefix, "a"}).pack());
            context.ensureActive().set(key, Tuple.from((Object[])new Object[]{1}).pack());
            context.commit();
        }
        try (FDBRecordContext callerContext = this.openContext();){
            AgilityContext agile = AgilityContext.agile((FDBRecordContext)callerContext, (long)TimeUnit.MINUTES.toMillis(5L), (long)1000000L);
            Assertions.assertEquals((Object)Tuple.from((Object[])new Object[]{1}), (Object)Tuple.fromBytes((byte[])((byte[])agile.get(key).join())));
            agile.set(key, Tuple.from((Object[])new Object[]{2}).pack());
            try (FDBRecordContext context = this.openContext();){
                Assertions.assertEquals((Object)Tuple.from((Object[])new Object[]{1}), (Object)Tuple.fromBytes((byte[])((byte[])context.ensureActive().get(key).join())));
                context.ensureActive().set(key, Tuple.from((Object[])new Object[]{3}).pack());
                context.commit();
            }
            Assertions.assertThrows(FDBExceptions.FDBStoreTransactionConflictException.class, () -> ((AgilityContext)agile).flush());
            RecordCoreStorageException exception = (RecordCoreStorageException)Assertions.assertThrows(RecordCoreStorageException.class, () -> agile.set(key, Tuple.from((Object[])new Object[]{5}).pack()));
            MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.containsString((String)"already closed"));
            Assertions.assertNotNull((Object)exception.getCause());
            MatcherAssert.assertThat((Object)exception.getCause().getMessage(), (Matcher)Matchers.containsString((String)"Transaction not committed due to conflict with another transaction"));
            try (FDBRecordContext context = this.openContext();){
                Assertions.assertEquals((Object)Tuple.from((Object[])new Object[]{3}), (Object)Tuple.fromBytes((byte[])((byte[])context.ensureActive().get(key).join())));
            }
        }
    }

    @Test
    void testAutoCommitVersionStampOuterSleep() throws InterruptedException {
        try (FDBRecordContext userContext = this.openContext();){
            byte[] key = this.path.toSubspace(userContext).pack((Object)Tuple.from((Object[])new Object[]{this.prefix, "a"}).pack());
            AgilityContext agilityContext = AgilityContext.agile((FDBRecordContext)userContext, (long)2L, (long)10000L);
            AtomicReference firstOperation = new AtomicReference();
            agilityContext.accept(context -> {
                context.ensureActive().set(key, Tuple.from((Object[])new Object[]{1}).pack());
                firstOperation.set(context);
            });
            Thread.sleep(5L);
            MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_AGILE_COMMITS_SIZE_QUOTA), (Matcher)Matchers.equalTo((Object)0));
            MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_AGILE_COMMITS_TIME_QUOTA), (Matcher)Matchers.equalTo((Object)0));
            AtomicReference secondOperation = new AtomicReference();
            agilityContext.accept(context -> {
                context.ensureActive().set(key, Tuple.from((Object[])new Object[]{3}).pack());
                secondOperation.set(context);
            });
            agilityContext.flush();
            MatcherAssert.assertThat((Object)((FDBRecordContext)secondOperation.get()).getCommittedVersion(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(((FDBRecordContext)firstOperation.get()).getCommittedVersion())));
        }
    }

    @Test
    void testAutoCommitVersionStampOuterSleepUseApply() throws InterruptedException {
        try (FDBRecordContext userContext = this.openContext();){
            byte[] key = this.path.toSubspace(userContext).pack((Object)Tuple.from((Object[])new Object[]{this.prefix, "a"}).pack());
            AgilityContext agilityContext = AgilityContext.agile((FDBRecordContext)userContext, (long)2L, (long)10000L);
            AtomicReference firstOperation = new AtomicReference();
            agilityContext.apply(context -> context.ensureActive().get(key).thenApply(oldVal -> {
                context.ensureActive().set(key, Tuple.from((Object[])new Object[]{1}).pack());
                firstOperation.set(context);
                return oldVal;
            })).join();
            Thread.sleep(5L);
            MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_AGILE_COMMITS_SIZE_QUOTA), (Matcher)Matchers.equalTo((Object)0));
            MatcherAssert.assertThat((Object)this.timer.getCount((StoreTimer.Event)LuceneEvents.Counts.LUCENE_AGILE_COMMITS_TIME_QUOTA), (Matcher)Matchers.equalTo((Object)0));
            AtomicReference secondOperation = new AtomicReference();
            agilityContext.apply(context -> context.ensureActive().get(key).thenApply(oldVal -> {
                context.ensureActive().set(key, Tuple.from((Object[])new Object[]{3}).pack());
                secondOperation.set(context);
                return oldVal;
            })).join();
            agilityContext.flush();
            MatcherAssert.assertThat((Object)((FDBRecordContext)secondOperation.get()).getCommittedVersion(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(((FDBRecordContext)firstOperation.get()).getCommittedVersion())));
        }
    }

    @Test
    void testAutoCommitVersionStampInnerSleep() {
        try (FDBRecordContext userContext = this.openContext();){
            byte[] key = this.path.toSubspace(userContext).pack((Object)Tuple.from((Object[])new Object[]{this.prefix, "a"}).pack());
            AgilityContext agilityContext = AgilityContext.agile((FDBRecordContext)userContext, (long)2L, (long)10000L);
            AtomicReference firstOperation = new AtomicReference();
            agilityContext.accept(context -> {
                context.ensureActive().set(key, Tuple.from((Object[])new Object[]{1}).pack());
                firstOperation.set(context);
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
            AtomicReference secondOperation = new AtomicReference();
            agilityContext.accept(context -> {
                context.ensureActive().set(key, Tuple.from((Object[])new Object[]{3}).pack());
                secondOperation.set(context);
            });
            agilityContext.flush();
            MatcherAssert.assertThat((Object)((FDBRecordContext)secondOperation.get()).getCommittedVersion(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(((FDBRecordContext)firstOperation.get()).getCommittedVersion())));
        }
    }

    @Test
    void testAutoCommitVersionStampInnerSleepUseApply() {
        try (FDBRecordContext userContext = this.openContext();){
            byte[] key = this.path.toSubspace(userContext).pack((Object)Tuple.from((Object[])new Object[]{this.prefix, "a"}).pack());
            AgilityContext agilityContext = AgilityContext.agile((FDBRecordContext)userContext, (long)2L, (long)10000L);
            AtomicReference firstOperation = new AtomicReference();
            agilityContext.apply(context -> context.ensureActive().get(key).thenApply(oldVal -> {
                context.ensureActive().set(key, Tuple.from((Object[])new Object[]{1}).pack());
                firstOperation.set(context);
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                return oldVal;
            })).join();
            AtomicReference secondOperation = new AtomicReference();
            agilityContext.apply(context -> context.ensureActive().get(key).thenApply(oldVal -> {
                context.ensureActive().set(key, Tuple.from((Object[])new Object[]{3}).pack());
                secondOperation.set(context);
                return oldVal;
            })).join();
            agilityContext.flush();
            MatcherAssert.assertThat((Object)((FDBRecordContext)secondOperation.get()).getCommittedVersion(), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(((FDBRecordContext)firstOperation.get()).getCommittedVersion())));
        }
    }

    @ParameterizedTest
    @BooleanSource
    void luceneTransactionPriorityVerificationTest(boolean usePriorityBatch) {
        try (FDBRecordContext userContext = this.openContext();){
            FDBTransactionPriority userPriority = userContext.getPriority();
            FDBTransactionPriority agilePriority = usePriorityBatch ? FDBTransactionPriority.BATCH : FDBTransactionPriority.DEFAULT;
            FDBRecordContextConfig.Builder contextBuilder = userContext.getConfig().toBuilder();
            contextBuilder.setPriority(agilePriority);
            AgilityContext agilityContext = AgilityContext.agile((FDBRecordContext)userContext, (FDBRecordContextConfig.Builder)contextBuilder, (long)2L, (long)10000L);
            agilityContext.apply(context -> {
                Assertions.assertEquals((Object)agilePriority, (Object)context.getPriority());
                return CompletableFuture.completedFuture(null);
            }).join();
            Assertions.assertEquals((Object)userPriority, (Object)userContext.getPriority());
            agilityContext.flushAndClose();
        }
    }

    private static enum LimitType {
        Size(1, 100000, (StoreTimer.Event)LuceneEvents.Counts.LUCENE_AGILE_COMMITS_SIZE_QUOTA),
        Time(100000, 1, (StoreTimer.Event)LuceneEvents.Counts.LUCENE_AGILE_COMMITS_TIME_QUOTA);

        private final int sizeLimit;
        private final int timeLimit;
        private final StoreTimer.Event timerEvent;

        private LimitType(int sizeLimit, int timeLimit, StoreTimer.Event timerEvent) {
            this.sizeLimit = sizeLimit;
            this.timeLimit = timeLimit;
            this.timerEvent = timerEvent;
        }
    }

    private static enum Method {
        Set,
        Apply,
        Accept;

    }

    private static class FailException
    extends RuntimeException {
        private FailException() {
        }
    }
}

