/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedFieldInfosFormat;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.index.BaseIndexFileFormatTestCaseUtils;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.ByteBuffersIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class TestFDBDirectory
extends FDBDirectory {
    private static final LuceneOptimizedFieldInfosFormat FIELD_INFOS_FORMAT = new LuceneOptimizedFieldInfosFormat();
    private static boolean fullBufferToSurviveDeletes;
    private static boolean allowAddIndexes;
    private static final AtomicReference<NonnullPair<String, FieldInfos>> previousFieldInfos;
    private static final AtomicReference<NonnullPair<String, Map<Long, byte[]>>> previousStoredFields;
    private static boolean blockAddIndexes;

    public TestFDBDirectory() {
        super(new Subspace(Tuple.from((Object[])new Object[]{"record-test", "unit", "lucene"})), BaseIndexFileFormatTestCaseUtils.dbExtension.getDatabase().openContext(), Map.of("optimizedStoredFieldsFormatEnabled", "true"));
    }

    public static void useFullBufferToSurviveDeletes() {
        fullBufferToSurviveDeletes = true;
    }

    public static void allowAddIndexes() {
        allowAddIndexes = true;
    }

    public static void reset() {
        fullBufferToSurviveDeletes = false;
        allowAddIndexes = false;
        previousFieldInfos.set(null);
        previousStoredFields.set(null);
    }

    @Nonnull
    public IndexInput openInput(@Nonnull String name, @Nonnull IOContext ioContext) throws IOException {
        IndexInput indexInput = super.openInput(name, ioContext);
        if (fullBufferToSurviveDeletes) {
            MatcherAssert.assertThat((String)"Avoid buffering more than 10MB", (Object)indexInput.length(), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(10000000L)));
            byte[] bytes = new byte[(int)indexInput.length()];
            indexInput.readBytes(bytes, 0, (int)indexInput.length());
            indexInput.close();
            return new ByteBuffersIndexInput(new ByteBuffersDataInput(List.of(ByteBuffer.wrap(bytes))), name);
        }
        if (allowAddIndexes) {
            if (TestFDBDirectory.isStacktraceCopySegmentAsIs()) {
                FieldInfos fieldInfos;
                NonnullPair<String, FieldInfos> previous;
                if ((name.endsWith(".fip") || name.endsWith(".cfe")) && (previous = previousFieldInfos.getAndSet((NonnullPair<String, FieldInfos>)NonnullPair.of((Object)name, (Object)(fieldInfos = FIELD_INFOS_FORMAT.read((Directory)this, name))))) != null) {
                    Assert.assertEquals((Object)previous.getLeft(), (Object)name);
                }
                if (name.endsWith(".cfs") || name.endsWith(".fsf")) {
                    String segmentName = IndexFileNames.parseSegmentName((String)name);
                    byte[] key = this.storedFieldsSubspace.pack(Tuple.from((Object[])new Object[]{segmentName}));
                    List rawStoredFields = (List)this.asyncToSync((StoreTimer.Wait)LuceneEvents.Waits.WAIT_LUCENE_GET_STORED_FIELDS, this.getAgilityContext().instrument((StoreTimer.Event)LuceneEvents.Events.LUCENE_READ_STORED_FIELDS, this.getAgilityContext().getRange(key, ByteArrayUtil.strinc((byte[])key))));
                    Map<Long, byte[]> storedFields = rawStoredFields.stream().collect(Collectors.toMap(keyValue -> this.storedFieldsSubspace.unpack(keyValue.getKey()).getLong(1), keyValue -> keyValue.getValue()));
                    NonnullPair<String, Map<Long, byte[]>> previous2 = previousStoredFields.getAndSet((NonnullPair<String, Map<Long, byte[]>>)NonnullPair.of((Object)name, storedFields));
                    if (previous2 != null) {
                        Assert.assertEquals((Object)previous2.getLeft(), (Object)name);
                    }
                }
            }
        } else if (blockAddIndexes) {
            Assert.assertFalse((String)"Tried to add indexes", (boolean)TestFDBDirectory.isStacktraceCopySegmentAsIs());
        }
        return indexInput;
    }

    @Nonnull
    public IndexOutput createOutput(final @Nonnull String name, @Nullable IOContext ioContext) throws IOException {
        IndexOutput indexOutput = super.createOutput(name, ioContext);
        if (allowAddIndexes && TestFDBDirectory.isStacktraceCopySegmentAsIs()) {
            if (name.endsWith(".fip") || name.endsWith(".cfe")) {
                return new WrappedIndexOutput(name, name, indexOutput){

                    @Override
                    public void close() throws IOException {
                        super.close();
                        NonnullPair<String, FieldInfos> previous = previousFieldInfos.get();
                        FIELD_INFOS_FORMAT.write((Directory)TestFDBDirectory.this, (FieldInfos)previous.getRight(), name);
                        previousFieldInfos.compareAndSet(previous, null);
                    }
                };
            }
            if (name.endsWith(".cfs") || name.endsWith(".fsf")) {
                NonnullPair<String, Map<Long, byte[]>> previous = previousStoredFields.get();
                String segmentName = IndexFileNames.parseSegmentName((String)name);
                for (Map.Entry storedFields : ((Map)previous.getRight()).entrySet()) {
                    this.writeStoredFields(segmentName, ((Long)storedFields.getKey()).intValue(), (byte[])storedFields.getValue());
                }
                previousStoredFields.compareAndSet(previous, null);
                return indexOutput;
            }
        }
        return indexOutput;
    }

    private static boolean isStacktraceCopySegmentAsIs() {
        return Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(element -> element.getClassName().equals(IndexWriter.class.getName()) && element.getMethodName().equals("addIndexes")) && Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(element -> element.getClassName().equals(IndexWriter.class.getName()) && element.getMethodName().equals("copySegmentAsIs"));
    }

    static {
        previousFieldInfos = new AtomicReference();
        previousStoredFields = new AtomicReference();
        blockAddIndexes = true;
    }

    private class WrappedIndexOutput
    extends IndexOutput {
        private final IndexOutput inner;

        protected WrappedIndexOutput(String resourceDescription, String name, IndexOutput inner) {
            super(resourceDescription, name);
            this.inner = inner;
        }

        public void close() throws IOException {
            this.inner.close();
        }

        public long getFilePointer() {
            return this.inner.getFilePointer();
        }

        public long getChecksum() throws IOException {
            return this.inner.getChecksum();
        }

        public void writeByte(byte b) throws IOException {
            this.inner.writeByte(b);
        }

        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            this.inner.writeBytes(b, offset, length);
        }
    }
}

