/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneIndexMaintainer;
import com.apple.foundationdb.record.lucene.LuceneIndexTestUtils;
import com.apple.foundationdb.record.lucene.LuceneIndexTestValidator;
import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.lucene.directory.AgilityContext;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.provider.foundationdb.OnlineIndexer;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyStorage;
import com.apple.foundationdb.record.query.plan.QueryPlanner;
import com.apple.foundationdb.record.util.pair.Pair;
import com.apple.foundationdb.tuple.Tuple;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;

public class LucenePrimaryKeySegmentIndexTest
extends FDBRecordStoreTestBase {
    private long idCounter = 1000L;
    private long textCounter = 1L;
    private boolean autoMerge = false;

    @ParameterizedTest
    @EnumSource(value=Version.class)
    void insertDocuments(Version version) throws Exception {
        Index index = version.simpleIndex;
        Set<Tuple> primaryKeys = this.createDocuments(index, 3);
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            LuceneIndexTestValidator.validatePrimaryKeySegmentIndex(this.recordStore, index, Tuple.from((Object[])new Object[0]), null, primaryKeys, false);
        }
    }

    @ParameterizedTest
    @EnumSource(value=Version.class)
    void insertDocumentAcrossTransactions(Version version) throws Exception {
        Index index = version.simpleIndex;
        Set<Tuple> primaryKeys = this.createDocuments(index, 1);
        primaryKeys.addAll(this.createDocuments(index, 1));
        primaryKeys.addAll(this.createDocuments(index, 1));
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            LuceneIndexTestValidator.validatePrimaryKeySegmentIndex(this.recordStore, index, Tuple.from((Object[])new Object[0]), null, primaryKeys, false);
        }
    }

    @ParameterizedTest
    @EnumSource(value=Version.class)
    void updateDocument(Version version) throws Exception {
        Index index = version.simpleIndex;
        Set<Tuple> primaryKeys = this.createDocuments(index, 3);
        this.idCounter -= 2L;
        this.createDocuments(index, 1);
        if (version.enabled) {
            Assertions.assertEquals((int)0, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY));
            Assertions.assertEquals((int)1, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY));
        } else {
            Assertions.assertEquals((int)1, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY));
            Assertions.assertEquals((int)0, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY));
        }
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            LuceneIndexTestValidator.validatePrimaryKeySegmentIndex(this.recordStore, index, Tuple.from((Object[])new Object[0]), null, primaryKeys, false);
        }
    }

    public static Stream<Arguments> versionAndBoolean() {
        return Arrays.stream(Version.values()).flatMap(version -> Stream.of(true, false).map(bool -> Arguments.of((Object[])new Object[]{version, bool})));
    }

    @ParameterizedTest
    @MethodSource(value={"versionAndBoolean"})
    void manyUpdates(Version version, boolean autoMerge) throws Exception {
        Index index = version.simpleIndex;
        this.autoMerge = autoMerge;
        Set<Tuple> primaryKeys = this.createDocuments(index, 3);
        for (int i = 0; i < 10; ++i) {
            this.idCounter -= 3L;
            this.createDocuments(index, 3);
        }
        if (!autoMerge) {
            try (OnlineIndexer indexBuilder = ((OnlineIndexer.Builder)OnlineIndexer.newBuilder().setRecordStore(this.recordStore)).setIndex(index).build();){
                indexBuilder.mergeIndex();
            }
        }
        if (version.enabled) {
            Assertions.assertEquals((int)0, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY));
            Assertions.assertEquals((int)30, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY));
        } else {
            Assertions.assertEquals((int)30, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY));
            Assertions.assertEquals((int)0, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY));
        }
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            LuceneIndexTestValidator.validatePrimaryKeySegmentIndex(this.recordStore, index, Tuple.from((Object[])new Object[0]), null, primaryKeys, false);
        }
    }

    @ParameterizedTest
    @EnumSource(value=Version.class)
    void deleteDocument(Version version) throws Exception {
        Index index = version.simpleIndex;
        Set<Tuple> primaryKeys = this.createDocuments(index, 3);
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            Tuple toDelete = List.copyOf(primaryKeys).get(1);
            this.recordStore.deleteRecord(toDelete);
            primaryKeys.remove(toDelete);
            context.commit();
        }
        if (version.enabled) {
            Assertions.assertEquals((int)0, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY));
            Assertions.assertEquals((int)1, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY));
        } else {
            Assertions.assertEquals((int)1, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY));
            Assertions.assertEquals((int)0, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY));
        }
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            LuceneIndexTestValidator.validatePrimaryKeySegmentIndex(this.recordStore, index, Tuple.from((Object[])new Object[0]), null, primaryKeys, false);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=Version.class)
    void deleteAllDocuments(Version version) throws Exception {
        Index index = version.simpleIndex;
        Set<Tuple> primaryKeys = this.createDocuments(index, 3);
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            for (Tuple toDelete : primaryKeys) {
                this.recordStore.deleteRecord(toDelete);
            }
            primaryKeys.clear();
            context.commit();
        }
        if (version.enabled) {
            Assertions.assertEquals((int)0, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY));
            Assertions.assertEquals((int)3, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY));
        } else {
            Assertions.assertEquals((int)3, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY));
            Assertions.assertEquals((int)0, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY));
        }
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            LuceneIndexTestValidator.validatePrimaryKeySegmentIndex(this.recordStore, index, Tuple.from((Object[])new Object[0]), null, primaryKeys, false);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    @ParameterizedTest
    @EnumSource(value=Version.class)
    void deleteAllDocumentsMultipleTransactions(Version version) throws Exception {
        Index index = version.simpleIndex;
        Set<Tuple> primaryKeys = this.createDocuments(index, 3);
        for (Tuple toDelete : primaryKeys) {
            FDBRecordContext context = this.openContext();
            try {
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                this.recordStore.deleteRecord(toDelete);
                context.commit();
            }
            finally {
                if (context == null) continue;
                context.close();
            }
        }
        primaryKeys.clear();
        if (version.enabled) {
            Assertions.assertEquals((int)0, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY));
            Assertions.assertEquals((int)3, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY));
        } else {
            Assertions.assertEquals((int)3, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY));
            Assertions.assertEquals((int)0, (int)this.timer.getCount((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY));
        }
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            LuceneIndexTestValidator.validatePrimaryKeySegmentIndex(this.recordStore, index, Tuple.from((Object[])new Object[0]), null, primaryKeys, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @EnumSource(value=Version.class)
    void flakyAgileContext(Version version) throws IOException {
        LuceneIndexMaintainer indexMaintainer;
        Index index = version.simpleIndex;
        HashSet<Tuple> primaryKeys = new HashSet<Tuple>();
        for (int i = 0; i < 3; ++i) {
            primaryKeys.addAll(this.createDocuments(index, 1));
        }
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            indexMaintainer = (LuceneIndexMaintainer)this.recordStore.getIndexMaintainer(index);
            FailCommitsAgilityContext agilityContext = new FailCommitsAgilityContext(context, index.getSubspaceKey());
            try {
                Assertions.assertThrows(FailedLuceneCommit.class, () -> indexMaintainer.mergeIndexForTesting(Tuple.from((Object[])new Object[0]), null, (AgilityContext)agilityContext));
            }
            finally {
                agilityContext.flushAndClose();
            }
            Assertions.assertEquals((int)1, (int)agilityContext.commitCount);
        }
        Assumptions.assumeTrue((version == Version.V2 ? 1 : 0) != 0);
        Assertions.assertAll((Executable[])new Executable[]{() -> {
            try (FDBRecordContext context = this.openContext();){
                this.rebuildIndexMetaData(context, "SimpleDocument", index);
                LuceneIndexTestValidator.validatePrimaryKeySegmentIndex(this.recordStore, index, Tuple.from((Object[])new Object[0]), null, primaryKeys, true);
            }
        }, () -> {
            this.timer.reset();
            Assertions.assertNull((Object)this.timer.getCounter((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY), () -> "Count: " + this.timer.getCounter((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY).getCount());
            this.idCounter -= 3L;
            this.createDocuments(index, 3);
            Assertions.assertNull((Object)this.timer.getCounter((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY), () -> "Count: " + this.timer.getCounter((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_QUERY).getCount());
            Assertions.assertEquals((int)3, (int)this.timer.getCounter((StoreTimer.Event)LuceneEvents.Events.LUCENE_DELETE_DOCUMENT_BY_PRIMARY_KEY).getCount());
        }});
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            indexMaintainer = (LuceneIndexMaintainer)this.recordStore.getIndexMaintainer(index);
            indexMaintainer.mergeIndex();
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
        context = this.openContext();
        try {
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            LuceneIndexTestValidator.validatePrimaryKeySegmentIndex(this.recordStore, index, Tuple.from((Object[])new Object[0]), null, primaryKeys, false);
        }
        finally {
            if (context != null) {
                context.close();
            }
        }
    }

    public FDBRecordContext openContext() {
        RecordLayerPropertyStorage contextProps = RecordLayerPropertyStorage.newBuilder().addProp(LuceneRecordContextProperties.LUCENE_MERGE_SEGMENTS_PER_TIER, (Object)2.0).build();
        return super.openContext(contextProps);
    }

    @Nonnull
    private Set<Tuple> createDocuments(Index index, int count) {
        HashSet<Tuple> primaryKeys = new HashSet<Tuple>();
        try (FDBRecordContext context = this.openContext();){
            this.rebuildIndexMetaData(context, "SimpleDocument", index);
            IntStream.range(0, count).mapToObj(i -> this.recordStore.saveRecord((Message)LuceneIndexTestUtils.createSimpleDocument(this.idCounter++, "Document " + this.textCounter++, 2)).getPrimaryKey()).forEach(primaryKeys::add);
            context.commit();
        }
        return primaryKeys;
    }

    private void rebuildIndexMetaData(FDBRecordContext context, String document, Index index) {
        Pair<FDBRecordStore, QueryPlanner> pair = LuceneIndexTestUtils.rebuildIndexMetaData(context, this.path, document, index, this.isUseCascadesPlanner());
        this.recordStore = (FDBRecordStore)pair.getLeft();
        this.planner = (QueryPlanner)pair.getRight();
        this.recordStore.getIndexDeferredMaintenanceControl().setAutoMergeDuringCommit(this.autoMerge);
    }

    static enum Version {
        Off(false, options -> {
            options.put("primaryKeySegmentIndexV2Enabled", "false");
            options.put("primaryKeySegmentIndexEnabled", "false");
        }),
        V1(true, options -> {
            options.remove("optimizedStoredFieldsFormatEnabled");
            options.remove("primaryKeySegmentIndexV2Enabled");
            options.put("primaryKeySegmentIndexEnabled", "true");
        }),
        V2(true, options -> {
            options.remove("optimizedStoredFieldsFormatEnabled");
            options.remove("primaryKeySegmentIndexEnabled");
            options.put("primaryKeySegmentIndexV2Enabled", "true");
        });

        private final Index simpleIndex;
        private final Index complexIndex;
        public final boolean enabled;

        private Version(boolean enabled, Consumer<Map<String, String>> optionsBuilder) {
            this.simpleIndex = LuceneIndexTestUtils.simpleTextSuffixesIndex(optionsBuilder);
            this.complexIndex = LuceneIndexTestUtils.textAndStoredComplexIndex(optionsBuilder);
            this.enabled = enabled;
        }
    }

    private static class FailCommitsAgilityContext
    extends AgilityContext.Agile {
        private final Object indexSubspaceKey;
        private int commitCount = 0;

        public FailCommitsAgilityContext(FDBRecordContext callerContext, Object indexSubspaceKey) {
            super(callerContext, null, 1L, 1L);
            this.indexSubspaceKey = indexSubspaceKey;
        }

        public void set(byte[] key, byte[] value) {
            int size;
            List keyItems = Tuple.fromBytes((byte[])key).getItems();
            if (keyItems.size() > 3 && keyItems.get((size = keyItems.size()) - 3).equals(this.indexSubspaceKey) && keyItems.get(size - 2).equals(1L) && keyItems.get(size - 1) instanceof String && ((String)keyItems.get(size - 1)).startsWith("segments_")) {
                ++this.commitCount;
                throw new FailedLuceneCommit();
            }
            super.set(key, value);
        }
    }

    private static class FailedLuceneCommit
    extends RuntimeException {
        private FailedLuceneCommit() {
        }
    }
}

