/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.lucene.LuceneFileSystemProto;
import com.apple.foundationdb.record.lucene.directory.LuceneSerializer;
import com.apple.foundationdb.record.util.RandomUtil;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="RequiresFDB")
public class LuceneCompressionTest {
    @Test
    void testEncodingWithoutCompression() throws InvalidProtocolBufferException {
        ByteString content = RandomUtil.randomByteString((Random)ThreadLocalRandom.current(), (int)100);
        LuceneFileSystemProto.LuceneFileReference reference = LuceneFileSystemProto.LuceneFileReference.newBuilder().setId(1L).setSize(20L).setBlockSize(10L).setContent(content).build();
        byte[] originalValue = reference.toByteArray();
        byte[] encodedValue = LuceneSerializer.encode((byte[])originalValue, (boolean)true, (boolean)false);
        byte[] decodedValue = LuceneSerializer.decode((byte[])encodedValue);
        byte[] expectedEncodedValue = new byte[originalValue.length + 1];
        System.arraycopy(originalValue, 0, expectedEncodedValue, 1, originalValue.length);
        Assertions.assertArrayEquals((byte[])expectedEncodedValue, (byte[])encodedValue);
        Assertions.assertArrayEquals((byte[])originalValue, (byte[])decodedValue);
        LuceneFileSystemProto.LuceneFileReference decompressedReference = LuceneFileSystemProto.LuceneFileReference.parseFrom((byte[])decodedValue);
        Assertions.assertEquals((long)1L, (long)decompressedReference.getId());
        Assertions.assertEquals((long)20L, (long)decompressedReference.getSize());
        Assertions.assertEquals((long)10L, (long)decompressedReference.getBlockSize());
        Assertions.assertEquals((Object)content, (Object)decompressedReference.getContent());
    }

    @Test
    void testEncodingWithCompression() throws InvalidProtocolBufferException {
        String duplicateMsg = "abcdefghijklmnopqrstuvwxyz";
        String content = "content_abcdefghijklmnopqrstuvwxyz_abcdefghijklmnopqrstuvwxyz";
        LuceneFileSystemProto.LuceneFileReference reference = LuceneFileSystemProto.LuceneFileReference.newBuilder().setId(1L).setSize(20L).setBlockSize(10L).setContent(ByteString.copyFromUtf8((String)"content_abcdefghijklmnopqrstuvwxyz_abcdefghijklmnopqrstuvwxyz")).build();
        byte[] value = reference.toByteArray();
        byte[] encodedValue = LuceneSerializer.encode((byte[])value, (boolean)true, (boolean)false);
        byte[] decodedValue = LuceneSerializer.decode((byte[])encodedValue);
        Assertions.assertTrue((value.length > encodedValue.length ? 1 : 0) != 0);
        Assertions.assertArrayEquals((byte[])value, (byte[])decodedValue);
        LuceneFileSystemProto.LuceneFileReference decompressedReference = LuceneFileSystemProto.LuceneFileReference.parseFrom((byte[])decodedValue);
        Assertions.assertEquals((long)1L, (long)decompressedReference.getId());
        Assertions.assertEquals((long)20L, (long)decompressedReference.getSize());
        Assertions.assertEquals((long)10L, (long)decompressedReference.getBlockSize());
        Assertions.assertEquals((Object)ByteString.copyFromUtf8((String)"content_abcdefghijklmnopqrstuvwxyz_abcdefghijklmnopqrstuvwxyz"), (Object)decompressedReference.getContent());
    }
}

