/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.lucene.ngram.NgramAnalyzer;
import com.apple.foundationdb.record.lucene.synonym.SynonymAnalyzer;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LuceneAnalyzerTest {
    @Test
    void testNgramAnalyzer() throws Exception {
        String input = "hello RL";
        HashSet<String> result = new HashSet<String>();
        LuceneAnalyzerTest.tokenizeWithAnalyzer(result, input, (Analyzer)new NgramAnalyzer(null, 3, 10, false));
        Assertions.assertEquals((Object)ImmutableSet.of((Object)"hel", (Object)"ell", (Object)"llo", (Object)"hell", (Object)"ello", (Object)"hello", (Object[])new String[]{"rl"}), result);
    }

    @Test
    void testEdgesOnlyNgramAnalyzer() throws Exception {
        String input = "hello RL";
        HashSet<String> result = new HashSet<String>();
        LuceneAnalyzerTest.tokenizeWithAnalyzer(result, input, (Analyzer)new NgramAnalyzer(null, 3, 10, true));
        Assertions.assertEquals((Object)ImmutableSet.of((Object)"hel", (Object)"hell", (Object)"hello", (Object)"rl"), result);
    }

    @Test
    void testNgramAnalyzerWithStopWords() throws Exception {
        CharArraySet stopSet = new CharArraySet(List.of("hello"), false);
        CharArraySet stopWords = CharArraySet.unmodifiableSet((CharArraySet)stopSet);
        String input = "hello RL";
        HashSet<String> result = new HashSet<String>();
        LuceneAnalyzerTest.tokenizeWithAnalyzer(result, input, (Analyzer)new NgramAnalyzer(stopWords, 3, 10, false));
        Assertions.assertEquals((Object)ImmutableSet.of((Object)"rl"), result);
    }

    @Test
    void testSynonymAnalyzer() throws Exception {
        String input = "Hello RL";
        HashSet<String> result = new HashSet<String>();
        LuceneAnalyzerTest.tokenizeWithAnalyzer(result, input, (Analyzer)new SynonymAnalyzer(null, "EXPANDED_US_EN"));
        Assertions.assertEquals((Object)ImmutableSet.of((Object)"hi", (Object)"how", (Object)"hullo", (Object)"howdy", (Object)"rl", (Object)"hello", (Object[])new String[]{"do", "you"}), result);
    }

    @Test
    void testStandardAnalyzer() throws Exception {
        String input = "hello RL";
        HashSet<String> result = new HashSet<String>();
        LuceneAnalyzerTest.tokenizeWithAnalyzer(result, input, (Analyzer)new StandardAnalyzer());
        Assertions.assertEquals((Object)ImmutableSet.of((Object)"hello", (Object)"rl"), result);
    }

    private static void tokenizeWithAnalyzer(Collection<String> result, @Nonnull String input, Analyzer analyzer) throws IOException {
        try (TokenStream stream = analyzer.tokenStream("field", (Reader)new StringReader(input));){
            stream.reset();
            while (stream.incrementToken()) {
                result.add(((CharTermAttribute)stream.getAttribute(CharTermAttribute.class)).toString());
            }
            stream.end();
        }
    }
}

