/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.EvaluationContext;
import com.apple.foundationdb.record.ExecuteProperties;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.TestRecordsTextProto;
import com.apple.foundationdb.record.lucene.LuceneIndexTestUtils;
import com.apple.foundationdb.record.lucene.LucenePlanner;
import com.apple.foundationdb.record.lucene.LuceneRecordContextProperties;
import com.apple.foundationdb.record.lucene.synonym.SynonymMapRegistryImpl;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.common.RecordSerializer;
import com.apple.foundationdb.record.provider.common.text.TextSamples;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecord;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.provider.foundationdb.indexes.TextIndexTestUtils;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyStorage;
import com.apple.foundationdb.record.provider.foundationdb.query.FDBRecordStoreQueryTestBase;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.PlannableIndexTypes;
import com.apple.foundationdb.record.query.plan.plans.QueryResult;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

@Tag(value="RequiresFDB")
public class FDBLuceneMapQueryTest
extends FDBRecordStoreQueryTestBase {
    private static final String MAP_DOC = "MapDocument";
    private static final KeyExpression mapString2LongIndexExpression = Key.Expressions.field((String)"stringToLongMap").nest((KeyExpression)Key.Expressions.function((String)"lucene_field_name", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"values", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.function((String)"lucene_field_name", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"value"), (KeyExpression)Key.Expressions.field((String)"key"), (KeyExpression[])new KeyExpression[0]))), (KeyExpression)Key.Expressions.value(null), (KeyExpression[])new KeyExpression[0])));
    private static final KeyExpression mapStringWrapper2LongIndexExpression = Key.Expressions.field((String)"stringWrapperToLongMap").nest((KeyExpression)Key.Expressions.function((String)"lucene_field_name", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"values", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.function((String)"lucene_field_name", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"value"), (KeyExpression)Key.Expressions.field((String)"key").nest("value"), (KeyExpression[])new KeyExpression[0]))), (KeyExpression)Key.Expressions.value(null), (KeyExpression[])new KeyExpression[0])));
    private static final KeyExpression mapString2IntIndexExpression = Key.Expressions.field((String)"stringToIntMap").nest((KeyExpression)Key.Expressions.function((String)"lucene_field_name", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"values", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.function((String)"lucene_field_name", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"value"), (KeyExpression)Key.Expressions.field((String)"key"), (KeyExpression[])new KeyExpression[0]))), (KeyExpression)Key.Expressions.value(null), (KeyExpression[])new KeyExpression[0])));
    private static final KeyExpression mapString2DoubleIndexExpression = Key.Expressions.field((String)"stringToDoubleMap").nest((KeyExpression)Key.Expressions.function((String)"lucene_field_name", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"values", (KeyExpression.FanType)KeyExpression.FanType.FanOut).nest((KeyExpression)Key.Expressions.function((String)"lucene_field_name", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"value"), (KeyExpression)Key.Expressions.field((String)"key"), (KeyExpression[])new KeyExpression[0]))), (KeyExpression)Key.Expressions.value(null), (KeyExpression[])new KeyExpression[0])));
    private static final Index MAP_STRING_2_LONG_LUCENE_INDEX = new Index("MapField$string2long", (KeyExpression)Key.Expressions.concat((KeyExpression)mapString2LongIndexExpression, (KeyExpression)Key.Expressions.field((String)"doc_id"), (KeyExpression[])new KeyExpression[0]), "lucene");
    private static final Index MAP_STRING_WRAPPER_TO_LONG_LUCENE_INDEX = new Index("MapField$stringWrapper2long", (KeyExpression)Key.Expressions.concat((KeyExpression)mapStringWrapper2LongIndexExpression, (KeyExpression)Key.Expressions.field((String)"doc_id"), (KeyExpression[])new KeyExpression[0]), "lucene");
    private static final Index MAP_STRING_2_INT_LUCENE_INDEX = new Index("MapField$string2int", (KeyExpression)Key.Expressions.concat((KeyExpression)mapString2IntIndexExpression, (KeyExpression)Key.Expressions.field((String)"doc_id"), (KeyExpression[])new KeyExpression[0]), "lucene");
    private static final Index MAP_STRING_2_DOUBLE_LUCENE_INDEX = new Index("MapField$string2double", (KeyExpression)Key.Expressions.concat((KeyExpression)mapString2DoubleIndexExpression, (KeyExpression)Key.Expressions.field((String)"doc_id"), (KeyExpression[])new KeyExpression[0]), "lucene");
    private static List<String> textSamples = Arrays.asList("Two households, both alike in dignity,\nIn fair Verona, where we lay our scene,\nFrom ancient grudge break to new mutiny,\nWhere civil blood makes civil hands unclean.\nFrom forth the fatal loins of these two foes\nA pair of star-cross\u2019d lovers take their life;\nWhose misadventur\u2019d piteous overthrows\nDoth with their death bury their parents\u2019 strife.\nThe fearful passage of their death-mark\u2019d love,\nAnd the continuance of their parents\u2019 rage,\nWhich, but their children\u2019s end, nought could remove,\nIs now the two hours\u2019 traffic of our stage;\nThe which, if you with patient ears attend,\nWhat here shall miss, our toil shall strive to mend.", "According to the encyclop\u00e6dia, \u00c6thelred the Unr\u00e6d was king from 966 to 1016.", "Two households, both alike in dignity,\nIn fair Verona, where we lay our scene,\nFrom ancient grudge break to new mutiny,\nWhere civil blood makes civil hands unclean.\nFrom forth the fatal loins of these two foes\nA pair of star-cross\u2019d lovers take their life;\nWhose misadventur\u2019d piteous overthrows\nDoth with their death bury their parents\u2019 strife.\nThe fearful passage of their death-mark\u2019d love,\nAnd the continuance of their parents\u2019 rage,\nWhich, but their children\u2019s end, nought could remove,\nIs now the two hours\u2019 traffic of our stage;\nThe which, if you with patient ears attend,\nWhat here shall miss, our toil shall strive to mend.", "The Angstrom unit (\u212b) was named after Anders \u00c5ngstr\u00f6m.", "According to the encyclop\u00e6dia, \u00c6thelred the Unr\u00e6d was king from 966 to 1016.", TextSamples.FRENCH);
    private static final List<TestRecordsTextProto.MapDocument> mapDocuments = FDBLuceneMapQueryTest.createMapDocuments();
    private ExecutorService executorService = null;

    @BeforeAll
    public static void setup() {
        SynonymMapRegistryImpl.instance().getSynonymMap("EXPANDED_US_EN");
    }

    public void setupPlanner(@Nullable PlannableIndexTypes indexTypes) {
        if (indexTypes == null) {
            indexTypes = new PlannableIndexTypes((Set)Sets.newHashSet((Object[])new String[]{"value", "version"}), (Set)Sets.newHashSet((Object[])new String[]{"rank", "time_window_leaderboard"}), (Set)Sets.newHashSet((Object[])new String[]{"text"}), (Set)Sets.newHashSet((Object[])new String[]{"lucene"}));
        }
        this.planner = new LucenePlanner(this.recordStore.getRecordMetaData(), this.recordStore.getRecordStoreState(), indexTypes, this.recordStore.getTimer());
    }

    protected RecordLayerPropertyStorage.Builder addDefaultProps(RecordLayerPropertyStorage.Builder props) {
        return super.addDefaultProps(props).addProp(LuceneRecordContextProperties.LUCENE_EXECUTOR_SERVICE, () -> this.executorService);
    }

    protected void openRecordStore(FDBRecordContext context) {
        this.openRecordStore(context, md -> {}, LuceneIndexTestUtils.SIMPLE_TEXT_SUFFIXES);
    }

    protected void openRecordStore(FDBRecordContext context, FDBRecordStoreTestBase.RecordMetaDataHook hook, Index simpleDocIndex) {
        RecordMetaDataBuilder metaDataBuilder = RecordMetaData.newBuilder().setRecords(TestRecordsTextProto.getDescriptor());
        metaDataBuilder.getRecordType("ComplexDocument").setPrimaryKey((KeyExpression)Key.Expressions.concatenateFields((String)"group", (String)"doc_id", (String[])new String[0]));
        if (simpleDocIndex != null) {
            metaDataBuilder.removeIndex("SimpleDocument$text");
            metaDataBuilder.addIndex("SimpleDocument", simpleDocIndex);
        }
        metaDataBuilder.addIndex(MAP_DOC, MAP_STRING_2_LONG_LUCENE_INDEX);
        metaDataBuilder.addIndex(MAP_DOC, MAP_STRING_WRAPPER_TO_LONG_LUCENE_INDEX);
        metaDataBuilder.addIndex(MAP_DOC, MAP_STRING_2_INT_LUCENE_INDEX);
        metaDataBuilder.addIndex(MAP_DOC, MAP_STRING_2_DOUBLE_LUCENE_INDEX);
        hook.apply(metaDataBuilder);
        this.recordStore = (FDBRecordStore)this.getStoreBuilder(context, metaDataBuilder.getRecordMetaData()).setSerializer((RecordSerializer)TextIndexTestUtils.COMPRESSING_SERIALIZER).createOrOpen();
        this.setupPlanner(null);
    }

    private void initializeNested() {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            mapDocuments.forEach(arg_0 -> ((FDBRecordStore)this.recordStore).saveRecord(arg_0));
            this.commit(context);
        }
    }

    public static Stream<Arguments> valueQueryParameters() {
        return Stream.of(Stream.of(Pair.of((Object)"d", (Object)true), Pair.of((Object)"Blah", (Object)false), Pair.of((Object)"c", (Object)false)).map(pair -> Arguments.of((Object[])new Object[]{Query.field((String)"stringToLongMap").matches(Query.field((String)"values").oneOfThem().matches(Query.field((String)"key").equalsValue(pair.getLeft()))), pair.getRight(), "MapField$string2long"})), Stream.of(Pair.of((Object)"c", (Object)true), Pair.of((Object)"Blah", (Object)false), Pair.of((Object)"d", (Object)false)).map(pair -> Arguments.of((Object[])new Object[]{Query.field((String)"stringWrapperToLongMap").matches(Query.field((String)"values").oneOfThem().matches(Query.field((String)"key").matches(Query.field((String)"value").equalsValue(pair.getLeft())))), pair.getRight(), "MapField$stringWrapper2long"})), Stream.of(Pair.of((Object)"f", (Object)true), Pair.of((Object)"Blah", (Object)false), Pair.of((Object)"d", (Object)false)).map(pair -> Arguments.of((Object[])new Object[]{Query.field((String)"stringToIntMap").matches(Query.field((String)"values").oneOfThem().matches(Query.field((String)"key").equalsValue(pair.getLeft()))), pair.getRight(), "MapField$string2int"})), Stream.of(Pair.of((Object)"g", (Object)true), Pair.of((Object)"Blah", (Object)false), Pair.of((Object)"a", (Object)false)).map(pair -> Arguments.of((Object[])new Object[]{Query.field((String)"stringToDoubleMap").matches(Query.field((String)"values").oneOfThem().matches(Query.field((String)"key").equalsValue(pair.getLeft()))), pair.getRight(), "MapField$string2double"}))).flatMap(Function.identity());
    }

    public static Stream<Arguments> parameterQueryParameters() {
        return Stream.of(Stream.of(Pair.of((Object)"d", (Object)true), Pair.of((Object)"Blah", (Object)false), Pair.of((Object)"a", (Object)false)).map(pair -> Arguments.of((Object[])new Object[]{Query.field((String)"stringToLongMap").matches(Query.field((String)"values").oneOfThem().matches(Query.field((String)"key").equalsParameter("$param"))), pair.getRight(), pair.getLeft(), "MapField$string2long"})), Stream.of(Pair.of((Object)"f", (Object)true), Pair.of((Object)"Blah", (Object)false), Pair.of((Object)"d", (Object)false)).map(pair -> Arguments.of((Object[])new Object[]{Query.field((String)"stringToIntMap").matches(Query.field((String)"values").oneOfThem().matches(Query.field((String)"key").equalsParameter("$param"))), pair.getRight(), pair.getLeft(), "MapField$string2int"})), Stream.of(Pair.of((Object)"g", (Object)true), Pair.of((Object)"Blah", (Object)false), Pair.of((Object)"a", (Object)false)).map(pair -> Arguments.of((Object[])new Object[]{Query.field((String)"stringToDoubleMap").matches(Query.field((String)"values").oneOfThem().matches(Query.field((String)"key").equalsParameter("$param"))), pair.getRight(), pair.getLeft(), "MapField$string2double"}))).flatMap(Function.identity());
    }

    @MethodSource(value={"valueQueryParameters"})
    @ParameterizedTest
    void mapQueryWithEmbeddedValue(QueryComponent filter, boolean found, String expectedIndex) throws Exception {
        this.initializeNested();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            RecordQuery query = RecordQuery.newBuilder().setRecordType(MAP_DOC).setFilter(filter).build();
            RecordQueryPlan plan = this.planQuery(query);
            Assertions.assertTrue((boolean)plan.getUsedIndexes().contains(expectedIndex));
            try (RecordCursor recordCursor = this.recordStore.executeQuery(plan);){
                List primaryKeys = (List)recordCursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                Set expected = found ? Set.of(Long.valueOf(0L), Long.valueOf(1L), Long.valueOf(2L)) : Set.of();
                Assertions.assertEquals(expected, Set.copyOf(primaryKeys));
            }
        }
    }

    @MethodSource(value={"parameterQueryParameters"})
    @ParameterizedTest
    void mapQueryWithParameterizedValue(QueryComponent filter, boolean found, String value, String expectedIndex) throws Exception {
        this.initializeNested();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            RecordQuery query = RecordQuery.newBuilder().setRecordType(MAP_DOC).setFilter(filter).build();
            RecordQueryPlan plan = this.planQuery(query);
            Assertions.assertTrue((boolean)plan.getUsedIndexes().contains(expectedIndex));
            try (RecordCursor recordCursor = this.recordStore.executeQuery(plan, null, EvaluationContext.forBinding((String)"$param", (Object)value), ExecuteProperties.SERIAL_EXECUTE);){
                List primaryKeys = (List)recordCursor.map(QueryResult::getQueriedRecord).map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                Set expected = found ? Set.of(Long.valueOf(0L), Long.valueOf(1L), Long.valueOf(2L)) : Set.of();
                Assertions.assertEquals(expected, Set.copyOf(primaryKeys));
            }
        }
    }

    @Test
    void mapStringToLongValueSearch() throws Exception {
        this.initializeNested();
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context);
            RecordQuery query = RecordQuery.newBuilder().setRecordType(MAP_DOC).setFilter(Query.field((String)"stringToLongMap").matches(Query.field((String)"values").oneOfThem().matches(Query.field((String)"value").equalsValue((Object)1L)))).build();
            RecordQueryPlan plan = this.planQuery(query);
            Assertions.assertTrue((boolean)plan.getUsedIndexes().isEmpty());
            try (RecordCursor recordCursor = this.recordStore.executeQuery(plan);){
                List primaryKeys = (List)recordCursor.map(FDBRecord::getPrimaryKey).map(t -> t.getLong(0)).asList().get();
                Set<Long> expected = Set.of(Long.valueOf(1L));
                Assertions.assertEquals(expected, Set.copyOf(primaryKeys));
            }
        }
    }

    @Nonnull
    private static List<TestRecordsTextProto.MapDocument> createMapDocuments() {
        List<TestRecordsTextProto.MapDocument> result = IntStream.range(0, textSamples.size() / 2).mapToObj(i -> TestRecordsTextProto.MapDocument.newBuilder().setDocId((long)i).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("a").setValue(textSamples.get(i * 2))).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("b").setValue(textSamples.get(i * 2 + 1))).setStringToLongMap(FDBLuceneMapQueryTest.getStringToLongMap(i, "d")).setStringWrapperToLongMap(FDBLuceneMapQueryTest.getStringWrapperToLongMap(i, "c")).setStringToIntMap(FDBLuceneMapQueryTest.getStringToIntMap(i, "f")).setStringToDoubleMap(FDBLuceneMapQueryTest.getStringToDoubleMap(i, "g")).setGroup((long)(i % 2)).build()).collect(Collectors.toList());
        result.add(TestRecordsTextProto.MapDocument.newBuilder().setDocId(1000L).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("a").setValue(textSamples.get(0))).addEntry(TestRecordsTextProto.MapDocument.Entry.newBuilder().setKey("b").setValue(textSamples.get(1))).setStringToLongMap(FDBLuceneMapQueryTest.getStringToLongMap(1000, "NOT_FOUND")).setStringWrapperToLongMap(FDBLuceneMapQueryTest.getStringWrapperToLongMap(1000, "NOT_FOUND")).setStringToIntMap(FDBLuceneMapQueryTest.getStringToIntMap(1000, "NOT_FOUND")).setStringToDoubleMap(FDBLuceneMapQueryTest.getStringToDoubleMap(1000, "NOT_FOUND")).setGroup(1000L).build());
        result.add(TestRecordsTextProto.MapDocument.newBuilder().setDocId(1001L).build());
        return result;
    }

    @Nonnull
    private static TestRecordsTextProto.MapDocument.String2Long.Builder getStringToLongMap(int i, String value) {
        TestRecordsTextProto.MapDocument.String2Long.Builder builder = TestRecordsTextProto.MapDocument.String2Long.newBuilder().addValues(TestRecordsTextProto.MapDocument.String2LongPair.newBuilder().setKey(value).setValue((long)i));
        if (i % 2 == 0) {
            builder.addValues(TestRecordsTextProto.MapDocument.String2LongPair.newBuilder().setKey("X").setValue((long)(i + 10)));
        }
        return builder;
    }

    @Nonnull
    private static TestRecordsTextProto.MapDocument.StringWrapper2Long.Builder getStringWrapperToLongMap(int i, String value) {
        TestRecordsTextProto.MapDocument.StringWrapper2Long.Builder builder = TestRecordsTextProto.MapDocument.StringWrapper2Long.newBuilder().addValues(TestRecordsTextProto.MapDocument.StringWrapper2LongPair.newBuilder().setKey(TestRecordsTextProto.MapDocument.StringWrapper.newBuilder().setValue(value).setFlags(5)).setValue((long)i));
        if (i % 2 == 0) {
            builder.addValues(TestRecordsTextProto.MapDocument.StringWrapper2LongPair.newBuilder().setKey(TestRecordsTextProto.MapDocument.StringWrapper.newBuilder().setValue("X").setFlags(5)).setValue((long)(i + 10)));
        }
        return builder;
    }

    @Nonnull
    private static TestRecordsTextProto.MapDocument.String2Int.Builder getStringToIntMap(int i, String value) {
        TestRecordsTextProto.MapDocument.String2Int.Builder builder = TestRecordsTextProto.MapDocument.String2Int.newBuilder().addValues(TestRecordsTextProto.MapDocument.String2IntPair.newBuilder().setKey(value).setValue(i));
        if (i % 2 == 0) {
            builder.addValues(TestRecordsTextProto.MapDocument.String2IntPair.newBuilder().setKey("X").setValue(i + 10));
        }
        return builder;
    }

    @Nonnull
    private static TestRecordsTextProto.MapDocument.String2Double.Builder getStringToDoubleMap(int i, String value) {
        TestRecordsTextProto.MapDocument.String2Double.Builder builder = TestRecordsTextProto.MapDocument.String2Double.newBuilder().addValues(TestRecordsTextProto.MapDocument.String2DoublePair.newBuilder().setKey(value).setValue((double)i + 7.8));
        if (i % 2 == 0) {
            builder.addValues(TestRecordsTextProto.MapDocument.String2DoublePair.newBuilder().setKey("X").setValue((double)i + 17.8));
        }
        return builder;
    }
}

