/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.synonym;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneLogMessageKeys;
import java.io.InputStream;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public interface SynonymMapConfig {
    public String getName();

    public InputStream getSynonymInputStream();

    public boolean expand();

    @Nonnull
    public static InputStream openFile(@Nonnull String file) {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
        if (stream == null) {
            throw new RecordCoreException("Synonym file not found", new Object[0]).addLogInfo(new Object[]{LuceneLogMessageKeys.FILE_NAME, file});
        }
        return stream;
    }
}

