/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.synonym;

import com.apple.foundationdb.record.lucene.AnalyzerChooser;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerFactory;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerType;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerWrapper;
import com.apple.foundationdb.record.lucene.synonym.SynonymMapRegistryImpl;
import com.apple.foundationdb.record.metadata.Index;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizer;
import org.apache.lucene.analysis.synonym.SynonymGraphFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;

public class SynonymAnalyzer
extends StopwordAnalyzerBase {
    @Nonnull
    private final String name;
    private int maxTokenLength = 255;

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public CharArraySet getStopwords() {
        return this.stopwords;
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public SynonymAnalyzer(@Nullable CharArraySet stopwords, @Nonnull String name) {
        super(stopwords);
        this.name = name;
    }

    public SynonymAnalyzer(@Nullable CharArraySet stopwords, @Nonnull String name, int maxTokenLength) {
        super(stopwords);
        this.name = name;
        this.maxTokenLength = maxTokenLength;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        UAX29URLEmailTokenizer src = new UAX29URLEmailTokenizer();
        src.setMaxTokenLength(this.maxTokenLength);
        LowerCaseFilter tok = new LowerCaseFilter((TokenStream)src);
        tok = new StopFilter((TokenStream)tok, this.stopwords);
        tok = new SynonymGraphFilter((TokenStream)tok, this.getSynonymMap(), true);
        return new Analyzer.TokenStreamComponents(r -> {
            src.setMaxTokenLength(this.maxTokenLength);
            src.setReader(r);
        }, (TokenStream)tok);
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }

    @Nonnull
    private SynonymMap getSynonymMap() {
        return SynonymMapRegistryImpl.instance().getSynonymMap(this.name);
    }

    public static class AuthoritativeSynonymOnlyAnalyzerFactory
    implements LuceneAnalyzerFactory {
        public static final String ANALYZER_FACTORY_NAME = "INDEX_ONLY_SYNONYM";

        @Override
        @Nonnull
        public String getName() {
            return ANALYZER_FACTORY_NAME;
        }

        @Override
        @Nonnull
        public LuceneAnalyzerType getType() {
            return LuceneAnalyzerType.FULL_TEXT;
        }

        @Override
        @Nonnull
        public AnalyzerChooser getIndexAnalyzerChooser(@Nonnull Index index) {
            String name = Objects.requireNonNullElse(index.getOption("textSynonymSetName"), "AUTHORITATIVE_ONLY_US_EN");
            return () -> new LuceneAnalyzerWrapper(ANALYZER_FACTORY_NAME, (Analyzer)new SynonymAnalyzer(EnglishAnalyzer.ENGLISH_STOP_WORDS_SET, name));
        }

        @Override
        @Nonnull
        public AnalyzerChooser getQueryAnalyzerChooser(@Nonnull Index index, @Nonnull AnalyzerChooser indexAnalyzerChooser) {
            return indexAnalyzerChooser;
        }
    }

    public static class QueryOnlySynonymAnalyzerFactory
    implements LuceneAnalyzerFactory {
        public static final String ANALYZER_FACTORY_NAME = "SYNONYM";

        @Override
        @Nonnull
        public String getName() {
            return ANALYZER_FACTORY_NAME;
        }

        @Override
        @Nonnull
        public LuceneAnalyzerType getType() {
            return LuceneAnalyzerType.FULL_TEXT;
        }

        @Override
        @Nonnull
        public AnalyzerChooser getIndexAnalyzerChooser(@Nonnull Index index) {
            return LuceneAnalyzerWrapper::getStandardAnalyzerWrapper;
        }

        @Override
        @Nonnull
        public AnalyzerChooser getQueryAnalyzerChooser(@Nonnull Index index, @Nonnull AnalyzerChooser indexAnalyzerChooser) {
            String name = Objects.requireNonNullElse(index.getOption("textSynonymSetName"), "EXPANDED_US_EN");
            return () -> new LuceneAnalyzerWrapper(ANALYZER_FACTORY_NAME, (Analyzer)new SynonymAnalyzer(EnglishAnalyzer.ENGLISH_STOP_WORDS_SET, name));
        }
    }
}

