/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.search;

import com.apple.foundationdb.record.lucene.search.ConfigAwareQueryParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.Token;
import org.apache.lucene.queryparser.flexible.standard.config.PointsConfig;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;

public class LuceneOptimizedMultiFieldQueryParser
extends MultiFieldQueryParser
implements ConfigAwareQueryParser {
    @Nonnull
    private final Map<String, PointsConfig> pointsConfig;

    public LuceneOptimizedMultiFieldQueryParser(String[] fields, Analyzer analyzer, @Nonnull Map<String, PointsConfig> pointsConfig) {
        super(fields, analyzer);
        this.pointsConfig = pointsConfig;
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        if (field == null) {
            ArrayList<Query> clauses = new ArrayList<Query>();
            Map boostMap = this.boosts == null ? Collections.emptyMap() : this.boosts;
            for (String s : this.fields) {
                Query q = super.getFieldQuery(s, queryText, true);
                if (q == null) continue;
                Float boost = (Float)boostMap.get(s);
                if (boost != null) {
                    q = new BoostQuery(q, boost.floatValue());
                }
                q = this.addSlop(q, slop);
                clauses.add(q);
            }
            if (clauses.isEmpty()) {
                return null;
            }
            return this.getMultiFieldQuery(clauses);
        }
        Query q = super.getFieldQuery(field, queryText, true);
        q = this.addSlop(q, slop);
        return q;
    }

    protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        return this.attemptConstructFieldQueryWithPointsConfig(field, queryText, quoted);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        return this.attemptConstructRangeQueryWithPointsConfig(field, part1, part2, startInclusive, endInclusive);
    }

    @Override
    @Nonnull
    public Map<String, PointsConfig> getPointsConfig() {
        return this.pointsConfig;
    }

    @Override
    @Nonnull
    public Query constructFieldWithoutPointsConfig(@Nonnull String field, @Nonnull String queryText, boolean quoted) throws ParseException {
        return super.getFieldQuery(field, queryText, quoted);
    }

    @Override
    @Nonnull
    public Query constructRangeQueryWithoutPointsConfig(@Nonnull String field, @Nonnull String part1, @Nonnull String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        return super.getRangeQuery(field, part1, part2, startInclusive, endInclusive);
    }

    @Override
    @Nonnull
    public final Token nextToken() {
        return this.getNextToken();
    }
}

