/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.search;

import com.apple.foundationdb.async.AsyncUtil;
import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.util.pair.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryHelper;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ThreadInterruptedException;

public class LuceneOptimizedIndexSearcher
extends IndexSearcher {
    public LuceneOptimizedIndexSearcher(IndexReader r) {
        super(r);
    }

    public LuceneOptimizedIndexSearcher(IndexReader r, Executor executor) {
        super(r, executor);
    }

    public void search(Query query, Collector results) throws IOException {
        query = this.rewrite(query);
        Executor executor = this.getExecutor();
        Weight weight = this.createWeight(query, results.scoreMode(), 1.0f);
        if (executor == null) {
            this.search(this.leafContexts, weight, results);
        } else {
            try {
                this.searchOptimized(executor, weight, this.leafContexts, results).join();
            }
            catch (WrapperException we) {
                throw we.unwrap();
            }
            catch (RecordCoreException ex) {
                throw LuceneExceptions.toIoException(ex, null);
            }
        }
    }

    public <C extends Collector, T> T search(Query query, CollectorManager<C, T> collectorManager) throws IOException {
        IndexSearcher.LeafSlice[] leafSlices = this.getSlices();
        Executor executor = this.getExecutor();
        if (executor == null || leafSlices.length <= 1) {
            Collector collector = collectorManager.newCollector();
            this.search(query, collector);
            return (T)collectorManager.reduce(Collections.singletonList(collector));
        }
        ArrayList<Collector> collectors = new ArrayList<Collector>(leafSlices.length);
        ScoreMode scoreMode = null;
        for (int i = 0; i < leafSlices.length; ++i) {
            Collector collector = collectorManager.newCollector();
            collectors.add(collector);
            if (scoreMode == null) {
                scoreMode = collector.scoreMode();
                continue;
            }
            if (scoreMode == collector.scoreMode()) continue;
            throw new IllegalStateException("CollectorManager does not always produce collectors with the same score mode");
        }
        if (scoreMode == null) {
            scoreMode = ScoreMode.COMPLETE;
        }
        query = this.rewrite(query);
        Weight weight = this.createWeight(query, scoreMode, 1.0f);
        ArrayList<CompletableFuture<Collector>> topDocsFutures = new ArrayList<CompletableFuture<Collector>>(leafSlices.length);
        for (int i = 0; i < leafSlices.length; ++i) {
            LeafReaderContext[] leafReaderContextArray = leafSlices[i].leaves;
            Collector collector = (Collector)collectors.get(i);
            CompletableFuture<Collector> future = this.searchOptimized(executor, weight, Arrays.asList(leafReaderContextArray), collector);
            topDocsFutures.add(future);
        }
        for (Future future : topDocsFutures) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                throw new ThreadInterruptedException(e);
            }
            catch (ExecutionException e) {
                throw LuceneExceptions.toIoException(e.getCause(), e);
            }
            catch (WrapperException we) {
                throw we.unwrap();
            }
        }
        return (T)collectorManager.reduce(collectors);
    }

    @Nonnull
    private <C extends Collector> CompletableFuture<C> searchOptimized(@Nonnull Executor executor, @Nonnull Weight weight, @Nonnull List<LeafReaderContext> leaves, @Nonnull C collector) {
        List dependencies = leaves.stream().map(ctx -> CompletableFuture.supplyAsync(() -> {
            try {
                Pair result = Pair.of((Object)collector.getLeafCollector(ctx), (Object)weight.bulkScorer(ctx));
                return Pair.of((Object)ctx, (Object)result);
            }
            catch (CollectionTerminatedException cte) {
                return Pair.of((Object)ctx, (Object)null);
            }
            catch (IOException ioe) {
                throw new WrapperException(ioe);
            }
        }, executor)).collect(Collectors.toList());
        return AsyncUtil.whenAll(dependencies).thenApplyAsync(ignored -> {
            dependencies.stream().map(CompletableFuture::join).collect(Collectors.toList()).forEach(result -> {
                Pair scorer = (Pair)result.getRight();
                LeafReaderContext ctx = (LeafReaderContext)result.getLeft();
                if (scorer != null && scorer.getLeft() != null && scorer.getRight() != null) {
                    try {
                        ((BulkScorer)scorer.getRight()).score((LeafCollector)scorer.getLeft(), ctx.reader().getLiveDocs());
                    }
                    catch (CollectionTerminatedException collectionTerminatedException) {
                    }
                    catch (IOException ioe) {
                        throw new WrapperException(ioe);
                    }
                }
            });
            return collector;
        }, executor);
    }

    public Weight createWeight(Query query, ScoreMode scoreMode, float boost) throws IOException {
        if (scoreMode.needsScores() && this.getExecutor() != null) {
            List<Term> terms = QueryHelper.getQueriesTerms(query);
            for (Term term : terms) {
                for (LeafReaderContext ctx : this.getTopReaderContext().leaves()) {
                    CompletableFuture.runAsync(() -> {
                        try {
                            LuceneOptimizedIndexSearcher.cacheTermsEnum(ctx, term);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }, this.getExecutor());
                }
            }
        }
        return super.createWeight(query, scoreMode, boost);
    }

    private static void cacheTermsEnum(LeafReaderContext ctx, Term term) throws IOException {
        Terms terms = ctx.reader().terms(term.field());
        if (terms != null) {
            TermsEnum termsEnum = terms.iterator();
            termsEnum.seekExact(term.bytes());
        }
    }

    private static class WrapperException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        @Nonnull
        private final IOException ioe;

        WrapperException(@Nonnull IOException ioe) {
            this.ioe = ioe;
        }

        @Nonnull
        public IOException unwrap() {
            return this.ioe;
        }
    }
}

