/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.idformat;

import com.apple.foundationdb.record.lucene.idformat.RecordCoreFormatException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class RecordIdFormat {
    @Nonnull
    private final TupleElement element;

    public RecordIdFormat(@Nonnull TupleElement element) {
        this.element = element;
    }

    public static RecordIdFormat of(FormatElement ... elements) {
        return new RecordIdFormat(TupleElement.of(elements));
    }

    @Nonnull
    public TupleElement getElement() {
        return this.element;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecordIdFormat)) {
            return false;
        }
        RecordIdFormat that = (RecordIdFormat)o;
        return this.element.equals(that.element);
    }

    public int hashCode() {
        return Objects.hash(this.element);
    }

    public String toString() {
        return this.element.toString();
    }

    public static class TupleElement
    implements FormatElement {
        @Nonnull
        private final List<FormatElement> children;

        public TupleElement(@Nonnull List<FormatElement> children) {
            if (children.isEmpty()) {
                throw new RecordCoreFormatException("Tuple element cannot be empty", new Object[0]);
            }
            this.children = children;
        }

        @Nonnull
        public List<FormatElement> getChildren() {
            return this.children;
        }

        @Nonnull
        public static TupleElement of(FormatElement ... children) {
            return new TupleElement(List.of(children));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof TupleElement)) {
                return false;
            }
            TupleElement that = (TupleElement)o;
            return this.children.equals(that.children);
        }

        public int hashCode() {
            return Objects.hash(this.children);
        }

        public String toString() {
            return "[" + this.getChildren().stream().map(Objects::toString).collect(Collectors.joining(",")) + "]";
        }
    }

    public static interface FormatElement {
    }

    public static enum FormatElementType implements FormatElement
    {
        NONE(0),
        NULL(1),
        INT32(5),
        INT32_OR_NULL(5),
        INT64(9),
        INT64_OR_NULL(9),
        UUID_AS_STRING(17),
        STRING_16(27);

        private final int allocatedSize;

        private FormatElementType(int allocatedSize) {
            this.allocatedSize = allocatedSize;
        }

        public int getAllocatedSize() {
            return this.allocatedSize;
        }
    }
}

