/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.highlight;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.RecordCoreArgumentException;
import com.apple.foundationdb.record.lucene.highlight.HighlightedTerm;
import java.text.BreakIterator;
import java.util.function.Supplier;
import org.apache.lucene.search.uhighlight.Passage;
import org.apache.lucene.search.uhighlight.PassageFormatter;

@API(value=API.Status.INTERNAL)
public class SnippetFormatter
extends PassageFormatter {
    private final Supplier<BreakIterator> breakIterator;
    private final int snippetSize;
    private static final String ELLIPSIS = "...";
    private final String fieldName;

    public SnippetFormatter(String fieldName, Supplier<BreakIterator> breakIterator, int snippetSize) {
        this.fieldName = fieldName;
        this.breakIterator = breakIterator;
        this.snippetSize = snippetSize;
        if (snippetSize <= 0) {
            throw new RecordCoreArgumentException("Cannot create a snippet formatter with a non-positive snippet size", new Object[0]);
        }
    }

    public Object format(Passage[] passages, String content) {
        BreakIterator breakIter = this.breakIterator.get();
        breakIter.setText(content);
        StringBuilder summaryBuilder = new StringBuilder();
        int[] highlightStarts = new int[passages.length];
        int[] highlightEnds = new int[passages.length];
        boolean hasMatches = false;
        int priorSnippetEnd = -1;
        int priorHighlightEnd = -1;
        for (int p = 0; p < passages.length; ++p) {
            Passage passage = passages[p];
            for (int i = 0; i < passage.getNumMatches(); ++i) {
                hasMatches = true;
                int start = passage.getMatchStarts()[i];
                int end = passage.getMatchEnds()[i];
                while (i + 1 < passage.getNumMatches() && passage.getMatchStarts()[i + 1] < end) {
                    end = passage.getMatchEnds()[++i];
                }
                end = Math.min(end, passage.getEndOffset());
                int snippetStart = this.getSnippetStart(breakIter, start);
                if (priorSnippetEnd < 0) {
                    if (snippetStart < ELLIPSIS.length()) {
                        snippetStart = 0;
                    } else {
                        summaryBuilder.append(ELLIPSIS);
                    }
                } else if (priorHighlightEnd <= snippetStart) {
                    if (priorSnippetEnd > snippetStart) {
                        priorSnippetEnd = snippetStart;
                    }
                    summaryBuilder.append(content, priorHighlightEnd, priorSnippetEnd);
                    if (priorSnippetEnd < snippetStart) {
                        summaryBuilder.append(ELLIPSIS);
                    }
                } else {
                    snippetStart = priorHighlightEnd;
                }
                summaryBuilder.append(content, snippetStart, start);
                highlightStarts[p] = summaryBuilder.length();
                summaryBuilder.append(content, start, end);
                highlightEnds[p] = summaryBuilder.length();
                priorHighlightEnd = end;
                priorSnippetEnd = this.getSnippetEnd(content.length(), breakIter, end);
            }
        }
        if (!hasMatches) {
            return new HighlightedTerm(this.fieldName, "", new int[0], new int[0]);
        }
        summaryBuilder.append(content, priorHighlightEnd, priorSnippetEnd);
        if (content.length() - priorSnippetEnd > ELLIPSIS.length()) {
            summaryBuilder.append(ELLIPSIS);
        }
        return new HighlightedTerm(this.fieldName, summaryBuilder.toString(), highlightStarts, highlightEnds);
    }

    private int getSnippetEnd(int contentLength, BreakIterator breakIter, int end) {
        int snippetEnd = end;
        for (int numTerms = this.snippetSize; snippetEnd != -1 && snippetEnd < contentLength && numTerms > 0; --numTerms) {
            snippetEnd = breakIter.following(snippetEnd + 1);
        }
        snippetEnd = snippetEnd >= 0 && snippetEnd <= contentLength ? snippetEnd : contentLength;
        return snippetEnd;
    }

    private int getSnippetStart(BreakIterator breakIter, int start) {
        int snippetStart = start;
        for (int numTerms = this.snippetSize; snippetStart > 0 && numTerms > 0; --numTerms) {
            snippetStart = breakIter.preceding(snippetStart - 1);
        }
        return Math.max(snippetStart, 0);
    }
}

