/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LuceneFieldInfosProto;
import com.apple.foundationdb.record.lucene.LuceneLogMessageKeys;
import com.apple.foundationdb.record.lucene.codec.LazyOpener;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryUtils;
import com.apple.foundationdb.record.lucene.directory.FDBLuceneFileReference;
import com.apple.foundationdb.record.util.pair.Pair;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.lucene.store.Directory;

public class FieldInfosStorage {
    public static final long GLOBAL_FIELD_INFOS_ID = -2L;
    private final LazyOpener<Map<Long, LuceneFieldInfosProto.FieldInfos>> allFieldInfosSupplier = LazyOpener.supply(() -> directory.getAllFieldInfosStream().collect(Collectors.toConcurrentMap(Pair::getLeft, pair -> {
        try {
            return LuceneFieldInfosProto.FieldInfos.parseFrom((byte[])pair.getRight());
        }
        catch (InvalidProtocolBufferException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    })));
    private final FDBDirectory directory;
    private final AtomicReference<ConcurrentMap<Long, AtomicInteger>> referenceCount;

    FieldInfosStorage(FDBDirectory directory) {
        this.directory = directory;
        this.referenceCount = new AtomicReference();
    }

    @VisibleForTesting
    public Map<Long, LuceneFieldInfosProto.FieldInfos> getAllFieldInfos() throws IOException {
        return this.allFieldInfosSupplier.get();
    }

    public LuceneFieldInfosProto.FieldInfos readGlobalFieldInfos() throws IOException {
        return this.readFieldInfos(-2L);
    }

    public LuceneFieldInfosProto.FieldInfos readFieldInfos(long id) throws IOException {
        return this.getAllFieldInfos().get(id);
    }

    public long writeFieldInfos(LuceneFieldInfosProto.FieldInfos value) throws IOException {
        try {
            long id = Boolean.TRUE.equals(this.getAllFieldInfos().isEmpty()) ? -2L : this.directory.getIncrement();
            this.writeFieldInfos(id, value);
            return id;
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    private void writeFieldInfos(long id, LuceneFieldInfosProto.FieldInfos value) throws IOException {
        try {
            this.directory.writeFieldInfos(id, value.toByteArray());
            this.getAllFieldInfos().put(id, value);
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    public void updateGlobalFieldInfos(LuceneFieldInfosProto.FieldInfos value) throws IOException {
        this.writeFieldInfos(-2L, value);
    }

    public FDBLuceneFileReference getFDBLuceneFileReference(String fileName) {
        return this.directory.getFDBLuceneFileReference(fileName);
    }

    public void setFieldInfoId(Directory wrappingDirectory, String fileName, long id, BitSet fieldBitSet) throws IOException {
        this.setFieldInfoId(wrappingDirectory, fileName, id, ByteString.copyFrom((byte[])fieldBitSet.toByteArray()));
    }

    private void setFieldInfoId(Directory wrappingDirectory, String fileName, long id, ByteString bitSet) throws IOException {
        try {
            wrappingDirectory.sync(List.of(fileName));
            this.directory.setFieldInfoId(fileName, id, bitSet);
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    void initializeReferenceCount(ConcurrentMap<Long, AtomicInteger> fieldInfosCount) {
        this.referenceCount.compareAndSet(null, fieldInfosCount);
    }

    public ConcurrentMap<Long, AtomicInteger> getReferenceCount() {
        return this.referenceCount.get();
    }

    public void addReference(FDBLuceneFileReference reference) {
        if (reference.getFieldInfosId() != 0L) {
            this.referenceCount.get().computeIfAbsent(reference.getFieldInfosId(), key -> new AtomicInteger(0)).incrementAndGet();
        }
    }

    public boolean delete(long id) throws IOException {
        if (id != 0L && ((AtomicInteger)Objects.requireNonNull(this.referenceCount.get(), "fieldInfosReferenceCache").get(id)).decrementAndGet() == 0) {
            this.getAllFieldInfos().remove(id);
            return true;
        }
        return false;
    }

    public static void copyFieldInfosId(Directory wrappingDirectory, String fieldInfosFileName, String entriesFile) throws IOException {
        try {
            FDBDirectory directory = FDBDirectoryUtils.getFDBDirectoryNotCompound(wrappingDirectory);
            FDBLuceneFileReference fieldInfosReference = directory.getFDBLuceneFileReference(fieldInfosFileName);
            if (fieldInfosReference == null) {
                throw new RecordCoreException("Reference not found", new Object[0]).addLogInfo(new Object[]{LuceneLogMessageKeys.FILE_NAME, fieldInfosFileName});
            }
            directory.getFieldInfosStorage().setFieldInfoId(wrappingDirectory, entriesFile, fieldInfosReference.getFieldInfosId(), fieldInfosReference.getFieldInfosBitSet());
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }
}

