/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.KeyValue;
import com.apple.foundationdb.Range;
import com.apple.foundationdb.record.RecordCoreStorageException;
import com.apple.foundationdb.record.logging.KeyValueLogMessage;
import com.apple.foundationdb.record.logging.LogMessageKeys;
import com.apple.foundationdb.record.lucene.LuceneConcurrency;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.provider.common.StoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.FDBDatabase;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContextConfig;
import com.apple.foundationdb.record.provider.foundationdb.FDBStoreTimer;
import com.apple.foundationdb.record.provider.foundationdb.properties.RecordLayerPropertyKey;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface AgilityContext {
    public static AgilityContext nonAgile(FDBRecordContext callerContext) {
        return new NonAgile(callerContext);
    }

    public static AgilityContext agile(FDBRecordContext callerContext, @Nullable FDBRecordContextConfig.Builder contextBuilder, long timeQuotaMillis, long sizeQuotaBytes) {
        return new Agile(callerContext, contextBuilder, timeQuotaMillis, sizeQuotaBytes);
    }

    public static AgilityContext agile(FDBRecordContext callerContext, long timeQuotaMillis, long sizeQuotaBytes) {
        return AgilityContext.agile(callerContext, null, timeQuotaMillis, sizeQuotaBytes);
    }

    public <R> CompletableFuture<R> apply(Function<FDBRecordContext, CompletableFuture<R>> var1);

    public <R> CompletableFuture<R> applyInRecoveryPath(Function<FDBRecordContext, CompletableFuture<R>> var1);

    public void accept(Consumer<FDBRecordContext> var1);

    public void set(byte[] var1, byte[] var2);

    public void flush();

    public void flushAndClose();

    public void abortAndClose();

    public boolean isClosed();

    default public CompletableFuture<byte[]> get(byte[] key) {
        return this.apply(context -> context.ensureActive().get(key));
    }

    default public void clear(byte[] key) {
        this.accept(context -> context.ensureActive().clear(key));
    }

    default public void clear(Range range) {
        this.accept(context -> context.clear(range));
    }

    default public CompletableFuture<List<KeyValue>> getRange(byte[] begin, byte[] end) {
        return this.apply(context -> context.ensureActive().getRange(begin, end).asList());
    }

    @Nonnull
    public FDBRecordContext getCallerContext();

    default public <T> CompletableFuture<T> instrument(StoreTimer.Event event, CompletableFuture<T> future) {
        return this.getCallerContext().instrument(event, future);
    }

    default public <T> CompletableFuture<T> instrument(StoreTimer.Event event, CompletableFuture<T> future, long start) {
        return this.getCallerContext().instrument(event, future, start);
    }

    default public void increment(@Nonnull StoreTimer.Count count) {
        this.getCallerContext().increment(count);
    }

    default public void increment(@Nonnull StoreTimer.Count count, int size) {
        this.getCallerContext().increment(count, size);
    }

    default public void recordEvent(@Nonnull StoreTimer.Event event, long timeDelta) {
        this.getCallerContext().record(event, timeDelta);
    }

    default public void recordSize(@Nonnull StoreTimer.SizeEvent sizeEvent, long size) {
        this.getCallerContext().recordSize(sizeEvent, size);
    }

    @Nullable
    default public <T> T asyncToSync(StoreTimer.Wait event, @Nonnull CompletableFuture<T> async) {
        return LuceneConcurrency.asyncToSync(event, async, this.getCallerContext());
    }

    @Nullable
    default public <T> T getPropertyValue(@Nonnull RecordLayerPropertyKey<T> propertyKey) {
        return (T)this.getCallerContext().getPropertyStorage().getPropertyValue(propertyKey);
    }

    public void setCommitCheck(Function<FDBRecordContext, CompletableFuture<Void>> var1);

    default public void commit(@Nonnull FDBRecordContext context) {
        LuceneConcurrency.asyncToSync((StoreTimer.Wait)FDBStoreTimer.Waits.WAIT_COMMIT, context.commitAsync(), context);
    }

    public static class NonAgile
    implements AgilityContext {
        private final FDBRecordContext callerContext;
        private boolean closed = false;

        public NonAgile(FDBRecordContext callerContext) {
            this.callerContext = callerContext;
        }

        @Override
        public <R> CompletableFuture<R> apply(Function<FDBRecordContext, CompletableFuture<R>> function) {
            this.ensureOpen();
            return function.apply(this.callerContext);
        }

        @Override
        public <R> CompletableFuture<R> applyInRecoveryPath(Function<FDBRecordContext, CompletableFuture<R>> function) {
            return function.apply(this.callerContext).exceptionally(ex -> null);
        }

        @Override
        public void accept(Consumer<FDBRecordContext> function) {
            this.ensureOpen();
            function.accept(this.callerContext);
        }

        @Override
        public void set(byte[] key, byte[] value) {
            this.accept(context -> context.ensureActive().set(key, value));
        }

        @Override
        @Nonnull
        public FDBRecordContext getCallerContext() {
            return this.callerContext;
        }

        private void ensureOpen() {
            if (this.closed) {
                throw new RecordCoreStorageException("NonAgile context is already closed");
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void flushAndClose() {
            this.closed = true;
        }

        @Override
        public void abortAndClose() {
            this.closed = true;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public void setCommitCheck(Function<FDBRecordContext, CompletableFuture<Void>> commitCheck) {
            this.callerContext.addCommitCheck(() -> (CompletableFuture)commitCheck.apply(this.callerContext));
        }
    }

    public static class Agile
    implements AgilityContext {
        static final Logger LOGGER = LoggerFactory.getLogger(Agile.class);
        private final FDBRecordContextConfig.Builder contextConfigBuilder;
        private final FDBDatabase database;
        private final FDBRecordContext callerContext;
        private FDBRecordContext currentContext;
        private long creationTime;
        private int currentWriteSize;
        private final long timeQuotaMillis;
        private final long sizeQuotaBytes;
        private final StampedLock lock = new StampedLock();
        private final Object createLockSync = new Object();
        private final Object commitLockSync = new Object();
        private boolean committingNow = false;
        private long prevCommitCheckTime;
        private boolean closed = false;
        private Function<FDBRecordContext, CompletableFuture<Void>> commitCheck;
        private Throwable lastException = null;

        protected Agile(FDBRecordContext callerContext, @Nullable FDBRecordContextConfig.Builder contextBuilder, long timeQuotaMillis, long sizeQuotaBytes) {
            this.callerContext = callerContext;
            this.contextConfigBuilder = contextBuilder != null ? contextBuilder : callerContext.getConfig().toBuilder();
            this.contextConfigBuilder.setWeakReadSemantics(null);
            this.database = callerContext.getDatabase();
            this.timeQuotaMillis = timeQuotaMillis;
            this.sizeQuotaBytes = sizeQuotaBytes;
            callerContext.getOrCreateCommitCheck("AgilityContext.Agile:", name -> () -> CompletableFuture.runAsync(this::flush));
            this.logSelf("Starting agility context");
        }

        private void logSelf(String staticMessage) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(KeyValueLogMessage.of((String)("AgilityContext: " + staticMessage), (Object[])new Object[]{LogMessageKeys.TIME_LIMIT_MILLIS, this.timeQuotaMillis, LogMessageKeys.LIMIT, this.sizeQuotaBytes, LogMessageKeys.AGILITY_CONTEXT, System.identityHashCode(this)}));
            }
        }

        @Override
        public void setCommitCheck(Function<FDBRecordContext, CompletableFuture<Void>> commitCheck) {
            this.commitCheck = commitCheck;
        }

        @Override
        @Nonnull
        public FDBRecordContext getCallerContext() {
            return this.callerContext;
        }

        private long now() {
            return System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createIfNeeded() {
            Object object = this.createLockSync;
            synchronized (object) {
                if (this.currentContext == null) {
                    this.ensureOpen();
                    FDBRecordContextConfig contextConfig = this.contextConfigBuilder.build();
                    this.currentContext = this.database.openContext(contextConfig);
                    Agile.addCommitCheckToContext(this.currentContext, this.commitCheck);
                    this.prevCommitCheckTime = this.creationTime = this.now();
                    this.currentWriteSize = 0;
                }
            }
        }

        private static void addCommitCheckToContext(FDBRecordContext commitCheckContext, @Nullable Function<FDBRecordContext, CompletableFuture<Void>> commitCheck) {
            if (commitCheck != null) {
                commitCheckContext.addCommitCheck(() -> (CompletableFuture)commitCheck.apply(commitCheckContext));
            }
        }

        private boolean reachedTimeQuota() {
            return this.now() > this.creationTime + this.timeQuotaMillis;
        }

        private boolean reachedSizeQuota() {
            return (long)this.currentWriteSize > this.sizeQuotaBytes;
        }

        private boolean shouldCommit() {
            if (this.currentContext != null && !this.committingNow) {
                if (this.reachedSizeQuota()) {
                    this.callerContext.increment((StoreTimer.Count)LuceneEvents.Counts.LUCENE_AGILE_COMMITS_SIZE_QUOTA);
                    return true;
                }
                if (this.reachedTimeQuota()) {
                    this.callerContext.increment((StoreTimer.Count)LuceneEvents.Counts.LUCENE_AGILE_COMMITS_TIME_QUOTA);
                    return true;
                }
            }
            return false;
        }

        private void commitIfNeeded() {
            if (this.shouldCommit()) {
                this.commitNow();
            }
            this.prevCommitCheckTime = this.now();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commitNow() {
            Object object = this.commitLockSync;
            synchronized (object) {
                if (this.currentContext != null) {
                    this.committingNow = true;
                    long stamp = this.lock.writeLock();
                    try (FDBRecordContext commitContext = this.currentContext;){
                        this.commit(commitContext);
                    }
                    catch (RuntimeException ex) {
                        this.closed = true;
                        this.reportFdbException(ex);
                        throw ex;
                    }
                    finally {
                        this.currentContext = null;
                        this.currentWriteSize = 0;
                        this.lock.unlock(stamp);
                        this.committingNow = false;
                    }
                }
            }
        }

        private void reportFdbException(Throwable ex) {
            if (LOGGER.isDebugEnabled()) {
                long nowMilliseconds = this.now();
                long creationAge = nowMilliseconds - this.creationTime;
                long prevCheckAge = nowMilliseconds - this.prevCommitCheckTime;
                LOGGER.debug(KeyValueLogMessage.build((String)"AgilityContext: Commit failed", (Object[])new Object[]{LogMessageKeys.AGILITY_CONTEXT_AGE_MILLISECONDS, creationAge, LogMessageKeys.AGILITY_CONTEXT_PREV_CHECK_MILLISECONDS, prevCheckAge, LogMessageKeys.AGILITY_CONTEXT_WRITE_SIZE_BYTES, this.currentWriteSize}).toString(), ex);
            }
            this.lastException = ex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <R> CompletableFuture<R> apply(Function<FDBRecordContext, CompletableFuture<R>> function) {
            this.ensureOpen();
            this.commitIfNeeded();
            long stamp = this.lock.readLock();
            boolean successfulCreate = false;
            try {
                this.createIfNeeded();
                successfulCreate = true;
            }
            finally {
                if (!successfulCreate) {
                    this.lock.unlock(stamp);
                }
            }
            return function.apply(this.currentContext).whenComplete((result, exception) -> {
                this.lock.unlock(stamp);
                if (exception == null) {
                    this.commitIfNeeded();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <R> CompletableFuture<R> applyInRecoveryPath(Function<FDBRecordContext, CompletableFuture<R>> function) {
            CompletionStage future;
            FDBRecordContextConfig contextConfig = this.contextConfigBuilder.build();
            FDBRecordContext recoveryContext = this.database.openContext(contextConfig);
            boolean successful = false;
            try {
                future = function.apply(recoveryContext).whenComplete((result, ex) -> {
                    if (ex == null) {
                        this.commit(recoveryContext);
                    }
                    recoveryContext.close();
                });
                successful = true;
            }
            finally {
                if (!successful) {
                    recoveryContext.close();
                }
            }
            return future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(Consumer<FDBRecordContext> function) {
            this.ensureOpen();
            this.commitIfNeeded();
            long stamp = this.lock.readLock();
            try {
                this.createIfNeeded();
                function.accept(this.currentContext);
            }
            finally {
                this.lock.unlock(stamp);
            }
            this.commitIfNeeded();
        }

        @Override
        public void set(byte[] key, byte[] value) {
            this.accept(context -> {
                context.ensureActive().set(key, value);
                this.currentWriteSize += key.length + value.length;
            });
        }

        private void ensureOpen() {
            if (this.closed) {
                throw new RecordCoreStorageException("Agile context is already closed", this.lastException);
            }
        }

        @Override
        public void flush() {
            this.commitNow();
            this.logSelf("Flushed agility context");
        }

        @Override
        public void flushAndClose() {
            this.closed = true;
            this.commitNow();
            this.logSelf("flushAndClose agility context");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void abortAndClose() {
            Object object = this.commitLockSync;
            synchronized (object) {
                this.closed = true;
                this.committingNow = true;
                this.currentWriteSize = 0;
                if (this.currentContext != null) {
                    this.currentContext.close();
                    this.currentContext = null;
                }
                this.lock.tryUnlockWrite();
                boolean releasedLock = this.lock.tryUnlockRead();
                for (int maxTries = 20; releasedLock && maxTries > 0; --maxTries) {
                    releasedLock = this.lock.tryUnlockRead();
                }
            }
            this.logSelf("AbortAndReset agility context");
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }
    }
}

