/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LucenePrimaryKeySegmentIndexV1;
import com.apple.foundationdb.record.lucene.codec.LazyCloseable;
import com.apple.foundationdb.record.lucene.codec.LazyStoredFieldsReader;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedStoredFieldsReader;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedStoredFieldsWriter;
import com.apple.foundationdb.record.lucene.codec.PrimaryKeyAndStoredFieldsWriter;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryUtils;
import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;

public class LuceneOptimizedStoredFieldsFormat
extends StoredFieldsFormat {
    public static final String STORED_FIELDS_EXTENSION = "fsf";
    private final StoredFieldsFormat storedFieldsFormat;

    LuceneOptimizedStoredFieldsFormat(StoredFieldsFormat storedFieldsFormat) {
        this.storedFieldsFormat = storedFieldsFormat;
    }

    public StoredFieldsReader fieldsReader(Directory directory, SegmentInfo si, FieldInfos fn, IOContext context) throws IOException {
        try {
            FDBDirectory fdbDirectory = FDBDirectoryUtils.getFDBDirectory(directory);
            if (fdbDirectory.usesOptimizedStoredFields()) {
                return new LuceneOptimizedStoredFieldsReader(fdbDirectory, si, fn);
            }
            return new LazyStoredFieldsReader(directory, si, fn, context, LazyCloseable.supply(() -> this.storedFieldsFormat.fieldsReader(directory, si, fn, context)));
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    public StoredFieldsWriter fieldsWriter(Directory directory, SegmentInfo si, IOContext context) throws IOException {
        try {
            StoredFieldsWriter storedFieldsWriter;
            FDBDirectory fdbDirectory = FDBDirectoryUtils.getFDBDirectory(directory);
            if (fdbDirectory.getBooleanIndexOption("primaryKeySegmentIndexV2Enabled", false)) {
                directory.createOutput(IndexFileNames.segmentFileName((String)si.name, (String)"", (String)STORED_FIELDS_EXTENSION), context).close();
                return new PrimaryKeyAndStoredFieldsWriter(si, fdbDirectory);
            }
            if (fdbDirectory.getBooleanIndexOption("optimizedStoredFieldsFormatEnabled", false)) {
                directory.createOutput(IndexFileNames.segmentFileName((String)si.name, (String)"", (String)STORED_FIELDS_EXTENSION), context).close();
                storedFieldsWriter = new LuceneOptimizedStoredFieldsWriter(fdbDirectory, si);
            } else {
                storedFieldsWriter = this.storedFieldsFormat.fieldsWriter(directory, si, context);
            }
            LucenePrimaryKeySegmentIndexV1 segmentIndex = (LucenePrimaryKeySegmentIndexV1)fdbDirectory.getPrimaryKeySegmentIndex();
            return segmentIndex == null ? storedFieldsWriter : segmentIndex.wrapFieldsWriter(storedFieldsWriter, si);
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }
}

