/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.codec;

import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedCompoundFormat;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedDocValuesFormat;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedFieldInfosFormat;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedLiveDocsFormat;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedPointsFormat;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedPostingsFormat;
import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedStoredFieldsFormat;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CompoundFormat;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.TermVectorsFormat;
import org.apache.lucene.codecs.lucene50.Lucene50CompoundFormat;
import org.apache.lucene.codecs.lucene80.Lucene80DocValuesFormat;
import org.apache.lucene.codecs.lucene84.Lucene84PostingsFormat;
import org.apache.lucene.codecs.lucene86.Lucene86SegmentInfoFormat;
import org.apache.lucene.codecs.lucene87.Lucene87Codec;
import org.apache.lucene.codecs.perfield.PerFieldDocValuesFormat;
import org.apache.lucene.codecs.perfield.PerFieldPostingsFormat;

public class LuceneOptimizedCodec
extends Codec {
    private final Lucene87Codec baseCodec;
    private final CompoundFormat compoundFormat;
    private final SegmentInfoFormat segmentInfoFormat;
    private final PointsFormat pointsFormat;
    private final StoredFieldsFormat storedFieldsFormat;
    private final PostingsFormat defaultPostingsFormat;
    private final DocValuesFormat defaultDocValuesFormat;
    private final LiveDocsFormat liveDocsFormat;
    private final FieldInfosFormat fieldInfosFormat;
    private final PostingsFormat postingsFormat = new PerFieldPostingsFormat(){

        public PostingsFormat getPostingsFormatForField(String field) {
            return LuceneOptimizedCodec.this.getPostingsFormatForField(field);
        }
    };
    private final DocValuesFormat docValuesFormat = new PerFieldDocValuesFormat(){

        public DocValuesFormat getDocValuesFormatForField(String field) {
            return LuceneOptimizedCodec.this.getDocValuesFormatForField(field);
        }
    };
    public static final LuceneOptimizedCodec CODEC = new LuceneOptimizedCodec();

    public LuceneOptimizedCodec() {
        super("RL");
        this.baseCodec = new Lucene87Codec(Lucene87Codec.Mode.BEST_SPEED);
        this.compoundFormat = new LuceneOptimizedCompoundFormat((CompoundFormat)new Lucene50CompoundFormat());
        this.segmentInfoFormat = new Lucene86SegmentInfoFormat();
        this.pointsFormat = new LuceneOptimizedPointsFormat(this.baseCodec.pointsFormat());
        this.defaultPostingsFormat = new LuceneOptimizedPostingsFormat((PostingsFormat)new Lucene84PostingsFormat());
        this.defaultDocValuesFormat = new LuceneOptimizedDocValuesFormat((DocValuesFormat)new Lucene80DocValuesFormat());
        this.storedFieldsFormat = new LuceneOptimizedStoredFieldsFormat(this.baseCodec.storedFieldsFormat());
        this.liveDocsFormat = new LuceneOptimizedLiveDocsFormat(this.baseCodec.liveDocsFormat());
        this.fieldInfosFormat = new LuceneOptimizedFieldInfosFormat();
    }

    public PostingsFormat postingsFormat() {
        return this.postingsFormat;
    }

    public DocValuesFormat docValuesFormat() {
        return this.docValuesFormat;
    }

    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    public TermVectorsFormat termVectorsFormat() {
        return this.baseCodec.termVectorsFormat();
    }

    public FieldInfosFormat fieldInfosFormat() {
        return this.fieldInfosFormat;
    }

    public SegmentInfoFormat segmentInfoFormat() {
        return this.segmentInfoFormat;
    }

    public NormsFormat normsFormat() {
        return this.baseCodec.normsFormat();
    }

    public LiveDocsFormat liveDocsFormat() {
        return this.liveDocsFormat;
    }

    public CompoundFormat compoundFormat() {
        return this.compoundFormat;
    }

    public PointsFormat pointsFormat() {
        return this.pointsFormat;
    }

    public PostingsFormat getPostingsFormatForField(String field) {
        return this.defaultPostingsFormat;
    }

    public DocValuesFormat getDocValuesFormatForField(String field) {
        return this.defaultDocValuesFormat;
    }
}

