/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.RecordCursor;
import com.apple.foundationdb.record.ScanProperties;
import com.apple.foundationdb.record.lucene.LuceneConcurrency;
import com.apple.foundationdb.record.lucene.LuceneEvents;
import com.apple.foundationdb.record.lucene.LuceneExceptions;
import com.apple.foundationdb.record.lucene.LucenePrimaryKeySegmentIndex;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.KeyValueCursor;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.ByteArrayUtil;
import com.apple.foundationdb.tuple.Tuple;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.StandardDirectoryReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LucenePrimaryKeySegmentIndexV1
implements LucenePrimaryKeySegmentIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(LucenePrimaryKeySegmentIndexV1.class);
    @Nonnull
    private final FDBDirectory directory;
    @Nonnull
    private final Subspace subspace;

    public LucenePrimaryKeySegmentIndexV1(@Nonnull FDBDirectory directory, @Nonnull Subspace subspace) {
        this.directory = directory;
        this.subspace = subspace;
    }

    @Override
    @VisibleForTesting
    public List<List<Object>> readAllEntries() {
        AtomicReference list = new AtomicReference();
        this.directory.getAgilityContext().accept(aContext -> this.readAllEntries((FDBRecordContext)aContext, list));
        return (List)list.get();
    }

    private void readAllEntries(FDBRecordContext aContext, AtomicReference<List<List<Object>>> list) {
        List tuples;
        try (KeyValueCursor kvs = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.newBuilder((Subspace)this.subspace).setContext(aContext)).setScanProperties(ScanProperties.FORWARD_SCAN)).build();
             RecordCursor entries = kvs.map(kv -> this.subspace.unpack(kv.getKey()));){
            tuples = (List)LuceneConcurrency.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_FIND_PRIMARY_KEY, entries.asList(), aContext);
        }
        list.set(tuples.stream().map(t -> {
            List items = t.getItems();
            String name = this.directory.primaryKeySegmentName((Long)items.get(items.size() - 2));
            if (name != null) {
                items.set(items.size() - 2, name);
            }
            items.set(items.size() - 1, ((Long)items.get(items.size() - 1)).intValue());
            return items;
        }).collect(Collectors.toList()));
    }

    @Override
    public List<String> findSegments(@Nonnull Tuple primaryKey) throws IOException {
        try {
            return (List)this.directory.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_FIND_PRIMARY_KEY, this.directory.getAgilityContext().apply(context -> {
                Subspace keySubspace = this.subspace.subspace(primaryKey);
                KeyValueCursor kvs = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.newBuilder((Subspace)keySubspace).setContext(context)).setScanProperties(ScanProperties.FORWARD_SCAN)).build();
                return kvs.map(kv -> {
                    Tuple segdoc = keySubspace.unpack(kv.getKey());
                    long segid = segdoc.getLong(0);
                    String segmentName = this.directory.primaryKeySegmentName(segid);
                    if (segmentName != null) {
                        return segmentName;
                    }
                    return "#" + segid;
                }).asList().whenComplete((result, err) -> kvs.close());
            }));
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    @Override
    @Nullable
    public LucenePrimaryKeySegmentIndex.DocumentIndexEntry findDocument(@Nonnull DirectoryReader directoryReader, @Nonnull Tuple primaryKey) throws IOException {
        try {
            AtomicReference doc = new AtomicReference();
            this.directory.getAgilityContext().accept(aContext -> this.findDocument((FDBRecordContext)aContext, doc, directoryReader, primaryKey));
            return (LucenePrimaryKeySegmentIndex.DocumentIndexEntry)doc.get();
        }
        catch (RecordCoreException ex) {
            throw LuceneExceptions.toIoException(ex, null);
        }
    }

    private void findDocument(FDBRecordContext aContext, AtomicReference<LucenePrimaryKeySegmentIndex.DocumentIndexEntry> doc, @Nonnull DirectoryReader directoryReader, @Nonnull Tuple primaryKey) {
        SegmentInfos segmentInfos = ((StandardDirectoryReader)FilterDirectoryReader.unwrap((DirectoryReader)directoryReader)).getSegmentInfos();
        Subspace keySubspace = this.subspace.subspace(primaryKey);
        try (KeyValueCursor kvs = ((KeyValueCursor.Builder)((KeyValueCursor.Builder)KeyValueCursor.Builder.newBuilder((Subspace)keySubspace).setContext(aContext)).setScanProperties(ScanProperties.FORWARD_SCAN)).build();
             RecordCursor documents = kvs.map(kv -> {
            Tuple segdoc = keySubspace.unpack(kv.getKey());
            long segid = segdoc.getLong(0);
            String segmentName = this.directory.primaryKeySegmentName(segid);
            if (segmentName == null) {
                return null;
            }
            for (int i = 0; i < segmentInfos.size(); ++i) {
                SegmentInfo segmentInfo = segmentInfos.info((int)i).info;
                if (!segmentInfo.name.equals(segmentName)) continue;
                int docid = (int)segdoc.getLong(1);
                return new LucenePrimaryKeySegmentIndex.DocumentIndexEntry(primaryKey, kv.getKey(), (IndexReader)((LeafReaderContext)directoryReader.leaves().get(i)).reader(), segmentName, docid);
            }
            return null;
        }).filter(Objects::nonNull);){
            doc.set(((Optional)this.directory.asyncToSync(LuceneEvents.Waits.WAIT_LUCENE_FIND_PRIMARY_KEY, documents.first())).orElse(null));
        }
    }

    @Nonnull
    public StoredFieldsWriter wrapFieldsWriter(@Nonnull StoredFieldsWriter storedFieldsWriter, @Nonnull SegmentInfo si) throws IOException {
        long segmentId = this.directory.primaryKeySegmentId(si.name, true);
        return new WrappedFieldsWriter(storedFieldsWriter, segmentId, si.name);
    }

    @Override
    public void addOrDeletePrimaryKeyEntry(@Nonnull byte[] primaryKey, long segmentId, int docId, boolean add, String segmentName) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("pkey " + (add ? "Adding" : "Deling") + " #" + segmentId + "(" + segmentName + ")" + String.valueOf(Tuple.fromBytes((byte[])primaryKey)));
        }
        byte[] entryKey = ByteArrayUtil.join((byte[][])new byte[][]{this.subspace.getKey(), primaryKey, Tuple.from((Object[])new Object[]{segmentId, docId}).pack()});
        if (add) {
            this.directory.getAgilityContext().set(entryKey, new byte[0]);
        } else {
            this.directory.getAgilityContext().clear(entryKey);
        }
    }

    @Override
    public void clearForSegment(String segmentName) {
    }

    class WrappedFieldsWriter
    extends StoredFieldsWriter {
        @Nonnull
        private final StoredFieldsWriter inner;
        @Nonnull
        private final long segmentId;
        private final String segmentName;
        private int documentId;

        WrappedFieldsWriter(StoredFieldsWriter inner, long segmentId, String segmentName) {
            this.inner = inner;
            this.segmentId = segmentId;
            this.segmentName = segmentName;
        }

        public void startDocument() throws IOException {
            this.inner.startDocument();
        }

        public void finishDocument() throws IOException {
            this.inner.finishDocument();
            ++this.documentId;
        }

        public void writeField(FieldInfo info, IndexableField field) throws IOException {
            this.inner.writeField(info, field);
            try {
                if (info.name.equals("_p")) {
                    byte[] primaryKey = field.binaryValue().bytes;
                    LucenePrimaryKeySegmentIndexV1.this.addOrDeletePrimaryKeyEntry(primaryKey, this.segmentId, this.documentId, true, this.segmentName);
                }
            }
            catch (RecordCoreException ex) {
                throw LuceneExceptions.toIoException(ex, null);
            }
        }

        public int merge(MergeState mergeState) throws IOException {
            int docCount = this.inner.merge(mergeState);
            try {
                int segmentCount = mergeState.storedFieldsReaders.length;
                PrimaryKeyVisitor visitor = new PrimaryKeyVisitor();
                for (int i = 0; i < segmentCount; ++i) {
                    StoredFieldsReader storedFieldsReader = mergeState.storedFieldsReaders[i];
                    SegmentInfo mergedSegmentInfo = ((StoredFieldsReaderSegmentInfo)storedFieldsReader).getSegmentInfo();
                    long mergedSegmentId = LucenePrimaryKeySegmentIndexV1.this.directory.primaryKeySegmentId(mergedSegmentInfo.name, false);
                    Bits liveDocs = mergeState.liveDocs[i];
                    MergeState.DocMap docMap = mergeState.docMaps[i];
                    int maxDoc = mergeState.maxDocs[i];
                    for (int j = 0; j < maxDoc; ++j) {
                        int docId;
                        storedFieldsReader.visitDocument(j, (StoredFieldVisitor)visitor);
                        byte[] primaryKey = visitor.getPrimaryKey();
                        if (primaryKey == null) continue;
                        if ((liveDocs == null || liveDocs.get(j)) && (docId = docMap.get(j)) >= 0) {
                            LucenePrimaryKeySegmentIndexV1.this.addOrDeletePrimaryKeyEntry(primaryKey, this.segmentId, docId, true, this.segmentName);
                        }
                        LucenePrimaryKeySegmentIndexV1.this.addOrDeletePrimaryKeyEntry(primaryKey, mergedSegmentId, j, false, this.segmentName);
                        visitor.reset();
                    }
                }
                LucenePrimaryKeySegmentIndexV1.this.directory.getAgilityContext().increment(LuceneEvents.Counts.LUCENE_MERGE_DOCUMENTS, docCount);
                LucenePrimaryKeySegmentIndexV1.this.directory.getAgilityContext().increment(LuceneEvents.Counts.LUCENE_MERGE_SEGMENTS, segmentCount);
                return docCount;
            }
            catch (RecordCoreException ex) {
                throw LuceneExceptions.toIoException(ex, null);
            }
        }

        public void finish(FieldInfos fis, int numDocs) throws IOException {
            this.inner.finish(fis, numDocs);
        }

        public void close() throws IOException {
            this.inner.close();
        }

        public long ramBytesUsed() {
            return this.inner.ramBytesUsed();
        }

        public Collection<Accountable> getChildResources() {
            return this.inner.getChildResources();
        }
    }

    static class PrimaryKeyVisitor
    extends StoredFieldVisitor {
        @Nullable
        private byte[] primaryKey = null;

        PrimaryKeyVisitor() {
        }

        @Nullable
        public byte[] getPrimaryKey() {
            return this.primaryKey;
        }

        public void reset() {
            this.primaryKey = null;
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
            if (fieldInfo.name.equals("_p")) {
                return StoredFieldVisitor.Status.YES;
            }
            if (this.primaryKey != null) {
                return StoredFieldVisitor.Status.STOP;
            }
            return StoredFieldVisitor.Status.NO;
        }

        public void binaryField(FieldInfo fieldInfo, byte[] value) {
            if (fieldInfo.name.equals("_p")) {
                this.primaryKey = value;
            }
        }
    }

    public static interface StoredFieldsReaderSegmentInfo {
        public SegmentInfo getSegmentInfo();
    }
}

