/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.lucene.LucenePartitionInfoProto;
import com.apple.foundationdb.record.provider.foundationdb.IndexOperationResult;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class LuceneMetadataInfo
extends IndexOperationResult {
    private List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfo;
    private Map<Integer, LuceneInfo> luceneInfo;

    public LuceneMetadataInfo(@Nonnull List<LucenePartitionInfoProto.LucenePartitionInfo> partitionInfo, @Nonnull Map<Integer, LuceneInfo> luceneInfo) {
        this.partitionInfo = partitionInfo;
        this.luceneInfo = luceneInfo;
    }

    public List<LucenePartitionInfoProto.LucenePartitionInfo> getPartitionInfo() {
        return this.partitionInfo;
    }

    public Map<Integer, LuceneInfo> getLuceneInfo() {
        return this.luceneInfo;
    }

    public static class LuceneInfo {
        private final int documentCount;
        private final Collection<String> files;
        private final int fieldInfoCount;

        public LuceneInfo(int documentCount, Collection<String> files, int fieldInfoCount) {
            this.documentCount = documentCount;
            this.files = files;
            this.fieldInfoCount = fieldInfoCount;
        }

        public int getDocumentCount() {
            return this.documentCount;
        }

        public Collection<String> getFiles() {
            return this.files;
        }

        public int getFieldInfoCount() {
            return this.fieldInfoCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LuceneInfo that = (LuceneInfo)o;
            return this.documentCount == that.documentCount && this.fieldInfoCount == that.fieldInfoCount && Objects.equals(this.files, that.files);
        }

        public int hashCode() {
            return Objects.hash(this.documentCount, this.files, this.fieldInfoCount);
        }
    }
}

