/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.annotation.API;
import com.apple.foundationdb.record.lucene.LuceneIndexMaintainer;
import com.apple.foundationdb.record.lucene.LuceneIndexValidator;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.IndexValidator;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainer;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerFactory;
import com.apple.foundationdb.record.provider.foundationdb.IndexMaintainerState;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@API(value=API.Status.EXPERIMENTAL)
public class LuceneIndexMaintainerFactory
implements IndexMaintainerFactory {
    @Nonnull
    private static final List<String> TYPES = Collections.singletonList("lucene");

    public Iterable<String> getIndexTypes() {
        return TYPES;
    }

    @Nonnull
    public IndexValidator getIndexValidator(@Nonnull Index index) {
        return new LuceneIndexValidator(index);
    }

    @Nonnull
    public IndexMaintainer getIndexMaintainer(@Nonnull IndexMaintainerState state) {
        return new LuceneIndexMaintainer(state, state.context.getExecutor());
    }
}

