/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.RecordCoreException;
import com.apple.foundationdb.record.lucene.filter.AlphanumericLengthFilter;
import com.apple.foundationdb.record.lucene.filter.CjkUnigramFilter;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cjk.CJKWidthFilter;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.standard.UAX29URLEmailTokenizerFactory;
import org.apache.lucene.analysis.synonym.SynonymGraphFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;

public class EmailCjkSynonymAnalyzer
extends StopwordAnalyzerBase {
    public static final String UNIQUE_IDENTIFIER = "SYNONYM_EMAIL";
    private final int minAlphanumericTokenLength;
    private int minTokenLength;
    private int maxTokenLength;
    private final boolean withEmailTokenizer;
    private final boolean withSynonymGraphFilter;
    @Nullable
    private final SynonymMap synonymMap;

    public EmailCjkSynonymAnalyzer(@Nonnull CharArraySet stopwords, int minTokenLength, int minAlphanumericTokenLength, int maxTokenLength, boolean withEmailTokenizer, boolean withSynonymGraphFilter, @Nullable SynonymMap synonymMap) {
        super(stopwords);
        this.minTokenLength = minTokenLength;
        this.maxTokenLength = maxTokenLength;
        this.withEmailTokenizer = withEmailTokenizer;
        this.withSynonymGraphFilter = withSynonymGraphFilter;
        this.minAlphanumericTokenLength = minAlphanumericTokenLength;
        this.synonymMap = synonymMap;
    }

    @Deprecated
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Object result;
        StandardTokenizer src;
        if (this.withEmailTokenizer()) {
            src = new UAX29URLEmailTokenizerFactory(Collections.emptyMap()).create(this.attributeFactory(fieldName));
            result = new CJKWidthFilter((TokenStream)src);
            result = new CjkUnigramFilter((TokenStream)result);
            result = new WordDelimiterFilter((TokenStream)result, 33, null);
            result = new org.apache.lucene.analysis.core.LowerCaseFilter((TokenStream)result);
            result = new ASCIIFoldingFilter((TokenStream)result);
        } else {
            src = new StandardTokenizer();
            result = new CJKWidthFilter((TokenStream)src);
            result = new org.apache.lucene.analysis.core.LowerCaseFilter((TokenStream)result);
            result = new ASCIIFoldingFilter((TokenStream)result);
            result = new CjkUnigramFilter((TokenStream)result);
        }
        result = new AlphanumericLengthFilter((TokenStream)result, this.minAlphanumericTokenLength, this.getMaxTokenLength());
        if (this.withSynonymGraphFilter()) {
            result = new SynonymGraphFilter((TokenStream)result, this.getSynonymMap(), true);
        }
        result = new StopFilter((TokenStream)result, this.stopwords);
        return new Analyzer.TokenStreamComponents((Tokenizer)src, (TokenStream)result);
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter((TokenStream)new CJKWidthFilter(in));
    }

    public int getMinTokenLength() {
        return this.minTokenLength;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    protected boolean withSynonymGraphFilter() {
        return this.withSynonymGraphFilter;
    }

    protected boolean withEmailTokenizer() {
        return this.withEmailTokenizer;
    }

    @Nonnull
    protected SynonymMap getSynonymMap() {
        if (!this.withSynonymGraphFilter || this.synonymMap == null) {
            throw new RecordCoreException("Invalid call to get synonym map for EmailCjkSynonymAnalyzer, which is not enabled with synonym and valid map", new Object[0]);
        }
        return this.synonymMap;
    }
}

