/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.idformat;

import com.apple.foundationdb.record.lucene.idformat.RecordCoreFormatException;
import com.apple.foundationdb.record.lucene.idformat.RecordIdFormat;
import com.apple.foundationdb.record.lucene.idformat.RecordIdFormatParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IdFormatParserTest {
    @Test
    void parseSimple() {
        RecordIdFormat format = RecordIdFormatParser.parse((String)"[INT32]");
        Assertions.assertEquals((Object)RecordIdFormat.of((RecordIdFormat.FormatElement[])new RecordIdFormat.FormatElement[]{RecordIdFormat.FormatElementType.INT32}), (Object)format);
    }

    @Test
    void parseMulti() {
        RecordIdFormat format = RecordIdFormatParser.parse((String)"[INT32,INT64,STRING_16]");
        Assertions.assertEquals((Object)RecordIdFormat.of((RecordIdFormat.FormatElement[])new RecordIdFormat.FormatElement[]{RecordIdFormat.FormatElementType.INT32, RecordIdFormat.FormatElementType.INT64, RecordIdFormat.FormatElementType.STRING_16}), (Object)format);
    }

    @Test
    void parseMultiWithWhitespace() {
        RecordIdFormat format = RecordIdFormatParser.parse((String)" [ INT32 , INT64 , STRING_16 ] ");
        Assertions.assertEquals((Object)RecordIdFormat.of((RecordIdFormat.FormatElement[])new RecordIdFormat.FormatElement[]{RecordIdFormat.FormatElementType.INT32, RecordIdFormat.FormatElementType.INT64, RecordIdFormat.FormatElementType.STRING_16}), (Object)format);
    }

    @Test
    void parseNested() {
        RecordIdFormat format = RecordIdFormatParser.parse((String)"[INT32,INT32,[INT64, STRING_16],INT64]");
        Assertions.assertEquals((Object)RecordIdFormat.of((RecordIdFormat.FormatElement[])new RecordIdFormat.FormatElement[]{RecordIdFormat.FormatElementType.INT32, RecordIdFormat.FormatElementType.INT32, RecordIdFormat.TupleElement.of((RecordIdFormat.FormatElement[])new RecordIdFormat.FormatElement[]{RecordIdFormat.FormatElementType.INT64, RecordIdFormat.FormatElementType.STRING_16}), RecordIdFormat.FormatElementType.INT64}), (Object)format);
    }

    @Test
    void parseNestedWithWhitespace() {
        RecordIdFormat format = RecordIdFormatParser.parse((String)" [ INT32 , INT32 , [ INT64 , STRING_16 ], INT64 ] ");
        Assertions.assertEquals((Object)RecordIdFormat.of((RecordIdFormat.FormatElement[])new RecordIdFormat.FormatElement[]{RecordIdFormat.FormatElementType.INT32, RecordIdFormat.FormatElementType.INT32, RecordIdFormat.TupleElement.of((RecordIdFormat.FormatElement[])new RecordIdFormat.FormatElement[]{RecordIdFormat.FormatElementType.INT64, RecordIdFormat.FormatElementType.STRING_16}), RecordIdFormat.FormatElementType.INT64}), (Object)format);
    }

    @Test
    void parseNestedMultiLayers() {
        RecordIdFormat format = RecordIdFormatParser.parse((String)"[INT32,INT32,[INT64,STRING_16,[UUID_AS_STRING,[NULL,NONE]]],INT64]");
        Assertions.assertEquals((Object)RecordIdFormat.of((RecordIdFormat.FormatElement[])new RecordIdFormat.FormatElement[]{RecordIdFormat.FormatElementType.INT32, RecordIdFormat.FormatElementType.INT32, RecordIdFormat.TupleElement.of((RecordIdFormat.FormatElement[])new RecordIdFormat.FormatElement[]{RecordIdFormat.FormatElementType.INT64, RecordIdFormat.FormatElementType.STRING_16, RecordIdFormat.TupleElement.of((RecordIdFormat.FormatElement[])new RecordIdFormat.FormatElement[]{RecordIdFormat.FormatElementType.UUID_AS_STRING, RecordIdFormat.TupleElement.of((RecordIdFormat.FormatElement[])new RecordIdFormat.FormatElement[]{RecordIdFormat.FormatElementType.NULL, RecordIdFormat.FormatElementType.NONE})})}), RecordIdFormat.FormatElementType.INT64}), (Object)format);
    }

    @Test
    void allTypes() {
        RecordIdFormat format = RecordIdFormatParser.parse((String)"[NONE,NULL,INT32,INT32_OR_NULL,INT64,INT64_OR_NULL,UUID_AS_STRING,STRING_16]");
        Assertions.assertEquals((Object)RecordIdFormat.of((RecordIdFormat.FormatElement[])new RecordIdFormat.FormatElement[]{RecordIdFormat.FormatElementType.NONE, RecordIdFormat.FormatElementType.NULL, RecordIdFormat.FormatElementType.INT32, RecordIdFormat.FormatElementType.INT32_OR_NULL, RecordIdFormat.FormatElementType.INT64, RecordIdFormat.FormatElementType.INT64_OR_NULL, RecordIdFormat.FormatElementType.UUID_AS_STRING, RecordIdFormat.FormatElementType.STRING_16}), (Object)format);
    }

    @Test
    void invalidSyntax() {
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)""));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)","));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)"[]"));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)"[],"));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)",[]"));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)"["));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)"]"));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)"[INT32,]"));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)"[INT32"));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)"[INT32,"));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)"INT32]"));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)",[INT32]"));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)"[INT32],"));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)"[[]]"));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)"[[]"));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)"[[NONE]"));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)"[[NULL, NULL],]"));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)"[BLAH]"));
        Assertions.assertThrows(RecordCoreFormatException.class, () -> RecordIdFormatParser.parse((String)"[NULL, [BLAH], INT32]"));
    }
}

