/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.record.lucene.LucenePrimaryKeySegmentIndex;
import com.apple.foundationdb.record.lucene.directory.AgilityContext;
import com.apple.foundationdb.record.lucene.directory.FDBDirectory;
import com.apple.foundationdb.record.lucene.directory.FDBDirectorySharedCacheManager;
import com.apple.foundationdb.record.lucene.directory.FDBLuceneFileReference;
import com.apple.foundationdb.record.lucene.directory.InjectedFailureRepository;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.util.pair.NonnullPair;
import com.apple.foundationdb.subspace.Subspace;
import com.apple.foundationdb.tuple.Tuple;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.lucene.store.IndexInput;

public class MockedFDBDirectory
extends FDBDirectory {
    private InjectedFailureRepository injectedFailures;

    public MockedFDBDirectory(Subspace subspace, Map<String, String> options, FDBDirectorySharedCacheManager sharedCacheManager, Tuple sharedCacheKey, boolean useCompoundFile, AgilityContext agilityContext, int blockCacheMaximumSize) {
        super(subspace, options, sharedCacheManager, sharedCacheKey, useCompoundFile, agilityContext, blockCacheMaximumSize);
    }

    public MockedFDBDirectory(@Nonnull Subspace subspace, @Nonnull FDBRecordContext context, @Nullable Map<String, String> indexOptions) {
        super(subspace, context, indexOptions);
    }

    public long getIncrement() throws IOException {
        this.injectedFailures.checkFailureForIoException(InjectedFailureRepository.Methods.LUCENE_GET_INCREMENT);
        return super.getIncrement();
    }

    @Nonnull
    public CompletableFuture<FDBLuceneFileReference> getFDBLuceneFileReferenceAsync(@Nonnull String name) {
        return super.getFDBLuceneFileReferenceAsync(name).thenApply(ref -> {
            this.injectedFailures.checkFailureForCoreException(InjectedFailureRepository.Methods.LUCENE_GET_FDB_LUCENE_FILE_REFERENCE_ASYNC);
            return ref;
        });
    }

    @Nonnull
    public CompletableFuture<byte[]> readBlock(@Nonnull IndexInput requestingInput, @Nonnull String fileName, @Nonnull CompletableFuture<FDBLuceneFileReference> referenceFuture, int block) {
        return super.readBlock(requestingInput, fileName, referenceFuture, block).thenApply(bytes -> {
            this.injectedFailures.checkFailureForCoreException(InjectedFailureRepository.Methods.LUCENE_READ_BLOCK);
            return bytes;
        });
    }

    @Nonnull
    public String[] listAll() throws IOException {
        this.injectedFailures.checkFailureForIoException(InjectedFailureRepository.Methods.LUCENE_LIST_ALL);
        return super.listAll();
    }

    @Nonnull
    public CompletableFuture<Map<String, FDBLuceneFileReference>> getFileReferenceCacheAsync() {
        return super.getFileReferenceCacheAsync().thenApply(cache -> {
            this.injectedFailures.checkFailureForCoreException(InjectedFailureRepository.Methods.LUCENE_GET_FILE_REFERENCE_CACHE_ASYNC);
            return cache;
        });
    }

    protected boolean deleteFileInternal(@Nonnull Map<String, FDBLuceneFileReference> cache, @Nonnull String name) throws IOException {
        this.injectedFailures.checkFailureForCoreException(InjectedFailureRepository.Methods.LUCENE_DELETE_FILE_INTERNAL);
        return super.deleteFileInternal(cache, name);
    }

    @Nullable
    public LucenePrimaryKeySegmentIndex getPrimaryKeySegmentIndex() {
        this.injectedFailures.checkFailureForCoreException(InjectedFailureRepository.Methods.LUCENE_GET_PRIMARY_KEY_SEGMENT_INDEX);
        return super.getPrimaryKeySegmentIndex();
    }

    Stream<NonnullPair<Long, byte[]>> getAllFieldInfosStream() {
        this.injectedFailures.checkFailureForCoreException(InjectedFailureRepository.Methods.LUCENE_GET_ALL_FIELDS_INFO_STREAM);
        return super.getAllFieldInfosStream();
    }

    public void setInjectedFailures(InjectedFailureRepository injectedFailures) {
        this.injectedFailures = injectedFailures;
    }
}

