/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.record.lucene.codec.LuceneOptimizedPostingsFormat;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryBaseTest;
import com.apple.foundationdb.record.lucene.directory.FDBLuceneTestIndex;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="RequiresFDB")
public class FDBLuceneFunctionalityTest
extends FDBDirectoryBaseTest {
    private FDBLuceneTestIndex luceneIndex;

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.luceneIndex = new FDBLuceneTestIndex((Directory)this.directory, (Analyzer)new StandardAnalyzer());
    }

    @Test
    public void givenSearchQueryWhenFetchedDocumentThenCorrect() throws Exception {
        this.luceneIndex.indexDocument("Hello world", "Some hello world ");
        List<Document> documents = this.luceneIndex.searchIndex("body", "world");
        Assertions.assertEquals((Object)"Hello world", (Object)documents.get(0).get("title"));
    }

    @Test
    public void givenTermQueryWhenFetchedDocumentThenCorrect() throws Exception {
        LuceneOptimizedPostingsFormat.setAllowCheckDataIntegrity((boolean)false);
        this.luceneIndex.indexDocument("activity", "running in track");
        this.luceneIndex.indexDocument("activity", "Cars are running on road");
        Term term = new Term("body", "running");
        TermQuery query = new TermQuery(term);
        List<Document> documents = this.luceneIndex.searchIndex((Query)query);
        Assertions.assertEquals((int)2, (int)documents.size());
    }

    @Test
    public void givenPrefixQueryWhenFetchedDocumentThenCorrect() throws Exception {
        this.luceneIndex.indexDocument("article", "Lucene introduction");
        this.luceneIndex.indexDocument("article", "Introduction to Lucene");
        Term term = new Term("body", "intro");
        PrefixQuery query = new PrefixQuery(term);
        List<Document> documents = this.luceneIndex.searchIndex((Query)query);
        Assertions.assertEquals((int)2, (int)documents.size());
    }

    @Test
    public void givenBooleanQueryWhenFetchedDocumentThenCorrect() throws Exception {
        this.luceneIndex.indexDocument("Destination", "Las Vegas singapore car");
        LuceneOptimizedPostingsFormat.setAllowCheckDataIntegrity((boolean)false);
        this.luceneIndex.indexDocument("Commutes in singapore", "Bus Car Bikes");
        Term term1 = new Term("body", "singapore");
        Term term2 = new Term("body", "car");
        TermQuery query1 = new TermQuery(term1);
        TermQuery query2 = new TermQuery(term2);
        BooleanQuery booleanQuery = new BooleanQuery.Builder().add((Query)query1, BooleanClause.Occur.MUST).add((Query)query2, BooleanClause.Occur.MUST).build();
        List<Document> documents = this.luceneIndex.searchIndex((Query)booleanQuery);
        Assertions.assertEquals((int)1, (int)documents.size());
    }

    @Test
    public void givenPhraseQueryWhenFetchedDocumentThenCorrect() throws Exception {
        this.luceneIndex.indexDocument("quotes", "A rose by any other name would smell as sweet.");
        PhraseQuery query = new PhraseQuery(1, "body", new BytesRef[]{new BytesRef((CharSequence)"smell"), new BytesRef((CharSequence)"sweet")});
        List<Document> documents = this.luceneIndex.searchIndex((Query)query);
        Assertions.assertEquals((int)1, (int)documents.size());
    }

    @Test
    public void givenFuzzyQueryWhenFetchedDocumentThenCorrect() throws Exception {
        LuceneOptimizedPostingsFormat.setAllowCheckDataIntegrity((boolean)false);
        this.luceneIndex.indexDocument("article", "Halloween Festival");
        this.luceneIndex.indexDocument("decoration", "Decorations for Halloween");
        Term term = new Term("body", "hallowen");
        FuzzyQuery query = new FuzzyQuery(term);
        List<Document> documents = this.luceneIndex.searchIndex((Query)query);
        Assertions.assertEquals((int)2, (int)documents.size());
    }

    @Test
    public void givenWildCardQueryWhenFetchedDocumentThenCorrect() throws Exception {
        this.luceneIndex.indexDocument("article", "Lucene introduction");
        this.luceneIndex.indexDocument("article", "Introducing Lucene with Spring");
        Term term = new Term("body", "intro*");
        WildcardQuery query = new WildcardQuery(term);
        List<Document> documents = this.luceneIndex.searchIndex((Query)query);
        Assertions.assertEquals((int)2, (int)documents.size());
    }

    @Test
    public void givenSortFieldWhenSortedThenCorrect() throws Exception {
        this.luceneIndex.indexDocument("Ganges", "River in India");
        this.luceneIndex.indexDocument("Mekong", "This river flows in south Asia");
        LuceneOptimizedPostingsFormat.setAllowCheckDataIntegrity((boolean)false);
        this.luceneIndex.indexDocument("Amazon", "Rain forest river");
        this.luceneIndex.indexDocument("Rhine", "Belongs to Europe");
        this.luceneIndex.indexDocument("Nile", "Longest River");
        Term term = new Term("body", "river");
        WildcardQuery query = new WildcardQuery(term);
        SortField sortField = new SortField("title", SortField.Type.STRING_VAL, false);
        Sort sortByTitle = new Sort(sortField);
        List<Document> documents = this.luceneIndex.searchIndex((Query)query, sortByTitle);
        Assertions.assertEquals((int)4, (int)documents.size());
        Assertions.assertEquals((Object)"Amazon", (Object)documents.get(0).getField("title").stringValue());
    }

    @Test
    public void whenDocumentDeletedThenCorrect() throws IOException {
        LuceneOptimizedPostingsFormat.setAllowCheckDataIntegrity((boolean)false);
        this.luceneIndex.indexDocument("Ganges", "River in India");
        this.luceneIndex.indexDocument("Mekong", "This river flows in south Asia");
        Term term = new Term("title", "ganges");
        this.luceneIndex.deleteDocument(term);
        TermQuery query = new TermQuery(term);
        Assertions.assertEquals((int)0, (int)this.luceneIndex.searchIndex((Query)query).size());
        term = new Term("title", "mekong");
        query = new TermQuery(term);
        Assertions.assertEquals((int)1, (int)this.luceneIndex.searchIndex((Query)query).size());
    }
}

