/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.record.lucene.codec.PrefetchableBufferedChecksumIndexInput;
import com.apple.foundationdb.record.lucene.directory.FDBDirectoryBaseTest;
import com.apple.foundationdb.record.lucene.directory.FDBIndexOutput;
import com.apple.foundationdb.record.util.pair.ComparablePair;
import com.apple.foundationdb.record.util.pair.Pair;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="RequiresFDB")
public class FDBIndexOutputTest
extends FDBDirectoryBaseTest {
    private static final String FILE_NAME = "y";
    private static final String FILE_NAME_TWO = "z";
    private static final Random RANDOM = new Random();
    private static final byte[] BLOCK_ARRAY_100 = new byte[102400];

    @Test
    public void testWriteBytes() throws Exception {
        FDBIndexOutput output = new FDBIndexOutput(FILE_NAME, this.directory);
        byte[] data = new byte[this.randomInt(256)];
        this.random.nextBytes(data);
        output.writeBytes(data, data.length);
        output.close();
        Assertions.assertEquals((long)data.length, (long)this.directory.getFDBLuceneFileReference(FILE_NAME).getSize());
    }

    @Test
    public void testWriteByte() throws Exception {
        FDBIndexOutput output = new FDBIndexOutput(FILE_NAME, this.directory);
        output.writeByte((byte)0);
        output.close();
        Assertions.assertEquals((long)1L, (long)this.directory.getFDBLuceneFileReference(FILE_NAME).getSize());
    }

    @Test
    public void testCopyBytesPipeline() throws Exception {
        FDBIndexOutput output = new FDBIndexOutput(FILE_NAME, this.directory);
        output.writeBytes(BLOCK_ARRAY_100, BLOCK_ARRAY_100.length);
        output.close();
        Assertions.assertEquals((long)BLOCK_ARRAY_100.length, (long)this.directory.getFDBLuceneFileReference(FILE_NAME).getSize());
        IndexInput blocks = this.directory.openInput(FILE_NAME, IOContext.READONCE);
        output = new FDBIndexOutput(FILE_NAME_TWO, this.directory);
        output.copyBytes((DataInput)blocks, blocks.length());
        output.close();
        Assertions.assertEquals((long)BLOCK_ARRAY_100.length, (long)this.directory.getFDBLuceneFileReference(FILE_NAME_TWO).getSize());
    }

    @Nonnull
    private List<ComparablePair<Long, Integer>> directoryCacheKeys() {
        return this.directory.getBlockCache().asMap().keySet().stream().sorted().collect(Collectors.toList());
    }

    @Test
    public void testCopyBytesReadAheadPipelineShortBuffer() throws Exception {
        FDBIndexOutput output = new FDBIndexOutput(FILE_NAME, this.directory);
        output.writeBytes(BLOCK_ARRAY_100, BLOCK_ARRAY_100.length);
        output.close();
        Assertions.assertEquals((long)BLOCK_ARRAY_100.length, (long)this.directory.getFDBLuceneFileReference(FILE_NAME).getSize());
        ChecksumIndexInput blocks = this.directory.openChecksumInput(FILE_NAME, IOContext.READONCE);
        output = new FDBIndexOutput(FILE_NAME_TWO, this.directory);
        output.setExpectedBytes((PrefetchableBufferedChecksumIndexInput)blocks, 2048L);
        Assertions.assertEquals(List.of(Pair.of((Object)1L, (Object)0), Pair.of((Object)1L, (Object)1)), this.directoryCacheKeys());
    }

    @Test
    public void testCopyBytesReadAheadPipelineGreaterThanBuffer() throws Exception {
        FDBIndexOutput output = new FDBIndexOutput(FILE_NAME, this.directory);
        output.writeBytes(BLOCK_ARRAY_100, BLOCK_ARRAY_100.length);
        output.close();
        Assertions.assertEquals((long)BLOCK_ARRAY_100.length, (long)this.directory.getFDBLuceneFileReference(FILE_NAME).getSize());
        ChecksumIndexInput blocks = this.directory.openChecksumInput(FILE_NAME, IOContext.READONCE);
        output = new FDBIndexOutput(FILE_NAME_TWO, this.directory);
        output.setExpectedBytes((PrefetchableBufferedChecksumIndexInput)blocks, 51200L);
        Assertions.assertEquals(IntStream.range(0, 10).mapToObj(i -> Pair.of((Object)1L, (Object)i)).collect(Collectors.toList()), this.directoryCacheKeys());
        byte[] fooey = new byte[1024];
        blocks.readBytes(fooey, 0, fooey.length);
        Assertions.assertEquals(IntStream.range(0, 11).mapToObj(i -> Pair.of((Object)1L, (Object)i)).collect(Collectors.toList()), this.directoryCacheKeys());
        blocks.readBytes(fooey, 0, fooey.length);
        blocks.readBytes(fooey, 0, fooey.length);
        Assertions.assertEquals(IntStream.range(0, 13).mapToObj(i -> Pair.of((Object)1L, (Object)i)).collect(Collectors.toList()), this.directoryCacheKeys());
        fooey = new byte[10240];
        blocks.readBytes(fooey, 0, fooey.length);
        Assertions.assertEquals(IntStream.range(0, 23).mapToObj(i -> Pair.of((Object)1L, (Object)i)).collect(Collectors.toList()), this.directoryCacheKeys());
    }

    @Test
    public void testSeekWithinPrefetchDuringCopyBytes() throws Exception {
        FDBIndexOutput output = new FDBIndexOutput(FILE_NAME, this.directory);
        output.writeBytes(BLOCK_ARRAY_100, BLOCK_ARRAY_100.length);
        output.close();
        Assertions.assertEquals((long)BLOCK_ARRAY_100.length, (long)this.directory.getFDBLuceneFileReference(FILE_NAME).getSize());
        ChecksumIndexInput blocks = this.directory.openChecksumInput(FILE_NAME, IOContext.READONCE);
        output = new FDBIndexOutput(FILE_NAME_TWO, this.directory);
        output.setExpectedBytes((PrefetchableBufferedChecksumIndexInput)blocks, 51200L);
        Assertions.assertEquals((int)10, (int)this.directory.getBlockCache().asMap().size());
        blocks.seek(1024L);
        Assertions.assertEquals((int)11, (int)this.directory.getBlockCache().asMap().size());
    }

    @Test
    public void testReadsOverLimit() throws Exception {
        FDBIndexOutput output = new FDBIndexOutput(FILE_NAME, this.directory);
        output.writeBytes(BLOCK_ARRAY_100, BLOCK_ARRAY_100.length);
        output.close();
        Assertions.assertEquals((long)BLOCK_ARRAY_100.length, (long)this.directory.getFDBLuceneFileReference(FILE_NAME).getSize());
        ChecksumIndexInput blocks = this.directory.openChecksumInput(FILE_NAME, IOContext.READONCE);
        output = new FDBIndexOutput(FILE_NAME_TWO, this.directory);
        output.setExpectedBytes((PrefetchableBufferedChecksumIndexInput)blocks, 51200L);
        Assertions.assertEquals((int)10, (int)this.directory.getBlockCache().asMap().size());
        blocks.seek(1024L);
        Assertions.assertEquals((int)11, (int)this.directory.getBlockCache().asMap().size());
    }

    @Test
    public void testSingleByteReadDoesNotAdvance() throws Exception {
        FDBIndexOutput output = new FDBIndexOutput(FILE_NAME, this.directory);
        output.writeBytes(BLOCK_ARRAY_100, BLOCK_ARRAY_100.length);
        output.close();
        Assertions.assertEquals((long)BLOCK_ARRAY_100.length, (long)this.directory.getFDBLuceneFileReference(FILE_NAME).getSize());
        ChecksumIndexInput blocks = this.directory.openChecksumInput(FILE_NAME, IOContext.READONCE);
        output = new FDBIndexOutput(FILE_NAME_TWO, this.directory);
        output.setExpectedBytes((PrefetchableBufferedChecksumIndexInput)blocks, 409600L);
        Assertions.assertEquals((int)10, (int)this.directory.getBlockCache().asMap().size());
        blocks.readByte();
        Assertions.assertEquals((int)10, (int)this.directory.getBlockCache().asMap().size());
    }

    @Test
    public void testCycleThrough() throws Exception {
        FDBIndexOutput output = new FDBIndexOutput(FILE_NAME, this.directory);
        output.writeBytes(BLOCK_ARRAY_100, BLOCK_ARRAY_100.length);
        output.close();
        Assertions.assertEquals((long)BLOCK_ARRAY_100.length, (long)this.directory.getFDBLuceneFileReference(FILE_NAME).getSize());
        ChecksumIndexInput blocks = this.directory.openChecksumInput(FILE_NAME, IOContext.READONCE);
        output = new FDBIndexOutput(FILE_NAME_TWO, this.directory);
        output.setExpectedBytes((PrefetchableBufferedChecksumIndexInput)blocks, 102400L);
        byte[] fooey = new byte[1024];
        HashMap<Integer, Integer> state = new HashMap<Integer, Integer>();
        state.put(-1, this.directory.getBlockCache().asMap().size());
        for (int i2 = 0; i2 < 100; ++i2) {
            blocks.readBytes(fooey, 0, fooey.length);
            state.put(i2, this.directory.getBlockCache().asMap().size());
        }
        Map expectedElements = IntStream.range(-1, 100).boxed().collect(Collectors.toMap(Function.identity(), i -> i == 99 ? 101 : Math.min(i + 11, 100)));
        Assertions.assertEquals(expectedElements, state);
    }

    @Test
    void testCloseTwice() throws IOException {
        FDBIndexOutput output = new FDBIndexOutput(FILE_NAME, this.directory);
        output.close();
        Assertions.assertDoesNotThrow(() -> ((FDBIndexOutput)output).close());
    }

    static {
        RANDOM.nextBytes(BLOCK_ARRAY_100);
    }
}

