/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene.directory;

import com.apple.foundationdb.record.lucene.directory.FDBDirectoryBaseTest;
import com.apple.foundationdb.record.lucene.directory.FDBIndexInput;
import com.apple.foundationdb.record.lucene.directory.FDBIndexOutput;
import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="RequiresFDB")
public class FDBIndexInputTest
extends FDBDirectoryBaseTest {
    private static final String FILE_NAME = "y";

    @Test
    public void testWriteReadBytes() throws Exception {
        FDBIndexOutput output = new FDBIndexOutput(FILE_NAME, this.directory);
        byte[] expected = new byte[this.randomInt(1)];
        this.random.nextBytes(expected);
        output.writeBytes(expected, expected.length);
        output.close();
        FDBIndexInput input = new FDBIndexInput(FILE_NAME, this.directory);
        byte[] actual = new byte[expected.length];
        input.readBytes(actual, 0, expected.length);
        Assertions.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testSeek() throws Exception {
        FDBIndexOutput output = new FDBIndexOutput(FILE_NAME, this.directory);
        byte[] expected = new byte[this.randomInt(512)];
        this.random.nextBytes(expected);
        output.writeBytes(expected, expected.length);
        output.close();
        FDBIndexInput input = new FDBIndexInput(FILE_NAME, this.directory);
        input.seek(256L);
        byte[] actual = new byte[expected.length - 256];
        input.readBytes(actual, 0, expected.length - 256);
        byte[] expectedAfterSeek = new byte[expected.length - 256];
        ByteBuffer.wrap(expected, 256, expected.length - 256).get(expectedAfterSeek);
        Assertions.assertArrayEquals((byte[])expectedAfterSeek, (byte[])actual);
    }

    @Test
    void testWriteReadWithOffset() throws Exception {
        FDBIndexOutput output = new FDBIndexOutput(FILE_NAME, this.directory);
        byte[] expected = new byte[this.randomInt(0) * 7 + this.randomInt(10)];
        int offset = this.random.nextInt(expected.length - 1);
        this.random.nextBytes(expected);
        output.writeBytes(expected, offset, expected.length - offset);
        output.close();
        FDBIndexInput input = new FDBIndexInput(FILE_NAME, this.directory);
        byte[] actual = new byte[expected.length - offset];
        input.readBytes(actual, 0, actual.length);
        Assertions.assertEquals((int)actual.length, (int)(expected.length - offset));
    }
}

