/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.google.common.collect.Streams;
import java.util.stream.Stream;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.SparseFixedBitSet;

public class Utf8Chars {
    private static final Bits UNDEFINED_CODE_POINTS = Utf8Chars.sparseBits(888, 889, 896, 897, 898, 899, 907, 909, 930);
    private static final Bits PUNCTUATION = Utf8Chars.sparseBits(885, 894, 900, 901, 903, 1014, 1154, 1155, 1156, 1157, 1158, 1159, 1160, 1161);
    private static final Bits DUPLICATES = Utf8Chars.sparseBits(1014);

    public static Stream<String> getUnusualTokenizableChars() {
        return Streams.concat((Stream[])new Stream[]{Utf8Chars.getGreekChars(), Utf8Chars.getCyrillicChars(), Utf8Chars.getExtendedLatin()});
    }

    public static Stream<String> getGreekChars() {
        return Stream.iterate(880, cp -> cp < 1023, cp -> cp + 1).filter(cp -> !UNDEFINED_CODE_POINTS.get(cp.intValue()) && !PUNCTUATION.get(cp.intValue()) && !DUPLICATES.get(cp.intValue())).map(Character::toString).filter(t -> !Utf8Chars.foldsToAscii(t));
    }

    public static Stream<String> getCyrillicChars() {
        return Stream.iterate(1024, cp -> cp < 1279, cp -> cp + 1).filter(cp -> !UNDEFINED_CODE_POINTS.get(cp.intValue()) && !PUNCTUATION.get(cp.intValue()) && !DUPLICATES.get(cp.intValue())).map(Character::toString).filter(t -> !Utf8Chars.foldsToAscii(t));
    }

    public static Stream<String> getExtendedLatin() {
        return Stream.iterate(7680, cp -> cp < 7935, cp -> cp + 1).filter(cp -> !UNDEFINED_CODE_POINTS.get(cp.intValue()) && !PUNCTUATION.get(cp.intValue()) && !DUPLICATES.get(cp.intValue())).map(Character::toString).filter(t -> !Utf8Chars.foldsToAscii(t));
    }

    private static Bits sparseBits(int ... codepoints) {
        final int len = codepoints[codepoints.length - 1] + 1;
        final SparseFixedBitSet bitset = new SparseFixedBitSet(len);
        for (int i : codepoints) {
            bitset.set(i);
        }
        return new Bits(){

            public boolean get(int index) {
                return index < len && bitset.get(index);
            }

            public int length() {
                return 0x110000;
            }
        };
    }

    private static boolean foldsToAscii(String text) {
        char[] input = text.toCharArray();
        char[] output = new char[4 * input.length];
        int finalPos = ASCIIFoldingFilter.foldToASCII((char[])input, (int)0, (char[])output, (int)0, (int)input.length);
        for (int i = 0; i < finalPos; ++i) {
            if (output[i] == input[i]) continue;
            return true;
        }
        return false;
    }
}

