/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.IndexScanType;
import com.apple.foundationdb.record.RecordMetaData;
import com.apple.foundationdb.record.RecordMetaDataBuilder;
import com.apple.foundationdb.record.TestRecordsJoinIndexProto;
import com.apple.foundationdb.record.TestRecordsTextProto;
import com.apple.foundationdb.record.lucene.LucenePlanMatchers;
import com.apple.foundationdb.record.lucene.LucenePlanner;
import com.apple.foundationdb.record.lucene.LuceneQueryClause;
import com.apple.foundationdb.record.lucene.LuceneQueryComponent;
import com.apple.foundationdb.record.lucene.LuceneScanTypes;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.JoinedRecordTypeBuilder;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.RecordTypeIndexesBuilder;
import com.apple.foundationdb.record.metadata.expressions.FieldKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.FunctionKeyExpression;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordContext;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStore;
import com.apple.foundationdb.record.provider.foundationdb.FDBRecordStoreTestBase;
import com.apple.foundationdb.record.query.RecordQuery;
import com.apple.foundationdb.record.query.expressions.Comparisons;
import com.apple.foundationdb.record.query.expressions.FieldWithComparison;
import com.apple.foundationdb.record.query.expressions.NestedField;
import com.apple.foundationdb.record.query.expressions.Query;
import com.apple.foundationdb.record.query.expressions.QueryComponent;
import com.apple.foundationdb.record.query.plan.PlannableIndexTypes;
import com.apple.foundationdb.record.query.plan.match.PlanMatchers;
import com.apple.foundationdb.record.query.plan.plans.RecordQueryPlan;
import com.apple.test.BooleanSource;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;

@Tag(value="RequiresFDB")
public class LucenePlannerTest
extends FDBRecordStoreTestBase {
    private static final String syntheticRecordTypeName = "luceneJoinedIdx";
    private static final FunctionKeyExpression docIdSortKey = Key.Expressions.function((String)"lucene_sorted", (KeyExpression)Key.Expressions.field((String)"doc_id"));
    private static final FunctionKeyExpression text1Key = Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text"));
    private static final FunctionKeyExpression text2Key = Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text2"));
    private static final FieldKeyExpression scoreKey = Key.Expressions.field((String)"score");
    private static final Index COMPLEX_TEXT1_INDEX = new Index("Complex$text1", (KeyExpression)text1Key.groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]), "lucene");
    private static final Index COMPLEX_TEXT2_INDEX = new Index("Complex$text2", (KeyExpression)text2Key.groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]), "lucene");
    private static final Index COMPLEX_BOTH_INDEX = new Index("Complex$both", (KeyExpression)Key.Expressions.concat((KeyExpression)text1Key, (KeyExpression)text2Key, (KeyExpression[])new KeyExpression[0]).groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]), "lucene");
    private static final Index COMPLEX_TEXT1_SORTED_INDEX = new Index("Complex$text1", (KeyExpression)Key.Expressions.concat((KeyExpression)docIdSortKey, (KeyExpression)text1Key, (KeyExpression[])new KeyExpression[0]).groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]), "lucene");
    private static final Index COMPLEX_TEXT2_SORTED_INDEX = new Index("Complex$text2", (KeyExpression)Key.Expressions.concat((KeyExpression)docIdSortKey, (KeyExpression)text2Key, (KeyExpression[])new KeyExpression[0]).groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]), "lucene");
    private static final Index COMPLEX_BOTH_SORTED_INDEX = new Index("Complex$both", (KeyExpression)Key.Expressions.concat((KeyExpression)docIdSortKey, (KeyExpression)text1Key, (KeyExpression[])new KeyExpression[]{text2Key}).groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]), "lucene");
    private static final Index COMPLEX_SCORE_INDEX = new Index("Complex$score", (KeyExpression)scoreKey.groupBy((KeyExpression)Key.Expressions.field((String)"group"), new KeyExpression[0]), "lucene");
    private static final Index LUCENE_JOIN_INDEX = new Index("joinNestedConcat", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"cust").nest((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"name"))), (KeyExpression)Key.Expressions.field((String)"order").nest((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.function((String)"lucene_stored", (KeyExpression)Key.Expressions.field((String)"order_no")), (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"order_desc")), (KeyExpression[])new KeyExpression[0])), (KeyExpression[])new KeyExpression[0]), "lucene");
    private static final FDBRecordStoreTestBase.RecordMetaDataHook separateHook = metaDataBuilder -> {
        metaDataBuilder.addIndex("ComplexDocument", COMPLEX_TEXT1_INDEX);
        metaDataBuilder.addIndex("ComplexDocument", COMPLEX_TEXT2_INDEX);
    };
    private static final FDBRecordStoreTestBase.RecordMetaDataHook combinedHook = metaDataBuilder -> metaDataBuilder.addIndex("ComplexDocument", COMPLEX_BOTH_INDEX);
    private static final FDBRecordStoreTestBase.RecordMetaDataHook separateSortedHook = metaDataBuilder -> {
        metaDataBuilder.addIndex("ComplexDocument", COMPLEX_TEXT1_SORTED_INDEX);
        metaDataBuilder.addIndex("ComplexDocument", COMPLEX_TEXT2_SORTED_INDEX);
    };
    private static final FDBRecordStoreTestBase.RecordMetaDataHook combinedSortedHook = metaDataBuilder -> metaDataBuilder.addIndex("ComplexDocument", COMPLEX_BOTH_SORTED_INDEX);
    private static final FDBRecordStoreTestBase.RecordMetaDataHook scoreHook = metaDataBuilder -> metaDataBuilder.addIndex("ComplexDocument", COMPLEX_SCORE_INDEX);
    private static final FDBRecordStoreTestBase.RecordMetaDataHook syntheticLuceneRecordMetaDataHook = metaDataBuilder -> {
        metaDataBuilder.getRecordType("CustomerWithHeader").setPrimaryKey((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"___header").nest("z_key"), (KeyExpression)Key.Expressions.field((String)"___header").nest("rec_id"), (KeyExpression[])new KeyExpression[0]));
        metaDataBuilder.getRecordType("OrderWithHeader").setPrimaryKey((KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"___header").nest("z_key"), (KeyExpression)Key.Expressions.field((String)"___header").nest("rec_id"), (KeyExpression[])new KeyExpression[0]));
        JoinedRecordTypeBuilder joined = metaDataBuilder.addJoinedRecordType(syntheticRecordTypeName);
        joined.addConstituent("order", "OrderWithHeader");
        joined.addConstituent("cust", "CustomerWithHeader");
        joined.addJoin("order", (KeyExpression)Key.Expressions.field((String)"___header").nest("z_key"), "cust", (KeyExpression)Key.Expressions.field((String)"___header").nest("z_key"));
        joined.addJoin("order", (KeyExpression)Key.Expressions.field((String)"custRef").nest("string_value"), "cust", (KeyExpression)Key.Expressions.field((String)"___header").nest("rec_id"));
        metaDataBuilder.addIndex((RecordTypeIndexesBuilder)joined, LUCENE_JOIN_INDEX);
        metaDataBuilder.addIndex("OrderWithHeader", "order$custRef", (KeyExpression)Key.Expressions.concat((KeyExpression)Key.Expressions.field((String)"___header").nest("z_key"), (KeyExpression)Key.Expressions.field((String)"custRef").nest("string_value"), (KeyExpression[])new KeyExpression[0]));
    };
    private static final LuceneQueryComponent luceneSyntaxAnd = new LuceneQueryComponent("text:\"first\" AND text2:\"second\"", List.of("text", "text2"));
    private static final LuceneQueryComponent luceneText1 = new LuceneQueryComponent("text:\"first\"", List.of("text"));
    private static final LuceneQueryComponent luceneText2 = new LuceneQueryComponent("text2:\"second\"", List.of("text2"));
    private static final LuceneQueryComponent luceneText3 = new LuceneQueryComponent("cust_name: \"John Smith\"", List.of("name"));
    private static final QueryComponent nestedFieldWithLuceneText = new NestedField("cust", (QueryComponent)luceneText3);
    private static final RecordQuery luceneSyntaxAndQuery = RecordQuery.newBuilder().setRecordType("ComplexDocument").setFilter(Query.and((QueryComponent)Query.field((String)"group").equalsParameter("group_value"), (QueryComponent)luceneSyntaxAnd, (QueryComponent[])new QueryComponent[0])).build();
    private static final RecordQuery andLuceneQuery = RecordQuery.newBuilder().setRecordType("ComplexDocument").setFilter(Query.and((QueryComponent)Query.field((String)"group").equalsParameter("group_value"), (QueryComponent)luceneText1, (QueryComponent[])new QueryComponent[]{luceneText2})).build();
    private static final RecordQuery andLuceneQueryOrdered = RecordQuery.newBuilder().setRecordType("ComplexDocument").setFilter(Query.and((QueryComponent)Query.field((String)"group").equalsParameter("group_value"), (QueryComponent)luceneText1, (QueryComponent[])new QueryComponent[]{luceneText2})).setSort((KeyExpression)Key.Expressions.field((String)"doc_id")).build();
    private static final RecordQuery orLuceneQuery = RecordQuery.newBuilder().setRecordType("ComplexDocument").setFilter(Query.and((QueryComponent)Query.field((String)"group").equalsParameter("group_value"), (QueryComponent)Query.or((QueryComponent)luceneText1, (QueryComponent)luceneText2, (QueryComponent[])new QueryComponent[0]), (QueryComponent[])new QueryComponent[0])).build();
    private static final RecordQuery orLuceneQueryOrdered = RecordQuery.newBuilder().setRecordType("ComplexDocument").setFilter(Query.and((QueryComponent)Query.field((String)"group").equalsParameter("group_value"), (QueryComponent)Query.or((QueryComponent)luceneText1, (QueryComponent)luceneText2, (QueryComponent[])new QueryComponent[0]), (QueryComponent[])new QueryComponent[0])).setSort((KeyExpression)Key.Expressions.field((String)"doc_id")).build();
    private static final RecordQuery inQuery = RecordQuery.newBuilder().setRecordType("ComplexDocument").setFilter(Query.and((QueryComponent)Query.field((String)"group").equalsParameter("group_value"), (QueryComponent)Query.field((String)"score").in(List.of(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(7))), (QueryComponent[])new QueryComponent[0])).build();
    private static final RecordQuery inParameterQuery = RecordQuery.newBuilder().setRecordType("ComplexDocument").setFilter(Query.and((QueryComponent)Query.field((String)"group").equalsParameter("group_value"), (QueryComponent)Query.field((String)"score").in("scores"), (QueryComponent[])new QueryComponent[0])).build();
    private static final QueryComponent customerRecIdFilter = new NestedField("cust", (QueryComponent)new NestedField("___header", (QueryComponent)new FieldWithComparison("rec_id", (Comparisons.Comparison)new Comparisons.NullComparison(Comparisons.Type.IS_NULL))));
    private static final RecordQuery andLuceneNestedField = RecordQuery.newBuilder().setRecordType("luceneJoinedIdx").setFilter(Query.and((QueryComponent)customerRecIdFilter, (QueryComponent)nestedFieldWithLuceneText, (QueryComponent[])new QueryComponent[0])).build();

    protected void openRecordStore(FDBRecordContext context, FDBRecordStoreTestBase.RecordMetaDataHook hook) {
        this.openRecordStore(context, hook, true);
    }

    protected void openRecordStore(FDBRecordContext context, FDBRecordStoreTestBase.RecordMetaDataHook hook, boolean attemptWholeFilter) {
        RecordMetaDataBuilder metaDataBuilder = RecordMetaData.newBuilder().setRecords(TestRecordsTextProto.getDescriptor());
        metaDataBuilder.getRecordType("ComplexDocument").setPrimaryKey((KeyExpression)Key.Expressions.concatenateFields((String)"group", (String)"doc_id", (String[])new String[0]));
        hook.apply(metaDataBuilder);
        this.recordStore = (FDBRecordStore)this.getStoreBuilder(context, metaDataBuilder.getRecordMetaData()).createOrOpen();
        this.setPlannerWholeFilterConfig(attemptWholeFilter);
    }

    protected void setPlannerWholeFilterConfig(boolean isTrue) {
        this.planner = new LucenePlanner(this.recordStore.getRecordMetaData(), this.recordStore.getRecordStoreState(), PlannableIndexTypes.DEFAULT, this.recordStore.getTimer());
        this.planner.setConfiguration(this.planner.getConfiguration().asBuilder().setPlanOtherAttemptWholeFilter(isTrue).build());
    }

    @Test
    void testLuceneSyntaxAndCombined() {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, combinedHook);
            RecordQueryPlan plan = this.planner.plan(luceneSyntaxAndQuery);
            Matcher matcher = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)COMPLEX_BOTH_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"text:\"first\" AND text2:\"second\"")))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            MatcherAssert.assertThat((Object)plan.toString(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)COMPLEX_BOTH_INDEX.getName()), (Matcher)Matchers.containsString((String)LuceneScanTypes.BY_LUCENE.toString()), (Matcher)Matchers.containsString((String)"text:\"first\" AND text2:\"second\"")));
        }
    }

    @Test
    void testLuceneSyntaxAndSeparate() {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, separateHook);
            RecordQueryPlan plan = this.planner.plan(luceneSyntaxAndQuery);
            Matcher matcher = PlanMatchers.filter((QueryComponent)luceneSyntaxAnd, (Matcher)PlanMatchers.typeFilter((Matcher)Matchers.contains((Object[])new String[]{"ComplexDocument"}), (Matcher)PlanMatchers.scan((Matcher)PlanMatchers.bounds((Matcher)PlanMatchers.hasTupleString((String)"[EQUALS $group_value]")))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
        }
    }

    @Test
    void testAndCombined() {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, combinedHook);
            RecordQueryPlan plan = this.planner.plan(andLuceneQuery);
            Matcher matcher = PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)COMPLEX_BOTH_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"text:\"first\" AND text2:\"second\"")))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
        }
    }

    @Test
    void testAndSeparate() {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, separateHook);
            RecordQueryPlan plan = this.planner.plan(andLuceneQuery);
            Matcher matcher = PlanMatchers.filter((QueryComponent)luceneText2, (Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)COMPLEX_TEXT1_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"text:\"first\""))))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
        }
    }

    @Test
    void testAndSeparateOrdered() {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, separateSortedHook);
            RecordQueryPlan plan = this.planner.plan(andLuceneQueryOrdered);
            Matcher matcher = PlanMatchers.intersection((Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)COMPLEX_TEXT1_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"text:\"first\""))))), (Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)COMPLEX_TEXT2_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"text2:\"second\""))))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
            MatcherAssert.assertThat((Object)plan.toString(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)COMPLEX_TEXT1_INDEX.getName()), (Matcher)Matchers.containsString((String)COMPLEX_TEXT2_INDEX.getName()), (Matcher)Matchers.containsString((String)"text:\"first\""), (Matcher)Matchers.containsString((String)"text2:\"second\""), (Matcher)Matchers.containsString((String)LuceneScanTypes.BY_LUCENE.toString())));
        }
    }

    @ParameterizedTest
    @BooleanSource
    void testOrCombined(boolean attemptWholeFilter) {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, combinedHook, attemptWholeFilter);
            RecordQueryPlan plan = this.planner.plan(orLuceneQuery);
            Matcher matcher = attemptWholeFilter ? PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)COMPLEX_BOTH_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"text:\"first\" OR text2:\"second\""))))) : PlanMatchers.primaryKeyDistinct((Matcher)PlanMatchers.unorderedUnion((Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)COMPLEX_BOTH_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"text:\"first\""))))), (Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)COMPLEX_BOTH_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"text2:\"second\"")))))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
        }
    }

    @Test
    void testOrSeparate() {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, separateHook);
            RecordQueryPlan plan = this.planner.plan(orLuceneQuery);
            Matcher matcher = PlanMatchers.primaryKeyDistinct((Matcher)PlanMatchers.unorderedUnion((Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)COMPLEX_TEXT1_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"text:\"first\""))))), (Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)COMPLEX_TEXT2_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"text2:\"second\"")))))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
        }
    }

    @Test
    void testOrSeparateOrdered() {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, separateSortedHook, false);
            RecordQueryPlan plan = this.planner.plan(orLuceneQueryOrdered);
            Matcher matcher = PlanMatchers.union((Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)COMPLEX_TEXT1_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"text:\"first\""))))), (Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)COMPLEX_TEXT2_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"text2:\"second\""))))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
        }
    }

    @ParameterizedTest
    @BooleanSource
    void testIn(boolean attemptWholeFilter) {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, scoreHook, attemptWholeFilter);
            RecordQueryPlan plan = this.planner.plan(inQuery);
            Matcher matcher = attemptWholeFilter ? PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)COMPLEX_SCORE_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"score:INT IN [1, 3, 7]"))))) : PlanMatchers.inValues((Matcher)Matchers.equalTo(Arrays.asList(1, 3, 7)), (Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)COMPLEX_SCORE_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"score:INT EQUALS $__in_score__0"))))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
        }
    }

    @ParameterizedTest
    @BooleanSource
    void testInParameter(boolean attemptWholeFilter) {
        try (FDBRecordContext context = this.openContext();){
            this.openRecordStore(context, scoreHook, attemptWholeFilter);
            RecordQueryPlan plan = this.planner.plan(inParameterQuery);
            Matcher matcher = attemptWholeFilter ? PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)COMPLEX_SCORE_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"score:INT IN $scores"))))) : PlanMatchers.inParameter((Matcher)Matchers.equalTo((Object)"scores"), (Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)COMPLEX_SCORE_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"score:INT EQUALS $__in_score__0"))))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
        }
    }

    @ParameterizedTest
    @BooleanSource
    void testLuceneQueryUnderNestedField(boolean attemptWholeFilter) {
        try (FDBRecordContext context = this.openContext();){
            RecordMetaDataBuilder metaDataBuilder = RecordMetaData.newBuilder().setRecords(TestRecordsJoinIndexProto.getDescriptor());
            syntheticLuceneRecordMetaDataHook.apply(metaDataBuilder);
            this.recordStore = (FDBRecordStore)this.getStoreBuilder(context, metaDataBuilder.getRecordMetaData()).createOrOpen();
            this.setPlannerWholeFilterConfig(attemptWholeFilter);
            RecordQueryPlan plan = this.planner.plan(andLuceneNestedField);
            QueryComponent filter = customerRecIdFilter;
            Matcher matcher = attemptWholeFilter ? PlanMatchers.fetch((Matcher)PlanMatchers.filter((QueryComponent)filter, (Matcher)PlanMatchers.coveringIndexScan((Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)LUCENE_JOIN_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"cust_name: \"John Smith\"")))))))) : PlanMatchers.fetch((Matcher)PlanMatchers.filter((QueryComponent)filter, (Matcher)PlanMatchers.coveringIndexScan((Matcher)PlanMatchers.indexScan((Matcher)Matchers.allOf((Matcher)PlanMatchers.indexName((String)LUCENE_JOIN_INDEX.getName()), (Matcher)PlanMatchers.indexScanType((IndexScanType)LuceneScanTypes.BY_LUCENE), LucenePlanMatchers.scanParams(LucenePlanMatchers.query((Matcher<LuceneQueryClause>)Matchers.hasToString((String)"cust_name: \"John Smith\""))))))));
            MatcherAssert.assertThat((Object)plan, (Matcher)matcher);
        }
    }
}

