/*
 * Decompiled with CFR 0.152.
 */
package com.apple.foundationdb.record.lucene;

import com.apple.foundationdb.record.lucene.LuceneAnalyzerRegistryImpl;
import com.apple.foundationdb.record.lucene.LuceneAnalyzerType;
import com.apple.foundationdb.record.metadata.Index;
import com.apple.foundationdb.record.metadata.Key;
import com.apple.foundationdb.record.metadata.expressions.KeyExpression;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LuceneAnalyzerRegistryTest {
    @Test
    void searchForAutoCompleteWithSynonymEnabledOnFullText() {
        Index index = new Index("Simple_with_auto_complete", (KeyExpression)Key.Expressions.function((String)"lucene_text", (KeyExpression)Key.Expressions.field((String)"text")), "lucene", (Map)ImmutableMap.of((Object)"luceneAnalyzerName", (Object)"SYNONYM", (Object)"textSynonymSetName", (Object)"EXPANDED_US_EN"));
        Assertions.assertEquals((Object)"SYNONYM", (Object)LuceneAnalyzerRegistryImpl.instance().getLuceneAnalyzerCombinationProvider(index, LuceneAnalyzerType.FULL_TEXT, Map.of()).provideQueryAnalyzer().getUniqueIdentifier());
        Assertions.assertEquals((Object)"STANDARD", (Object)LuceneAnalyzerRegistryImpl.instance().getLuceneAnalyzerCombinationProvider(index, LuceneAnalyzerType.AUTO_COMPLETE, Map.of()).provideQueryAnalyzer().getUniqueIdentifier());
    }
}

