/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MultiTermQueryConstantScoreWrapper;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.search.TermQuery;

public class QueryHelper {
    public static List<Term> getQueriesTerms(Query query) {
        if (query instanceof PhraseQuery) {
            return Lists.newArrayList((Object[])((PhraseQuery)query).getTerms());
        }
        if (query instanceof SynonymQuery) {
            return ((SynonymQuery)query).getTerms();
        }
        if (query instanceof TermQuery) {
            return Lists.newArrayList((Object[])new Term[]{((TermQuery)query).getTerm()});
        }
        if (query instanceof BoostQuery) {
            return QueryHelper.getQueriesTerms(((BoostQuery)query).getQuery());
        }
        if (query instanceof MultiTermQueryConstantScoreWrapper) {
            return QueryHelper.getQueriesTerms((Query)((MultiTermQueryConstantScoreWrapper)query).getQuery());
        }
        return Collections.emptyList();
    }
}

