/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.StandardDirectoryReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.IOUtils;

public class StandardDirectoryReaderOptimization {
    private StandardDirectoryReaderOptimization() {
    }

    public static DirectoryReader open(Directory directory, IndexCommit commit, final Comparator<LeafReader> leafSorter, final Executor executor, final int parallelism) throws IOException {
        return (DirectoryReader)new SegmentInfos.FindSegmentsFile<DirectoryReader>(directory){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected DirectoryReader doBody(String segmentFileName) throws IOException {
                SegmentInfos sis = SegmentInfos.readCommit((Directory)this.directory, (String)segmentFileName);
                SegmentReader[] readers = new SegmentReader[sis.size()];
                boolean success = false;
                try {
                    ArrayDeque<SegmentReaderOpener> openers = new ArrayDeque<SegmentReaderOpener>(parallelism);
                    int readerIndex = 0;
                    while (true) {
                        if (readerIndex < readers.length && openers.size() < parallelism) {
                            SegmentCommitInfo info = sis.info(sis.size() - 1 - readerIndex);
                            SegmentReaderOpener opener = new SegmentReaderOpener(readers, readerIndex, info, sis.getIndexCreatedVersionMajor(), IOContext.READ);
                            ++readerIndex;
                            openers.add(opener);
                            opener.start(executor);
                            continue;
                        }
                        if (openers.isEmpty()) break;
                        ((SegmentReaderOpener)openers.pop()).finish();
                    }
                    StandardDirectoryReader reader = new StandardDirectoryReader(this.directory, (LeafReader[])readers, null, sis, leafSorter, false, false);
                    success = true;
                    StandardDirectoryReader standardDirectoryReader = reader;
                    return standardDirectoryReader;
                }
                finally {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])readers);
                    }
                }
            }
        }.run(commit);
    }

    static class SegmentReaderOpener {
        private final SegmentReader[] segmentReaders;
        private final int readerIndex;
        private final SegmentCommitInfo segmentCommitInfo;
        private final int createdVersionMajor;
        private final IOContext ioContext;
        private IOException ioException;
        private CompletableFuture<Void> future;

        SegmentReaderOpener(SegmentReader[] segmentReaders, int readerIndex, SegmentCommitInfo segmentCommitInfo, int createdVersionMajor, IOContext ioContext) {
            this.segmentReaders = segmentReaders;
            this.readerIndex = readerIndex;
            this.segmentCommitInfo = segmentCommitInfo;
            this.createdVersionMajor = createdVersionMajor;
            this.ioContext = ioContext;
        }

        public void start(Executor executor) {
            try {
                this.future = CompletableFuture.runAsync(() -> {
                    try {
                        this.open();
                    }
                    catch (IOException ex) {
                        this.ioException = ex;
                    }
                    catch (RejectedExecutionException ex) {
                        this.segmentReaders[this.readerIndex] = null;
                    }
                }, executor);
            }
            catch (RejectedExecutionException ex) {
                this.future = null;
            }
        }

        public void finish() throws IOException {
            if (this.future != null) {
                this.future.join();
            }
            if (this.ioException != null) {
                throw this.ioException;
            }
            if (this.segmentReaders[this.readerIndex] == null) {
                this.open();
            }
        }

        private void open() throws IOException {
            this.segmentReaders[this.readerIndex] = new SegmentReader(this.segmentCommitInfo, this.createdVersionMajor, this.ioContext);
        }
    }
}

